/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.data.Channel;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.graupner.HoTTAdapter;
import gde.exception.DataInconsitsentException;
import gde.io.FileHandler;
import gde.log.Level;
import gde.messages.Messages;
import java.io.FileNotFoundException;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class HoTTViewer
extends HoTTAdapter
implements IDevice {
    static final Logger log = Logger.getLogger(HoTTViewer.class.getName());

    public HoTTViewer(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        if (this.application.getMenuToolBar() != null) {
            String toolTipText = HoTTAdapter.getImportToolTip();
            this.configureSerialPortMenu(0, toolTipText, toolTipText);
            this.updateFileExportMenu(this.application.getMenuBar().getExportMenu());
        }
    }

    public HoTTViewer(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        if (this.application.getMenuToolBar() != null) {
            String toolTipText = HoTTAdapter.getImportToolTip();
            this.configureSerialPortMenu(0, toolTipText, toolTipText);
            this.updateFileExportMenu(this.application.getMenuBar().getExportMenu());
        }
    }

    @Override
    public void updateFileExportMenu(Menu exportMenue) {
        if (exportMenue.getItem(exportMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0732"))) {
            new MenuItem(exportMenue, 2);
            MenuItem convertKMZ3DRelativeItem = new MenuItem(exportMenue, 8);
            convertKMZ3DRelativeItem.setText(Messages.getString((String)"GDE_MSGT2405"));
            convertKMZ3DRelativeItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKMZ3DRelativeItem action performed! " + String.valueOf(e));
                    HoTTViewer.this.export2KMZ3D(0);
                }
            });
            MenuItem convertKMZDAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZDAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT2406"));
            convertKMZDAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKMZDAbsoluteItem action performed! " + String.valueOf(e));
                    HoTTViewer.this.export2KMZ3D(1);
                }
            });
            convertKMZDAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZDAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT2407"));
            convertKMZDAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKMZDAbsoluteItem action performed! " + String.valueOf(e));
                    HoTTViewer.this.export2KMZ3D(2);
                }
            });
        }
    }

    @Override
    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        int[] points = new int[recordSet.getNoneCalculationRecordNames().length];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 1;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 4 * recordDataSize;
        int index = 0;
        for (int i = 0; i < recordDataSize; ++i) {
            index = i * dataBufferSize + timeStampBufferSize;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + index);
            }
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((dataBuffer[0 + j * 4 + index] & 0xFF) << 24) + ((dataBuffer[1 + j * 4 + index] & 0xFF) << 16) + ((dataBuffer[2 + j * 4 + index] & 0xFF) << 8) + ((dataBuffer[3 + j * 4 + index] & 0xFF) << 0);
            }
            recordSet.addNoneCalculationRecordsPoints(points, (double)(((dataBuffer[0 + i * 4] & 0xFF) << 24) + ((dataBuffer[1 + i * 4] & 0xFF) << 16) + ((dataBuffer[2 + i * 4] & 0xFF) << 8) + ((dataBuffer[3 + i * 4] & 0xFF) << 0)) / 10.0);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
        if (recordSet.getRecordSetDescription().contains("(")) {
            recordSet.setRecordSetDescription(this.getName() + recordSet.getRecordSetDescription().substring(recordSet.getRecordSetDescription().lastIndexOf("(")));
        } else if (recordSet.getRecordSetDescription().contains(" - ")) {
            recordSet.setRecordSetDescription(this.getName() + recordSet.getRecordSetDescription().substring(recordSet.getRecordSetDescription().indexOf(" - ")));
        }
    }

    @Override
    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                int ordinal = record.getOrdinal();
                switch (ordinal) {
                    default: {
                        dataTableRow[index + 1] = record.getFormattedTableValue(rowIndex);
                        break;
                    }
                    case 0: {
                        dataTableRow[index + 1] = String.format("%.0f", (double)record.realGet(rowIndex).intValue() / 1000.0);
                    }
                }
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    @Override
    public boolean isActualRecordSetWithGpsData() {
        RecordSet activeRecordSet;
        boolean containsGPSdata = false;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
            containsGPSdata = activeRecordSet.get(22).hasReasonableData() && activeRecordSet.get(23).hasReasonableData();
        }
        return containsGPSdata;
    }

    @Override
    public boolean isGPSCoordinates(Record record) {
        int latOrdinal = 22;
        int lonOrdinal = 23;
        return record.getOrdinal() == 22 || record.getOrdinal() == 23;
    }

    @Override
    public Integer getGPS2KMZMeasurementOrdinal() {
        if (this.kmzMeasurementOrdinal == null) {
            return 7;
        }
        return this.kmzMeasurementOrdinal;
    }

    @Override
    public String exportFile(String fileEndingType, boolean isExport2TmpDir) {
        RecordSet activeRecordSet;
        String exportFileName = "";
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && fileEndingType.contains("kmz")) {
            int additionalMeasurementOrdinal = this.getGPS2KMZMeasurementOrdinal();
            int latOrdinal = 22;
            int lonOrdinal = 23;
            int altOrdinal = 6;
            int climbOrdinal = 3;
            exportFileName = new FileHandler().exportFileKMZ(23, 22, 6, additionalMeasurementOrdinal, 3, -1, -1, true, isExport2TmpDir);
        }
        return exportFileName;
    }

    @Override
    public void export2KMZ3D(int type) {
        int latOrdinal = 22;
        int lonOrdinal = 23;
        int altOrdinal = 6;
        int climbOrdinal = 3;
        int speedOrdinal = 7;
        new FileHandler().exportFileKMZ(Messages.getString((String)"GDE_MSGT2403"), 23, 22, 6, 7, 3, -1, -1, type == 0, type == 2);
    }

    @Override
    public void export2GPX(boolean isGarminExtension) {
        if (isGarminExtension) {
            new FileHandler().exportFileGPX(Messages.getString((String)"GDE_MSGT0730"), 22, 23, 6, 7, -1, -1, -1, -1, new int[]{-1, -1, -1});
        } else {
            new FileHandler().exportFileGPX(Messages.getString((String)"GDE_MSGT0730"), 22, 23, 6, 7, -1, -1, -1, -1, new int[0]);
        }
    }

    @Override
    public double translateValue(Record record, double value) {
        double newValue = 0.0;
        int latOrdinal = 22;
        int lonOrdinal = 23;
        if (record.getOrdinal() == 22 || record.getOrdinal() == 23) {
            int grad = (int)(value / 1000.0);
            double minuten = (value - (double)grad * 1000.0) / 10.0;
            newValue = (double)grad + minuten / 60.0;
        } else {
            double factor = record.getFactor();
            double offset = record.getOffset();
            double reduction = record.getReduction();
            newValue = (value - reduction) * factor + offset;
        }
        log.log(java.util.logging.Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    @Override
    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = 0.0;
        int latOrdinal = 22;
        int lonOrdinal = 23;
        if (record.getOrdinal() == 22 || record.getOrdinal() == 23) {
            int grad = (int)value;
            double minuten = (value - (double)grad * 1.0) * 60.0;
            newValue = ((double)grad + minuten / 100.0) * 1000.0;
        } else {
            newValue = (value - offset) / factor + reduction;
        }
        log.log(java.util.logging.Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    @Override
    public void makeInActiveDisplayable(RecordSet recordSet) {
        recordSet.syncScaleOfSyncableRecords();
        this.application.updateStatisticsData();
        this.updateVisibilityStatus(recordSet, true);
        this.application.getActiveChannel().setFileDescription(recordSet.getFormatedTime_sec(0, true).trim().split(" ")[0]);
        recordSet.setSaved(true);
    }
}

