/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.moment;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class VectorialMean
implements Serializable {
    private static final long serialVersionUID = 8223009086481006892L;
    private final Mean[] means;

    public VectorialMean(int dimension) {
        this.means = new Mean[dimension];
        for (int i2 = 0; i2 < dimension; ++i2) {
            this.means[i2] = new Mean();
        }
    }

    public void increment(double[] v) throws DimensionMismatchException {
        if (v.length != this.means.length) {
            throw new DimensionMismatchException(v.length, this.means.length);
        }
        for (int i2 = 0; i2 < v.length; ++i2) {
            this.means[i2].increment(v[i2]);
        }
    }

    public double[] getResult() {
        double[] result2 = new double[this.means.length];
        for (int i2 = 0; i2 < result2.length; ++i2) {
            result2[i2] = this.means[i2].getResult();
        }
        return result2;
    }

    public long getN() {
        return this.means.length == 0 ? 0L : this.means[0].getN();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + Arrays.hashCode(this.means);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VectorialMean)) {
            return false;
        }
        VectorialMean other = (VectorialMean)obj;
        return Arrays.equals(this.means, other.means);
    }
}

