/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.data.CommonRecord;
import gde.data.Record;
import gde.device.IChannelItem;
import gde.device.MeasurementType;
import gde.device.TrailTypes;
import gde.device.resource.DeviceXmlResource;
import gde.histo.cache.ExtendedVault;
import gde.histo.cache.HistoVault;
import gde.histo.config.HistoGraphicsTemplate;
import gde.histo.datasources.HistoSet;
import gde.histo.guard.Guardian;
import gde.histo.guard.Reminder;
import gde.histo.recordings.MeasurementTrailSelector;
import gde.histo.recordings.SuiteRecord;
import gde.histo.recordings.SuiteRecords;
import gde.histo.recordings.TrailRecordFormatter;
import gde.histo.recordings.TrailRecordSet;
import gde.histo.recordings.TrailSelector;
import gde.histo.utils.ElementaryQuantile;
import gde.histo.utils.Spot;
import gde.log.Logger;
import gde.utils.ColorUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.stream.DoubleStream;

public abstract class TrailRecord
extends CommonRecord {
    private static final String $CLASS_NAME = TrailRecord.class.getName();
    private static final long serialVersionUID = 110124007964748556L;
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    protected final ChartTemplate template = new ChartTemplate();
    protected final DeviceXmlResource xmlResource = DeviceXmlResource.getInstance();
    protected final IChannelItem channelItem;
    protected final SuiteRecords suiteRecords = new SuiteRecords();
    protected boolean isDisplayable;
    protected TrailSelector trailSelector;
    protected ElementaryQuantile<Double> quantile;

    protected TrailRecord(IChannelItem channelItem, int newOrdinal, TrailRecordSet parentTrail, int initialCapacity) {
        super(parentTrail.getAnalyzer().getActiveDevice(), newOrdinal, channelItem.getName(), channelItem.getSymbol(), channelItem.getUnit(), channelItem.isActive(), null, initialCapacity);
        this.channelItem = channelItem;
        this.parent = parentTrail;
        log.fine(() -> channelItem.toString());
    }

    @Override
    @Deprecated
    public synchronized boolean add(Integer point) {
        throw new UnsupportedOperationException(" " + point);
    }

    @Override
    public synchronized void addElement(Integer point) {
        if (point == null) {
            if (this.isEmpty()) {
                this.minValue = Integer.MAX_VALUE;
                this.maxValue = Integer.MIN_VALUE;
            }
        } else if (this.isEmpty()) {
            this.minValue = this.maxValue = point.intValue();
        } else {
            if (point > this.maxValue) {
                this.maxValue = point;
            }
            if (point < this.minValue) {
                this.minValue = point;
            }
        }
        super.addElement(point);
        log.finer(() -> this.name + " adding point = " + point);
        log.finest(() -> this.name + " minValue = " + this.minValue + " maxValue = " + this.maxValue);
    }

    @Override
    @Deprecated
    public synchronized Integer set(int index, Integer point) {
        throw new UnsupportedOperationException(" " + index + " " + point);
    }

    @Override
    public void clear() {
        this.suiteRecords.clear();
        this.quantile = null;
        super.clear();
    }

    @Override
    public synchronized int size() {
        return this.suiteRecords.getSuiteLength() > 0 && this.trailSelector.isTrailSuite() ? this.suiteRecords.realSize() : super.realSize();
    }

    @Override
    public int realSize() {
        return super.realSize();
    }

    @Override
    public String getSyncMasterName() {
        StringBuilder sb = new StringBuilder().append(this.getNameReplacement().split(" ")[0]);
        Vector<TrailRecord> syncedChildren = this.getParent().getScaleSyncedRecords(this.ordinal);
        if (syncedChildren == null) {
            throw new UnsupportedOperationException();
        }
        if (syncedChildren.firstElement().getNameReplacement().split(" ").length > 1) {
            sb.append(" ");
            String[] splitName = syncedChildren.firstElement().getNameReplacement().split(" ");
            sb.append(splitName.length > 1 ? splitName[1] : "*");
            sb.append(".").append(".");
            String trailer = "*";
            for (TrailRecord tmpRecord : syncedChildren) {
                if (!tmpRecord.isDisplayable() || tmpRecord.size() <= 1) continue;
                trailer = tmpRecord.getNameReplacement();
            }
            sb.append(trailer.split(" ").length > 1 ? trailer.split(" ")[1] : "*");
        } else {
            sb.append(" - ").append(syncedChildren.lastElement().getNameReplacement());
        }
        return sb.toString();
    }

    public String getScaleText() {
        Object graphText;
        if (this.isScaleSyncMaster()) {
            graphText = this.getSyncMasterName();
            graphText = (String)graphText + (String)(this.getSymbol() != null && this.getSymbol().length() > 0 ? "   " + this.getSymbol() : "");
            graphText = (String)graphText + (String)(this.getUnit() != null && this.getUnit().length() > 0 ? "   [" + this.getUnit() + "]" : "   []");
        } else {
            String triggerScaleRawText = "";
            Object triggerScaleUnit = "";
            if (this.trailSelector instanceof MeasurementTrailSelector && ((MeasurementTrailSelector)this.trailSelector).isTriggerTrail()) {
                triggerScaleRawText = ((MeasurementTrailSelector)this.trailSelector).getTriggerScaleRawText();
                triggerScaleUnit = ((MeasurementTrailSelector)this.trailSelector).getTriggerScaleUnit();
                if (!((String)triggerScaleUnit).isEmpty() && ((String)triggerScaleUnit).startsWith("/")) {
                    TrailRecord referencedRatioRecord = this.getParent().get(((MeasurementType)this.getChannelItem()).getStatistics().getRatioRefOrdinal());
                    triggerScaleUnit = referencedRatioRecord.getUnit() + (String)triggerScaleUnit;
                }
            }
            graphText = triggerScaleRawText.isEmpty() ? DeviceXmlResource.getInstance().getReplacement(this.getName()) : DeviceXmlResource.getInstance().getReplacement(triggerScaleRawText);
            graphText = (String)graphText + (String)(this.getSymbol() != null && this.getSymbol().length() > 0 && triggerScaleRawText.isEmpty() ? "   " + this.getSymbol() : "");
            graphText = (String)graphText + (this.getUnit() != null && this.getUnit().length() > 0 && triggerScaleRawText.isEmpty() ? "   [" + this.getUnit() + "]" : "   [" + (String)triggerScaleUnit + "]");
        }
        return graphText;
    }

    @Override
    public double getFactor() {
        return this.channelItem.getFactor();
    }

    @Override
    public double getOffset() {
        return this.channelItem.getOffset();
    }

    @Override
    public double getReduction() {
        return this.channelItem.getReduction();
    }

    @Override
    public boolean isBits() {
        return this.channelItem.isBits();
    }

    @Override
    public boolean isTokens() {
        return this.channelItem.isTokens();
    }

    @Override
    public void setNumberFormatDirect(int newNumberFormat) {
        this.setNumberFormat(newNumberFormat);
    }

    @Override
    public void setNumberFormat(int newNumberFormat) {
        log.log(Level.FINE, this.name, newNumberFormat);
        this.template.numberFormat = newNumberFormat;
        this.template.df = new TrailRecordFormatter(this).getDecimalFormat(newNumberFormat);
    }

    @Override
    public int getMaxValue() {
        return this.maxValue == this.minValue ? this.maxValue + 100 : this.maxValue;
    }

    @Override
    public int getMinValue() {
        return this.minValue == this.maxValue ? this.minValue - 100 : this.minValue;
    }

    @Override
    public double getMaxScaleValue() {
        return this.template.maxScaleValue;
    }

    @Override
    public double getMinScaleValue() {
        return this.template.minScaleValue;
    }

    public void setMinMaxScaleValue(double minScaleValue, double maxScaleValue) {
        this.template.minScaleValue = minScaleValue;
        this.template.maxScaleValue = maxScaleValue;
        log.fine(() -> this.getName() + " minScaleValue = " + minScaleValue + "; maxScaleValue = " + minScaleValue);
    }

    @Override
    public boolean hasReasonableData() {
        boolean hasReasonableData = false;
        if (this.size() > 0) {
            double[] extrema = Guardian.defineStandardExtrema(Arrays.asList(this.getParent().getIndexedVaults()), this.channelItem, this.getParent().getAnalyzer().getSettings());
            hasReasonableData = !HistoSet.fuzzyEquals(extrema[0], extrema[1]) || !HistoSet.fuzzyEquals(extrema[0], 0.0);
            log.log(Level.FINE, this.name, hasReasonableData);
        }
        return hasReasonableData;
    }

    @Override
    public boolean isActive() {
        return this.isActive == null || this.size() == 0 ? false : this.isActive;
    }

    protected abstract boolean isAllowedBySetting();

    @Override
    public boolean isScaleVisible() {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, this.name + " isScaleSyncMaster=" + this.isScaleSyncMaster() + " isOneOfSyncableRecord=" + this.getAbstractParent().isOneOfSyncableRecord(this.getName()));
        }
        return this.isScaleSyncMaster() ? this.getAbstractParent().isOneSyncableVisible(this.ordinal) : !this.getAbstractParent().isOneOfSyncableRecord(this.getName()) && this.template.isVisible && this.isDisplayable;
    }

    @Override
    @Deprecated
    public double getTime_ms(int index) {
        throw new UnsupportedOperationException();
    }

    public void setDisplayable() {
        this.isDisplayable = this.isAllowedBySetting() && this.hasReasonableData();
    }

    @Override
    public boolean isDisplayable() {
        return this.isDisplayable;
    }

    @Override
    public boolean isVisible() {
        return this.template.isVisible;
    }

    @Override
    public void setVisible(boolean enabled) {
        this.template.isVisible = enabled;
    }

    @Override
    public boolean isPositionLeft() {
        return this.template.isPositionLeft;
    }

    @Override
    public void setPositionLeft(boolean enabled) {
        this.template.isPositionLeft = enabled;
    }

    @Override
    public String getRGB() {
        return this.template.rgb;
    }

    @Override
    public void setRGB(String rgb) {
        this.template.rgb = rgb;
    }

    @Override
    @Deprecated
    public boolean isRoundOut() {
        return false;
    }

    public boolean isRealRoundOut() {
        return this.template.isRoundOut;
    }

    @Override
    public void setRoundOut(boolean enabled) {
        this.template.isRoundOut = enabled;
    }

    @Override
    public boolean isStartpointZero() {
        return this.template.isStartpointZero;
    }

    @Override
    public void setStartpointZero(boolean enabled) {
        this.template.isStartpointZero = enabled;
    }

    @Override
    public boolean isStartEndDefined() {
        return this.template.isStartEndDefined;
    }

    @Override
    public void setStartEndDefined(boolean enabled) {
        this.template.isStartEndDefined = enabled;
    }

    @Override
    public void setStartEndDefined(boolean enabled, double newMinScaleValue, double newMaxScaleValue) {
        log.finer(() -> this.name + " enabled=" + enabled + " newMinScaleValue=" + newMinScaleValue + " newMaxScaleValue=" + newMaxScaleValue);
        this.template.isStartEndDefined = enabled;
        if (enabled) {
            this.template.maxScaleValue = newMaxScaleValue;
            this.template.minScaleValue = newMinScaleValue;
        } else {
            this.template.maxScaleValue = HistoSet.decodeVaultValue(this.channelItem, (double)this.maxValue / 1000.0);
            this.template.minScaleValue = HistoSet.decodeVaultValue(this.channelItem, (double)this.minValue / 1000.0);
        }
    }

    @Override
    public void setMinScaleValue(double newMinScaleValue) {
        this.template.minScaleValue = newMinScaleValue;
    }

    @Override
    public void setMaxScaleValue(double newMaxScaleValue) {
        this.template.maxScaleValue = newMaxScaleValue;
    }

    @Override
    public int getLineWidth() {
        return this.template.lineWidth;
    }

    @Override
    public void setLineWidth(int newLineWidth) {
        this.template.lineWidth = newLineWidth;
    }

    @Override
    public int getLineStyle() {
        return this.template.lineStyle;
    }

    @Override
    public void setLineStyle(int newLineStyle) {
        this.template.lineStyle = newLineStyle;
    }

    @Override
    public int getNumberFormat() {
        return this.template.numberFormat;
    }

    public TrailRecordSet getParent() {
        return (TrailRecordSet)this.parent;
    }

    public int[] defineRangeIndices(long timeStamp1_ms, long timeStamp2_ms) {
        int index1 = this.getIndex(timeStamp1_ms);
        int index2 = this.getIndex(timeStamp2_ms);
        return new int[]{Math.min(index1, index2), Math.max(index1, index2)};
    }

    public List<Spot<Double>> getSubPoints(int fromIndex, int toIndex) {
        int recordSize = toIndex - fromIndex;
        ArrayList<Spot<Double>> result = new ArrayList<Spot<Double>>(recordSize);
        Vector<Integer> points = this.getPoints();
        for (int i = fromIndex; i < toIndex; ++i) {
            if (points.elementAt(i) == null) continue;
            result.add(new Spot<Double>(this.parent.getTime_ms(i), HistoSet.decodeVaultValue(this.channelItem, (double)points.elementAt(i).intValue() / 1000.0)));
        }
        log.finer(() -> Arrays.toString(result.toArray()));
        return result;
    }

    public int getIndex(long timeStamp_ms) {
        return this.getParent().getIndex(timeStamp_ms);
    }

    public Vector<Integer> getPoints() {
        Vector points = !this.trailSelector.isTrailSuite() ? this : this.suiteRecords.get(this.trailSelector.getSuiteMasterIndex());
        return points;
    }

    public void setSuite(int initialCapacity) {
        this.suiteRecords.clear();
        List<TrailTypes> suiteMembers = this.trailSelector.getSuiteMembers();
        for (int i = 0; i < suiteMembers.size(); ++i) {
            this.suiteRecords.put(i, new SuiteRecord(suiteMembers.get(i).ordinal(), initialCapacity));
        }
    }

    public String getNameReplacement() {
        return this.getDeviceXmlReplacement(this.name);
    }

    public String getLabel() {
        return this.getDeviceXmlReplacement(this.channelItem.getLabel());
    }

    public String getTableRowHeader() {
        return this.getUnit().length() > 0 ? (this.getNameReplacement() + " [" + this.getUnit() + "]").intern() : this.getNameReplacement().intern();
    }

    private String getDeviceXmlReplacement(String replacementKey) {
        return replacementKey != null ? this.xmlResource.getReplacement(replacementKey) : "";
    }

    public TrailSelector getTrailSelector() {
        return this.trailSelector;
    }

    public SuiteRecords getSuiteRecords() {
        return this.suiteRecords;
    }

    @Override
    public String getFormattedScaleValue(double finalValue) {
        return new TrailRecordFormatter(this).getScaleValue(finalValue);
    }

    @Override
    public DecimalFormat getRealDf() {
        return this.template.df;
    }

    @Override
    public void setRealDf(DecimalFormat realDf) {
        this.template.df = realDf;
    }

    public DecimalFormat getDecimalFormat() {
        if (this.template.numberFormat == -1) {
            this.setNumberFormat(-1);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, this.isScaleSynced() + " - " + this.getAbstractParent().getSyncMasterRecordOrdinal(this.getName()));
        }
        return this.isScaleSynced() ? this.getAbstractParent().get(this.getAbstractParent().getSyncMasterRecordOrdinal(this.getName())).getRealDf() : this.template.df;
    }

    public void setColorDefaultsAndPosition(int recordOrdinal) {
        this.template.rgb = ColorUtils.getDefaultRgb(recordOrdinal);
        this.template.setPositionLeft(recordOrdinal);
    }

    public IChannelItem getChannelItem() {
        return this.channelItem;
    }

    public void setSelectedTrail() {
        this.setSelectedTrail(this.template.trailTextOrdinal);
    }

    public void setSelectedTrail(int trailTextOrdinal) {
        if (trailTextOrdinal >= 0 && trailTextOrdinal < this.trailSelector.getApplicableTrailsTexts().size()) {
            this.trailSelector.setTrailTextSelectedIndex(trailTextOrdinal);
        } else {
            this.trailSelector.setMostApplicableTrailTextOrdinal();
        }
        this.template.trailTextOrdinal = this.trailSelector.getTrailTextSelectedIndex();
        if (this.trailSelector.getTrailTextSelectedIndex() < 0) {
            log.info(() -> String.format("%s : no trail types identified" + this.name, new Object[0]));
        }
        log.finer(() -> String.format("%s", this.trailSelector.toString()));
    }

    public abstract Integer getVaultPoint(ExtendedVault var1, int var2);

    @Override
    public int getSyncMasterRecordOrdinal() {
        return this.channelItem.getSyncMasterRecordOrdinal();
    }

    @Override
    @Deprecated
    public void setSyncMinMax(int newMin, int newMax) {
        log.finer(() -> "  DEPRECATED    " + this.getName() + " syncMinValue=" + newMin + " syncMaxValue=" + newMax);
    }

    public double[] defineRecentMinMax(int limit) {
        int trailOrdinal = this.trailSelector.getTrailOrdinal();
        if (this.trailSelector.isOddRangeTrail()) {
            return Guardian.defineAlienMinMax(Arrays.stream(this.getParent().getIndexedVaults()).limit(limit), this.channelItem, trailOrdinal);
        }
        return Guardian.defineStandardMinMax(Arrays.stream(this.getParent().getIndexedVaults()).limit(limit), this.channelItem);
    }

    public double[] defineExtrema() {
        int trailOrdinal = this.trailSelector.getTrailOrdinal();
        if (this.trailSelector.isOddRangeTrail()) {
            return Guardian.defineAlienExtrema(Arrays.asList(this.getParent().getIndexedVaults()), this.channelItem, trailOrdinal, this.getParent().getAnalyzer().getSettings());
        }
        return Guardian.defineStandardExtrema(Arrays.asList(this.getParent().getIndexedVaults()), this.channelItem, this.getParent().getAnalyzer().getSettings());
    }

    public Reminder[] defineMinMaxWarning(int logLimit) {
        return Guardian.defineMinMaxReminder(this.getParent().getIndexedVaults(), this.channelItem, this.trailSelector, logLimit, this.getParent().getAnalyzer().getSettings());
    }

    protected List<Double> getDecodedNotNullValues() {
        ArrayList<Double> decodedValues = new ArrayList<Double>();
        Vector record = this.trailSelector.isTrailSuite() ? this.suiteRecords.get(this.trailSelector.getSuiteMasterIndex()) : this;
        for (Integer value : record) {
            if (value == null) continue;
            decodedValues.add(HistoSet.decodeVaultValue(this.channelItem, (double)value.intValue() / 1000.0));
        }
        return decodedValues;
    }

    protected void defineQuantile() {
        this.quantile = new ElementaryQuantile<Double>(this.getDecodedNotNullValues(), true, this.getParent().getAnalyzer().getSettings());
        log.finest(() -> this.name + " size=" + this.quantile.getSize() + " UpperWhisker=" + this.quantile.getQuantileUpperWhisker());
    }

    public ElementaryQuantile<Double> getQuantile() {
        if (this.quantile == null) {
            this.defineQuantile();
        }
        return this.quantile;
    }

    protected Integer[] getExtremumTrailPoints(ExtendedVault vault) {
        int[] extremumOrdinals = this.trailSelector.getExtremumTrailsOrdinals();
        return new Integer[]{this.getVaultPoint(vault, extremumOrdinals[0]), this.getVaultPoint(vault, extremumOrdinals[1])};
    }

    public void initializeFromVaults(TreeMap<Long, List<ExtendedVault>> histoVaults) {
        RecordCollector collector = new RecordCollector();
        collector.addVaults(histoVaults);
    }

    public abstract boolean hasVaultOutliers(ExtendedVault var1);

    public abstract DoubleStream getVaultScraps(ExtendedVault var1);

    public abstract DoubleStream getVaultOutliers(ExtendedVault var1);

    public abstract boolean hasVaultScraps(ExtendedVault var1);

    public abstract Record.DataType getVaultDataType(HistoVault var1);

    @Override
    public Record.DataType getDataType() {
        return this.channelItem.getUnifiedDataType();
    }

    public void applyTemplate() {
        this.template.applyTemplate(this.getParent().getTemplate(), this);
    }

    public void saveTemplate() {
        this.template.saveTemplate(this.getParent().getTemplate(), this);
    }

    public abstract void setTrailSelector();

    public static class ChartTemplate {
        boolean isVisible = true;
        boolean isPositionLeft = true;
        String rgb = "0,0,0";
        int lineWidth = 1;
        int lineStyle = 1;
        boolean isRoundOut = false;
        boolean isStartpointZero = false;
        boolean isStartEndDefined = false;
        DecimalFormat df = new DecimalFormat("0.0");
        int numberFormat = -1;
        double maxScaleValue = 0.0;
        double minScaleValue = 0.0;
        int trailTextOrdinal = -1;

        void saveTemplate(HistoGraphicsTemplate template, TrailRecord record) {
            String recordName = record.getName();
            template.setRecordProperty(recordName, "_isVisible", String.valueOf(this.isVisible));
            template.setRecordProperty(recordName, "_isPositionLeft", String.valueOf(this.isPositionLeft));
            template.setRecordProperty(recordName, "_color", this.rgb);
            template.setRecordProperty(recordName, "_lineWidth", String.valueOf(this.lineWidth));
            template.setRecordProperty(recordName, "_lineStyle", String.valueOf(this.lineStyle));
            template.setRecordProperty(recordName, "_isRoundOut", String.valueOf(this.isRoundOut));
            template.setRecordProperty(recordName, "_isStartpointZero", String.valueOf(this.isStartpointZero));
            template.setRecordProperty(recordName, "_numberFormat", String.valueOf(this.numberFormat));
            template.setRecordProperty(recordName, "_isStartEndDefined", String.valueOf(this.isStartEndDefined));
            template.setRecordProperty(recordName, "_defMaxValue", String.valueOf(this.maxScaleValue));
            template.setRecordProperty(recordName, "_defMinValue", String.valueOf(this.minScaleValue));
            template.setRecordProperty(recordName, "_trailTextOrdinal", String.valueOf(this.trailTextOrdinal));
        }

        void applyTemplate(HistoGraphicsTemplate template, TrailRecord record) {
            String recordName = record.getName();
            this.isVisible = Boolean.parseBoolean(template.getRecordProperty(recordName, "_isVisible", "false"));
            this.isPositionLeft = Boolean.parseBoolean(template.getRecordProperty(recordName, "_isPositionLeft", "true"));
            this.rgb = template.getRecordProperty(recordName, "_color", record.getRGB());
            this.lineWidth = Integer.parseInt(template.getRecordProperty(recordName, "_lineWidth", "1"));
            this.lineStyle = Integer.parseInt(template.getRecordProperty(recordName, "_lineStyle", "1"));
            this.isRoundOut = Boolean.parseBoolean(template.getRecordProperty(recordName, "_isRoundOut", "false"));
            this.isStartpointZero = Boolean.parseBoolean(template.getRecordProperty(recordName, "_isStartpointZero", "false"));
            record.setStartEndDefined(Boolean.parseBoolean(template.getRecordProperty(recordName, "_isStartEndDefined", "false")), Double.parseDouble(template.getRecordProperty(recordName, "_defMinValue", "0")), Double.parseDouble(template.getRecordProperty(recordName, "_defMaxValue", "0")));
            this.numberFormat = Integer.parseInt(template.getRecordProperty(recordName, "_numberFormat", "-1"));
            this.df = new TrailRecordFormatter(record).getDecimalFormat(this.numberFormat);
        }

        public void setPositionLeft(int recordOrdinal) {
            this.isPositionLeft = recordOrdinal % 2 == 0;
        }
    }

    final class RecordCollector {
        private final Logger log = Logger.getLogger(RecordCollector.class.getName());

        RecordCollector() {
        }

        synchronized void addVaults(TreeMap<Long, List<ExtendedVault>> histoVaults) {
            if (!TrailRecord.this.trailSelector.isTrailSuite()) {
                histoVaults.values().stream().flatMap(Collection::stream).forEach(v -> TrailRecord.this.addElement(TrailRecord.this.getVaultPoint((ExtendedVault)v, TrailRecord.this.trailSelector.getTrailOrdinal())));
            } else {
                TrailRecord.this.setSuite(histoVaults.size());
                histoVaults.values().stream().flatMap(Collection::stream).forEach(v -> this.addVaultToSuite((ExtendedVault)v));
            }
            this.log.finer(() -> " " + String.valueOf(TrailRecord.this.getTrailSelector()));
        }

        private void addVaultToSuite(ExtendedVault histoVault) {
            List<TrailTypes> suiteMembers = TrailRecord.this.trailSelector.getSuiteMembers();
            if (TrailRecord.this.trailSelector.isBoxPlotSuite()) {
                for (int i = 0; i < TrailRecord.this.trailSelector.getSuiteMembers().size(); ++i) {
                    TrailRecord.this.suiteRecords.get(i).addElement(TrailRecord.this.getVaultPoint(histoVault, suiteMembers.get(i).ordinal()));
                }
            } else {
                int tmpSummationFactor = 0;
                int masterPoint = 0;
                for (int i = 0; i < suiteMembers.size(); ++i) {
                    Integer point = TrailRecord.this.getVaultPoint(histoVault, suiteMembers.get(i).ordinal());
                    if (point == null) {
                        TrailRecord.this.suiteRecords.get(i).addElement(null);
                    } else {
                        tmpSummationFactor = this.getSummationFactor(suiteMembers.get(i), tmpSummationFactor);
                        if (tmpSummationFactor == 0) {
                            masterPoint = point;
                        } else {
                            point = masterPoint + tmpSummationFactor * point * 2;
                        }
                        TrailRecord.this.suiteRecords.get(i).addElement(point);
                    }
                    if (!this.log.isLoggable(Level.FINER)) continue;
                    this.log.log(Level.FINER, String.format(" %s trail %3d  %s  %d minVal=%d maxVal=%d", TrailRecord.this.getName(), TrailRecord.this.trailSelector.getTrailOrdinal(), histoVault.getLoadFilePath(), point, TrailRecord.this.suiteRecords.get(i).getMinRecordValue(), TrailRecord.this.suiteRecords.get(i).getMaxRecordValue()));
                }
            }
            this.log.log(Level.FINER, " ", TrailRecord.this.trailSelector);
        }

        private int getSummationFactor(TrailTypes trailType, int previousFactor) {
            boolean isOddRange = TrailTypes.ODD_RANGE_TRAILS.contains((Object)trailType);
            if (isOddRange) {
                return previousFactor == 0 ? -1 : previousFactor * -1;
            }
            return 0;
        }
    }
}

