/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.io.Serializable;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.linear.AbstractRealMatrix;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SparseRealMatrix;
import org.apache.commons.math3.util.OpenIntToDoubleHashMap;

public class OpenMapRealMatrix
extends AbstractRealMatrix
implements SparseRealMatrix,
Serializable {
    private static final long serialVersionUID = -5962461716457143437L;
    private final int rows;
    private final int columns;
    private final OpenIntToDoubleHashMap entries;

    public OpenMapRealMatrix(int rowDimension, int columnDimension) throws NotStrictlyPositiveException, NumberIsTooLargeException {
        super(rowDimension, columnDimension);
        long lRow = rowDimension;
        long lCol = columnDimension;
        if (lRow * lCol >= Integer.MAX_VALUE) {
            throw new NumberIsTooLargeException(lRow * lCol, (Number)Integer.MAX_VALUE, false);
        }
        this.rows = rowDimension;
        this.columns = columnDimension;
        this.entries = new OpenIntToDoubleHashMap(0.0);
    }

    public OpenMapRealMatrix(OpenMapRealMatrix matrix) {
        this.rows = matrix.rows;
        this.columns = matrix.columns;
        this.entries = new OpenIntToDoubleHashMap(matrix.entries);
    }

    public OpenMapRealMatrix copy() {
        return new OpenMapRealMatrix(this);
    }

    public OpenMapRealMatrix createMatrix(int rowDimension, int columnDimension) throws NotStrictlyPositiveException, NumberIsTooLargeException {
        return new OpenMapRealMatrix(rowDimension, columnDimension);
    }

    public int getColumnDimension() {
        return this.columns;
    }

    public OpenMapRealMatrix add(OpenMapRealMatrix m) throws MatrixDimensionMismatchException {
        MatrixUtils.checkAdditionCompatible(this, m);
        OpenMapRealMatrix out = new OpenMapRealMatrix(this);
        OpenIntToDoubleHashMap.Iterator iterator2 = m.entries.iterator();
        while (iterator2.hasNext()) {
            iterator2.advance();
            int row2 = iterator2.key() / this.columns;
            int col = iterator2.key() - row2 * this.columns;
            out.setEntry(row2, col, this.getEntry(row2, col) + iterator2.value());
        }
        return out;
    }

    public OpenMapRealMatrix subtract(RealMatrix m) throws MatrixDimensionMismatchException {
        try {
            return this.subtract((OpenMapRealMatrix)m);
        }
        catch (ClassCastException cce) {
            return (OpenMapRealMatrix)super.subtract(m);
        }
    }

    public OpenMapRealMatrix subtract(OpenMapRealMatrix m) throws MatrixDimensionMismatchException {
        MatrixUtils.checkAdditionCompatible(this, m);
        OpenMapRealMatrix out = new OpenMapRealMatrix(this);
        OpenIntToDoubleHashMap.Iterator iterator2 = m.entries.iterator();
        while (iterator2.hasNext()) {
            iterator2.advance();
            int row2 = iterator2.key() / this.columns;
            int col = iterator2.key() - row2 * this.columns;
            out.setEntry(row2, col, this.getEntry(row2, col) - iterator2.value());
        }
        return out;
    }

    public RealMatrix multiply(RealMatrix m) throws DimensionMismatchException, NumberIsTooLargeException {
        try {
            return this.multiply((OpenMapRealMatrix)m);
        }
        catch (ClassCastException cce) {
            MatrixUtils.checkMultiplicationCompatible(this, m);
            int outCols = m.getColumnDimension();
            BlockRealMatrix out = new BlockRealMatrix(this.rows, outCols);
            OpenIntToDoubleHashMap.Iterator iterator2 = this.entries.iterator();
            while (iterator2.hasNext()) {
                iterator2.advance();
                double value = iterator2.value();
                int key2 = iterator2.key();
                int i2 = key2 / this.columns;
                int k = key2 % this.columns;
                for (int j = 0; j < outCols; ++j) {
                    out.addToEntry(i2, j, value * m.getEntry(k, j));
                }
            }
            return out;
        }
    }

    public OpenMapRealMatrix multiply(OpenMapRealMatrix m) throws DimensionMismatchException, NumberIsTooLargeException {
        MatrixUtils.checkMultiplicationCompatible(this, m);
        int outCols = m.getColumnDimension();
        OpenMapRealMatrix out = new OpenMapRealMatrix(this.rows, outCols);
        OpenIntToDoubleHashMap.Iterator iterator2 = this.entries.iterator();
        while (iterator2.hasNext()) {
            iterator2.advance();
            double value = iterator2.value();
            int key2 = iterator2.key();
            int i2 = key2 / this.columns;
            int k = key2 % this.columns;
            for (int j = 0; j < outCols; ++j) {
                int rightKey = m.computeKey(k, j);
                if (!m.entries.containsKey(rightKey)) continue;
                int outKey = out.computeKey(i2, j);
                double outValue = out.entries.get(outKey) + value * m.entries.get(rightKey);
                if (outValue == 0.0) {
                    out.entries.remove(outKey);
                    continue;
                }
                out.entries.put(outKey, outValue);
            }
        }
        return out;
    }

    public double getEntry(int row2, int column2) throws OutOfRangeException {
        MatrixUtils.checkRowIndex(this, row2);
        MatrixUtils.checkColumnIndex(this, column2);
        return this.entries.get(this.computeKey(row2, column2));
    }

    public int getRowDimension() {
        return this.rows;
    }

    public void setEntry(int row2, int column2, double value) throws OutOfRangeException {
        MatrixUtils.checkRowIndex(this, row2);
        MatrixUtils.checkColumnIndex(this, column2);
        if (value == 0.0) {
            this.entries.remove(this.computeKey(row2, column2));
        } else {
            this.entries.put(this.computeKey(row2, column2), value);
        }
    }

    public void addToEntry(int row2, int column2, double increment) throws OutOfRangeException {
        MatrixUtils.checkRowIndex(this, row2);
        MatrixUtils.checkColumnIndex(this, column2);
        int key2 = this.computeKey(row2, column2);
        double value = this.entries.get(key2) + increment;
        if (value == 0.0) {
            this.entries.remove(key2);
        } else {
            this.entries.put(key2, value);
        }
    }

    public void multiplyEntry(int row2, int column2, double factor) throws OutOfRangeException {
        MatrixUtils.checkRowIndex(this, row2);
        MatrixUtils.checkColumnIndex(this, column2);
        int key2 = this.computeKey(row2, column2);
        double value = this.entries.get(key2) * factor;
        if (value == 0.0) {
            this.entries.remove(key2);
        } else {
            this.entries.put(key2, value);
        }
    }

    private int computeKey(int row2, int column2) {
        return row2 * this.columns + column2;
    }
}

