/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.jsp;

import freemarker.log.Logger;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class EventForwarding
implements ServletContextAttributeListener,
ServletContextListener,
HttpSessionListener,
HttpSessionAttributeListener {
    private static final Logger LOG = Logger.getLogger("freemarker.jsp");
    private static final String ATTR_NAME = EventForwarding.class.getName();
    private final List servletContextAttributeListeners = new ArrayList();
    private final List servletContextListeners = new ArrayList();
    private final List httpSessionAttributeListeners = new ArrayList();
    private final List httpSessionListeners = new ArrayList();

    void addListeners(List listeners) {
        Iterator iter = listeners.iterator();
        while (iter.hasNext()) {
            this.addListener((EventListener)iter.next());
        }
    }

    private void addListener(EventListener listener2) {
        boolean added = false;
        if (listener2 instanceof ServletContextAttributeListener) {
            this.addListener(this.servletContextAttributeListeners, listener2);
            added = true;
        }
        if (listener2 instanceof ServletContextListener) {
            this.addListener(this.servletContextListeners, listener2);
            added = true;
        }
        if (listener2 instanceof HttpSessionAttributeListener) {
            this.addListener(this.httpSessionAttributeListeners, listener2);
            added = true;
        }
        if (listener2 instanceof HttpSessionListener) {
            this.addListener(this.httpSessionListeners, listener2);
            added = true;
        }
        if (!added) {
            LOG.warn("Listener of class " + listener2.getClass().getName() + "wasn't registered as it doesn't implement any of the recognized listener interfaces.");
        }
    }

    static EventForwarding getInstance(ServletContext context) {
        return (EventForwarding)context.getAttribute(ATTR_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(List listeners, EventListener listener2) {
        List list2 = listeners;
        synchronized (list2) {
            listeners.add(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeAdded(ServletContextAttributeEvent arg0) {
        List list2 = this.servletContextAttributeListeners;
        synchronized (list2) {
            int s = this.servletContextAttributeListeners.size();
            for (int i2 = 0; i2 < s; ++i2) {
                ((ServletContextAttributeListener)this.servletContextAttributeListeners.get(i2)).attributeAdded(arg0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeRemoved(ServletContextAttributeEvent arg0) {
        List list2 = this.servletContextAttributeListeners;
        synchronized (list2) {
            int s = this.servletContextAttributeListeners.size();
            for (int i2 = 0; i2 < s; ++i2) {
                ((ServletContextAttributeListener)this.servletContextAttributeListeners.get(i2)).attributeRemoved(arg0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeReplaced(ServletContextAttributeEvent arg0) {
        List list2 = this.servletContextAttributeListeners;
        synchronized (list2) {
            int s = this.servletContextAttributeListeners.size();
            for (int i2 = 0; i2 < s; ++i2) {
                ((ServletContextAttributeListener)this.servletContextAttributeListeners.get(i2)).attributeReplaced(arg0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent arg0) {
        arg0.getServletContext().setAttribute(ATTR_NAME, (Object)this);
        List list2 = this.servletContextListeners;
        synchronized (list2) {
            int s = this.servletContextListeners.size();
            for (int i2 = 0; i2 < s; ++i2) {
                ((ServletContextListener)this.servletContextListeners.get(i2)).contextInitialized(arg0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent arg0) {
        List list2 = this.servletContextListeners;
        synchronized (list2) {
            int s = this.servletContextListeners.size();
            for (int i2 = s - 1; i2 >= 0; --i2) {
                ((ServletContextListener)this.servletContextListeners.get(i2)).contextDestroyed(arg0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCreated(HttpSessionEvent arg0) {
        List list2 = this.httpSessionListeners;
        synchronized (list2) {
            int s = this.httpSessionListeners.size();
            for (int i2 = 0; i2 < s; ++i2) {
                ((HttpSessionListener)this.httpSessionListeners.get(i2)).sessionCreated(arg0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent arg0) {
        List list2 = this.httpSessionListeners;
        synchronized (list2) {
            int s = this.httpSessionListeners.size();
            for (int i2 = s - 1; i2 >= 0; --i2) {
                ((HttpSessionListener)this.httpSessionListeners.get(i2)).sessionDestroyed(arg0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeAdded(HttpSessionBindingEvent arg0) {
        List list2 = this.httpSessionAttributeListeners;
        synchronized (list2) {
            int s = this.httpSessionAttributeListeners.size();
            for (int i2 = 0; i2 < s; ++i2) {
                ((HttpSessionAttributeListener)this.httpSessionAttributeListeners.get(i2)).attributeAdded(arg0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeRemoved(HttpSessionBindingEvent arg0) {
        List list2 = this.httpSessionAttributeListeners;
        synchronized (list2) {
            int s = this.httpSessionAttributeListeners.size();
            for (int i2 = 0; i2 < s; ++i2) {
                ((HttpSessionAttributeListener)this.httpSessionAttributeListeners.get(i2)).attributeRemoved(arg0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeReplaced(HttpSessionBindingEvent arg0) {
        List list2 = this.httpSessionAttributeListeners;
        synchronized (list2) {
            int s = this.httpSessionAttributeListeners.size();
            for (int i2 = 0; i2 < s; ++i2) {
                ((HttpSessionAttributeListener)this.httpSessionAttributeListeners.get(i2)).attributeReplaced(arg0);
            }
        }
    }
}

