/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.ClassIntrospector;
import freemarker.template.utility.ClassUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

class UnsafeMethods {
    private static final String UNSAFE_METHODS_PROPERTIES = "unsafeMethods.properties";
    private static final Set UNSAFE_METHODS = UnsafeMethods.createUnsafeMethodsSet();

    private UnsafeMethods() {
    }

    static boolean isUnsafeMethod(Method method) {
        return UNSAFE_METHODS.contains(method);
    }

    private static final Set createUnsafeMethodsSet() {
        try {
            Properties props = ClassUtil.loadProperties(BeansWrapper.class, UNSAFE_METHODS_PROPERTIES);
            HashSet<Method> set2 = new HashSet<Method>(props.size() * 4 / 3, 1.0f);
            Map primClasses = UnsafeMethods.createPrimitiveClassesMap();
            for (Object key2 : props.keySet()) {
                try {
                    set2.add(UnsafeMethods.parseMethodSpec((String)key2, primClasses));
                }
                catch (ClassNotFoundException e) {
                    if (!ClassIntrospector.DEVELOPMENT_MODE) continue;
                    throw e;
                }
                catch (NoSuchMethodException e) {
                    if (!ClassIntrospector.DEVELOPMENT_MODE) continue;
                    throw e;
                }
            }
            return set2;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load unsafe method set", e);
        }
    }

    private static Method parseMethodSpec(String methodSpec, Map primClasses) throws ClassNotFoundException, NoSuchMethodException {
        int brace = methodSpec.indexOf(40);
        int dot = methodSpec.lastIndexOf(46, brace);
        Class clazz = ClassUtil.forName(methodSpec.substring(0, dot));
        String methodName = methodSpec.substring(dot + 1, brace);
        String argSpec = methodSpec.substring(brace + 1, methodSpec.length() - 1);
        StringTokenizer tok = new StringTokenizer(argSpec, ",");
        int argcount = tok.countTokens();
        Class[] argTypes = new Class[argcount];
        for (int i2 = 0; i2 < argcount; ++i2) {
            String argClassName = tok.nextToken();
            argTypes[i2] = (Class)primClasses.get(argClassName);
            if (argTypes[i2] != null) continue;
            argTypes[i2] = ClassUtil.forName(argClassName);
        }
        return clazz.getMethod(methodName, argTypes);
    }

    private static Map createPrimitiveClassesMap() {
        HashMap<String, Class<Comparable<Boolean>>> map2 = new HashMap<String, Class<Comparable<Boolean>>>();
        map2.put("boolean", Boolean.TYPE);
        map2.put("byte", Byte.TYPE);
        map2.put("char", Character.TYPE);
        map2.put("short", Short.TYPE);
        map2.put("int", Integer.TYPE);
        map2.put("long", Long.TYPE);
        map2.put("float", Float.TYPE);
        map2.put("double", Double.TYPE);
        return map2;
    }
}

