/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u001a\u0010\u0005\u001a\u00020\u0003*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010\u000b\u001a\u00020\u0003*\u00020\f\u001a\n\u0010\r\u001a\u00020\u0003*\u00020\n\u001a\n\u0010\r\u001a\u00020\u0003*\u00020\u000e\u001a\u0012\u0010\r\u001a\u00020\u0003*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b\u001a\n\u0010\r\u001a\u00020\u0003*\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"BUFFER_SIZE", "", "HASH_ALGORITHM", "", "HASH_SIZE", "extract", "Ljava/util/zip/ZipFile;", "zipEntry", "Ljava/util/zip/ZipEntry;", "file", "Ljava/io/File;", "getHash", "Ljava/security/MessageDigest;", "hash", "Ljava/io/InputStream;", "entry", "", "HoTT-Util"})
public final class HashUtilsKt {
    private static final int BUFFER_SIZE = 0x100000;
    @NotNull
    public static final String HASH_ALGORITHM = "MD5";
    public static final int HASH_SIZE = 32;

    @NotNull
    public static final String hash(@NotNull byte[] $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        byte[] byArray = $receiver;
        return HashUtilsKt.hash(new ByteArrayInputStream(byArray));
    }

    @NotNull
    public static final String getHash(@NotNull MessageDigest $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        String string2 = new BigInteger(1, $receiver.digest()).toString(16);
        Intrinsics.checkExpressionValueIsNotNull(string2, "BigInteger(1, digest()).toString(16)");
        return StringsKt.padStart(string2, 32, '0');
    }

    @NotNull
    public static final String hash(@NotNull ZipFile $receiver, @NotNull ZipEntry entry) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(entry, "entry");
        InputStream inputStream2 = $receiver.getInputStream(entry);
        Intrinsics.checkExpressionValueIsNotNull(inputStream2, "getInputStream(entry)");
        return HashUtilsKt.hash(inputStream2);
    }

    @NotNull
    public static final String hash(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        File file = $receiver;
        return HashUtilsKt.hash(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String hash(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        MessageDigest md = MessageDigest.getInstance(HASH_ALGORITHM);
        byte[] buffer = new byte[0x100000];
        Closeable closeable = $receiver;
        Throwable throwable = null;
        try {
            int len;
            InputStream stream = (InputStream)closeable;
            while ((len = stream.read(buffer)) >= 0) {
                md.update(buffer, 0, len);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        MessageDigest messageDigest = md;
        Intrinsics.checkExpressionValueIsNotNull(messageDigest, "md");
        return HashUtilsKt.getHash(messageDigest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String extract(@NotNull ZipFile $receiver, @NotNull ZipEntry zipEntry, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(zipEntry, "zipEntry");
        Intrinsics.checkParameterIsNotNull(file, "file");
        MessageDigest md = MessageDigest.getInstance(HASH_ALGORITHM);
        byte[] buffer = new byte[0x100000];
        file.getParentFile().mkdirs();
        long bytesRead = 0L;
        Closeable closeable = $receiver.getInputStream(zipEntry);
        Throwable throwable = null;
        try {
            InputStream inputStream2 = (InputStream)closeable;
            Object object = file;
            object = new FileOutputStream((File)object);
            Throwable throwable2 = null;
            try {
                int len;
                FileOutputStream outputStream = (FileOutputStream)object;
                while ((len = inputStream2.read(buffer)) >= 0) {
                    bytesRead += (long)len;
                    md.update(buffer, 0, len);
                    outputStream.write(buffer, 0, len);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        file.setLastModified(zipEntry.getTime());
        MessageDigest messageDigest = md;
        Intrinsics.checkExpressionValueIsNotNull(messageDigest, "md");
        return HashUtilsKt.getHash(messageDigest);
    }
}

