/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.decoder.internal.firmware;

import de.treichels.hott.decoder.internal.firmware.Hex;
import de.treichels.hott.decoder.internal.firmware.HexFileKt;
import de.treichels.hott.util.ByteOrder;
import de.treichels.hott.util.StreamSupportKt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0096\u0003J\u0017\u0010\f\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0096\u0001J\u0006\u0010\u000f\u001a\u00020\u0010J\u0011\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0006H\u0096\u0003J\u0011\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0002H\u0096\u0001J\t\u0010\u0014\u001a\u00020\nH\u0096\u0001J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0096\u0003J\u0011\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0002H\u0096\u0001J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0096\u0001J\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0006H\u0096\u0001J\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u001bJ\u001f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0096\u0001R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u0006X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lde/treichels/hott/decoder/internal/firmware/HexFile;", "", "Lde/treichels/hott/decoder/internal/firmware/Hex;", "lines", "(Ljava/util/List;)V", "size", "", "getSize", "()I", "contains", "", "element", "containsAll", "elements", "", "data", "", "get", "index", "indexOf", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "range", "Lkotlin/Pair;", "subList", "fromIndex", "toIndex", "Companion", "HoTT-Decoder"})
public final class HexFile
implements List<Hex>,
KMappedMarker {
    private final List<Hex> lines;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Pair<Integer, Integer> range() {
        int min = Integer.MAX_VALUE;
        int max = 0;
        int extAddr = 0;
        HexFile $receiver$iv = this;
        for (Object element$iv : $receiver$iv) {
            Hex hex2 = (Hex)element$iv;
            switch (hex2.getRecordType()) {
                case 0: {
                    int n;
                    int address = extAddr + hex2.getAddress();
                    int n2 = min;
                    min = n = Math.min(n2, address);
                    n2 = max;
                    int n3 = address + hex2.getSize();
                    max = n = Math.max(n2, n3);
                    break;
                }
                case 1: {
                    return new Pair<Integer, Integer>(min, max);
                }
                case 4: {
                    short s = StreamSupportKt.readUShort$default(hex2.getData(), 0, ByteOrder.BigEndian, 1, null);
                    int n = s & 0xFFFF;
                    extAddr = n << 16;
                    break;
                }
                default: {
                    throw (Throwable)new IOException("invalid record type");
                }
            }
        }
        throw (Throwable)new IOException("file does not end with an end-of-file record");
    }

    @NotNull
    public final byte[] data() {
        byte[] data2 = new byte[((Number)this.range().getSecond()).intValue()];
        int extAddr = 0;
        HexFile $receiver$iv = this;
        for (Object element$iv : $receiver$iv) {
            Hex hex2 = (Hex)element$iv;
            switch (hex2.getRecordType()) {
                case 0: {
                    int address = extAddr + hex2.getAddress();
                    System.arraycopy(hex2.getData(), 0, data2, address, hex2.getSize());
                    break;
                }
                case 1: {
                    return data2;
                }
                case 4: {
                    short s = StreamSupportKt.readUShort$default(hex2.getData(), 0, ByteOrder.BigEndian, 1, null);
                    int n = s & 0xFFFF;
                    extAddr = n << 16;
                    break;
                }
                default: {
                    throw (Throwable)new IOException("invalid record type");
                }
            }
        }
        throw (Throwable)new IOException("file does not end with an end-of-file record");
    }

    public HexFile(@NotNull List<Hex> lines) {
        Intrinsics.checkParameterIsNotNull(lines, "lines");
        this.lines = lines;
    }

    public int getSize() {
        return this.lines.size();
    }

    public boolean contains(@NotNull Hex element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        return this.lines.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull(elements, "elements");
        return this.lines.containsAll(elements);
    }

    @Override
    @NotNull
    public Hex get(int index) {
        Hex hex2 = this.lines.get(index);
        Intrinsics.checkExpressionValueIsNotNull(hex2, "get(...)");
        return hex2;
    }

    public int indexOf(@NotNull Hex element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        return this.lines.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<Hex> iterator() {
        return this.lines.iterator();
    }

    public int lastIndexOf(@NotNull Hex element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        return this.lines.lastIndexOf(element);
    }

    @Override
    @NotNull
    public ListIterator<Hex> listIterator() {
        return this.lines.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<Hex> listIterator(int index) {
        return this.lines.listIterator(index);
    }

    @Override
    @NotNull
    public List<Hex> subList(int fromIndex, int toIndex) {
        return this.lines.subList(fromIndex, toIndex);
    }

    @Override
    public boolean add(Hex hex2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void add(int n, Hex hex2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int n, Collection<? extends Hex> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends Hex> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Hex remove(int n) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<Hex> unaryOperator) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Hex set(int n, Hex hex2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super Hex> comparator) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ boolean add(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ void add(int n, Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object remove(int n) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object set(int n, Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray(this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return CollectionToArray.toArray(this, TArray);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a8\u0006\r"}, d2={"Lde/treichels/hott/decoder/internal/firmware/HexFile$Companion;", "", "()V", "parse", "Lde/treichels/hott/decoder/internal/firmware/HexFile;", "file", "Ljava/io/File;", "decode", "", "text", "", "lines", "", "HoTT-Decoder"})
    public static final class Companion {
        @NotNull
        public final HexFile parse(@NotNull File file, boolean decode) {
            HexFile hexFile;
            Intrinsics.checkParameterIsNotNull(file, "file");
            if (decode) {
                byte[] byArray = HexFileKt.decode(FilesKt.readBytes(file));
                Companion companion = this;
                String string2 = new String(byArray, Charsets.UTF_8);
                hexFile = companion.parse(string2);
            } else {
                hexFile = this.parse(FilesKt.readLines$default(file, null, 1, null));
            }
            return hexFile;
        }

        @NotNull
        public static /* synthetic */ HexFile parse$default(Companion companion, File file, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.parse(file, bl);
        }

        @NotNull
        public final HexFile parse(@NotNull String text2) {
            Intrinsics.checkParameterIsNotNull(text2, "text");
            return this.parse(StringsKt.lines(text2));
        }

        @NotNull
        public final HexFile parse(@NotNull List<String> lines) {
            String it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull(lines, "lines");
            Iterable iterable = $receiver$iv = (Iterable)lines;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (String)element$iv$iv;
                CharSequence charSequence = it;
                if (!(!StringsKt.isBlank(charSequence))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<Hex> collection = (List)destination$iv$iv;
            $receiver$iv = collection;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                Hex hex2 = Hex.Companion.parseLine$HoTT_Decoder(it);
                collection.add(hex2);
            }
            collection = (List)destination$iv$iv;
            List list2 = collection;
            return new HexFile(list2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

