/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.decoder.internal.firmware;

import de.treichels.hott.decoder.internal.firmware.DeviceFirmware;
import de.treichels.hott.decoder.internal.firmware.HexFile;
import de.treichels.hott.model.enums.ESCType;
import de.treichels.hott.model.enums.ModuleType;
import de.treichels.hott.model.enums.Registered;
import de.treichels.hott.serial.SerialPort;
import de.treichels.hott.util.ByteOrder;
import de.treichels.hott.util.Callback;
import de.treichels.hott.util.StreamSupportKt;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B'\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lde/treichels/hott/decoder/internal/firmware/HexDeviceFirmware;", "Lde/treichels/hott/decoder/internal/firmware/DeviceFirmware;", "deviceType", "Lde/treichels/hott/model/enums/Registered;", "version", "", "packets", "", "", "(Lde/treichels/hott/model/enums/Registered;I[[B)V", "getVersion", "()I", "updateDevice", "", "callback", "Lde/treichels/hott/util/Callback;", "port", "Lde/treichels/hott/serial/SerialPort;", "Companion", "HoTT-Decoder"})
public final class HexDeviceFirmware
extends DeviceFirmware {
    private final int version;
    public static final Companion Companion = new Companion(null);

    @Override
    public void updateDevice(@Nullable Callback callback, @NotNull SerialPort port) {
        Intrinsics.checkParameterIsNotNull(port, "port");
        String string2 = "not implemented";
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
    }

    public final int getVersion() {
        return this.version;
    }

    public HexDeviceFirmware(@NotNull Registered<?> deviceType, int version, @NotNull byte[][] packets) {
        Intrinsics.checkParameterIsNotNull(deviceType, "deviceType");
        Intrinsics.checkParameterIsNotNull(packets, "packets");
        super(deviceType, packets);
        this.version = version;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lde/treichels/hott/decoder/internal/firmware/HexDeviceFirmware$Companion;", "", "()V", "load", "Lde/treichels/hott/decoder/internal/firmware/HexDeviceFirmware;", "file", "Ljava/io/File;", "HoTT-Decoder"})
    public static final class Companion {
        @NotNull
        public final HexDeviceFirmware load(@NotNull File file) {
            HexFile hexFile;
            Intrinsics.checkParameterIsNotNull(file, "file");
            try {
                hexFile = HexFile.Companion.parse(file, true);
            }
            catch (IOException e) {
                hexFile = HexFile.Companion.parse(file, false);
            }
            HexFile hex2 = hexFile;
            int productCode = StreamSupportKt.readInt(hex2.data(), 8192, ByteOrder.LittleEndian);
            ESCType eSCType = ESCType.Companion.forProductCode(productCode);
            Registered deviceType = eSCType != null ? (Registered)eSCType : (Registered)ModuleType.Companion.forProductCode(productCode);
            int version = StreamSupportKt.readInt$default(hex2.data(), 8196, null, 2, null);
            if (deviceType == null) {
                throw (Throwable)new IOException("unknown product code " + productCode);
            }
            String string2 = "found firmware for device " + deviceType + " version " + version;
            System.out.println((Object)string2);
            return new HexDeviceFirmware(deviceType, version, new byte[][]{hex2.data()});
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

