/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.decoder;

import de.treichels.hott.decoder.HoTTSerialPortException;
import de.treichels.hott.decoder.internal.commands.ADPCMErase;
import de.treichels.hott.decoder.internal.commands.ADPCMPlay;
import de.treichels.hott.decoder.internal.commands.ADPCMReadDeviceInfo;
import de.treichels.hott.decoder.internal.commands.ADPCMReadFileData;
import de.treichels.hott.decoder.internal.commands.ADPCMReadFileInfo;
import de.treichels.hott.decoder.internal.commands.ADPCMReadInfoSectorCount;
import de.treichels.hott.decoder.internal.commands.ADPCMWriteFileData;
import de.treichels.hott.decoder.internal.commands.ADPCMWriteFileInfo;
import de.treichels.hott.decoder.internal.commands.BaseCommand;
import de.treichels.hott.decoder.internal.commands.BaseResponse;
import de.treichels.hott.decoder.internal.commands.DirCreate;
import de.treichels.hott.decoder.internal.commands.DirListOne;
import de.treichels.hott.decoder.internal.commands.DirOpen;
import de.treichels.hott.decoder.internal.commands.EEpromReadPacket;
import de.treichels.hott.decoder.internal.commands.FileClose;
import de.treichels.hott.decoder.internal.commands.FileDelete;
import de.treichels.hott.decoder.internal.commands.FileOpen;
import de.treichels.hott.decoder.internal.commands.FileRead;
import de.treichels.hott.decoder.internal.commands.FileStatus;
import de.treichels.hott.decoder.internal.commands.FileWrite;
import de.treichels.hott.decoder.internal.commands.LCDClear;
import de.treichels.hott.decoder.internal.commands.LCDDisplay;
import de.treichels.hott.decoder.internal.commands.LCDOff;
import de.treichels.hott.decoder.internal.commands.LCDOn;
import de.treichels.hott.decoder.internal.commands.QueryTxInfo;
import de.treichels.hott.decoder.internal.commands.ReadModelData;
import de.treichels.hott.decoder.internal.commands.RfOutOff;
import de.treichels.hott.decoder.internal.commands.RfOutOn;
import de.treichels.hott.decoder.internal.commands.ServoPositions;
import de.treichels.hott.decoder.internal.decoder.BaseDecoder;
import de.treichels.hott.decoder.internal.decoder.VDFDecoder;
import de.treichels.hott.decoder.internal.firmware.DeviceFirmware;
import de.treichels.hott.decoder.internal.io.HoTTReader;
import de.treichels.hott.decoder.internal.io.HoTTWriter;
import de.treichels.hott.model.HoTTException;
import de.treichels.hott.model.enums.Registered;
import de.treichels.hott.model.enums.TransmitterType;
import de.treichels.hott.serial.FileInfo;
import de.treichels.hott.serial.FileMode;
import de.treichels.hott.serial.FileType;
import de.treichels.hott.serial.ModelInfo;
import de.treichels.hott.serial.ResponseCode;
import de.treichels.hott.serial.SerialPort;
import de.treichels.hott.serial.TxInfo;
import de.treichels.hott.serial.UpdateHandler;
import de.treichels.hott.util.ByteOrder;
import de.treichels.hott.util.Callback;
import de.treichels.hott.voice.CountryCode;
import de.treichels.hott.voice.VDFType;
import de.treichels.hott.voice.VoiceData;
import de.treichels.hott.voice.VoiceFile;
import de.treichels.hott.voice.VoiceFileInfo;
import de.treichels.hott.voice.VoiceInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u0092\u00012\u00020\u0001:\u0002\u0092\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0010J\t\u0010<\u001a\u00020=H\u0096\u0001J\u0006\u0010>\u001a\u00020=J\u000e\u0010?\u001a\u00020=2\u0006\u0010;\u001a\u00020\u0010J\u000e\u0010@\u001a\u00020=2\u0006\u0010;\u001a\u00020\u0010J\u0016\u0010A\u001a\b\u0012\u0002\b\u0003\u0018\u00010B2\b\u0010C\u001a\u0004\u0018\u00010DJ\u0010\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0002J\u000e\u0010I\u001a\u00020=2\u0006\u0010J\u001a\u00020\u0018J\u0011\u0010K\u001a\u00020=2\u0006\u0010L\u001a\u00020\nH\u0096\u0001J\u0012\u0010M\u001a\u0006\u0012\u0002\b\u00030B2\u0006\u0010N\u001a\u00020OJ\u000e\u0010P\u001a\u00020Q2\u0006\u0010;\u001a\u00020\u0010J\u000e\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u0006J\u000e\u0010R\u001a\u00020S2\u0006\u0010U\u001a\u00020\nJ\u000e\u0010V\u001a\u00020\u00062\u0006\u0010U\u001a\u00020\nJ\u0010\u0010W\u001a\u0004\u0018\u00010X2\u0006\u0010T\u001a\u00020YJ\u0018\u0010W\u001a\u0004\u0018\u00010X2\u0006\u0010Z\u001a\u00020\n2\u0006\u0010J\u001a\u00020\u0018J\u0018\u0010[\u001a\u0004\u0018\u00010Y2\u0006\u0010Z\u001a\u00020\n2\u0006\u0010J\u001a\u00020\u0018J\u000e\u0010\\\u001a\u00020]2\u0006\u0010J\u001a\u00020\u0018J\u0019\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00100_2\u0006\u0010;\u001a\u00020\u0010\u00a2\u0006\u0002\u0010`J\u001c\u0010a\u001a\u0004\u0018\u00010b2\u0006\u0010J\u001a\u00020\u00182\n\u0010c\u001a\u0006\u0012\u0002\b\u00030dJ\t\u0010e\u001a\u00020=H\u0096\u0001J\u000e\u0010f\u001a\u00020=2\u0006\u0010Z\u001a\u00020\nJ\t\u0010g\u001a\u00020\nH\u0096\u0001J%\u0010h\u001a\u00020\n2\u0006\u0010i\u001a\u00020S2\b\b\u0002\u0010j\u001a\u00020'2\b\b\u0002\u0010k\u001a\u00020'H\u0096\u0001J\u0016\u0010l\u001a\u00020=2\u0006\u0010;\u001a\u00020\u00102\u0006\u0010m\u001a\u00020!J\u0013\u0010n\u001a\u00020\n2\b\b\u0002\u0010o\u001a\u00020pH\u0096\u0001J\u0013\u0010q\u001a\u00020'2\b\b\u0002\u0010o\u001a\u00020pH\u0096\u0001J\u001e\u0010r\u001a\u00020=2\u0006\u0010s\u001a\u00020\n2\u0006\u0010t\u001a\u00020\n2\u0006\u0010m\u001a\u00020!J\"\u0010u\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020S0v2\u0006\u0010s\u001a\u00020\n2\u0006\u0010t\u001a\u00020\nJ\u000e\u0010w\u001a\u00020S2\u0006\u0010s\u001a\u00020\nJ\u0010\u0010x\u001a\u00020=2\u0006\u0010y\u001a\u00020FH\u0002J\u0013\u0010z\u001a\u00020{2\b\b\u0002\u0010o\u001a\u00020pH\u0096\u0001J\t\u0010|\u001a\u00020=H\u0096\u0001J\u0010\u0010}\u001a\u00020=2\u0006\u0010G\u001a\u00020HH\u0002J\u001a\u0010~\u001a\u00020=2\u0006\u0010\u007f\u001a\u00020b2\n\u0010c\u001a\u0006\u0012\u0002\b\u00030dJ\u000e\u0010\u0080\u0001\u001a\t\u0012\u0005\u0012\u00030\u0081\u00010\u0005J\u0007\u0010\u0082\u0001\u001a\u00020=J\u0007\u0010\u0083\u0001\u001a\u00020=J\u0019\u0010\u0084\u0001\u001a\u00020=2\u0006\u0010N\u001a\u00020O2\b\u0010C\u001a\u0004\u0018\u00010DJ\u0013\u0010\u0085\u0001\u001a\u00020\n2\u0007\u0010\u0086\u0001\u001a\u00020\nH\u0096\u0001J&\u0010\u0087\u0001\u001a\u00020\n2\u0006\u0010i\u001a\u00020S2\b\b\u0002\u0010j\u001a\u00020'2\b\b\u0002\u0010k\u001a\u00020'H\u0096\u0001J$\u0010\u0088\u0001\u001a\u00020=2\u0006\u0010;\u001a\u00020\u00102\u0007\u0010\u0089\u0001\u001a\u00020\u00142\n\b\u0002\u0010\u008a\u0001\u001a\u00030\u008b\u0001J.\u0010\u008c\u0001\u001a\u00020=2\u0006\u0010J\u001a\u00020\u00182\u0006\u0010i\u001a\u00020S2\u0007\u0010\u008d\u0001\u001a\u00020\n2\n\u0010c\u001a\u0006\u0012\u0002\b\u00030dH\u0002J%\u0010\u008e\u0001\u001a\u00020=2\u0006\u0010J\u001a\u00020\u00182\u0006\u0010i\u001a\u00020S2\n\u0010c\u001a\u0006\u0012\u0002\b\u00030dH\u0002J\"\u0010\u008f\u0001\u001a\u00020:2\u0013\u0010\u0090\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100_\"\u00020\u0010\u00a2\u0006\u0003\u0010\u0091\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\nX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0018X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\f\"\u0004\b\u001f\u0010\u000eR\u0012\u0010 \u001a\u00020!X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0012\u0010$\u001a\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0012R\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R$\u0010+\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\f\"\u0004\b-\u0010\u000eR\u0018\u0010.\u001a\u00020\nX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b/\u0010\f\"\u0004\b0\u0010\u000eR\u0011\u00101\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0011\u00105\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006\u0093\u0001"}, d2={"Lde/treichels/hott/decoder/HoTTSerialPort;", "Lde/treichels/hott/serial/SerialPort;", "implementation", "(Lde/treichels/hott/serial/SerialPort;)V", "allModelInfos", "", "Lde/treichels/hott/serial/ModelInfo;", "getAllModelInfos", "()Ljava/util/List;", "baudRate", "", "getBaudRate", "()I", "setBaudRate", "(I)V", "currentThread", "", "getCurrentThread", "()Ljava/lang/String;", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "isOpen", "", "()Z", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "maxRetries", "getMaxRetries", "setMaxRetries", "outputStream", "Ljava/io/OutputStream;", "getOutputStream", "()Ljava/io/OutputStream;", "portName", "getPortName", "rfId", "", "getRfId", "()J", "<set-?>", "sequence", "getSequence", "setSequence", "timeout", "getTimeout", "setTimeout", "transmitterType", "Lde/treichels/hott/model/enums/TransmitterType;", "getTransmitterType", "()Lde/treichels/hott/model/enums/TransmitterType;", "txInfo", "Lde/treichels/hott/serial/TxInfo;", "getTxInfo", "()Lde/treichels/hott/serial/TxInfo;", "changeDir", "Lde/treichels/hott/serial/ResponseCode;", "path", "close", "", "closeScreen", "createDir", "deleteFile", "detectDevice", "Lde/treichels/hott/model/enums/Registered;", "callback", "Lde/treichels/hott/util/Callback;", "doCommand", "Lde/treichels/hott/decoder/internal/commands/BaseResponse;", "cmd", "Lde/treichels/hott/decoder/internal/commands/BaseCommand;", "eraseVoiceFiles", "user", "expect", "rc", "getDeviceType", "file", "Ljava/io/File;", "getFileInfo", "Lde/treichels/hott/serial/FileInfo;", "getModelData", "", "info", "modelNumber", "getModelInfo", "getVoiceData", "Lde/treichels/hott/voice/VoiceData;", "Lde/treichels/hott/voice/VoiceFileInfo;", "index", "getVoiceFileInfo", "getVoiceInfo", "Lde/treichels/hott/voice/VoiceInfo;", "listDir", "", "(Ljava/lang/String;)[Ljava/lang/String;", "loadVoiceFile", "Lde/treichels/hott/voice/VoiceFile;", "handler", "Lde/treichels/hott/serial/UpdateHandler;", "open", "playSound", "read", "readBytes", "data", "length", "offset", "readFile", "out", "readInt", "byteOrder", "Lde/treichels/hott/util/ByteOrder;", "readLong", "readMemory", "address", "size", "readMemoryBlock", "Lkotlin/Pair;", "readModelData", "readResponse", "response", "readShort", "", "reset", "sendCommand", "sendVoiceFile", "voiceFile", "servoPositions", "", "turnRfOutOff", "turnRfOutOn", "updateDevice", "write", "b", "writeBytes", "writeFile", "in", "mode", "Lde/treichels/hott/serial/FileMode;", "writeFileData", "infoSize", "writeFileInfo", "writeScreen", "text", "([Ljava/lang/String;)Lde/treichels/hott/serial/ResponseCode;", "Companion", "HoTT-Decoder"})
public final class HoTTSerialPort
implements SerialPort {
    private int sequence;
    private int maxRetries;
    private final Logger logger;
    private static final int DEFAULT_RETRIES = 20;
    private static final int STX = 0;
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ SerialPort $$delegate_0;

    public final int getSequence() {
        return this.sequence;
    }

    private final void setSequence(int n) {
        this.sequence = n;
    }

    public final int getMaxRetries() {
        return this.maxRetries;
    }

    public final void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    @NotNull
    public final List<ModelInfo> getAllModelInfos() {
        return BaseDecoder.Companion.getDecoder(this).getAllModelInfos(this);
    }

    public final long getRfId() {
        return BaseDecoder.Companion.getRfId(this);
    }

    @NotNull
    public final TransmitterType getTransmitterType() {
        BaseResponse response = this.doCommand(new EEpromReadPacket(8, 4));
        HoTTReader reader = new HoTTReader(response.getData());
        int productCode = reader.readInt();
        return TransmitterType.Companion.forProductCode(productCode);
    }

    @NotNull
    public final TxInfo getTxInfo() {
        BaseResponse baseResponse = this.doCommand(new QueryTxInfo());
        if (baseResponse == null) {
            throw new TypeCastException("null cannot be cast to non-null type de.treichels.hott.decoder.internal.commands.QueryTxInfo.Response");
        }
        QueryTxInfo.Response response = (QueryTxInfo.Response)baseResponse;
        BaseDecoder decoder2 = BaseDecoder.Companion.getDecoder(response.getTransmitterType());
        String ownerName = decoder2.getOwnerName(this);
        List<String> customPhaseNames = decoder2.getCustomPhaseNames(this);
        long rfId = this.getRfId();
        return new TxInfo(rfId, response.getTransmitterType(), response.getAppVersion(), response.getMemoryVersion(), response.getYear(), response.getName(), response.getVendor(), ownerName, customPhaseNames);
    }

    public final void updateDevice(@NotNull File file, @Nullable Callback callback) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        DeviceFirmware.Companion.load(file).updateDevice(callback, this);
    }

    @Nullable
    public final Registered<?> detectDevice(@Nullable Callback callback) {
        return DeviceFirmware.Companion.detectDevice(callback, this);
    }

    @NotNull
    public final Registered<?> getDeviceType(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        return DeviceFirmware.Companion.load(file).getDeviceType();
    }

    @NotNull
    public final ResponseCode changeDir(@NotNull String path2) {
        Intrinsics.checkParameterIsNotNull(path2, "path");
        return this.doCommand(new DirOpen(path2)).getResponseCode();
    }

    public final void closeScreen() {
        this.doCommand(new LCDOff());
    }

    public final void createDir(@NotNull String path2) {
        Intrinsics.checkParameterIsNotNull(path2, "path");
        this.doCommand(new DirCreate(path2));
    }

    public final void deleteFile(@NotNull String path2) {
        Intrinsics.checkParameterIsNotNull(path2, "path");
        this.doCommand(new FileDelete(path2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BaseResponse doCommand(BaseCommand cmd) {
        Object object;
        Exception exception;
        BaseResponse response;
        block14: {
            int retries = 0;
            response = cmd.getResponse();
            exception = null;
            HoTTSerialPort hoTTSerialPort = this;
            Throwable throwable = null;
            try {
                HoTTSerialPort it = hoTTSerialPort;
                it.open();
                while (retries < this.maxRetries) {
                    try {
                        this.sendCommand(cmd);
                        this.readResponse(response);
                        if (response.getResponseCode() == ResponseCode.ACK || response.getResponseCode() == ResponseCode.NACK) {
                            exception = null;
                            object = response;
                            break block14;
                        }
                        if (response.getResponseCode() != ResponseCode.BUSY) continue;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            throw (Throwable)new HoTTSerialPortException(e);
                        }
                    }
                    catch (IOException e) {
                        this.logger.log(Level.WARNING, "command failed " + retries + '/' + this.maxRetries, e);
                        int n = retries;
                        retries = n + 1;
                        exception = e;
                    }
                }
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(hoTTSerialPort, throwable);
            }
        }
        Unit unit = object;
        if (exception != null) {
            Exception exception2 = exception;
            if (exception2 == null) {
                Intrinsics.throwNpe();
            }
            throw (Throwable)exception2;
        }
        return response;
    }

    public final void eraseVoiceFiles(boolean user) {
        this.doCommand(new ADPCMErase(user));
    }

    @NotNull
    public final FileInfo getFileInfo(@NotNull String path2) {
        Intrinsics.checkParameterIsNotNull(path2, "path");
        BaseResponse baseResponse = this.doCommand(new FileStatus(path2));
        if (baseResponse == null) {
            throw new TypeCastException("null cannot be cast to non-null type de.treichels.hott.decoder.internal.commands.FileStatus.Response");
        }
        FileStatus.Response response = (FileStatus.Response)baseResponse;
        return new FileInfo(path2, response.getName(), response.getSize(), response.getModifyDate(), response.getFileType());
    }

    @NotNull
    public final byte[] getModelData(int modelNumber) {
        return BaseDecoder.Companion.getDecoder(this).getModelData(this, modelNumber);
    }

    @NotNull
    public final byte[] getModelData(@NotNull ModelInfo info) {
        Intrinsics.checkParameterIsNotNull(info, "info");
        TransmitterType transmitterType = info.getTransmitterType();
        return BaseDecoder.Companion.getDecoder(transmitterType).getModelData(this, info);
    }

    @NotNull
    public final ModelInfo getModelInfo(int modelNumber) {
        return BaseDecoder.Companion.getDecoder(this).getModelInfo(this, modelNumber);
    }

    @Nullable
    public final VoiceData getVoiceData(int index, boolean user) {
        VoiceFileInfo info = this.getVoiceFileInfo(index, user);
        return info == null ? null : this.getVoiceData(info);
    }

    private final String getCurrentThread() {
        Thread thread2 = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull(thread2, "Thread.currentThread()");
        String string2 = thread2.getName();
        Intrinsics.checkExpressionValueIsNotNull(string2, "Thread.currentThread().name");
        return string2;
    }

    @Nullable
    public final VoiceData getVoiceData(@NotNull VoiceFileInfo info) {
        Intrinsics.checkParameterIsNotNull(info, "info");
        int baseAddress = info.getBaseAddress();
        int size = info.getSize();
        int maxPacketSize = 2048;
        byte[] data2 = new byte[]{};
        while (data2.length < size) {
            int address = baseAddress + data2.length;
            int packetSize = Math.min(maxPacketSize, size - data2.length);
            BaseResponse response = this.doCommand(new ADPCMReadFileData(address, packetSize, info.getVdfType() == VDFType.User));
            if (response.getData().length != packetSize) {
                this.logger.warning("invalid packet size " + response.getData().length + " expected " + packetSize + '!');
            }
            data2 = ArraysKt.plus(data2, response.getData());
        }
        return data2.length == size ? new VoiceData(info.getName(), data2) : null;
    }

    @Nullable
    public final VoiceFileInfo getVoiceFileInfo(int index, boolean user) {
        BaseResponse baseResponse = this.doCommand(new ADPCMReadFileInfo(index, user));
        if (baseResponse == null) {
            throw new TypeCastException("null cannot be cast to non-null type de.treichels.hott.decoder.internal.commands.ADPCMReadFileInfo.Response");
        }
        ADPCMReadFileInfo.Response r = (ADPCMReadFileInfo.Response)baseResponse;
        return r.getResponseCode() == ResponseCode.NACK ? null : new VoiceFileInfo(user ? VDFType.User : VDFType.System, r.getSize(), r.getBaseAddress(), r.getIndex(), r.getReverseIndex(), r.getSampleRate(), r.getName());
    }

    @NotNull
    public final VoiceInfo getVoiceInfo(boolean user) {
        int n;
        BaseResponse baseResponse = this.doCommand(new ADPCMReadDeviceInfo(user));
        if (baseResponse == null) {
            throw new TypeCastException("null cannot be cast to non-null type de.treichels.hott.decoder.internal.commands.ADPCMReadDeviceInfo.Response");
        }
        ADPCMReadDeviceInfo.Response deviceInfo = (ADPCMReadDeviceInfo.Response)baseResponse;
        int flashSize = deviceInfo.getFlashSize();
        int sectorCount = deviceInfo.getSectorCount();
        int sectorSize = deviceInfo.getSectorSize();
        int voiceVersion = deviceInfo.getVoiceVersion();
        if (voiceVersion < 2500) {
            n = 8192;
        } else {
            BaseResponse baseResponse2 = this.doCommand(new ADPCMReadInfoSectorCount(user));
            if (baseResponse2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type de.treichels.hott.decoder.internal.commands.ADPCMReadInfoSectorCount.Response");
            }
            ADPCMReadInfoSectorCount.Response response = (ADPCMReadInfoSectorCount.Response)baseResponse2;
            n = response.getInfoSectorCount() * sectorSize;
        }
        int infoSize = n;
        int maxDataSize = flashSize - infoSize;
        return new VoiceInfo(user ? VDFType.User : VDFType.System, flashSize, sectorCount, sectorSize, voiceVersion, infoSize, maxDataSize);
    }

    @NotNull
    public final String[] listDir(@NotNull String path2) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull(path2, "path");
        ArrayList<String> names = new ArrayList<String>();
        this.changeDir(path2);
        while (true) {
            BaseResponse baseResponse = this.doCommand(new DirListOne());
            if (baseResponse == null) {
                throw new TypeCastException("null cannot be cast to non-null type de.treichels.hott.decoder.internal.commands.DirListOne.Response");
            }
            DirListOne.Response response = (DirListOne.Response)baseResponse;
            if (response.getLen() == 0) break;
            if (response.getFileType() != FileType.Dir && (response.getFileType() != FileType.File || response.getFlag() != 'A')) continue;
            names.add(path2 + (StringsKt.endsWith$default(path2, "/", false, 2, null) ? "" : "/") + response.getName());
        }
        Collection thisCollection$iv = $receiver$iv = (Collection)names;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final VoiceFile loadVoiceFile(boolean user, @NotNull UpdateHandler<?> handler) {
        void vdfType;
        boolean bl;
        void voiceVersion;
        Intrinsics.checkParameterIsNotNull(handler, "handler");
        ArrayList<VoiceData> voiceDataList = new ArrayList<VoiceData>();
        VoiceInfo voiceInfo = this.getVoiceInfo(user);
        VDFType vDFType = voiceInfo.component1();
        int n = voiceInfo.component5();
        int infoSize = voiceInfo.component6();
        if (user && voiceVersion == 2000) {
            return null;
        }
        BaseResponse response = this.doCommand(new ADPCMReadFileData(infoSize - 32, 32, user));
        HoTTReader reader = new HoTTReader(response.getData());
        int voiceVersion2 = reader.readInt();
        boolean bl2 = bl = voiceVersion == voiceVersion2;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        TransmitterType transmitterType = TransmitterType.Companion.forProductCode(reader.readInt());
        CountryCode countryCode = CountryCode.Companion.forCode(reader.readByte());
        ObservableList observableList = FXCollections.observableList((List)voiceDataList);
        Intrinsics.checkExpressionValueIsNotNull(observableList, "FXCollections.observableList(voiceDataList)");
        VoiceFile result2 = new VoiceFile((VDFType)vdfType, transmitterType, (int)voiceVersion, countryCode, (List)observableList);
        int maxCount = VDFDecoder.INSTANCE.getMaxVoiceCount(result2);
        boolean done = false;
        try {
            int n2 = 0;
            int n3 = maxCount;
            while (n2 < n3) {
                void i2;
                if (!handler.isCancelled() && !done) {
                    handler.update((int)i2, maxCount);
                    while (true) {
                        VoiceFileInfo info;
                        if ((info = this.getVoiceFileInfo((int)i2, user)) == null) {
                            done = true;
                            break;
                        }
                        VoiceData voiceData = this.getVoiceData(info);
                        if (voiceData != null) {
                            voiceDataList.add(voiceData);
                            break;
                        }
                        this.logger.warning("empty voice data");
                    }
                }
                ++i2;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return handler.isCancelled() ? null : result2;
    }

    public final void playSound(int index) {
        this.doCommand(new ADPCMPlay(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readFile(@NotNull String path2, @NotNull OutputStream out) {
        Intrinsics.checkParameterIsNotNull(path2, "path");
        Intrinsics.checkParameterIsNotNull(out, "out");
        FileInfo info = this.getFileInfo(path2);
        int size = info.getSize();
        this.doCommand(new FileOpen(path2, FileMode.Read));
        try {
            BaseResponse response;
            for (int offset = 0; offset < size; offset += response.getLen()) {
                int len = Math.min(512, size - offset);
                response = this.doCommand(new FileRead(len));
                out.write(response.getData(), 0, response.getLen());
            }
        }
        finally {
            this.doCommand(new FileClose());
        }
    }

    public final void readMemory(int address, int size, @NotNull OutputStream out) {
        byte[] data2;
        Intrinsics.checkParameterIsNotNull(out, "out");
        for (int offset = 0; offset < size; offset += data2.length) {
            int len = Math.min(size - offset, 2048);
            Pair<ResponseCode, byte[]> pair = this.readMemoryBlock(address + offset, len);
            data2 = pair.component2();
            out.write(data2);
        }
    }

    @NotNull
    public final Pair<ResponseCode, byte[]> readMemoryBlock(int address, int size) {
        if (size < 0 || size > 2048) {
            throw (Throwable)new HoTTException("HoTTSerialPort.InvalidBlockSize", new Object[0]);
        }
        BaseResponse response = this.doCommand(new EEpromReadPacket(address, size));
        return new Pair<ResponseCode, byte[]>(response.getResponseCode(), response.getData());
    }

    @NotNull
    public final byte[] readModelData(int address) {
        BaseResponse response = this.doCommand(new ReadModelData(address));
        return response.getData();
    }

    private final void readResponse(BaseResponse response) {
        HoTTReader reader = new HoTTReader(this.getInputStream());
        if (reader.readUnsignedByte() != 0) {
            throw (Throwable)new HoTTSerialPortException("HoTTSerialPort.NoStx", new Object[0]);
        }
        int sqn1 = reader.readUnsignedByte();
        int sqn2 = reader.readUnsignedByte();
        reader.resetCRC();
        int len = reader.readShort();
        int tcmd = reader.readByte();
        ResponseCode rc = ResponseCode.Companion.forId(reader.readByte());
        byte[] data2 = new byte[len];
        if (len > 0) {
            HoTTReader.read$default(reader, data2, 0, 0, 6, null);
        }
        int expected = reader.getCrc();
        int crc = reader.readUnsignedShort();
        this.logger.fine("SQN1=" + sqn1 + ", SQN2=" + sqn2 + ", len=" + len + ", tcmd=" + tcmd + ", rc=" + (Object)((Object)rc) + ", crc=" + crc + '/' + expected);
        if (sqn1 != (~sqn2 & 0xFF)) {
            throw (Throwable)new HoTTSerialPortException("HoTTSerialPort.WrongSqn2", new Object[0]);
        }
        if (crc != expected) {
            throw (Throwable)new HoTTSerialPortException("ChecksumError", expected, crc);
        }
        response.setSqn1(sqn1);
        response.setSqn2(sqn2);
        response.setLen(len);
        response.setTcmd(tcmd);
        response.setResponseCode(rc);
        response.setData(data2);
    }

    private final void sendCommand(BaseCommand cmd) {
        HoTTWriter writer = new HoTTWriter(null, 1, null);
        writer.writeUnsignedByte(0);
        writer.writeUnsignedByte(this.sequence);
        writer.writeUnsignedByte(~this.sequence & 0xFF);
        writer.resetCRC();
        writer.writeUnsignedShort(cmd.getLen());
        writer.writeUnsignedByte(cmd.getTcmd());
        writer.writeUnsignedByte(cmd.getPcmd());
        if (cmd.getLen() > 0) {
            HoTTWriter.write$default(writer, cmd.getData(), 0, 0, 6, null);
        }
        writer.writeUnsignedShort(writer.getCrc());
        this.logger.fine(cmd.getClass().getSimpleName() + " SQN1=" + this.sequence + ", SQN2=" + (~this.sequence & 0xFF) + ", len=" + cmd.getLen() + ", tcmd=" + cmd.getTcmd() + ", pcmd=" + cmd.getPcmd());
        HoTTSerialPort hoTTSerialPort = this;
        ++hoTTSerialPort.sequence;
        if (hoTTSerialPort.sequence == 255) {
            this.sequence = 1;
        }
        this.getOutputStream().write(writer.getData());
        this.getOutputStream().flush();
    }

    /*
     * WARNING - void declaration
     */
    public final void sendVoiceFile(@NotNull VoiceFile voiceFile, @NotNull UpdateHandler<?> handler) {
        void voiceVersion;
        Intrinsics.checkParameterIsNotNull(voiceFile, "voiceFile");
        Intrinsics.checkParameterIsNotNull(handler, "handler");
        TransmitterType transmitterType = this.getTransmitterType();
        if (voiceFile.getTransmitterType() != transmitterType) {
            throw (Throwable)new HoTTException("TransmitterTypeMismatch", new Object[0]);
        }
        boolean user = voiceFile.getVdfType() == VDFType.User;
        VoiceInfo voiceInfo = this.getVoiceInfo(user);
        int n = voiceInfo.component5();
        int infoSize = voiceInfo.component6();
        if (voiceVersion != voiceFile.getVdfVersion()) {
            throw (Throwable)new HoTTException("VoiceVersionMismatch", new Object[0]);
        }
        int dataSize = voiceFile.getRawDataSize();
        int headerSize = 32;
        byte[] data2 = VDFDecoder.INSTANCE.encodeVDF(voiceFile);
        try {
            byte[] infoData = new byte[infoSize];
            System.arraycopy(data2, headerSize, infoData, 0, infoSize);
            this.writeFileInfo(user, infoData, handler);
            byte[] pcmData = new byte[dataSize];
            System.arraycopy(data2, headerSize + infoSize, pcmData, 0, dataSize);
            this.writeFileData(user, pcmData, infoSize, handler);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @NotNull
    public final List<Float> servoPositions() {
        BaseResponse baseResponse = this.doCommand(new ServoPositions());
        if (baseResponse == null) {
            throw new TypeCastException("null cannot be cast to non-null type de.treichels.hott.decoder.internal.commands.ServoPositions.Response");
        }
        return ((ServoPositions.Response)baseResponse).getPositions();
    }

    public final void turnRfOutOff() {
        this.doCommand(new RfOutOff());
    }

    public final void turnRfOutOn() {
        this.doCommand(new RfOutOn());
    }

    public final void writeFile(@NotNull String path2, @NotNull InputStream in, @NotNull FileMode mode) {
        Intrinsics.checkParameterIsNotNull(path2, "path");
        Intrinsics.checkParameterIsNotNull(in, "in");
        Intrinsics.checkParameterIsNotNull((Object)mode, "mode");
        this.doCommand(new FileOpen(path2, mode));
        while (in.available() > 0) {
            int len = Math.min(512, in.available());
            byte[] d = new byte[len];
            in.read(d);
            this.doCommand(new FileWrite(d));
        }
        this.doCommand(new FileClose());
    }

    public static /* synthetic */ void writeFile$default(HoTTSerialPort hoTTSerialPort, String string2, InputStream inputStream2, FileMode fileMode, int n, Object object) {
        if ((n & 4) != 0) {
            fileMode = FileMode.Create;
        }
        hoTTSerialPort.writeFile(string2, inputStream2, fileMode);
    }

    private final void writeFileData(boolean user, byte[] data2, int infoSize, UpdateHandler<?> handler) {
        byte[] buffer;
        int size = data2.length;
        int packetSize = 2048;
        int count = size / packetSize;
        int rest = size % packetSize;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%sFileData: total size=%d with %d packets of size %d, rest %d%n";
        Object[] objectArray = new Object[]{user ? "User" : "System", size, count, packetSize, rest};
        Logger logger = this.logger;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(format, *args)");
        String string4 = string3;
        logger.fine(string4);
        for (int i2 = 0; i2 < count && !handler.isCancelled(); ++i2) {
            int address = i2 * packetSize;
            buffer = new byte[packetSize];
            System.arraycopy(data2, address, buffer, 0, packetSize);
            this.doCommand(new ADPCMWriteFileData(address + infoSize, user, buffer));
            handler.update(i2, count);
        }
        if (rest > 0) {
            int address = count * packetSize;
            buffer = new byte[rest];
            System.arraycopy(data2, address, buffer, 0, rest);
            this.doCommand(new ADPCMWriteFileData(address + infoSize, user, buffer));
            handler.update(count, count);
        }
    }

    private final void writeFileInfo(boolean user, byte[] data2, UpdateHandler<?> handler) {
        byte[] buffer;
        int size = data2.length;
        int packetSize = 2048;
        int count = size / packetSize;
        int rest = size % packetSize;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%sFileInfo: total size=%d with %d packets of size %d, rest %d%n";
        Object[] objectArray = new Object[]{user ? "User" : "System", size, count, packetSize, rest};
        Logger logger = this.logger;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(format, *args)");
        String string4 = string3;
        logger.fine(string4);
        for (int i2 = 0; i2 < count && !handler.isCancelled(); ++i2) {
            int address = i2 * packetSize;
            buffer = new byte[packetSize];
            System.arraycopy(data2, address, buffer, 0, packetSize);
            this.doCommand(new ADPCMWriteFileInfo(address, user, buffer));
            handler.update(i2, count);
        }
        if (rest > 0) {
            int address = count * packetSize;
            buffer = new byte[rest];
            System.arraycopy(data2, address, buffer, 0, rest);
            this.doCommand(new ADPCMWriteFileInfo(address, user, buffer));
            handler.update(count, count);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ResponseCode writeScreen(String ... text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        int rows = Math.min(text2.length, 6);
        ResponseCode rc = this.doCommand(new LCDOn()).getResponseCode();
        if (rc == ResponseCode.ACK && (rc = this.doCommand(new LCDClear()).getResponseCode()) == ResponseCode.ACK) {
            void i2;
            int n = 0;
            int n2 = rows;
            while (n < n2 && (rc = this.doCommand(new LCDDisplay((int)i2, text2[i2])).getResponseCode()) == ResponseCode.ACK) {
                ++i2;
            }
        }
        return rc;
    }

    public HoTTSerialPort(@NotNull SerialPort implementation) {
        Intrinsics.checkParameterIsNotNull(implementation, "implementation");
        this.$$delegate_0 = implementation;
        this.sequence = 1;
        this.maxRetries = 20;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    @Override
    public int getBaudRate() {
        return this.$$delegate_0.getBaudRate();
    }

    @Override
    public void setBaudRate(int n) {
        this.$$delegate_0.setBaudRate(n);
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return this.$$delegate_0.getInputStream();
    }

    @Override
    public boolean isOpen() {
        return this.$$delegate_0.isOpen();
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        return this.$$delegate_0.getOutputStream();
    }

    @Override
    @NotNull
    public String getPortName() {
        return this.$$delegate_0.getPortName();
    }

    @Override
    public int getTimeout() {
        return this.$$delegate_0.getTimeout();
    }

    @Override
    public void setTimeout(int n) {
        this.$$delegate_0.setTimeout(n);
    }

    @Override
    public void close() {
        this.$$delegate_0.close();
    }

    @Override
    public void expect(int rc) {
        this.$$delegate_0.expect(rc);
    }

    @Override
    public void open() {
        this.$$delegate_0.open();
    }

    @Override
    public int read() {
        return this.$$delegate_0.read();
    }

    @Override
    public int readBytes(@NotNull byte[] data2, long length, long offset) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        return this.$$delegate_0.readBytes(data2, length, offset);
    }

    @Override
    public int readInt(@NotNull ByteOrder byteOrder) {
        Intrinsics.checkParameterIsNotNull((Object)byteOrder, "byteOrder");
        return this.$$delegate_0.readInt(byteOrder);
    }

    @Override
    public long readLong(@NotNull ByteOrder byteOrder) {
        Intrinsics.checkParameterIsNotNull((Object)byteOrder, "byteOrder");
        return this.$$delegate_0.readLong(byteOrder);
    }

    @Override
    public short readShort(@NotNull ByteOrder byteOrder) {
        Intrinsics.checkParameterIsNotNull((Object)byteOrder, "byteOrder");
        return this.$$delegate_0.readShort(byteOrder);
    }

    @Override
    public void reset() {
        this.$$delegate_0.reset();
    }

    @Override
    public int write(int b) {
        return this.$$delegate_0.write(b);
    }

    @Override
    public int writeBytes(@NotNull byte[] data2, long length, long offset) {
        Intrinsics.checkParameterIsNotNull(data2, "data");
        return this.$$delegate_0.writeBytes(data2, length, offset);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/treichels/hott/decoder/HoTTSerialPort$Companion;", "", "()V", "DEFAULT_RETRIES", "", "STX", "HoTT-Decoder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

