/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusBehavior;
import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Slider;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class SliderBehavior
extends BehaviorBase<Slider> {
    private final InputMap<Slider> sliderInputMap = this.createInputMap();
    private TwoLevelFocusBehavior tlFocus;

    public SliderBehavior(Slider slider2) {
        super(slider2);
        this.addDefaultMapping(this.sliderInputMap, new InputMap.KeyMapping(KeyCode.HOME, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.home())), new InputMap.KeyMapping(KeyCode.END, (EventType<KeyEvent>)KeyEvent.KEY_RELEASED, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.end())));
        InputMap<Slider> inputMap = new InputMap<Slider>(slider2);
        inputMap.setInterceptor(event -> slider2.getOrientation() != Orientation.HORIZONTAL);
        inputMap.getMappings().addAll((Object[])new InputMap.Mapping[]{new InputMap.KeyMapping(KeyCode.LEFT, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.rtl((Node)slider2, this::incrementValue, this::decrementValue))), new InputMap.KeyMapping(KeyCode.KP_LEFT, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.rtl((Node)slider2, this::incrementValue, this::decrementValue))), new InputMap.KeyMapping(KeyCode.RIGHT, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.rtl((Node)slider2, this::decrementValue, this::incrementValue))), new InputMap.KeyMapping(KeyCode.KP_RIGHT, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.rtl((Node)slider2, this::decrementValue, this::incrementValue)))});
        this.addDefaultChildMap(this.sliderInputMap, inputMap);
        InputMap<Slider> inputMap2 = new InputMap<Slider>(slider2);
        inputMap2.setInterceptor(event -> slider2.getOrientation() != Orientation.VERTICAL);
        inputMap2.getMappings().addAll((Object[])new InputMap.Mapping[]{new InputMap.KeyMapping(KeyCode.DOWN, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.decrementValue())), new InputMap.KeyMapping(KeyCode.KP_DOWN, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.decrementValue())), new InputMap.KeyMapping(KeyCode.UP, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.incrementValue())), new InputMap.KeyMapping(KeyCode.KP_UP, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> this.incrementValue()))});
        this.addDefaultChildMap(this.sliderInputMap, inputMap2);
        if (Utils.isTwoLevelFocus()) {
            this.tlFocus = new TwoLevelFocusBehavior((Node)slider2);
        }
    }

    @Override
    public void dispose() {
        if (this.tlFocus != null) {
            this.tlFocus.dispose();
        }
        super.dispose();
    }

    @Override
    public InputMap<Slider> getInputMap() {
        return this.sliderInputMap;
    }

    public void trackPress(MouseEvent mouseEvent, double d) {
        Slider slider2 = (Slider)this.getNode();
        if (!slider2.isFocused()) {
            slider2.requestFocus();
        }
        if (slider2.getOrientation().equals((Object)Orientation.HORIZONTAL)) {
            slider2.adjustValue(d * (slider2.getMax() - slider2.getMin()) + slider2.getMin());
        } else {
            slider2.adjustValue((1.0 - d) * (slider2.getMax() - slider2.getMin()) + slider2.getMin());
        }
    }

    public void thumbPressed(MouseEvent mouseEvent, double d) {
        Slider slider2 = (Slider)this.getNode();
        if (!slider2.isFocused()) {
            slider2.requestFocus();
        }
        slider2.setValueChanging(true);
    }

    public void thumbDragged(MouseEvent mouseEvent, double d) {
        Slider slider2 = (Slider)this.getNode();
        slider2.setValue(com.sun.javafx.util.Utils.clamp(slider2.getMin(), d * (slider2.getMax() - slider2.getMin()) + slider2.getMin(), slider2.getMax()));
    }

    public void thumbReleased(MouseEvent mouseEvent) {
        Slider slider2 = (Slider)this.getNode();
        slider2.setValueChanging(false);
        slider2.adjustValue(slider2.getValue());
    }

    void home() {
        Slider slider2 = (Slider)this.getNode();
        slider2.adjustValue(slider2.getMin());
    }

    void decrementValue() {
        Slider slider2 = (Slider)this.getNode();
        if (slider2.isSnapToTicks()) {
            slider2.adjustValue(slider2.getValue() - this.computeIncrement());
        } else {
            slider2.decrement();
        }
    }

    void end() {
        Slider slider2 = (Slider)this.getNode();
        slider2.adjustValue(slider2.getMax());
    }

    void incrementValue() {
        Slider slider2 = (Slider)this.getNode();
        if (slider2.isSnapToTicks()) {
            slider2.adjustValue(slider2.getValue() + this.computeIncrement());
        } else {
            slider2.increment();
        }
    }

    double computeIncrement() {
        Slider slider2 = (Slider)this.getNode();
        double d = 0.0;
        d = slider2.getMinorTickCount() != 0 ? slider2.getMajorTickUnit() / (double)(Math.max(slider2.getMinorTickCount(), 0) + 1) : slider2.getMajorTickUnit();
        if (slider2.getBlockIncrement() > 0.0 && slider2.getBlockIncrement() < d) {
            return d;
        }
        return slider2.getBlockIncrement();
    }
}

