/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.qrcode;

import com.itextpdf.text.pdf.qrcode.BitArray;

public final class BitMatrix {
    public final int width;
    public final int height;
    public final int rowSize;
    public final int[] bits;

    public BitMatrix(int dimension) {
        this(dimension, dimension);
    }

    public BitMatrix(int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Both dimensions must be greater than 0");
        }
        this.width = width;
        this.height = height;
        int rowSize = width >> 5;
        if ((width & 0x1F) != 0) {
            ++rowSize;
        }
        this.rowSize = rowSize;
        this.bits = new int[rowSize * height];
    }

    public boolean get(int x, int y) {
        int offset = y * this.rowSize + (x >> 5);
        return (this.bits[offset] >>> (x & 0x1F) & 1) != 0;
    }

    public void set(int x, int y) {
        int offset;
        int n = offset = y * this.rowSize + (x >> 5);
        this.bits[n] = this.bits[n] | 1 << (x & 0x1F);
    }

    public void flip(int x, int y) {
        int offset;
        int n = offset = y * this.rowSize + (x >> 5);
        this.bits[n] = this.bits[n] ^ 1 << (x & 0x1F);
    }

    public void clear() {
        int max = this.bits.length;
        for (int i2 = 0; i2 < max; ++i2) {
            this.bits[i2] = 0;
        }
    }

    public void setRegion(int left2, int top2, int width, int height) {
        if (top2 < 0 || left2 < 0) {
            throw new IllegalArgumentException("Left and top must be nonnegative");
        }
        if (height < 1 || width < 1) {
            throw new IllegalArgumentException("Height and width must be at least 1");
        }
        int right2 = left2 + width;
        int bottom2 = top2 + height;
        if (bottom2 > this.height || right2 > this.width) {
            throw new IllegalArgumentException("The region must fit inside the matrix");
        }
        for (int y = top2; y < bottom2; ++y) {
            int offset = y * this.rowSize;
            for (int x = left2; x < right2; ++x) {
                int n = offset + (x >> 5);
                this.bits[n] = this.bits[n] | 1 << (x & 0x1F);
            }
        }
    }

    public BitArray getRow(int y, BitArray row2) {
        if (row2 == null || row2.getSize() < this.width) {
            row2 = new BitArray(this.width);
        }
        int offset = y * this.rowSize;
        for (int x = 0; x < this.rowSize; ++x) {
            row2.setBulk(x << 5, this.bits[offset + x]);
        }
        return row2;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDimension() {
        if (this.width != this.height) {
            throw new RuntimeException("Can't call getDimension() on a non-square matrix");
        }
        return this.width;
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer(this.height * (this.width + 1));
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                result2.append(this.get(x, y) ? "X " : "  ");
            }
            result2.append('\n');
        }
        return result2.toString();
    }
}

