/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class MappedRandomAccessFile {
    private static final int BUFSIZE = 0x40000000;
    private FileChannel channel = null;
    private MappedByteBuffer[] mappedBuffers;
    private long size;
    private long pos;

    public MappedRandomAccessFile(String filename, String mode) throws FileNotFoundException, IOException {
        if (mode.equals("rw")) {
            this.init(new RandomAccessFile(filename, mode).getChannel(), FileChannel.MapMode.READ_WRITE);
        } else {
            this.init(new FileInputStream(filename).getChannel(), FileChannel.MapMode.READ_ONLY);
        }
    }

    private void init(FileChannel channel, FileChannel.MapMode mapMode) throws IOException {
        this.channel = channel;
        this.size = channel.size();
        this.pos = 0L;
        int requiredBuffers = (int)(this.size / 0x40000000L) + (this.size % 0x40000000L == 0L ? 0 : 1);
        this.mappedBuffers = new MappedByteBuffer[requiredBuffers];
        try {
            int index = 0;
            for (long offset = 0L; offset < this.size; offset += 0x40000000L) {
                long size2 = Math.min(this.size - offset, 0x40000000L);
                this.mappedBuffers[index] = channel.map(mapMode, offset, size2);
                this.mappedBuffers[index].load();
                ++index;
            }
            if (index != requiredBuffers) {
                throw new Error("Should never happen - " + index + " != " + requiredBuffers);
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        catch (RuntimeException e) {
            this.close();
            throw e;
        }
    }

    public FileChannel getChannel() {
        return this.channel;
    }

    public int read() {
        try {
            int mapN = (int)(this.pos / 0x40000000L);
            int offN = (int)(this.pos % 0x40000000L);
            if (mapN >= this.mappedBuffers.length) {
                return -1;
            }
            if (offN >= this.mappedBuffers[mapN].limit()) {
                return -1;
            }
            byte b = this.mappedBuffers[mapN].get(offN);
            ++this.pos;
            int n = b & 0xFF;
            return n;
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    public int read(byte[] bytes, int off, int len) {
        MappedByteBuffer currentBuffer;
        int totalRead;
        int bytesFromThisBuffer;
        int mapN = (int)(this.pos / 0x40000000L);
        int offN = (int)(this.pos % 0x40000000L);
        for (totalRead = 0; totalRead < len && mapN < this.mappedBuffers.length && offN <= (currentBuffer = this.mappedBuffers[mapN]).limit(); totalRead += bytesFromThisBuffer, ++mapN) {
            currentBuffer.position(offN);
            bytesFromThisBuffer = Math.min(len - totalRead, currentBuffer.remaining());
            currentBuffer.get(bytes, off, bytesFromThisBuffer);
            off += bytesFromThisBuffer;
            this.pos += (long)bytesFromThisBuffer;
            offN = 0;
        }
        return totalRead == 0 ? -1 : totalRead;
    }

    public long getFilePointer() {
        return this.pos;
    }

    public void seek(long pos) {
        this.pos = pos;
    }

    public long length() {
        return this.size;
    }

    public void close() throws IOException {
        for (int i2 = 0; i2 < this.mappedBuffers.length; ++i2) {
            if (this.mappedBuffers[i2] == null) continue;
            MappedRandomAccessFile.clean(this.mappedBuffers[i2]);
            this.mappedBuffers[i2] = null;
        }
        if (this.channel != null) {
            this.channel.close();
        }
        this.channel = null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public static boolean clean(final ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect()) {
            return false;
        }
        Boolean b = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Boolean success = Boolean.FALSE;
                try {
                    Method getCleanerMethod = buffer.getClass().getMethod("cleaner", null);
                    getCleanerMethod.setAccessible(true);
                    Object cleaner = getCleanerMethod.invoke((Object)buffer, (Object[])null);
                    Method clean = cleaner.getClass().getMethod("clean", null);
                    clean.invoke(cleaner, (Object[])null);
                    success = Boolean.TRUE;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return success;
            }
        });
        return b;
    }
}

