/*
 * Decompiled with CFR 0.152.
 */
package gde.device.junsi;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.junsi.iChargerUsb;
import gde.device.junsi.iChargerUsbPort;
import gde.device.junsi.modbus.ChargerInfo;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbNotClaimedException;

public class UsbGathererThread
extends Thread {
    protected static final int USB_QUERY_DELAY = GDE.IS_WINDOWS ? 70 : 160;
    static final String $CLASS_NAME = UsbGathererThread.class.getName();
    static final Logger log = Logger.getLogger(UsbGathererThread.class.getName());
    static final int WAIT_TIME_RETRYS = 1900;
    final DataExplorer application;
    final Settings settings;
    final iChargerUsbPort usbPort;
    final iChargerUsb device;
    final Channels channels;
    final Channel channel;
    final int channelNumber;
    String recordSetKey;
    boolean isPortOpenedByLiveGatherer;
    boolean isGatheredRecordSetVisible;
    boolean isCollectDataStopped;
    boolean isProgrammExecuting1;
    boolean isProgrammExecuting2;
    boolean isProgrammExecuting3;
    boolean isProgrammExecuting4;
    boolean[] isAlerted4Finish;
    int retryCounter;
    long lastTimeStamp_01_ms;
    long lastRecordEndTimeStamp_01_ms;
    long lastTimeStamp_02_ms;
    long lastRecordEndTimeStamp_02_ms;
    ChargerInfo chargerInfo;
    int lastNumberDisplayableRecords;

    public UsbGathererThread(DataExplorer currentApplication, iChargerUsb useDevice, iChargerUsbPort useSerialPort, int channelConfigNumber) throws ApplicationConfigurationException, UsbDisconnectedException, UsbException {
        block8: {
            super("dataGatherer");
            this.recordSetKey = Messages.getString((String)"GDE_MSGT0272");
            this.isPortOpenedByLiveGatherer = false;
            this.isGatheredRecordSetVisible = true;
            this.isCollectDataStopped = false;
            this.isProgrammExecuting1 = false;
            this.isProgrammExecuting2 = false;
            this.isProgrammExecuting3 = false;
            this.isProgrammExecuting4 = false;
            this.isAlerted4Finish = new boolean[]{false, false, false, false};
            this.retryCounter = 1900;
            this.lastTimeStamp_01_ms = 0L;
            this.lastRecordEndTimeStamp_01_ms = 0L;
            this.lastTimeStamp_02_ms = 0L;
            this.lastRecordEndTimeStamp_02_ms = 0L;
            this.chargerInfo = null;
            this.lastNumberDisplayableRecords = 0;
            this.application = currentApplication;
            this.settings = Settings.getInstance();
            this.device = useDevice;
            this.usbPort = useSerialPort;
            this.channels = Channels.getInstance();
            this.channelNumber = channelConfigNumber;
            this.channel = (Channel)this.channels.get((Object)this.channelNumber);
            if (this.usbPort != null) {
                this.usbPort.setTimeOut_ms(1200L);
            }
            if (!this.usbPort.isConnected()) {
                this.usbPort.openUsbPort();
                this.isPortOpenedByLiveGatherer = true;
            }
            this.setPriority(10);
            try {
                if (this.device.getDialog() == null) break block8;
                try {
                    this.usbPort.getData();
                    WaitTimer.delay((long)100L);
                }
                catch (TimeOutException timeOutException) {
                    // empty catch block
                }
                this.device.getDialog().startLogTransmission();
                this.chargerInfo = this.device.getDialog().readInfo();
                if (this.chargerInfo != null) {
                    log.log(Level.INFO, this.device.getName() + " - " + this.chargerInfo.getSystemInfo(this.device.getName().toLowerCase().endsWith("duo")));
                } else {
                    log.log(Level.WARNING, this.device.getName() + " - failed to initialize chargerInfo");
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String $METHOD_NAME = "run";
            RecordSet recordSet1 = null;
            RecordSet recordSet2 = null;
            int[] points1 = new int[this.device.getNumberOfMeasurements(1)];
            int[] points2 = new int[this.device.getNumberOfMeasurements(2)];
            int lastEnergie1 = 0;
            int lastEnergie2 = 0;
            this.isProgrammExecuting1 = false;
            this.isProgrammExecuting2 = false;
            byte[] dataBuffer1 = new byte[this.device.getDataBlockSize(InputTypes.SERIAL_IO)];
            byte[] dataBuffer2 = new byte[this.device.getDataBlockSize(InputTypes.SERIAL_IO)];
            byte[] dataBuffer = null;
            String recordSetKey1 = Messages.getString((String)"GDE_MSGT0272");
            String recordSetKey2 = Messages.getString((String)"GDE_MSGT0272");
            this.isCollectDataStopped = false;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "run", "====> entry initial time step ms = " + this.device.getTimeStep_ms());
            }
            while (!this.isCollectDataStopped && this.usbPort.isConnected()) {
                try {
                    if (this.application != null) {
                        this.application.setPortConnected(true);
                        this.application.setSerialRxOn();
                    }
                    dataBuffer = this.usbPort.getData();
                    if (this.application != null) {
                        this.application.setSerialRxOff();
                    }
                    this.isProgrammExecuting1 = dataBuffer[2] == 1;
                    boolean bl = this.isProgrammExecuting2 = dataBuffer[2] == 2;
                    if (this.isProgrammExecuting1) {
                        System.arraycopy(dataBuffer, 0, dataBuffer1, 0, dataBuffer1.length);
                    }
                    if (this.isProgrammExecuting2) {
                        System.arraycopy(dataBuffer, 0, dataBuffer2, 0, dataBuffer2.length);
                    }
                    if (this.isProgrammExecuting1 || this.isProgrammExecuting2) {
                        lastEnergie1 = points1[5];
                        if (this.isProgrammExecuting2) {
                            lastEnergie2 = points2[5];
                        }
                        if (this.isProgrammExecuting1) {
                            points1[5] = lastEnergie1;
                            Object[] ch1 = this.processDataChannel(1, recordSet1, recordSetKey1, dataBuffer1, points1);
                            recordSet1 = (RecordSet)ch1[0];
                            recordSetKey1 = (String)ch1[1];
                        }
                        if (this.isProgrammExecuting2) {
                            points2[5] = lastEnergie2;
                            Object[] ch2 = this.processDataChannel(2, recordSet2, recordSetKey2, dataBuffer2, points2);
                            recordSet2 = (RecordSet)ch2[0];
                            recordSetKey2 = (String)ch2[1];
                        }
                        this.application.setStatusMessage("");
                        this.retryCounter = 1900;
                        continue;
                    }
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI2600"));
                    log.logp(Level.FINE, $CLASS_NAME, "run", "wait for device activation ...");
                    WaitTimer.delay((long)1000L);
                    if (0 < --this.retryCounter) continue;
                    log.log(Level.FINE, "device activation timeout");
                    this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW2600"));
                    this.stopDataGatheringThread(false, null);
                }
                catch (DataInconsitsentException e) {
                    String message = Messages.getString((String)"GDE_MSGE0036", (Object[])new Object[]{this.getClass().getSimpleName(), "run"});
                    this.cleanup(message);
                }
                catch (Throwable e) {
                    if (e instanceof TimeOutException) {
                        if (this.usbPort != null) {
                            this.usbPort.setTimeOut_ms(1200L);
                        }
                        this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI2600"));
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.logp(Level.FINE, $CLASS_NAME, "run", Messages.getString((String)"GDE_MSGI2600"));
                        continue;
                    }
                    if (e instanceof UsbNotClaimedException) {
                        this.application.setStatusMessage(Messages.getString((String)"GDE_MSGE0051", (Object[])new Object[]{e.getClass().getSimpleName() + " : " + e.getMessage()}));
                        this.stopDataGatheringThread(false, e);
                        continue;
                    }
                    if (e instanceof UsbDisconnectedException) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.setStatusMessage(e.getMessage(), 3);
                        try {
                            this.usbPort.closeUsbPort(true);
                            log.log(Level.FINE, "USB interface closed");
                        }
                        catch (UsbException eClose) {
                            log.log(Level.SEVERE, eClose.getMessage(), eClose);
                        }
                        for (int i = 0; i < 5; ++i) {
                            try {
                                WaitTimer.delay((long)500L);
                                if (this.usbPort.isConnected()) continue;
                                log.log(Level.WARNING, "USB error recovery, reopen USB port");
                                this.usbPort.openUsbPort();
                                this.isPortOpenedByLiveGatherer = true;
                                continue;
                            }
                            catch (UsbException eOpen) {
                                log.log(Level.SEVERE, eOpen.getMessage(), eOpen);
                            }
                        }
                        continue;
                    }
                    if (e instanceof UsbException) {
                        this.application.setStatusMessage(Messages.getString((String)"GDE_MSGE0050"));
                        this.stopDataGatheringThread(false, e);
                        continue;
                    }
                    if (e instanceof IllegalStateException) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.setStatusMessage(e.getMessage(), 3);
                        try {
                            this.usbPort.closeUsbPort(true);
                            log.log(Level.FINE, "USB interface closed");
                        }
                        catch (UsbException eClose) {
                            log.log(Level.SEVERE, eClose.getMessage(), eClose);
                        }
                        for (int i = 0; i < 5; ++i) {
                            try {
                                WaitTimer.delay((long)500L);
                                if (this.usbPort.isConnected()) continue;
                                log.log(Level.WARNING, "USB error recovery, reopen USB port");
                                this.usbPort.openUsbPort();
                                this.isPortOpenedByLiveGatherer = true;
                                continue;
                            }
                            catch (UsbException eOpen) {
                                log.log(Level.SEVERE, eOpen.getMessage(), eOpen);
                            }
                        }
                        continue;
                    }
                    log.log(Level.FINE, "data gathering end detected");
                    this.stopDataGatheringThread(true, e);
                }
            }
            this.application.setStatusMessage("");
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "run", "======> exit");
            }
            if (!this.isCollectDataStopped) {
                this.stopDataGatheringThread(true, null);
            }
        }
        finally {
            try {
                this.usbPort.closeUsbPort(false);
                log.log(Level.FINE, "USB interface closed");
            }
            catch (UsbException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private Object[] processDataChannel(int number, RecordSet recordSet, String processRecordSetKey, byte[] dataBuffer, int[] points) throws DataInconsitsentException {
        Channel outputChannel;
        String processStatusName;
        String $METHOD_NAME = "processOutlet";
        Object[] result = new Object[2];
        boolean isReduceChargeDischarge = this.settings.isReduceChargeDischarge();
        boolean isContinuousRecordSet = this.settings.isContinuousRecordSet();
        if ((dataBuffer[7] & 0xFF) == 128) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("channel:%d integrate Ri values", number));
            }
            this.device.convertDataBytes(points, dataBuffer);
            result[0] = recordSet;
            result[1] = processRecordSetKey;
            return result;
        }
        if ((dataBuffer[7] & 0xFF) > 128) {
            log.log(Level.WARNING, "iCharger special message - " + StringHelper.byte2Hex2CharString((byte[])dataBuffer, (int)dataBuffer.length));
            result[0] = recordSet;
            result[1] = processRecordSetKey;
            return result;
        }
        if (isReduceChargeDischarge && dataBuffer[7] == 4) {
            result[0] = recordSet;
            result[1] = processRecordSetKey;
            return result;
        }
        String batteryType = this.device.getBatteryType(dataBuffer);
        byte processModeNumber = dataBuffer[7];
        String processTypeName = isContinuousRecordSet ? Messages.getString((String)"GDE_MSGT2618") : this.device.getRecordSetStateNameReplacement(processModeNumber);
        String string = processStatusName = !isContinuousRecordSet && dataBuffer[9] != 0 ? Messages.getString((String)"GDE_MSGT2610") : "";
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("channel:%d %s %s %s", number, batteryType, processTypeName, processStatusName).trim());
        }
        if ((outputChannel = (Channel)this.channels.get((Object)number)) != null) {
            RecordSet activeRecordSet;
            long deltaTimeStamp_ms = this.device.getTimeStamp(dataBuffer) - (number == 2 ? this.lastTimeStamp_02_ms : this.lastTimeStamp_01_ms);
            if (recordSet == null || deltaTimeStamp_ms <= 0L && this.device.getTimeStamp(dataBuffer) == 0L || !processRecordSetKey.contains(batteryType) || !processRecordSetKey.contains(processTypeName) || !processRecordSetKey.contains(processStatusName)) {
                byte cycleNumber;
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "timestampDifference " + deltaTimeStamp_ms);
                }
                this.application.setStatusMessage("");
                StringBuilder extend = new StringBuilder();
                if (!isContinuousRecordSet && dataBuffer[9] != 0 && (cycleNumber = dataBuffer[9]) >= 0) {
                    extend.append(" [").append(processStatusName).append(":").append(cycleNumber).append("]");
                }
                this.device.resetEnergySum(number);
                processRecordSetKey = String.format("%d) %s - %s %s", outputChannel.getNextRecordSetNumber(), batteryType, processTypeName, extend.toString()).trim();
                processRecordSetKey = processRecordSetKey.length() <= 40 ? processRecordSetKey : processRecordSetKey.substring(0, 40);
                outputChannel.put((Object)processRecordSetKey, (Object)RecordSet.createRecordSet((String)processRecordSetKey, (IDevice)this.application.getActiveDevice(), (int)outputChannel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                outputChannel.applyTemplateBasics(processRecordSetKey);
                log.logp(Level.FINE, $CLASS_NAME, "processOutlet", processRecordSetKey + " created for channel " + outputChannel.getName());
                recordSet = (RecordSet)outputChannel.get((Object)processRecordSetKey);
                if (this.chargerInfo != null) {
                    recordSet.setRecordSetDescription(String.format("%s\n%s", recordSet.getDescription(), this.chargerInfo.getSystemInfo(this.device.getName().toLowerCase().endsWith("duo"))));
                }
                recordSet.setAllDisplayable();
                this.channel.applyTemplate(this.recordSetKey, false);
                this.channels.switchChannel(outputChannel.getNumber(), processRecordSetKey);
                outputChannel.switchRecordSet(processRecordSetKey);
                Arrays.fill(points, 0);
                switch (number) {
                    default: {
                        this.lastRecordEndTimeStamp_01_ms = this.device.getTimeStamp(dataBuffer);
                        this.lastTimeStamp_01_ms = 0L;
                        break;
                    }
                    case 2: {
                        this.lastRecordEndTimeStamp_02_ms = this.device.getTimeStamp(dataBuffer);
                        this.lastTimeStamp_02_ms = 0L;
                    }
                }
            }
            if ((deltaTimeStamp_ms = this.device.getTimeStamp(dataBuffer) - (number == 2 ? this.lastRecordEndTimeStamp_02_ms : this.lastRecordEndTimeStamp_01_ms)) > 0L) {
                recordSet.addPoints(this.device.convertDataBytes(points, dataBuffer), (double)deltaTimeStamp_ms);
            }
            long intervalTime_ms = deltaTimeStamp_ms - (number == 2 ? this.lastTimeStamp_02_ms : this.lastTimeStamp_01_ms);
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "TimeOut = " + this.usbPort.getTimeOut_ms() + " deltaTimeStamp_ms = " + deltaTimeStamp_ms + " intervalTime_ms = " + intervalTime_ms + " lastTimeStamp_01_ms = " + this.lastTimeStamp_01_ms);
            }
            if (this.usbPort.getTimeOut_ms() != intervalTime_ms + 200L) {
                this.usbPort.setTimeOut_ms(intervalTime_ms + 200L);
            }
            switch (number) {
                default: {
                    this.lastTimeStamp_01_ms = deltaTimeStamp_ms;
                    break;
                }
                case 2: {
                    this.lastTimeStamp_02_ms = deltaTimeStamp_ms;
                }
            }
            if (recordSet.get(0).realSize() < 3 || recordSet.get(0).realSize() % 10 == 0) {
                this.device.updateVisibilityStatus(recordSet, true);
            }
            if ((activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet()) != null && recordSet.size() > 0 && recordSet.isChildOfActiveChannel() && recordSet.equals((Object)activeRecordSet)) {
                this.application.updateAllTabs(false, this.lastNumberDisplayableRecords != activeRecordSet.getConfiguredDisplayable());
                this.lastNumberDisplayableRecords = activeRecordSet.getConfiguredDisplayable();
            }
        }
        result[0] = recordSet;
        result[1] = processRecordSetKey;
        return result;
    }

    void stopDataGatheringThread(boolean enableEndMessage, Throwable throwable) {
        RecordSet recordSet;
        String $METHOD_NAME = "stopDataGatheringThread";
        if (throwable != null) {
            log.logp(Level.WARNING, $CLASS_NAME, "stopDataGatheringThread", throwable.getMessage(), throwable);
        }
        this.isCollectDataStopped = true;
        WaitTimer.delay((long)this.usbPort.getTimeOut_ms());
        if (this.usbPort != null && this.usbPort.getXferErrors() > 0) {
            log.log(Level.WARNING, "During complete data transfer " + this.usbPort.getXferErrors() + " number of errors occured!");
        }
        if (this.usbPort != null && this.usbPort.isConnected() && this.isPortOpenedByLiveGatherer && this.usbPort.isConnected()) {
            try {
                this.usbPort.closeUsbPort(false);
            }
            catch (UsbException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if ((recordSet = (RecordSet)this.channel.get((Object)this.recordSetKey)) != null && recordSet.getRecordDataSize(true) > 5) {
            this.finalizeRecordSet(false);
            if (enableEndMessage) {
                this.application.openMessageDialog(Messages.getString((String)"GDE_MSGT2603"));
            }
        } else if (enableEndMessage && throwable != null) {
            this.cleanup(throwable.getMessage());
        } else if (throwable != null) {
            this.cleanup(Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{throwable.getClass().getSimpleName(), throwable.getMessage()}));
        } else if (enableEndMessage) {
            this.cleanup(Messages.getString((String)"GDE_MSGE0026"));
        }
    }

    void finalizeRecordSet(boolean doClosePort) {
        RecordSet tmpRecordSet;
        if (doClosePort && this.isPortOpenedByLiveGatherer && this.usbPort.isConnected()) {
            try {
                this.usbPort.closeUsbPort(false);
            }
            catch (UsbException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if ((tmpRecordSet = (RecordSet)this.channel.get((Object)this.recordSetKey)) != null) {
            this.device.updateVisibilityStatus(tmpRecordSet, false);
            this.device.makeInActiveDisplayable(tmpRecordSet);
            this.application.updateStatisticsData();
            this.application.updateDataTable(this.recordSetKey, false);
            this.device.setAverageTimeStep_ms(tmpRecordSet.getAverageTimeStep_ms());
            log.log(Level.TIME, "set average time step msec = " + this.device.getAverageTimeStep_ms());
        }
    }

    void cleanup(final String message) {
        if (this.channel.get((Object)this.recordSetKey) != null) {
            ((RecordSet)this.channel.get((Object)this.recordSetKey)).clear();
            this.channel.remove(this.recordSetKey);
            if (Thread.currentThread().getId() == this.application.getThreadId()) {
                this.application.getMenuToolBar().updateRecordSetSelectCombo();
                this.application.updateStatisticsData();
                this.application.updateDataTable(this.recordSetKey, true);
                this.application.openMessageDialog(message);
            } else {
                final String useRecordSetKey = this.recordSetKey;
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        UsbGathererThread.this.application.getMenuToolBar().updateRecordSetSelectCombo();
                        UsbGathererThread.this.application.updateStatisticsData();
                        UsbGathererThread.this.application.updateDataTable(useRecordSetKey, true);
                        UsbGathererThread.this.application.openMessageDialog(message);
                    }
                });
            }
        } else {
            this.application.openMessageDialog(message);
        }
    }

    void setCollectDataStopped(boolean enabled) {
        this.isCollectDataStopped = enabled;
    }

    boolean isCollectDataStopped() {
        return this.isCollectDataStopped;
    }
}

