/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import java.util.zip.Adler32;
import java.util.zip.CRC32;

public class Checksum {
    private static final int poly = 4129;
    private static int[] crcTable = new int[256];

    public static void main(String[] args) {
        byte[] b = new byte[]{27, 6, 92, 27, 6, 92, 27, 6, 92, 27, 6, 92, 27, 6, 92, 27, 6, 92, 27, 6, 92, 27, 6, 92, 27, 6, 92, 27, 6, 92, 0};
        byte[] b1 = new byte[]{27, 6, 92, 28, 6, 92, 28, 6, 92, 28, 6, 92, 28, 6, 92, 28, 6, 92, 28, 6, 92, 28, 6, 92, 28, 6, 92, 28, 6, 92, 7};
        byte[] HOTT_19200_N_MASTER = new byte[]{-128, -115, -115, 124, 0, 0, 62, 52, 55, 62, 100, 51, -48, 7, 0, 65, -64, 0, -128, -61, -62, -61, -60, 0, 0, 0, 0, 0, 0, 43, 43, 0, 0, 0, 0, 0, -12, 1, 48, 117, 120, 0, 0, -100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 125, -33};
        byte[] HOTT_19200_N_MASTER_1 = new byte[]{-128, -115, 124, 0, 0, 63, 52, 55, 63, 100, 51, -48, 7, 0, 62, -64, 0, -128, -61, -62, -61, -60, 0, 0, 0, 0, 0, 0, 43, 43, 0, 0, 0, 0, 0, -12, 1, 58, 117, 120, 0, 0, -100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 125, -24};
        byte[] HOTT_19200_N_MASTER_2 = new byte[]{-128, -119, 124, 0, 0, 58, 53, 54, 47, 100, 53, 10, 0, 0, 47, -64, 0, -128, -61, -62, -61, -60, 0, 0, 0, 0, 0, 0, 49, 43, 0, 0, 0, 0, 0, -11, 1, 48, 117, 120, 0, 0, -100, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 125, -8};
        byte[] HOTT_19200_N_SLAVE = new byte[]{-128, -115, 124, 0, 0, 83, 52, 55, 83, 100, 51, -48, 7, 0, 85, -64, 0, -128, -61, -62, -61, -60, 0, 0, 0, 0, 0, 0, 43, 43, 0, 0, 0, 0, 0, -12, 1, 18, 117, 120, 0, 0, -100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 125, -1};
        System.out.println("CRC16    \t= " + Integer.toHexString(Checksum.CRC16(b, 0)));
        System.out.println("CRC16CCITT= " + Integer.toHexString(Checksum.CRC16CCITT(b, 0)));
        System.out.println("CRC32 \t\t= " + Integer.toHexString(Checksum.CRC32(b)));
        System.out.println("Adler32  \t= " + Long.toHexString(Checksum.adler32(b)));
        System.out.println("AND      \t= " + Integer.toHexString(Checksum.AND(b)));
        System.out.println("XOR     \t= " + Integer.toHexString(Checksum.XOR(b)));
        System.out.println("XOR      \t= " + Integer.toHexString(Checksum.XOR(b1)));
        System.out.println("ADD      \t= " + Integer.toHexString(0xFF & Checksum.ADD(HOTT_19200_N_MASTER, 2, HOTT_19200_N_MASTER.length - 2)) + " - " + Integer.toHexString(0xFF & HOTT_19200_N_MASTER[HOTT_19200_N_MASTER.length - 1]));
        System.out.println("ADD      \t= " + Integer.toHexString(0xFF & Checksum.ADD(HOTT_19200_N_MASTER_1, 2, HOTT_19200_N_MASTER_1.length - 2)) + " - " + Integer.toHexString(0xFF & HOTT_19200_N_MASTER_1[HOTT_19200_N_MASTER_1.length - 1]));
        System.out.println("ADD      \t= " + Integer.toHexString(0xFF & Checksum.ADD(HOTT_19200_N_MASTER_2, 2, HOTT_19200_N_MASTER_2.length - 2)) + " - " + Integer.toHexString(0xFF & HOTT_19200_N_MASTER_2[HOTT_19200_N_MASTER_2.length - 1]));
        System.out.println("ADD      \t= " + Integer.toHexString(0xFF & Checksum.ADD(HOTT_19200_N_SLAVE, 2, HOTT_19200_N_SLAVE.length - 2)) + " - " + Integer.toHexString(0xFF & HOTT_19200_N_SLAVE[HOTT_19200_N_SLAVE.length - 1]));
    }

    public static short CRC16(byte[] bytes, int initValue) {
        int crc = initValue;
        int polynomial = 4129;
        for (byte b : bytes) {
            for (int i = 0; i < 8; ++i) {
                boolean bit = (b >> 7 - i & 1) == 1;
                boolean c15 = (crc >> 15 & 1) == 1;
                crc <<= 1;
                if (!(c15 ^ bit)) continue;
                crc ^= polynomial;
            }
        }
        return (short)(crc &= 0xFFFF);
    }

    public static short CRC16CCITT(byte[] b, int initValue) {
        int crc = initValue;
        for (int i = 0; i < b.length; ++i) {
            crc = (crcTable[(b[i] ^ crc >>> 8) & 0xFF] ^ crc << 8) & 0xFFFF;
        }
        return (short)crc;
    }

    public static short CRC16CCITT(char[] c) {
        int crc = 0;
        for (int i = 0; i < c.length; ++i) {
            crc = (crcTable[(c[i] ^ crc >>> 8) & 0xFF] ^ crc << 8) & 0xFFFF;
        }
        return (short)crc;
    }

    public static short CRC16CCITT(byte[] b, int startIndex, int length) {
        int crc = 0;
        for (int i = startIndex; i < length + startIndex; ++i) {
            crc = (crcTable[(b[i] ^ crc >>> 8) & 0xFF] ^ crc << 8) & 0xFFFF;
        }
        return (short)crc;
    }

    public static int CRC32(byte[] b) {
        CRC32 crc = new CRC32();
        for (int i = 0; i < b.length; ++i) {
            crc.update(b[i]);
        }
        return (int)crc.getValue();
    }

    public static long adler32(byte[] b) {
        Adler32 digester = new Adler32();
        digester.update(b);
        return digester.getValue();
    }

    public static byte OR(byte[] b) {
        int value = b[0];
        for (int i = 1; i < b.length; ++i) {
            value |= b[i];
        }
        return (byte)value;
    }

    public static int OR(int[] a, int offset, int length) {
        int value = a[offset];
        for (int i = 1; i < length; ++i) {
            value |= a[i];
        }
        return value;
    }

    public static int XOR(char[] c) {
        int value = 0;
        for (int i = 0; i < c.length; ++i) {
            value ^= c[i];
        }
        return value;
    }

    public static int XOR(byte[] b) {
        int value = 0;
        for (int i = 0; i < b.length; ++i) {
            value ^= b[i];
        }
        return value;
    }

    public static int XOR(byte[] b, int length) {
        int value = 0;
        for (int i = 0; i < length; ++i) {
            value ^= b[i];
        }
        return value;
    }

    public static int XOR(int[] a, int offset, int length) {
        int value = a[offset];
        for (int i = offset + 1; i < length; ++i) {
            value ^= a[i];
        }
        return value;
    }

    public static byte AND(byte[] b) {
        int value = b[0];
        for (int i = 1; i < b.length; ++i) {
            value &= b[i];
        }
        return (byte)value;
    }

    public static int AND(byte[] b, int offset, int length) {
        int value = b[offset] & 0xFF;
        for (int i = offset + 1; i < length; ++i) {
            value &= b[i];
        }
        return value;
    }

    public static int AND(int[] a, int offset, int length) {
        int value = a[offset];
        for (int i = offset + 1; i < length; ++i) {
            value &= a[i];
        }
        return value;
    }

    public static int ADD(byte[] b) {
        int value = b[0] & 0xFF;
        for (int i = 1; i < b.length; ++i) {
            value += b[i] & 0xFF;
        }
        return value;
    }

    public static int ADD(byte[] b, int len) {
        int value = b[0] & 0xFF;
        for (int i = 1; i < b.length - len; ++i) {
            value += b[i] & 0xFF;
        }
        return value;
    }

    public static int ADD(byte[] b, int start, int len) {
        int value = b[start] & 0xFF;
        for (int i = start + 1; i <= len; ++i) {
            value += b[i] & 0xFF;
        }
        return value;
    }

    public static int ADD(int[] a, int offset, int length) {
        int value = a[offset];
        for (int i = offset + 1; i < length; ++i) {
            value += a[i];
        }
        return value;
    }

    public static void calculateAndWrite(byte[] bytes, int start, int end) {
        short checkSum = Checksum.CRC16CCITT(bytes, start, end - start);
        bytes[end] = (byte)(checkSum & 0xFF);
        bytes[end + 1] = (byte)((checkSum & 0xFF00) >> 8);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int fcs = 0;
            int d = i << 8;
            for (int k = 0; k < 8; ++k) {
                fcs = ((fcs ^ d) & 0x8000) != 0 ? fcs << 1 ^ 0x1021 : (fcs <<= 1);
                d <<= 1;
                fcs &= 0xFFFF;
            }
            Checksum.crcTable[i] = fcs;
        }
    }
}

