/*
 * Decompiled with CFR 0.152.
 */
package gde.io;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.ChannelTypes;
import gde.device.IDevice;
import gde.io.CSVReaderWriter;
import gde.io.GPXWriter;
import gde.io.KMZWriter;
import gde.io.LogViewReader;
import gde.io.OsdReaderWriter;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.FileUtils;
import gde.utils.ObjectKeyCompliance;
import gde.utils.OperatingSystemHelper;
import gde.utils.StringHelper;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.FileDialog;

public class FileHandler {
    static final Logger log = Logger.getLogger(FileHandler.class.getName());
    final DataExplorer application = DataExplorer.getInstance();
    final Channels channels = Channels.getInstance();
    final Settings settings = Settings.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFileCSV(String dialogName, boolean isRaw) {
        IDevice activeDevice = this.application.getActiveDevice();
        if (activeDevice == null) {
            this.application.openMessageDialog(Messages.getString("GDE_MSGI0004"));
            return;
        }
        Settings deviceSetting = Settings.getInstance();
        String devicePath = this.getDevicePath();
        String path = deviceSetting.getDataFilePath() + devicePath + "/";
        FileDialog csvFileDialog = this.application.openFileOpenDialog(dialogName, new String[]{"*.csv"}, path, null, 4);
        if (csvFileDialog.getFileName().length() > 4) {
            String csvFilePath = csvFileDialog.getFilterPath() + "/" + csvFileDialog.getFileName();
            String directoryName = ObjectKeyCompliance.getUpcomingObjectKey(Paths.get(csvFilePath, new String[0]));
            if (!directoryName.isEmpty()) {
                ObjectKeyCompliance.createObjectKey(directoryName);
            }
            try {
                char listSeparator = deviceSetting.getListSeparator();
                String fileDeviceName = CSVReaderWriter.getHeader(listSeparator, csvFilePath).get("DeviceName : ");
                String activeDeviceName = this.application.getActiveDevice().getName();
                if (!activeDeviceName.equals(fileDeviceName)) {
                    String msg = Messages.getString("GDE_MSGI0009", new Object[]{fileDeviceName});
                    if (128 == this.application.openYesNoMessageDialog(msg)) {
                        return;
                    }
                    this.application.getDeviceSelectionDialog().setupDevice(fileDeviceName);
                }
                this.application.enableMenuActions(false);
                this.application.setCursor(SWTResourceManager.getCursor(1));
                RecordSet activeRecordSet = CSVReaderWriter.read(listSeparator, csvFilePath, this.application.getActiveDevice().getRecordSetStemNameReplacement(), isRaw);
                activeDevice.updateVisibilityStatus(activeRecordSet, true);
                this.application.getActiveChannel().applyTemplate(activeRecordSet.getName(), true);
                activeRecordSet.descriptionAppendFilename(csvFileDialog.getFileName());
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
                this.application.openMessageDialog(e.getClass().getSimpleName() + " - " + e.getMessage());
            }
            finally {
                this.application.enableMenuActions(true);
                this.application.setCursor(SWTResourceManager.getCursor(0));
            }
        }
    }

    public void exportFileCSV(String dialogName, boolean isRaw, String encoding) {
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel == null) {
            this.application.openMessageDialog(Messages.getString("GDE_MSGI0005"));
            return;
        }
        RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
        if (activeRecordSet == null) {
            this.application.openMessageDialog(Messages.getString("GDE_MSGI0005"));
            return;
        }
        Settings deviceSetting = Settings.getInstance();
        String devicePath = this.getDevicePath();
        String path = deviceSetting.getDataFilePath() + devicePath + "/";
        FileDialog csvFileDialog = this.application.prepareFileSaveDialog(dialogName, new String[]{"*.csv"}, path, this.getFileNameProposal(true));
        String recordSetKey = activeRecordSet.getName();
        String csvFilePath = csvFileDialog.open();
        if (csvFilePath != null && csvFilePath.length() > 4) {
            if (FileUtils.checkFileExist(csvFilePath) && 128 == this.application.openYesNoMessageDialog(Messages.getString("GDE_MSGI0007", new Object[]{csvFilePath}))) {
                return;
            }
            try {
                this.application.enableMenuActions(false);
                this.application.setCursor(SWTResourceManager.getCursor(1));
                CSVReaderWriter.write(deviceSetting.getListSeparator(), recordSetKey, csvFilePath, isRaw, encoding);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
                this.application.openMessageDialog(e.getClass().getSimpleName() + " - " + e.getMessage());
            }
            this.application.enableMenuActions(true);
            this.application.setCursor(SWTResourceManager.getCursor(0));
        }
    }

    String getFileNameProposal(String recordSetName) {
        Object fileName = "";
        if (Settings.getInstance().getUsageDateAsFileNameLeader()) {
            int chunkSize;
            String[] chunks;
            String fileDescriptionDate = "";
            if (this.application.getActiveChannel() != null && this.application.getActiveChannel().getFileDescription().split("-").length >= 3 && chunks[(chunkSize = (chunks = this.application.getActiveChannel().getFileDescription().split("-")).length) == 4 ? 1 : 0].length() >= 4 && chunks[chunkSize == 4 ? 2 : 1].length() == 2 && chunks[chunkSize == 4 ? 3 : 2].length() >= 2) {
                try {
                    int year = Integer.parseInt(chunks[0].substring(chunks[0].length() - 4));
                    int month = Integer.parseInt(chunks[1]);
                    int day = Integer.parseInt(chunks[2].substring(0, 2));
                    fileDescriptionDate = String.format("%04d-%02d-%02d", year, month, day);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            fileName = (fileDescriptionDate.length() > 0 ? fileDescriptionDate : StringHelper.getDate()) + "_";
        }
        if (Settings.getInstance().getUsageObjectKeyInFileName() && Channels.getInstance().getActiveChannel() != null && Channels.getInstance().getActiveChannel().getActiveRecordSet() != null) {
            fileName = (String)fileName + Channels.getInstance().getActiveChannel().getObjectKey();
        }
        if (this.application.getActiveChannel() != null) {
            fileName = (String)fileName + (((String)fileName).endsWith("_") ? "" : "_") + recordSetName.replace(") ", "_");
        }
        return fileName;
    }

    String getFileNameProposal(boolean addRecordSetName) {
        Object fileName = "";
        if (Settings.getInstance().getUsageDateAsFileNameLeader()) {
            String fileDescriptionDate = "";
            if (this.application.getActiveRecordSet() != null) {
                fileDescriptionDate = StringHelper.getFormatedTime("yyyy-MM-dd", this.application.getActiveRecordSet().getStartTimeStamp());
            }
            fileName = (fileDescriptionDate.length() > 0 ? fileDescriptionDate : StringHelper.getDate()) + "_";
        }
        if (this.application.isObjectoriented() && Settings.getInstance().getUsageObjectKeyInFileName() && Channels.getInstance().getActiveChannel() != null && Channels.getInstance().getActiveChannel().getActiveRecordSet() != null) {
            fileName = (String)fileName + Channels.getInstance().getActiveChannel().getObjectKey();
        }
        if (addRecordSetName && this.application.getActiveChannel() != null && this.application.getActiveChannel().getActiveRecordSet() != null) {
            fileName = (String)(((String)fileName).endsWith("_") ? fileName : (String)fileName + "_") + this.application.getActiveChannel().getActiveRecordSet().getName().replace(") ", "_");
        }
        return fileName;
    }

    public void openFileDialog(String dialogName) {
        if (this.application.getDeviceSelectionDialog().checkDataSaved()) {
            String path;
            Settings deviceSetting = Settings.getInstance();
            if (this.application.isObjectoriented()) {
                path = this.application.getObjectFilePath();
            } else {
                String devicePath = this.getDevicePath();
                String string = path = this.application.getActiveDevice() != null ? deviceSetting.getDataFilePath() + devicePath + "/" : deviceSetting.getDataFilePath();
                if (!FileUtils.checkDirectoryAndCreate(path)) {
                    if (!FileUtils.checkDirectoryExist(path)) {
                        this.application.openMessageDialog(Messages.getString("GDE_MSGI0056", new Object[]{path}));
                    } else {
                        this.application.openMessageDialog(Messages.getString("GDE_MSGI0012", new Object[]{path}));
                    }
                }
            }
            FileDialog openFileDialog = this.application.openFileOpenDialog(dialogName, new String[]{"*.osd", "*.lov"}, path, null, 4);
            if (openFileDialog.getFileName().length() > 4) {
                String openFilePath = (openFileDialog.getFilterPath() + "/" + openFileDialog.getFileName()).replace('\\', '/');
                if (openFilePath.toLowerCase().endsWith("osd")) {
                    String directoryName = ObjectKeyCompliance.getUpcomingObjectKey(Paths.get(openFilePath, new String[0]));
                    if (!directoryName.isEmpty()) {
                        ObjectKeyCompliance.createObjectKey(directoryName);
                    }
                    this.openOsdFile(openFilePath.replace('\\', '/'));
                } else if (openFilePath.toLowerCase().endsWith("lov")) {
                    String directoryName = ObjectKeyCompliance.getUpcomingObjectKey(Paths.get(openFilePath, new String[0]));
                    if (!directoryName.isEmpty()) {
                        ObjectKeyCompliance.createObjectKey(directoryName);
                    }
                    this.openLovFile(openFilePath);
                } else {
                    this.application.openMessageDialog(Messages.getString("GDE_MSGI0008") + openFilePath);
                }
            }
        }
    }

    private String getDevicePath() {
        Object devicePath = "/";
        if (this.application.getActiveDevice() != null) {
            devicePath = "/" + this.application.getActiveDevice().getFileBaseDir();
        }
        return devicePath;
    }

    public void openOsdFile(String inputFilePath) {
        try {
            boolean isChannelTypeOutlet;
            boolean existAsObjectLinkFile = true;
            String openFilePath = OperatingSystemHelper.getLinkContainedFilePath(inputFilePath);
            if (OperatingSystemHelper.isLinkContained(inputFilePath) && openFilePath.replace('\\', '/').equals(inputFilePath)) {
                DataExplorer.getInstance().openMessageDialogAsync(Messages.getString("GDE_MSGI0066", new String[]{openFilePath}));
                return;
            }
            HashMap<String, String> osdHeader = OsdReaderWriter.getHeader(openFilePath);
            String fileDeviceName = osdHeader.get("DeviceName : ");
            IDevice activeDevice = this.application.getActiveDevice();
            if (activeDevice == null || !activeDevice.getName().equals(fileDeviceName)) {
                this.application.getDeviceSelectionDialog().setupDevice(GDE.deviceMap.get(fileDeviceName) == null ? fileDeviceName : GDE.deviceMap.get(fileDeviceName));
            }
            String objectkey = osdHeader.get("ObjectKey : ");
            if (this.application.isObjectoriented() && objectkey != null && !objectkey.equals("")) {
                existAsObjectLinkFile = FileUtils.checkDirectoryAndCreate(Settings.getInstance().getDataFilePath() + "/" + objectkey);
                this.application.getMenuToolBar().selectObjectKey(0, objectkey);
            } else {
                this.application.getMenuToolBar().selectObjectKeyDeviceOriented();
            }
            String recordSetPropertys = osdHeader.get("1 RecordSetName : ");
            String channelConfigName = OsdReaderWriter.getRecordSetProperties(recordSetPropertys).get("Channel/Configuration Name: ");
            boolean bl = isChannelTypeOutlet = this.channels.getActiveChannel().getType() == ChannelTypes.TYPE_OUTLET;
            if (isChannelTypeOutlet && this.channels.size() > 1) {
                int answer;
                String[] splitChannel = channelConfigName.split(" ");
                int channelNumber = 1;
                try {
                    channelNumber = splitChannel.length == 2 ? Integer.valueOf(splitChannel[1]) : (splitChannel.length > 2 ? Integer.valueOf(splitChannel[0]) : 1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Channel channel = (Channel)this.channels.get(channelNumber);
                if (channel.size() > 0 && (answer = this.application.openOkCancelMessageDialog(Messages.getString("GDE_MSGI0010", new Object[]{channelNumber + " : " + channel.getChannelConfigKey()}))) != 32) {
                    return;
                }
                channel.clear();
            } else {
                this.application.getDeviceSelectionDialog().setupDevice(GDE.deviceMap.get(fileDeviceName) == null ? fileDeviceName : GDE.deviceMap.get(fileDeviceName));
            }
            try {
                this.application.enableMenuActions(false);
                OsdReaderWriter.read(openFilePath);
                this.channels.getActiveChannel().setFileName(openFilePath.replace('\\', '/'));
                if (!existAsObjectLinkFile) {
                    this.channels.getActiveChannel().setUnsaved(Channel.UNSAVED_REASON_ADD_OBJECT_KEY);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
                this.application.openMessageDialog(e.getClass().getSimpleName() + " - " + e.getMessage());
            }
            this.application.enableMenuActions(true);
            this.application.updateSubHistoryMenuItem(openFilePath);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.getMessage(), e);
            this.application.openMessageDialog(e.getClass().getSimpleName() + " - " + e.getMessage());
        }
    }

    public void openOsdFile(String openFilePath, String recordSetName) {
        if (this.application.getDeviceSelectionDialog().checkDataSaved()) {
            try {
                openFilePath = OperatingSystemHelper.getLinkContainedFilePath(openFilePath);
                for (Channel channel : this.channels.values()) {
                    channel.clear();
                }
                this.application.enableMenuActions(false);
                try {
                    OsdReaderWriter.read(openFilePath, recordSetName);
                    this.channels.getActiveChannel().setFileName(openFilePath.replace('\\', '/'));
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                    this.application.openMessageDialog(e.getClass().getSimpleName() + " - " + e.getMessage());
                }
                this.application.enableMenuActions(true);
                this.application.updateSubHistoryMenuItem(openFilePath);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.getMessage(), e);
                this.application.openMessageDialog(e.getClass().getSimpleName() + " - " + e.getMessage());
            }
        }
    }

    public void saveOsdFile(String dialogName, String fileName) {
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel == null) {
            this.application.openMessageDialog(Messages.getString("GDE_MSGI0011"));
            return;
        }
        RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
        if (activeRecordSet == null) {
            this.application.openMessageDialog(Messages.getString("GDE_MSGI0011"));
            return;
        }
        Settings deviceSetting = Settings.getInstance();
        String devicePath = this.getDevicePath();
        String path = deviceSetting.getDataFilePath() + devicePath;
        if (!FileUtils.checkDirectoryAndCreate(path)) {
            if (!FileUtils.checkDirectoryExist(path)) {
                this.application.openMessageDialog(Messages.getString("GDE_MSGI0056", new Object[]{path}));
            } else {
                this.application.openMessageDialog(Messages.getString("GDE_MSGI0012", new Object[]{path}));
            }
        }
        FileDialog fileDialog = null;
        Object osdFilePath = null;
        if (fileName == null || fileName.length() < 5 || fileName.equals(this.getFileNameProposal(false))) {
            fileDialog = this.application.prepareFileSaveDialog(dialogName, new String[]{"*.osd"}, path + "/", this.getFileNameProposal(false));
            if (fileDialog != null) {
                osdFilePath = fileDialog.open();
            }
        } else {
            osdFilePath = path + "/" + fileName;
        }
        if (!(osdFilePath == null || ((String)osdFilePath).length() <= 4 || this.getFileNameProposal(false).length() != 0 && ((String)osdFilePath).endsWith(this.getFileNameProposal(false)))) {
            while (((String)osdFilePath).toLowerCase().endsWith(".osd") || ((String)osdFilePath).toLowerCase().endsWith(".lov")) {
                osdFilePath = ((String)osdFilePath).substring(0, ((String)osdFilePath).lastIndexOf(46));
            }
            if (FileUtils.checkFileExist((String)(osdFilePath = ((String)osdFilePath + ".osd").replace('\\', '/'))) && 128 == this.application.openYesNoMessageDialog(Messages.getString("GDE_MSGI0013", new Object[]{osdFilePath}))) {
                return;
            }
            String directoryName = ObjectKeyCompliance.getUpcomingObjectKey(Paths.get((String)osdFilePath, new String[0]));
            if (!directoryName.isEmpty()) {
                ObjectKeyCompliance.createObjectKey(directoryName);
            }
            try {
                this.application.enableMenuActions(false);
                this.application.setCursor(SWTResourceManager.getCursor(1));
                FileUtils.renameFile((String)osdFilePath, "bak");
                OsdReaderWriter.write((String)osdFilePath, activeChannel, 4);
                activeChannel.setFileName(((String)osdFilePath).replace('\\', '/'));
                activeChannel.setSaved(true);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
                this.application.openMessageDialog(e.getClass().getSimpleName() + " - " + e.getMessage());
            }
            this.application.enableMenuActions(true);
            this.application.updateSubHistoryMenuItem((String)osdFilePath);
            this.application.setCursor(SWTResourceManager.getCursor(0));
        }
    }

    public boolean deleteOsdFile() {
        String filename = this.channels.getActiveChannel().getFullQualifiedFileName();
        if (filename == null || filename.isEmpty()) {
            return false;
        }
        File osdFile = new File(filename);
        if (!FileUtils.checkFileExist(filename) || this.application.openYesNoMessageDialog(Messages.getString("GDE_MSGI0050", new Object[]{osdFile.getAbsolutePath()})) == 128) {
            return false;
        }
        try {
            this.application.enableMenuActions(false);
            this.application.setCursor(SWTResourceManager.getCursor(1));
            FileUtils.deleteFile(filename);
            if (this.application.isObjectoriented()) {
                String linkedFile = this.application.getObjectFilePath() + this.channels.getActiveChannel().getFileName();
                FileUtils.deleteFile(linkedFile);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
            this.application.openMessageDialog(e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        this.application.enableMenuActions(true);
        Settings.getInstance().getFileHistory().remove(filename);
        this.application.updateSubHistoryMenuItem(null);
        this.application.setCursor(SWTResourceManager.getCursor(0));
        return true;
    }

    public void openLovFile(String openFilePath) {
        try {
            HashMap<String, String> lovHeader = LogViewReader.getHeader(openFilePath);
            String fileDeviceName = lovHeader.get("DeviceName : ");
            String activeDeviceName = this.application.getActiveDevice().getName();
            if (!activeDeviceName.equals(fileDeviceName)) {
                this.application.getDeviceSelectionDialog().setupDevice(fileDeviceName);
            }
            int channelNumber = this.application.getActiveDevice().recordSetNumberFollowChannel() ? Integer.valueOf(lovHeader.get("Channel/Configuration Number : ")).intValue() : this.channels.getActiveChannelNumber();
            IDevice activeDevice = this.application.getActiveDevice();
            String channelType = activeDevice.getChannelTypes(channelNumber).name();
            String channelConfigName = activeDevice.getChannelNameReplacement(channelNumber);
            log.log(Level.FINE, "channelConfigName = " + channelConfigName + " (Channel/Configuration Type : " + channelType + "; Channel/Configuration Number : " + channelNumber + ")");
            Channel channel = (Channel)this.channels.get(channelNumber);
            if (channel != null && this.channels.getActiveChannel() != null && this.channels.getActiveChannel().getType() == ChannelTypes.TYPE_OUTLET && this.channels.size() > 1) {
                int answer;
                if (this.channels.getActiveChannelNumber() != channelNumber && (answer = this.application.openOkCancelMessageDialog(Messages.getString("GDE_MSGI0006", new Object[]{channelConfigName}))) != 32) {
                    return;
                }
                channel.clear();
            } else {
                this.application.getDeviceSelectionDialog().setupDevice(fileDeviceName);
            }
            try {
                this.application.enableMenuActions(false);
                LogViewReader.read(openFilePath);
                this.channels.getActiveChannel().setFileName(openFilePath.replace('\\', '/'));
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
                this.application.openMessageDialog(e.getClass().getSimpleName() + " - " + e.getMessage());
            }
            this.application.enableMenuActions(true);
            this.application.updateSubHistoryMenuItem(openFilePath);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
            this.application.openMessageDialog(e.getClass().getSimpleName() + " - " + e.getMessage());
        }
    }

    public void exportFileKMZ(String dialogName, int ordinalLongitude, int ordinalLatitude, int ordinalAltitude, int ordinalSpeed, int ordinalClimb, int ordinalTripLength, int ordinalAzimuth, boolean isRelative, boolean isClampToGround) {
        FileDialog kmlFileDialog;
        String kmzFilePath;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel == null) {
            this.application.openMessageDialog(Messages.getString("GDE_MSGI0005"));
            return;
        }
        RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
        if (activeRecordSet == null) {
            this.application.openMessageDialog(Messages.getString("GDE_MSGI0005"));
            return;
        }
        Settings deviceSetting = Settings.getInstance();
        String devicePath = this.getDevicePath();
        String path = deviceSetting.getDataFilePath() + devicePath + "/";
        Object fileName = activeChannel.getFileName() == null ? this.getFileNameProposal(true) : activeChannel.getFileName();
        Object object = fileName = fileName != null && ((String)fileName).contains(".") ? ((String)fileName).substring(0, ((String)fileName).indexOf(46)) : fileName;
        if (activeRecordSet.getName().contains("]") && activeRecordSet.getName().contains("[")) {
            try {
                String flightNumber = activeRecordSet.getName().substring(activeRecordSet.getName().lastIndexOf(91) + 1, activeRecordSet.getName().lastIndexOf(93));
                if (fileName != null && !((String)fileName).contains("" + Integer.parseInt(flightNumber))) {
                    fileName = (String)fileName + "_" + flightNumber;
                }
            }
            catch (NumberFormatException flightNumber) {
                // empty catch block
            }
        }
        if ((kmzFilePath = (kmlFileDialog = this.application.prepareFileSaveDialog(dialogName, new String[]{"*.kmz"}, path, (String)(fileName != null && ((String)fileName).length() > 4 ? fileName : this.getFileNameProposal(true)))).open()) != null && kmlFileDialog.getFileName().length() > 4) {
            if (FileUtils.checkFileExist(kmzFilePath) && 128 == this.application.openYesNoMessageDialog(Messages.getString("GDE_MSGI0007", new Object[]{kmzFilePath}))) {
                return;
            }
            try {
                this.application.enableMenuActions(false);
                this.application.setCursor(SWTResourceManager.getCursor(1));
                GDE.getUiNotification().setStatusMessage(Messages.getString("GDE_MSGT0138", new String[]{"kmz", kmzFilePath}));
                Object kmlFileName = this.getFileNameProposal(activeChannel.getActiveRecordSet().getName());
                kmlFileName = kmlFileName != null && ((String)kmlFileName).contains(".") ? ((String)kmlFileName).substring(0, ((String)kmlFileName).indexOf(46)) : kmlFileName;
                kmlFileName = (String)kmlFileName + ".kml";
                KMZWriter.write(kmzFilePath, (String)kmlFileName, activeChannel.getActiveRecordSet(), ordinalLongitude, ordinalLatitude, ordinalAltitude, ordinalSpeed, ordinalClimb, ordinalTripLength, ordinalAzimuth, isRelative, isClampToGround);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
                this.application.openMessageDialog(e.getClass().getSimpleName() + " - " + e.getMessage());
            }
            this.application.enableMenuActions(true);
            this.application.setCursor(SWTResourceManager.getCursor(0));
        }
    }

    public String exportFileKMZ(int ordinalLongitude, int ordinalLatitude, int ordinalHeight, int ordinalMeasurement, int ordinalSlope, int ordinalTripLength, int ordinalAzimuth, boolean isHeightRelative, boolean isExportTmpDir) {
        Object kmzFilePath = "";
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel == null) {
            this.application.openMessageDialog(Messages.getString("GDE_MSGI0005"));
            return "";
        }
        RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
        if (activeRecordSet == null) {
            this.application.openMessageDialog(Messages.getString("GDE_MSGI0005"));
            return "";
        }
        Settings deviceSetting = Settings.getInstance();
        String devicePath = this.getDevicePath();
        String path = isExportTmpDir ? GDE.JAVA_IO_TMPDIR : deviceSetting.getDataFilePath() + devicePath + "/";
        FileUtils.checkDirectoryAndCreate(path);
        String fileName = path + (activeChannel.getFileName() == null ? this.getFileNameProposal(true) : activeChannel.getFileName());
        String string = fileName = fileName.contains(".") ? fileName.substring(0, fileName.indexOf(46)) : fileName;
        if (activeRecordSet.getName().contains("]") && activeRecordSet.getName().contains("[")) {
            try {
                String flightNumber = activeRecordSet.getName().substring(activeRecordSet.getName().lastIndexOf(91) + 1, activeRecordSet.getName().lastIndexOf(93));
                if (!fileName.contains("" + Integer.parseInt(flightNumber))) {
                    fileName = fileName + "_" + flightNumber;
                }
            }
            catch (NumberFormatException flightNumber) {
                // empty catch block
            }
        }
        if (((String)(kmzFilePath = fileName + ".kmz")).length() > 4) {
            try {
                this.application.enableMenuActions(false);
                this.application.setCursor(SWTResourceManager.getCursor(1));
                KMZWriter.write((String)kmzFilePath, fileName.substring(fileName.lastIndexOf(GDE.FILE_SEPARATOR) + 1) + ".kml", activeRecordSet, ordinalLongitude, ordinalLatitude, ordinalHeight, ordinalMeasurement, ordinalSlope, ordinalTripLength, ordinalAzimuth, isHeightRelative, ordinalHeight == -1);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
                this.application.openMessageDialog(e.getClass().getSimpleName() + " - " + e.getMessage());
            }
            this.application.enableMenuActions(true);
            this.application.setCursor(SWTResourceManager.getCursor(0));
        }
        GDE.getUiNotification().setProgress(100);
        return kmzFilePath;
    }

    public void exportFileGPX(String dialogName, int latitudeOrdinal, int longitudeOrdinal, int altitudeOrdinal, int speedOrdinal, int satellitesOrdinal, int hdopOrdinal, int vdopOrdinal, int pdodOrdinal, int[] accelerationXYZ) {
        FileDialog gpxFileDialog;
        String gpxFilePath;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel == null) {
            this.application.openMessageDialog(Messages.getString("GDE_MSGI0005"));
            return;
        }
        RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
        if (activeRecordSet == null) {
            this.application.openMessageDialog(Messages.getString("GDE_MSGI0005"));
            return;
        }
        Settings deviceSetting = Settings.getInstance();
        String devicePath = this.getDevicePath();
        String path = deviceSetting.getDataFilePath() + devicePath + "/";
        Object fileName = activeChannel.getFileName() == null ? this.getFileNameProposal(true) : activeChannel.getFileName();
        Object object = fileName = fileName != null && ((String)fileName).contains(".") ? ((String)fileName).substring(0, ((String)fileName).indexOf(46)) : fileName;
        if (activeRecordSet.getName().contains("]") && activeRecordSet.getName().contains("[")) {
            try {
                String flightNumber = activeRecordSet.getName().substring(activeRecordSet.getName().lastIndexOf(91) + 1, activeRecordSet.getName().lastIndexOf(93));
                if (fileName != null && !((String)fileName).contains("" + Integer.parseInt(flightNumber))) {
                    fileName = (String)fileName + "_" + flightNumber;
                }
            }
            catch (NumberFormatException flightNumber) {
                // empty catch block
            }
        }
        if ((gpxFilePath = (gpxFileDialog = this.application.prepareFileSaveDialog(dialogName, new String[]{"*.gpx"}, path, (String)(fileName != null && ((String)fileName).length() > 4 ? fileName : this.getFileNameProposal(true)))).open()) != null && gpxFilePath.length() > 4) {
            if (FileUtils.checkFileExist(gpxFilePath) && 128 == this.application.openYesNoMessageDialog(Messages.getString("GDE_MSGI0007", new Object[]{gpxFilePath}))) {
                return;
            }
            try {
                this.application.enableMenuActions(false);
                this.application.setCursor(SWTResourceManager.getCursor(1));
                GPXWriter.write(gpxFilePath, activeRecordSet, latitudeOrdinal, longitudeOrdinal, altitudeOrdinal, speedOrdinal, satellitesOrdinal, hdopOrdinal, vdopOrdinal, pdodOrdinal, accelerationXYZ);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
                this.application.openMessageDialog(e.getClass().getSimpleName() + " - " + e.getMessage());
            }
            this.application.enableMenuActions(true);
            this.application.setCursor(SWTResourceManager.getCursor(0));
        }
    }
}

