/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui;

import gde.GDE;
import gde.config.Settings;
import gde.histo.recordings.TrailRecordSet;
import gde.histo.ui.AbstractChartWindow;
import gde.histo.ui.AbstractMeasuring;
import gde.histo.ui.Measure;
import gde.histo.ui.menu.AbstractTabAreaContextMenu;
import gde.log.Logger;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.GraphicsUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractChartComposite
extends Composite {
    private static final String $CLASS_NAME = AbstractChartComposite.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    protected static final int DEFAULT_TOP_GAP = 5;
    protected static final int DEFAULT_SIDE_GAP = 10;
    protected static final int DEFAULT_BOTTOM_GAP = 20;
    protected static final int DEFAULT_HEADER_GAP = 5;
    protected static final int DEFAULT_COMMENT_GAP = 5;
    protected static final int ZERO_CANVAS_HEIGHT = 11;
    protected final DataExplorer application = DataExplorer.getInstance();
    protected final Settings settings = Settings.getInstance();
    protected final AbstractChartWindow.WindowActor windowActor;
    protected Menu popupmenu;
    protected AbstractTabAreaContextMenu contextMenu;
    protected Color curveAreaBackground;
    protected Color surroundingBackground;
    protected Color curveAreaBorderColor;
    protected Text graphicsHeader;
    protected Text recordSetComment;
    protected Text xScale;
    protected Canvas graphicCanvas;
    int headerHeight = 0;
    int headerGap = 0;
    int commentHeight = 0;
    int commentGap = 0;
    int xScaleHeight = 0;
    protected String graphicsHeaderText;
    protected Rectangle canvasBounds;
    protected Image canvasImage;
    protected GC canvasImageGC;
    protected Rectangle curveAreaBounds = new Rectangle(0, 0, 1, 1);
    protected int fixedCanvasY = -1;
    protected int fixedCanvasHeight = -1;
    protected Point oldSize = new Point(0, 0);
    protected AbstractMeasuring measuring;

    public static int constrainToRange(int value, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException(value + "  " + min + "/" + max);
        }
        return Math.min(Math.max(value, min), max);
    }

    public AbstractChartComposite(Composite parent, CTabItem parentWindow, int style) {
        super(parent, style);
        this.windowActor = ((AbstractChartWindow)parentWindow).windowActor;
    }

    protected TrailRecordSet retrieveTrailRecordSet() {
        return this.windowActor.getTrailRecordSet();
    }

    public void redrawGraphics() {
        if (Thread.currentThread().getId() == this.application.getThreadId()) {
            this.doRedrawGraphics();
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractChartComposite.this.doRedrawGraphics();
                }
            });
        }
    }

    protected synchronized void doRedrawGraphics() {
        log.fine(() -> "refresch graphics");
        this.drawCurves();
        this.graphicCanvas.redraw();
        this.recordSetComment.redraw();
    }

    public void notifySelected() {
        this.recordSetComment.notifyListeners(16, new Event());
    }

    protected void setRecordSetCommentStandard() {
        this.recordSetComment.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.recordSetComment.setText(this.application.getPresentHistoExplorer().getHistoSet().getDirectoryScanStatistics());
        this.recordSetComment.setToolTipText(Messages.getString("GDE_MSGT0896"));
    }

    public void enableGraphicsHeader(boolean enabled) {
        if (enabled) {
            this.headerGap = 5;
            this.headerHeight = 28;
        } else {
            this.headerGap = 5;
            this.headerHeight = 0;
        }
        this.setComponentBounds();
    }

    public void enableGraphicsScale(boolean enabled) {
        if (enabled) {
            GC gc = new GC((Drawable)this.xScale);
            Point pt = gc.textExtent("0");
            this.xScaleHeight = 3 * pt.y;
            gc.dispose();
        } else {
            this.xScaleHeight = 0;
        }
        this.setComponentBounds();
    }

    public void enableRecordSetComment(boolean enabled) {
        if (enabled) {
            this.commentGap = 5;
            GC gc = new GC((Drawable)this.recordSetComment);
            int stringHeight = gc.stringExtent((String)this.recordSetComment.getText()).y;
            this.commentHeight = stringHeight * 2 + 8;
            gc.dispose();
        } else {
            this.commentGap = 0;
            this.commentHeight = 0;
        }
        this.setComponentBounds();
    }

    public void clearHeaderAndComment() {
        this.recordSetComment.setText("");
        this.recordSetComment.setToolTipText("");
        this.graphicsHeader.setText("");
        this.graphicsHeaderText = null;
        this.updateCaptions();
    }

    public synchronized void updateCaptions() {
        this.recordSetComment.redraw();
        this.graphicsHeader.redraw();
    }

    protected void setComponentBounds() {
        Rectangle graphicsBounds = this.getClientArea();
        int x = 0;
        int y = this.headerGap;
        int width = graphicsBounds.width;
        int height = this.headerHeight;
        this.graphicsHeader.setBounds(x, y, width, height);
        log.log(Level.FINER, "recordSetHeader.setBounds " + String.valueOf(this.graphicsHeader.getBounds()));
        y = this.fixedCanvasY < 0 ? this.headerGap + this.headerHeight : this.fixedCanvasY;
        height = this.fixedCanvasHeight < 0 ? graphicsBounds.height - (this.headerGap + this.commentGap + this.commentHeight + this.headerHeight) : this.fixedCanvasHeight + this.headerGap + 20;
        this.graphicCanvas.setBounds(x, y, width, height);
        log.log(Level.FINER, "graphicCanvas.setBounds ", this.graphicCanvas.getBounds());
        y += height + this.commentGap;
        height = this.commentHeight;
        this.recordSetComment.setBounds(20, y, width - 40, height - 5);
        log.log(Level.FINER, "recordSetComment.setBounds " + String.valueOf(this.recordSetComment.getBounds()));
    }

    protected abstract void setFixedGraphicCanvas(Rectangle var1);

    public void setFixedGraphicCanvas(int fixedY, int fixedHeight) {
        this.fixedCanvasY = fixedY;
        this.fixedCanvasHeight = fixedHeight;
        log.finer(() -> "y = " + fixedY + "  height = " + fixedHeight);
        this.setComponentBounds();
    }

    public Image getGraphicsPrintImage() {
        Image graphicsImage = null;
        int graphicsHeight = 30 + this.canvasBounds.height + 40;
        TrailRecordSet trailRecordSet = this.windowActor.getTrailRecordSet();
        if (trailRecordSet != null && trailRecordSet.getTimeStepSize() > 0) {
            if (this.canvasImage != null) {
                this.canvasImage.dispose();
            }
            this.canvasImage = new Image((Device)GDE.display, this.canvasBounds);
            this.canvasImageGC = new GC((Drawable)this.canvasImage);
            this.canvasImageGC.setBackground(this.surroundingBackground);
            this.canvasImageGC.fillRectangle(this.canvasBounds);
            this.canvasImageGC.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.drawCurves();
            graphicsImage = new Image((Device)GDE.display, this.canvasBounds.width, graphicsHeight);
            GC graphicsGC = new GC((Drawable)graphicsImage);
            graphicsGC.setForeground(this.graphicsHeader.getForeground());
            graphicsGC.setBackground(this.surroundingBackground);
            graphicsGC.setFont(this.graphicsHeader.getFont());
            graphicsGC.fillRectangle(0, 0, this.canvasBounds.width, graphicsHeight);
            if (this.graphicsHeader.getText().length() > 1) {
                GraphicsUtils.drawTextCentered(this.graphicsHeader.getText(), this.canvasBounds.width / 2, 20, graphicsGC, 256);
            }
            graphicsGC.setFont(this.recordSetComment.getFont());
            if (this.recordSetComment.getText().length() > 1) {
                GraphicsUtils.drawText(this.recordSetComment.getText(), 20, graphicsHeight - 40, graphicsGC, 256);
            }
            graphicsGC.drawImage(this.canvasImage, 0, 30);
            graphicsGC.dispose();
            this.canvasImageGC.dispose();
        }
        return graphicsImage;
    }

    protected void drawCurves() {
        if (this.windowActor.getTrailRecordSet() != null) {
            this.canvasBounds = this.graphicCanvas.getClientArea();
            log.finer(() -> "canvasBounds" + String.valueOf(this.canvasBounds));
            if (this.canvasBounds.height <= 0 || this.canvasBounds.width <= 0) {
                return;
            }
            if (this.canvasImage != null) {
                this.canvasImage.dispose();
            }
            this.canvasImage = new Image((Device)GDE.display, this.canvasBounds);
            this.canvasImageGC = new GC((Drawable)this.canvasImage);
            this.canvasImageGC.setBackground(this.surroundingBackground);
            this.canvasImageGC.fillRectangle(this.canvasBounds);
            this.canvasImageGC.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.windowActor.getTrailRecordSet().syncScaleOfSyncableRecords();
            int dataScaleWidth = this.defineDataScaleWidth();
            this.curveAreaBounds = this.defineCurveAreaBounds(dataScaleWidth, this.defineNumberLeftRightScales());
            this.defineLayoutParams();
            this.drawCurveArea(dataScaleWidth);
            this.canvasImageGC.dispose();
        }
    }

    private int defineDataScaleWidth() {
        Point pt = this.canvasImageGC.textExtent("-000,00");
        int horizontalGap = pt.x / 5;
        int horizontalNumberExtend = pt.x;
        int horizontalCaptionExtend = pt.y;
        int dataScaleWidth = horizontalNumberExtend + horizontalCaptionExtend + horizontalGap;
        return dataScaleWidth;
    }

    private Rectangle defineCurveAreaBounds(int dataScaleWidth, int[] numberLeftRightScales) {
        int spaceLeft = numberLeftRightScales[0] * dataScaleWidth;
        int spaceRight = numberLeftRightScales[1] * dataScaleWidth;
        int gapSide = 10;
        int x0 = spaceLeft + (numberLeftRightScales[0] > 0 ? gapSide / 2 : gapSide);
        int xMax = this.canvasBounds.width - spaceRight - (numberLeftRightScales[1] > 0 ? gapSide / 2 : gapSide);
        int width = Math.max(1, xMax - x0);
        int yMax = 5;
        int y0 = this.canvasBounds.height - yMax - this.getXScaleHeight();
        int height = Math.max(1, y0 - yMax);
        log.finer(() -> "draw area x0=" + x0 + ", y0=" + y0 + ", xMax=" + xMax + ", yMax=" + yMax + ", width=" + width + ", height=" + height);
        Rectangle result = new Rectangle(x0, y0 - height, width, height);
        log.log(Level.FINE, "curve bounds=", result);
        return result;
    }

    public int getFixedTotalHeight() {
        return 5 + this.headerHeight + 5 + this.fixedCanvasHeight + 5 + this.commentHeight + 20;
    }

    public int getXScaleHeight() {
        return this.xScaleHeight;
    }

    protected abstract int[] defineNumberLeftRightScales();

    protected abstract void drawCurveArea(int var1);

    protected Point checkCurveBounds(int xPos, int yPos) {
        log.finer(() -> "in  xPos = " + xPos + " yPos = " + yPos);
        int tmpxPos = xPos - this.curveAreaBounds.x;
        int tmpyPos = yPos - this.curveAreaBounds.y;
        tmpxPos = AbstractChartComposite.constrainToRange(tmpxPos, 0, this.curveAreaBounds.width);
        tmpyPos = AbstractChartComposite.constrainToRange(tmpyPos, 0, this.curveAreaBounds.height);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "out xPos = " + tmpxPos + " yPos = " + tmpyPos);
        }
        return new Point(tmpxPos, tmpyPos);
    }

    protected boolean isBeyondLeftBounds(int xPos) {
        return xPos < this.curveAreaBounds.x;
    }

    protected boolean isBeyondRightBounds(int xPos) {
        return xPos > this.curveAreaBounds.x + this.curveAreaBounds.width;
    }

    public Optional<AbstractMeasuring> getMeasuring() {
        return Optional.ofNullable(this.measuring);
    }

    public abstract void setMeasuringActive(Measure var1);

    public void cleanMeasuring() {
        this.measuring.cleanMeasuring();
        this.measuring = null;
    }

    public void abstractDrawAreaPaintControl(GC canvasGC) {
        if (this.windowActor.getTrailRecordSet() == null) {
            return;
        }
        this.setRecordSetCommentStandard();
        this.windowActor.setStatusMessage("");
        TrailRecordSet trailRecordSet = this.retrieveTrailRecordSet();
        if (trailRecordSet != null && trailRecordSet.getTimeStepSize() > 0) {
            canvasGC.drawImage(this.canvasImage, 0, 0);
            if (this.measuring != null) {
                this.measuring.drawMeasuring(canvasGC);
            }
        } else {
            canvasGC.drawImage(this.canvasImage, 0, 0);
        }
    }

    protected abstract void defineLayoutParams();

    public static class AbstractChartData {
        private final Map<String, AbstractChartLayout> chartData = new LinkedHashMap<String, AbstractChartLayout>();

        public void clear() {
            this.chartData.clear();
        }

        public AbstractChartLayout get(String recordName) {
            return this.chartData.get(recordName);
        }

        public AbstractChartLayout put(String recordName, AbstractChartLayout chartLayout) {
            return this.chartData.put(recordName, chartLayout);
        }

        public String toString() {
            int maxLen = 10;
            return "AbstractChartData [chartData=" + (this.chartData != null ? this.toString(this.chartData.entrySet(), 10) : null) + "]";
        }

        private String toString(Collection<?> collection, int maxLen) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            Iterator<?> iterator = collection.iterator();
            for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(iterator.next());
            }
            builder.append("]");
            return builder.toString();
        }
    }

    protected static class AbstractChartLayout {
        protected AbstractChartLayout() {
        }
    }
}

