/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.transitions;

import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.TransitionType;
import gde.histo.transitions.AbstractDetector;
import gde.histo.transitions.GroupTransitions;
import gde.histo.transitions.Transition;
import gde.log.Logger;
import java.util.logging.Level;

public final class SlopeDetector
extends AbstractDetector {
    static final String $CLASS_NAME = SlopeDetector.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    private final RecordSet recordSet;

    public SlopeDetector(RecordSet recordSet) {
        super(recordSet.getAnalyzer());
        this.recordSet = recordSet;
    }

    public GroupTransitions.TransitionChronicle findTransitions(Record record, TransitionType transitionType) {
        this.triggerState = AbstractDetector.TriggerState.WAITING;
        this.initializeDeques(record, transitionType);
        return this.findSlopeTransitions(record, transitionType);
    }

    private GroupTransitions.TransitionChronicle findSlopeTransitions(Record record, TransitionType transitionType) {
        GroupTransitions.TransitionChronicle transitions = new GroupTransitions.TransitionChronicle();
        IDevice device = this.analyzer.getActiveDevice();
        AbstractDetector.LevelChecker levelChecker = new AbstractDetector.LevelChecker(record, transitionType);
        block4: for (int i = 0; i < record.realSize() && record.elementAt(i) != null; ++i) {
            long timeStamp_100ns = (long)(record.getTime_ms(i) * 10.0);
            double translatedValue = device.translateValue(record, (double)((Integer)record.elementAt(i)).intValue() / 1000.0);
            switch (this.triggerState) {
                case WAITING: {
                    this.previousTriggerState = this.triggerState;
                    boolean isThresholdLevel = levelChecker.isBeyondThresholdLevel(translatedValue);
                    if (isThresholdLevel && !this.referenceDeque.isAddableInTimePeriod(timeStamp_100ns) && !levelChecker.isBeyondThresholdLevel(this.referenceDeque.getSecurityValue())) {
                        this.triggerState = AbstractDetector.TriggerState.TRIGGERED;
                        this.thresholdDeque.initialize(i);
                        this.thresholdDeque.addLast(translatedValue, timeStamp_100ns);
                        log.finer(() -> Integer.toString(transitionType.getTransitionId()) + String.valueOf(this));
                        continue block4;
                    }
                    this.referenceDeque.addLast(translatedValue, timeStamp_100ns);
                    continue block4;
                }
                case TRIGGERED: {
                    this.previousTriggerState = this.triggerState;
                    boolean isPersistentTrigger = levelChecker.isBeyondThresholdLevel(translatedValue);
                    if (!this.thresholdDeque.isAddableInTimePeriod(timeStamp_100ns)) {
                        if (!levelChecker.isBeyondThresholdLevel(this.referenceDeque.getSecurityValue())) {
                            this.triggerState = AbstractDetector.TriggerState.WAITING;
                            log.finer(() -> Integer.toString(transitionType.getTransitionId()) + String.valueOf(this));
                            Transition transition = new Transition(this.referenceDeque.startIndex, this.referenceDeque.size(), this.thresholdDeque.startIndex, this.thresholdDeque.size(), record, transitionType);
                            transitions.put(transition.getThresholdStartTimeStamp_ms(), transition);
                            log.log(Level.FINE, ">", transition);
                            log.finer(() -> Integer.toString(transitionType.getTransitionId()) + String.valueOf(this));
                            this.thresholdDeque.clear();
                            this.referenceDeque.initialize(i);
                            this.referenceDeque.addLast(translatedValue, timeStamp_100ns);
                            continue block4;
                        }
                        log.warning(() -> String.format("%d trigger security check provoked a fallback %s: translatedValue=%f  thresholdAverage=%f", transitionType.getTransitionId(), this.thresholdDeque.getFormatedDuration(this.thresholdDeque.size() - 1), translatedValue, this.thresholdDeque.getAverageValue()));
                        this.triggerState = AbstractDetector.TriggerState.WAITING;
                        log.log(Level.FINER, Integer.toString(transitionType.getTransitionId()), this);
                        this.referenceDeque.initialize(i - this.thresholdDeque.size());
                        this.referenceDeque.addLast(translatedValue, timeStamp_100ns);
                        this.thresholdDeque.clear();
                        continue block4;
                    }
                    if (!isPersistentTrigger) {
                        this.triggerState = AbstractDetector.TriggerState.WAITING;
                        log.log(Level.FINE, " !isPersistentTrigger " + transitionType.getTransitionId(), this);
                        this.referenceDeque.initialize(i - this.thresholdDeque.size());
                        this.referenceDeque.addLastByMoving(this.thresholdDeque);
                        this.referenceDeque.addLast(translatedValue, timeStamp_100ns);
                        continue block4;
                    }
                    this.thresholdDeque.addLast(translatedValue, timeStamp_100ns);
                    continue block4;
                }
            }
        }
        return transitions;
    }

    private void initializeDeques(Record transitionRecord, TransitionType transitionType) {
        int referenceDequeSize = (int)((double)transitionType.getReferenceTimeMsec() / this.recordSet.getAverageTimeStep_ms());
        int thresholdDequeSize = (int)((double)transitionType.getThresholdTimeMsec() / this.recordSet.getAverageTimeStep_ms());
        this.referenceDeque = new AbstractDetector.SettlementDeque(referenceDequeSize, transitionType.isGreater(), transitionType.getReferenceTimeMsec() * 10);
        this.thresholdDeque = new AbstractDetector.SettlementDeque(thresholdDequeSize, !transitionType.isGreater(), transitionType.getThresholdTimeMsec() * 10);
        this.recoveryDeque = new AbstractDetector.SettlementDeque(1, true, 1L);
        this.referenceDeque.initialize(0);
        int descriptionCutPoint = transitionRecord.getParent().getDescription().indexOf("\r");
        if (descriptionCutPoint < 0) {
            descriptionCutPoint = 11;
        }
        log.log(Level.FINEST, transitionType.getTransitionId() + "  " + transitionRecord.getParent().getName() + "  " + transitionRecord.getParent().getDescription().substring(0, descriptionCutPoint) + String.format(" %s initialized: referenceDequeSize=%d  thresholdDequeSize=%d", transitionRecord.getName(), referenceDequeSize, thresholdDequeSize));
    }
}

