/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.decoder;

import de.treichels.hott.decoder.HoTTSerialPort;
import de.treichels.hott.decoder.internal.decoder.BaseDecoder;
import de.treichels.hott.decoder.internal.decoder.VDFDecoder;
import de.treichels.hott.model.BaseModel;
import de.treichels.hott.model.enums.ModelType;
import de.treichels.hott.voice.VoiceFile;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0006J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u0014\u00a8\u0006\""}, d2={"Lde/treichels/hott/decoder/HoTTDecoder;", "", "()V", "decodeFile", "Lde/treichels/hott/model/BaseModel;", "file", "Ljava/io/File;", "decodeMemory", "port", "Lde/treichels/hott/decoder/HoTTSerialPort;", "modelNumber", "", "decodeStream", "type", "Lde/treichels/hott/model/enums/ModelType;", "name", "", "data", "Ljava/io/InputStream;", "decodeVDF", "Lde/treichels/hott/voice/VoiceFile;", "bytes", "", "encodeFile", "model", "dir", "encodeVDF", "Ljava/nio/file/Path;", "voiceFile", "getMaxDataSize", "getMaxInfoSize", "getMaxVoiceCount", "verityVDF", "", "HoTT-Decoder"})
public final class HoTTDecoder {
    public static final HoTTDecoder INSTANCE;

    @NotNull
    public final BaseModel decodeFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        return BaseDecoder.Companion.decode(file);
    }

    @NotNull
    public final BaseModel decodeMemory(@NotNull HoTTSerialPort port, int modelNumber) {
        Intrinsics.checkParameterIsNotNull(port, "port");
        return BaseDecoder.Companion.decode(port, modelNumber);
    }

    @NotNull
    public final BaseModel decodeStream(@NotNull ModelType type2, @NotNull String name, @NotNull InputStream data2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, "type");
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(data2, "data");
        return BaseDecoder.Companion.decode(type2, name, data2);
    }

    @NotNull
    public final VoiceFile decodeVDF(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull(bytes, "bytes");
        return VDFDecoder.INSTANCE.decodeVDF(bytes);
    }

    @NotNull
    public final VoiceFile decodeVDF(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        byte[] byArray = Files.readAllBytes(file.toPath());
        Intrinsics.checkExpressionValueIsNotNull(byArray, "Files.readAllBytes(file.toPath())");
        return this.decodeVDF(byArray);
    }

    @NotNull
    public final File encodeFile(@NotNull BaseModel model, @NotNull File dir) {
        Intrinsics.checkParameterIsNotNull(model, "model");
        Intrinsics.checkParameterIsNotNull(dir, "dir");
        return BaseDecoder.Companion.encode(model, dir);
    }

    @NotNull
    public final Path encodeVDF(@NotNull VoiceFile voiceFile, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull(voiceFile, "voiceFile");
        Intrinsics.checkParameterIsNotNull(file, "file");
        Path path2 = Files.write(file.toPath(), VDFDecoder.INSTANCE.encodeVDF(voiceFile), new OpenOption[0]);
        Intrinsics.checkExpressionValueIsNotNull(path2, "Files.write(file.toPath(\u2026der.encodeVDF(voiceFile))");
        return path2;
    }

    public final int getMaxDataSize(@NotNull VoiceFile voiceFile) {
        Intrinsics.checkParameterIsNotNull(voiceFile, "voiceFile");
        return VDFDecoder.INSTANCE.getDataSize(voiceFile);
    }

    public final int getMaxInfoSize(@NotNull VoiceFile voiceFile) {
        Intrinsics.checkParameterIsNotNull(voiceFile, "voiceFile");
        return VDFDecoder.INSTANCE.getInfoSize(voiceFile);
    }

    public final int getMaxVoiceCount(@NotNull VoiceFile voiceFile) {
        Intrinsics.checkParameterIsNotNull(voiceFile, "voiceFile");
        return VDFDecoder.INSTANCE.getMaxVoiceCount(voiceFile);
    }

    public final void verityVDF(@NotNull VoiceFile voiceFile) {
        Intrinsics.checkParameterIsNotNull(voiceFile, "voiceFile");
        VDFDecoder.INSTANCE.verifyVDF(voiceFile);
    }

    private HoTTDecoder() {
    }

    static {
        HoTTDecoder hoTTDecoder;
        INSTANCE = hoTTDecoder = new HoTTDecoder();
    }
}

