/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.webkit.network.Cookie;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

final class CookieStore {
    private static final PlatformLogger logger = PlatformLogger.getLogger(CookieStore.class.getName());
    private static final int MAX_BUCKET_SIZE = 50;
    private static final int TOTAL_COUNT_LOWER_THRESHOLD = 3000;
    private static final int TOTAL_COUNT_UPPER_THRESHOLD = 4000;
    private final Map<String, Map<Cookie, Cookie>> buckets = new HashMap<String, Map<Cookie, Cookie>>();
    private int totalCount = 0;

    CookieStore() {
    }

    Cookie get(Cookie cookie) {
        Map<Cookie, Cookie> map2 = this.buckets.get(cookie.getDomain());
        if (map2 == null) {
            return null;
        }
        Cookie cookie2 = map2.get(cookie);
        if (cookie2 == null) {
            return null;
        }
        if (cookie2.hasExpired()) {
            map2.remove(cookie2);
            --this.totalCount;
            this.log("Expired cookie removed by get", cookie2, map2);
            return null;
        }
        return cookie2;
    }

    List<Cookie> get(String string2, String string3, boolean bl, boolean bl2) {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest("hostname: [{0}], path: [{1}], secureProtocol: [{2}], httpApi: [{3}]", string2, string3, bl, bl2);
        }
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        String string4 = string2;
        while (string4.length() > 0) {
            int n;
            Map<Cookie, Cookie> map2 = this.buckets.get(string4);
            if (map2 != null) {
                this.find(arrayList, map2, string2, string3, bl, bl2);
            }
            if ((n = string4.indexOf(46)) == -1) break;
            string4 = string4.substring(n + 1);
        }
        Collections.sort(arrayList, new GetComparator());
        long l = System.currentTimeMillis();
        for (Cookie cookie : arrayList) {
            cookie.setLastAccessTime(l);
        }
        logger.finest("result: {0}", arrayList);
        return arrayList;
    }

    private void find(List<Cookie> list2, Map<Cookie, Cookie> map2, String string2, String string3, boolean bl, boolean bl2) {
        Iterator<Cookie> iterator2 = map2.values().iterator();
        while (iterator2.hasNext()) {
            Cookie cookie = iterator2.next();
            if (cookie.hasExpired()) {
                iterator2.remove();
                --this.totalCount;
                this.log("Expired cookie removed by find", cookie, map2);
                continue;
            }
            if (!cookie.getHostOnly() ? !Cookie.domainMatches(string2, cookie.getDomain()) : !string2.equalsIgnoreCase(cookie.getDomain())) continue;
            if (!Cookie.pathMatches(string3, cookie.getPath()) || cookie.getSecureOnly() && !bl || cookie.getHttpOnly() && !bl2) continue;
            list2.add(cookie);
        }
    }

    void put(Cookie cookie) {
        Map<Cookie, Cookie> map2 = this.buckets.get(cookie.getDomain());
        if (map2 == null) {
            map2 = new LinkedHashMap<Cookie, Cookie>(20);
            this.buckets.put(cookie.getDomain(), map2);
        }
        if (cookie.hasExpired()) {
            this.log("Cookie expired", cookie, map2);
            if (map2.remove(cookie) != null) {
                --this.totalCount;
                this.log("Expired cookie removed by put", cookie, map2);
            }
        } else if (map2.put(cookie, cookie) == null) {
            ++this.totalCount;
            this.log("Cookie added", cookie, map2);
            if (map2.size() > 50) {
                this.purge(map2);
            }
            if (this.totalCount > 4000) {
                this.purge();
            }
        } else {
            this.log("Cookie updated", cookie, map2);
        }
    }

    private void purge(Map<Cookie, Cookie> map2) {
        logger.finest("Purging bucket: {0}", map2.values());
        Cookie cookie = null;
        Iterator<Cookie> iterator2 = map2.values().iterator();
        while (iterator2.hasNext()) {
            Cookie cookie2 = iterator2.next();
            if (cookie2.hasExpired()) {
                iterator2.remove();
                --this.totalCount;
                this.log("Expired cookie removed", cookie2, map2);
                continue;
            }
            if (cookie != null && cookie2.getLastAccessTime() >= cookie.getLastAccessTime()) continue;
            cookie = cookie2;
        }
        if (map2.size() > 50) {
            map2.remove(cookie);
            --this.totalCount;
            this.log("Excess cookie removed", cookie, map2);
        }
    }

    private void purge() {
        logger.finest("Purging store");
        PriorityQueue<Cookie> priorityQueue = new PriorityQueue<Cookie>(this.totalCount / 2, new RemovalComparator());
        for (Map.Entry<String, Map<Cookie, Cookie>> map2 : this.buckets.entrySet()) {
            Map<Cookie, Cookie> map3 = map2.getValue();
            Iterator<Cookie> iterator2 = map3.values().iterator();
            while (iterator2.hasNext()) {
                Cookie cookie = iterator2.next();
                if (cookie.hasExpired()) {
                    iterator2.remove();
                    --this.totalCount;
                    this.log("Expired cookie removed", cookie, map3);
                    continue;
                }
                priorityQueue.add(cookie);
            }
        }
        while (this.totalCount > 3000) {
            Cookie cookie = (Cookie)priorityQueue.remove();
            Map<Cookie, Cookie> map4 = this.buckets.get(cookie.getDomain());
            if (map4 == null) continue;
            map4.remove(cookie);
            --this.totalCount;
            this.log("Excess cookie removed", cookie, map4);
        }
    }

    private void log(String string2, Cookie cookie, Map<Cookie, Cookie> map2) {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest("{0}: {1}, bucket size: {2}, total count: {3}", string2, cookie, map2.size(), this.totalCount);
        }
    }

    private static final class RemovalComparator
    implements Comparator<Cookie> {
        private RemovalComparator() {
        }

        @Override
        public int compare(Cookie cookie, Cookie cookie2) {
            return (int)(cookie.getLastAccessTime() - cookie2.getLastAccessTime());
        }
    }

    private static final class GetComparator
    implements Comparator<Cookie> {
        private GetComparator() {
        }

        @Override
        public int compare(Cookie cookie, Cookie cookie2) {
            int n = cookie2.getPath().length() - cookie.getPath().length();
            if (n != 0) {
                return n;
            }
            return cookie.getCreationTime().compareTo(cookie2.getCreationTime());
        }
    }
}

