/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.GDE;
import gde.config.ExportService;
import gde.config.Settings;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.exception.ApplicationConfigurationException;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.dialog.edit.DevicePropertiesEditor;
import gde.utils.OperatingSystemHelper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class FileUtils {
    private static final Logger log = Logger.getLogger(FileUtils.class.getName());
    public static final List<String> onExitRenameJar = new ArrayList<String>();

    public static void copyFile(File in, File out) throws IOException {
        AbstractInterruptibleChannel inChannel = null;
        AbstractInterruptibleChannel outChannel = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(in);
            fos = new FileOutputStream(out);
            inChannel = fis.getChannel();
            outChannel = fos.getChannel();
            ((FileChannel)inChannel).transferTo(0L, ((FileChannel)inChannel).size(), (WritableByteChannel)((Object)outChannel));
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static void copyAllFiles(String srcDir, String tgtDir) throws IOException, ApplicationConfigurationException {
        File sourceDir = new File(srcDir);
        String[] files = sourceDir.list();
        if (files == null) {
            throw new ApplicationConfigurationException(Messages.getString("GDE_MSGE0017", new Object[]{srcDir}));
        }
        for (String srcFile : files) {
            File src;
            if (GDE.IS_WINDOWS) {
                srcFile = srcFile.replace("%20", " ");
            }
            if ((src = new File(srcDir + "/" + srcFile)).isDirectory()) continue;
            File tgt = new File(tgtDir + "/" + srcFile);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "copy " + src.toString() + " to " + tgt.toString());
            }
            FileUtils.copyFile(src, tgt);
        }
    }

    public static boolean checkDirectoryAndCreate(String directory) {
        boolean exist = true;
        File dir = new File(directory);
        if (!dir.exists() && !dir.isDirectory()) {
            exist = false;
            if (!dir.mkdirs()) {
                log.log(Level.WARNING, "failed to create " + directory);
            }
        }
        return exist;
    }

    public static boolean checkDirectoryAndCreate(String directory, String versionFileName) {
        boolean exist = true;
        int version = Integer.parseInt(versionFileName.substring(versionFileName.length() - 6, versionFileName.length() - 4));
        File dir = new File(directory);
        if (!dir.exists() && !dir.isDirectory()) {
            exist = false;
            if (!dir.mkdir()) {
                log.log(Level.WARNING, "error upon create " + directory);
            }
        } else {
            File file = new File(String.format("%s%s%s", directory, "/", versionFileName));
            if (!file.exists()) {
                try {
                    for (File tmpFile : FileUtils.getFileListingNoSort(dir, 3)) {
                        int oldVersion;
                        if (!tmpFile.getPath().endsWith(".xsd") || dir.renameTo(new File(directory + "_V" + (oldVersion = Integer.parseInt(tmpFile.getPath().substring(tmpFile.getPath().length() - 6, tmpFile.getPath().length() - 4)))))) continue;
                        log.log(Level.WARNING, "failed to rename " + directory + " into _V" + oldVersion);
                    }
                    File versionDir = new File(directory + "_V" + version);
                    if (versionDir.exists()) {
                        if (!versionDir.renameTo(new File(directory))) {
                            log.log(Level.WARNING, "failed to rename " + directory + " into _V" + version);
                        }
                    } else {
                        exist = false;
                        File newDir = new File(directory);
                        if (!newDir.mkdir()) {
                            log.log(Level.WARNING, "failed to create " + directory);
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return exist;
    }

    public static boolean cleanDirectory(File dir) {
        boolean exist = false;
        if (dir.exists() && dir.isDirectory() && dir.canWrite()) {
            exist = true;
            try {
                for (File file : FileUtils.getFileListing(dir, 5)) {
                    if (file.canWrite()) {
                        log.log(Level.FINE, file.getAbsolutePath() + " deletion " + file.delete());
                        continue;
                    }
                    log.log(Level.WARNING, "no delete permission on " + file.getAbsolutePath());
                }
                for (File directory : FileUtils.getDirListing(dir)) {
                    if (directory.canWrite() && FileUtils.deleteDirectory(directory.getAbsolutePath())) continue;
                    log.log(Level.WARNING, "no delete permission on " + directory.getAbsolutePath());
                }
            }
            catch (FileNotFoundException e) {
                throw new UnsupportedOperationException();
            }
        } else {
            log.log(Level.WARNING, "directory does not exist or no delete permission on " + dir.getAbsolutePath());
        }
        return exist;
    }

    public static boolean deleteDirectory(String fullQualifiedDirectoryPath) {
        boolean exist;
        block5: {
            exist = false;
            File dir = new File(fullQualifiedDirectoryPath);
            if (dir.exists() && dir.isDirectory() && dir.canWrite()) {
                exist = true;
                try {
                    FileUtils.cleanDirectory(dir);
                    log.log(Level.FINE, dir.getAbsolutePath() + " deletion " + dir.delete());
                }
                catch (Exception e) {
                    if (e instanceof FileNotFoundException) {
                        log.log(Level.WARNING, e.getMessage(), e);
                        break block5;
                    }
                    log.log(Level.SEVERE, dir.getAbsolutePath(), e);
                }
            } else {
                log.log(Level.WARNING, "directory does not exist or no delete permission on " + dir.getAbsolutePath());
            }
        }
        return exist;
    }

    public static void deleteFile(String filename) {
        if (!FileUtils.checkFileExist(filename)) {
            return;
        }
        File file = new File(filename);
        try {
            if (!file.canWrite()) {
                log.log(Level.WARNING, "no delete permission on " + filename);
            }
            log.log(Level.WARNING, "deleting " + filename);
            file.delete();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, filename, e);
        }
    }

    public static boolean checkFileExist(String fullQualifiedFileName) {
        File file = new File(fullQualifiedFileName);
        return file.exists() && !file.isDirectory();
    }

    public static boolean checkDirectoryExist(String fullQualifiedFileName) {
        File file = new File(fullQualifiedFileName);
        return file.exists() && file.isDirectory();
    }

    public static String renameFile(String filePath, String extension) {
        Object resultFilePath = filePath;
        if (FileUtils.checkFileExist(filePath)) {
            File file = new File(filePath);
            if (file.canWrite()) {
                File newFile = new File(filePath.substring(0, filePath.lastIndexOf(46) + 1) + extension);
                if (newFile.exists() && !newFile.delete()) {
                    log.log(Level.WARNING, "failed to delete " + filePath);
                }
                if (!file.renameTo(newFile)) {
                    log.log(Level.WARNING, "failed to rename " + filePath.substring(0, filePath.lastIndexOf(46) + 1) + extension);
                }
                resultFilePath = filePath.substring(0, filePath.lastIndexOf(46) + 1) + extension;
            } else {
                log.log(Level.WARNING, "no write permission on " + file.getAbsolutePath());
            }
        }
        return resultFilePath;
    }

    public static void cleanFile(String fullQualifiedFilePath) {
        if (FileUtils.checkFileExist(fullQualifiedFilePath) || FileUtils.checkDirectoryExist(fullQualifiedFilePath)) {
            File fileToBeDeleted = new File(fullQualifiedFilePath);
            if (!fileToBeDeleted.isDirectory() && fileToBeDeleted.canWrite()) {
                if (!fileToBeDeleted.delete()) {
                    log.log(Level.WARNING, "failed to delete " + fullQualifiedFilePath);
                }
            } else if (fileToBeDeleted.isDirectory() && fileToBeDeleted.canWrite()) {
                FileUtils.deleteDirectory(fileToBeDeleted.getAbsolutePath());
            } else {
                log.log(Level.WARNING, fileToBeDeleted.getAbsolutePath() + " is a directory or no delete permission !");
            }
        }
    }

    public static void cleanFiles(String fileBasePath, String[] fileNames) {
        fileBasePath = fileBasePath.replace('\\', '/');
        Vector<String> fileNamesWildCard = new Vector<String>();
        for (String fileName : fileNames) {
            if (fileName.length() >= 2 && !fileName.contains("*")) {
                FileUtils.cleanFile(fileBasePath + fileName);
                continue;
            }
            fileNamesWildCard.add(fileName);
        }
        if (fileNamesWildCard.size() > 0) {
            for (String fileName : fileNamesWildCard) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "fileName = '" + fileName + "'");
                }
                try {
                    String startSignature = fileName.substring(0, fileName.indexOf(42));
                    String endingSignature = fileName.substring(fileName.lastIndexOf(42) + 1);
                    List<File> fileList = FileUtils.getFileListingNoSort(new File(fileBasePath), 0);
                    for (File file : fileList) {
                        String tmpFileName = file.getName();
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "evaluating " + tmpFileName);
                        }
                        if (!(startSignature.length() == 0 && endingSignature.length() != 0 && tmpFileName.endsWith(endingSignature) || startSignature.length() != 0 && tmpFileName.startsWith(startSignature) && endingSignature.length() == 0) && (startSignature.length() == 0 || !tmpFileName.startsWith(startSignature) || endingSignature.length() == 0 || !tmpFileName.endsWith(endingSignature))) continue;
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "deleting " + tmpFileName);
                        }
                        FileUtils.cleanFile(fileBasePath + tmpFileName);
                    }
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
    }

    public static void extractWhileReplace(String placeholderKey, String replacement, String jarFilePath, String jarInternalFilePath, String targetFilePath, String sourceEncoding, String targetEncoding) throws IOException, UnsupportedEncodingException, FileNotFoundException {
        String line;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "jarFilePath = " + jarFilePath);
        }
        JarFile jarFile = new JarFile(jarFilePath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(FileUtils.getFileInputStream(jarFile, jarInternalFilePath), sourceEncoding));
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "targetPath = " + targetFilePath);
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFilePath), targetEncoding));
        while ((line = reader.readLine()) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, line);
            }
            while (line.indexOf(placeholderKey) > -1) {
                StringBuilder sb = new StringBuilder();
                sb.append(line.substring(0, line.indexOf(placeholderKey)));
                sb.append(replacement);
                sb.append(line.substring(line.indexOf(placeholderKey) + placeholderKey.length()));
                line = sb.toString();
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, line);
            }
            writer.write(line + GDE.LINE_SEPARATOR);
        }
        reader.close();
        writer.flush();
        writer.close();
    }

    public static void copyFileWhileReplaceKey(String placeHolderKey, String replacement, String sourceFilePath, String targetFilePath) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        Object line;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourceFilePath), "UTF-8"));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFilePath), "UTF-8"));
        while ((line = reader.readLine()) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, (String)line);
            }
            if (((String)line).indexOf(placeHolderKey) > -1) {
                StringBuilder sb = new StringBuilder();
                sb.append(((String)line).substring(0, ((String)line).indexOf(placeHolderKey)));
                sb.append(replacement);
                sb.append(((String)line).substring(((String)line).indexOf(placeHolderKey) + placeHolderKey.length()));
                line = sb.toString();
            }
            line = ((String)line).replace('\\', '/').replace("%20", " ") + GDE.LINE_SEPARATOR;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, (String)line);
            }
            writer.write((String)line);
        }
        reader.close();
        writer.flush();
        writer.close();
    }

    public static boolean extract(Class<?> runtimeInstance, String fileName, String jarInternalSourceDirectory, String targetDirectory, String permissionsUNIX) {
        boolean isExtracted = false;
        jarInternalSourceDirectory = ((String)(jarInternalSourceDirectory = ((String)jarInternalSourceDirectory).replace('\\', '/'))).endsWith("/") ? jarInternalSourceDirectory : (String)jarInternalSourceDirectory + "/";
        targetDirectory = ((String)targetDirectory).replace('\\', '/');
        targetDirectory = ((String)targetDirectory).endsWith("/") ? targetDirectory : (String)targetDirectory + "/";
        FileOutputStream os = null;
        InputStream is = null;
        File file = new File((String)targetDirectory, fileName);
        try {
            if (!file.exists()) {
                if (file.createNewFile()) {
                    log.info(() -> String.format(">>>>>> created %s", file.getAbsolutePath()));
                }
                if ((is = runtimeInstance.getClassLoader().getResourceAsStream(String.format("%s%s", jarInternalSourceDirectory, fileName))) != null) {
                    int read;
                    byte[] buffer = new byte[4096];
                    os = new FileOutputStream(file);
                    while ((read = is.read(buffer)) != -1) {
                        os.write(buffer, 0, read);
                    }
                    os.close();
                    is.close();
                    FileUtils.setAccessPermission(fileName, permissionsUNIX);
                    isExtracted = true;
                } else {
                    file.delete();
                    log.log(Level.SEVERE, String.format("extraction of %s%s failed!", jarInternalSourceDirectory, fileName));
                }
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return isExtracted;
    }

    public static InputStream getFileInputStream(JarFile jarFile, String jarInternalFilePath) throws IOException {
        jarInternalFilePath = jarInternalFilePath.replace('\\', '/');
        ZipEntry ze = jarFile.getEntry(jarInternalFilePath);
        InputStream is = jarFile.getInputStream(ze);
        return is;
    }

    public static boolean extract(Class<?> runtimeInstance, String sourceFileName, String targetFileName, String jarInternalSourceDirectory, String targetDirectory, String unixPermissions) {
        boolean isRenamed = false;
        jarInternalSourceDirectory = (jarInternalSourceDirectory = jarInternalSourceDirectory.replace('\\', '/')).endsWith("/") ? jarInternalSourceDirectory : (jarInternalSourceDirectory.length() > 1 ? jarInternalSourceDirectory + "/" : jarInternalSourceDirectory);
        targetDirectory = targetDirectory.replace('\\', '/');
        targetDirectory = targetDirectory.endsWith("/") ? targetDirectory : (targetDirectory.length() > 1 ? targetDirectory + "/" : targetDirectory);
        FileUtils.extract(runtimeInstance, sourceFileName, jarInternalSourceDirectory, targetDirectory, unixPermissions);
        File sourceFile = new File(targetDirectory + sourceFileName);
        if (new File(targetDirectory + targetFileName).exists()) {
            log.log(Level.WARNING, targetDirectory + targetFileName);
        }
        if (sourceFile.exists() && sourceFile.canWrite() && !(isRenamed = sourceFile.renameTo(new File(targetDirectory + targetFileName)))) {
            log.log(Level.WARNING, "renaming to " + targetDirectory + targetFileName + " failed !");
        }
        return isRenamed;
    }

    public static void extract(JarFile jarFile, String fileName, String jarSourceDirectory, String targetDirectory, String unixPermissions) {
        fileName = (fileName = fileName.replace('\\', '/')).startsWith("/") ? fileName.substring(1) : fileName;
        jarSourceDirectory = (jarSourceDirectory = jarSourceDirectory.replace('\\', '/')).endsWith("/") ? jarSourceDirectory : (jarSourceDirectory.length() > 1 ? jarSourceDirectory + "/" : jarSourceDirectory);
        targetDirectory = targetDirectory.replace('\\', '/');
        targetDirectory = targetDirectory.endsWith("/") ? targetDirectory : (targetDirectory.length() > 1 ? targetDirectory + "/" : targetDirectory);
        ZipEntry ze = jarFile.getEntry(jarSourceDirectory + fileName);
        byte[] buffer = new byte[4096];
        InputStream is = null;
        FileOutputStream os = null;
        try {
            if (ze != null) {
                int read;
                is = jarFile.getInputStream(ze);
                os = new FileOutputStream(targetDirectory + fileName);
                while ((read = is.read(buffer)) != -1) {
                    os.write(buffer, 0, read);
                }
                os.close();
                is.close();
                FileUtils.setAccessPermission(fileName, unixPermissions);
            } else {
                log.log(Level.WARNING, jarSourceDirectory + fileName + " does not exist!");
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void extractDir(JarFile jarFile, String jarInternalSourceDirectory, String targetDirectory, String permissionsUNIX) {
        jarInternalSourceDirectory = ((String)(jarInternalSourceDirectory = ((String)jarInternalSourceDirectory).replace('\\', '/'))).endsWith("/") ? jarInternalSourceDirectory : (String)jarInternalSourceDirectory + "/";
        targetDirectory = ((String)targetDirectory).replace('\\', '/');
        targetDirectory = ((String)targetDirectory).endsWith("/") ? targetDirectory : (String)targetDirectory + "/";
        byte[] buffer = new byte[4096];
        InputStream is = null;
        FileOutputStream os = null;
        FileUtils.checkDirectoryAndCreate((String)targetDirectory + (String)jarInternalSourceDirectory);
        Enumeration<JarEntry> enties = jarFile.entries();
        while (enties.hasMoreElements()) {
            JarEntry jarEntry = enties.nextElement();
            String entryName = jarEntry.getName();
            if (!entryName.startsWith((String)jarInternalSourceDirectory) && !entryName.endsWith(".css") || !entryName.contains(".") || FileUtils.checkFileExist((String)targetDirectory + entryName)) continue;
            ZipEntry ze = jarFile.getEntry(entryName);
            FileUtils.checkDirectoryAndCreate((String)targetDirectory + entryName.substring(0, entryName.lastIndexOf(47)));
            try {
                int read;
                is = jarFile.getInputStream(ze);
                os = new FileOutputStream((String)targetDirectory + entryName);
                while ((read = is.read(buffer)) != -1) {
                    os.write(buffer, 0, read);
                }
                os.close();
                is.close();
                FileUtils.setAccessPermission(entryName, permissionsUNIX);
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (is == null) continue;
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void updateImageInDeviceJar(DeviceConfiguration deviceConfig, String imageFileName, Image deviceImage) {
        block9: {
            try {
                boolean isStartedWithinEclipse = DevicePropertiesEditor.class.getProtectionDomain().getCodeSource().getLocation().getPath().endsWith("/");
                if (isStartedWithinEclipse) {
                    log.log(Level.INFO, "started within Eclipse");
                    String fullQualifiedImageTargetName = FileUtils.findDeviceProjectDirectoryPath(deviceConfig) + "/src/resource/" + imageFileName;
                    log.log(Level.INFO, "fullQualifiedImageTargetName = " + fullQualifiedImageTargetName);
                    ImageLoader imageLoader = new ImageLoader();
                    imageLoader.data = new ImageData[]{deviceImage.getImageData()};
                    try {
                        imageLoader.save((OutputStream)new FileOutputStream(fullQualifiedImageTargetName), 4);
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                    }
                    break block9;
                }
                if (DataExplorer.isInitialized()) {
                    log.log(Level.INFO, "started within DataExplorer");
                } else {
                    log.log(Level.INFO, "started outside DataExplorer");
                    try {
                        Thread.currentThread().setContextClassLoader(GDE.getClassLoader());
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                String addJarEntryName = "resource/" + imageFileName;
                String deviceJarPath = FileUtils.getJarFileNameOfDevice(deviceConfig);
                Object tmpDeviceJarPath = deviceJarPath.replace('\\', '/');
                tmpDeviceJarPath = GDE.JAVA_IO_TMPDIR.replace('\\', '/') + ((String)tmpDeviceJarPath).substring(((String)tmpDeviceJarPath).lastIndexOf(47) + 1, ((String)tmpDeviceJarPath).length());
                log.log(Level.WARNING, "deviceJarPath = " + deviceJarPath + "; tmpDeviceJarPath = " + (String)tmpDeviceJarPath);
                FileUtils.updateJarContent(deviceJarPath, (String)tmpDeviceJarPath, addJarEntryName, deviceImage, DevicePropertiesEditor.dialogShell);
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public static void updateJarContent(String deviceJarPath, String tmpDeviceJarPath, String addJarEntryName, Image deviceImage, Shell messageBoxShell) throws IOException, FileNotFoundException {
        JarEntry inEntry;
        if (FileUtils.checkFileExist(tmpDeviceJarPath)) {
            MessageBox mBox = new MessageBox(messageBoxShell, 33220);
            mBox.setText("DataExplorer");
            mBox.setMessage(Messages.getString("GDE_MSGI0043", new String[]{tmpDeviceJarPath}));
            int ret = mBox.open();
            if (256 == ret) {
                return;
            }
            if (128 == ret) {
                FileUtils.renameFile(tmpDeviceJarPath, "bak");
                deviceJarPath = tmpDeviceJarPath.substring(0, tmpDeviceJarPath.lastIndexOf(46) + 1) + "bak";
            }
        }
        JarInputStream in = new JarInputStream(new FileInputStream((String)deviceJarPath));
        JarFile jarFile = new JarFile((String)deviceJarPath);
        JarOutputStream out = new JarOutputStream((OutputStream)new FileOutputStream(new File(tmpDeviceJarPath)), jarFile.getManifest());
        byte[] buf = new byte[1024];
        int len = 0;
        while ((inEntry = in.getNextJarEntry()) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "inEntry = " + inEntry.getName());
            }
            if (!inEntry.getName().equalsIgnoreCase(addJarEntryName) && !inEntry.getName().endsWith("MANIFEST.MF")) {
                out.putNextEntry(new JarEntry(inEntry));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
            }
            in.closeEntry();
        }
        in.close();
        JarEntry jarAddEntry = new JarEntry(addJarEntryName);
        out.putNextEntry(jarAddEntry);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{deviceImage.getImageData()};
        imageLoader.save((OutputStream)out, 4);
        out.closeEntry();
        out.close();
        jarFile.close();
        File tmpFile = new File(tmpDeviceJarPath);
        if (tmpFile.exists()) {
            MessageBox mBox = new MessageBox(messageBoxShell, 32);
            mBox.setText("DataExplorer");
            mBox.setMessage(Messages.getString("GDE_MSGI0044", new String[]{tmpDeviceJarPath}));
            mBox.open();
        }
    }

    public static void updateFileInDeviceJar(DeviceConfiguration deviceConfig, String devicePropsFileName) {
        block8: {
            String deviceJarPath = null;
            String devicePropsFileNameResource = devicePropsFileName = devicePropsFileName.replace('\\', '/');
            if (devicePropsFileNameResource.contains("/")) {
                devicePropsFileNameResource = devicePropsFileNameResource.substring(devicePropsFileNameResource.lastIndexOf(47), devicePropsFileNameResource.length());
            }
            try {
                boolean isStartedWithinEclipse = DevicePropertiesEditor.class.getProtectionDomain().getCodeSource().getLocation().getPath().endsWith("/");
                if (isStartedWithinEclipse) {
                    log.log(Level.INFO, "started within Eclipse");
                    String fullQualifiedPropertiesTargetFileName = FileUtils.findDeviceProjectDirectoryPath(deviceConfig) + "/src/resource/" + String.valueOf(Settings.getInstance().getLocale()) + "/" + devicePropsFileName;
                    log.log(Level.INFO, "fullQualifiedImageTargetFileName = " + fullQualifiedPropertiesTargetFileName);
                    deviceConfig.storeDeviceProperties(fullQualifiedPropertiesTargetFileName);
                    break block8;
                }
                if (DataExplorer.isInitialized()) {
                    log.log(Level.INFO, "started within DataExplorer");
                } else {
                    log.log(Level.INFO, "started outside DataExplorer");
                    try {
                        Thread.currentThread().setContextClassLoader(GDE.getClassLoader());
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                String addJarEntryName = "resource/" + String.valueOf(Settings.getInstance().getLocale()) + devicePropsFileNameResource;
                String tmpDeviceJarPath = null;
                deviceJarPath = FileUtils.getJarFileNameOfDevice(deviceConfig);
                tmpDeviceJarPath = GDE.JAVA_IO_TMPDIR + deviceJarPath.substring(deviceJarPath.lastIndexOf(47) + 1, deviceJarPath.length());
                log.log(Level.WARNING, "deviceJarPath = " + deviceJarPath + "; tmpDeviceJarPath = " + tmpDeviceJarPath);
                FileUtils.updateJarContent(deviceJarPath, tmpDeviceJarPath, addJarEntryName, devicePropsFileName, DevicePropertiesEditor.dialogShell);
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public static String findDeviceProjectDirectoryPath(DeviceConfiguration deviceConfig) throws MalformedURLException, URISyntaxException, ApplicationConfigurationException, ClassNotFoundException {
        String className = deviceConfig.getClassImplName();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "loading Class " + className);
        }
        Thread.currentThread().setContextClassLoader(GDE.getClassLoader());
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> c = loader.loadClass(className);
        String basPath = c.getProtectionDomain().getCodeSource().getLocation().getPath();
        return basPath.substring(0, basPath.indexOf("bin") - 1);
    }

    public static String getJarFileNameOfDevice(DeviceConfiguration deviceConfig) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoClassDefFoundError {
        IDevice newInst = deviceConfig.defineInstanceOfDevice();
        String deviceJarFileName = newInst.getClass().getProtectionDomain().getCodeSource().getLocation().getPath().replace("%20", " ");
        deviceJarFileName = deviceJarFileName.replace('\\', '/');
        log.log(Level.WARNING, "deviceJarPath = " + deviceJarFileName);
        if (deviceJarFileName.endsWith("/classes/")) {
            deviceJarFileName = deviceJarFileName.substring(0, deviceJarFileName.indexOf("/classes/"));
            deviceJarFileName = deviceJarFileName.substring(deviceJarFileName.lastIndexOf(47) + 1);
        }
        return deviceJarFileName;
    }

    public static void updateJarContent(String deviceJarPath, String tmpDeviceJarPath, String addJarEntryName, String addJarFileName, Shell messageBoxShell) throws IOException, FileNotFoundException {
        JarEntry inEntry;
        if (FileUtils.checkFileExist(tmpDeviceJarPath)) {
            MessageBox mBox = new MessageBox(messageBoxShell, 33220);
            mBox.setText("DataExplorer");
            mBox.setMessage(Messages.getString("GDE_MSGI0043", new String[]{tmpDeviceJarPath}));
            int ret = mBox.open();
            if (256 == ret) {
                return;
            }
            if (128 == ret) {
                FileUtils.renameFile(tmpDeviceJarPath, "bak");
                deviceJarPath = tmpDeviceJarPath.substring(0, tmpDeviceJarPath.lastIndexOf(46) + 1) + "bak";
            }
        }
        JarInputStream in = new JarInputStream(new FileInputStream((String)deviceJarPath));
        JarFile jarFile = new JarFile((String)deviceJarPath);
        JarOutputStream out = new JarOutputStream((OutputStream)new FileOutputStream(new File(tmpDeviceJarPath)), jarFile.getManifest());
        byte[] buf = new byte[1024];
        int len = 0;
        while ((inEntry = in.getNextJarEntry()) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "inEntry = " + inEntry.getName());
            }
            if (!inEntry.getName().equalsIgnoreCase(addJarEntryName) && !inEntry.getName().endsWith("MANIFEST.MF")) {
                out.putNextEntry(new JarEntry(inEntry));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
            }
            in.closeEntry();
        }
        in.close();
        JarEntry jarAddEntry = new JarEntry(addJarEntryName);
        out.putNextEntry(jarAddEntry);
        FileInputStream addIn = new FileInputStream(addJarFileName);
        len = 0;
        while ((len = ((InputStream)addIn).read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        ((InputStream)addIn).close();
        out.closeEntry();
        out.close();
        jarFile.close();
        File tmpFile = new File(tmpDeviceJarPath);
        if (tmpFile.exists()) {
            MessageBox mBox = new MessageBox(messageBoxShell, 32);
            mBox.setText("DataExplorer");
            mBox.setMessage(Messages.getString("GDE_MSGI0044", new String[]{tmpDeviceJarPath}));
            mBox.open();
        }
    }

    public static void runOnExitRenamer() {
        if (onExitRenameJar != null && onExitRenameJar.size() > 0) {
            Thread onExitThread = new Thread(){

                @Override
                public void run() {
                    for (String job : onExitRenameJar) {
                        String deviceJarPath = job.split("2")[0];
                        String tmpDeviceJarPath = job.split("2")[1];
                        try {
                            String javaexec = System.getProperty("java.home").replace('\\', '/') + "/bin/java";
                            String classpath = OperatingSystemHelper.getClasspathAsString().replace("%20", " ");
                            String command = javaexec + " -classpath '" + classpath + "' gde.utils.FileUtils '" + deviceJarPath + "' '" + tmpDeviceJarPath + "'";
                            log.log(Level.INFO, "executing: " + command);
                            new ProcessBuilder(javaexec, "-classpath", classpath, "gde.utils.FileUtils", deviceJarPath, tmpDeviceJarPath).start();
                        }
                        catch (Throwable e) {
                            log.log(Level.WARNING, e.getMessage());
                        }
                    }
                }
            };
            onExitThread.start();
        }
    }

    public static void rename(String sourceFullQualifiedFileName, String targetFullQualifiedFileName) {
        if (!new File(sourceFullQualifiedFileName).delete()) {
            log.log(Level.WARNING, "could not delete jar file " + sourceFullQualifiedFileName);
        } else if (!new File(targetFullQualifiedFileName).renameTo(new File(sourceFullQualifiedFileName))) {
            log.log(Level.WARNING, "could not rename jar file " + targetFullQualifiedFileName + " to " + sourceFullQualifiedFileName);
        }
    }

    private static void setAccessPermission(String fullQualifiedFilePath, String unixPermissions) {
        if (!GDE.IS_WINDOWS) {
            try {
                unixPermissions = unixPermissions.trim();
                try {
                    Integer.valueOf(unixPermissions);
                }
                catch (NumberFormatException e) {
                    log.log(Level.SEVERE, "Internal Error - permission not usable (" + unixPermissions + ")");
                }
                Runtime.getRuntime().exec(new String[]{"chmod", unixPermissions, fullQualifiedFilePath}).waitFor();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static String getJarBasePath() {
        Object basePath;
        URL url = DataExplorer.class.getProtectionDomain().getCodeSource().getLocation();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "base URL = " + url.toExternalForm());
        }
        if (url.getPath().endsWith("/")) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "started inside Eclipse");
            }
            basePath = url.getFile().substring(GDE.IS_WINDOWS ? 1 : 0, url.getPath().lastIndexOf(DataExplorer.class.getSimpleName()));
            basePath = ((String)basePath).replace("%20", " ");
            basePath = (String)basePath + "build/target/" + (GDE.IS_LINUX ? "GNU" : "") + System.getProperty("os.name").split(" ")[0] + "_" + GDE.BIT_MODE + "/DataExplorer" + (GDE.IS_MAC ? ".app/Contents/Resources" : "") + "/";
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "started outside with: java -jar *.jar");
            }
            basePath = url.getFile().substring(0, url.getPath().lastIndexOf("/") + 1);
            basePath = ((String)basePath).replace("%20", " ");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "GDE base path = " + (String)basePath);
        }
        return basePath;
    }

    public static String getDevicePluginJarBasePath() {
        String jarPath = null;
        URL url = DataExplorer.class.getProtectionDomain().getCodeSource().getLocation();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "base URL = " + url.toExternalForm());
        }
        if (url.getPath().endsWith("/")) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "started inside Eclipse");
            }
            String basePath = url.getFile().substring(0, url.getPath().lastIndexOf(DataExplorer.class.getSimpleName()));
            basePath = basePath.replace("%20", " ");
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "basePath = " + basePath);
            }
            try {
                jarPath = basePath + "build/target/" + (GDE.IS_LINUX ? "GNU" : "") + System.getProperty("os.name").split(" ")[0] + "_" + GDE.BIT_MODE + "/DataExplorer" + (GDE.IS_MAC ? ".app/Contents/Resources" : "") + "/devices";
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "started outside with: java -jar *.jar");
            }
            String basePath = url.getFile().substring(0, url.getPath().lastIndexOf("/") + 1);
            basePath = basePath.replace("%20", " ");
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "basePath = " + basePath);
            }
            try {
                jarPath = basePath + "devices";
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "device plug-ins path = " + jarPath);
        }
        return jarPath;
    }

    public static String[] getDeviceJarServicesNames(JarFile jarFile) throws IOException {
        Vector<String> pluginNamesVector = new Vector<String>();
        Manifest m = jarFile.getManifest();
        String services = m.getMainAttributes().getValue("Export-Service");
        if (services != null && services.length() >= 5) {
            String[] serviceNames;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Export-Service = " + services);
            }
            for (String name : serviceNames = services.split(", *")) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "service name = " + name);
                }
                pluginNamesVector.add(name);
            }
        }
        return pluginNamesVector.toArray(new String[0]);
    }

    public static List<ExportService> getDeviceJarServices(JarFile jarFile) throws IOException {
        ArrayList<ExportService> pluginServices = new ArrayList<ExportService>();
        Manifest m = jarFile.getManifest();
        String exportServices = m.getMainAttributes().getValue("Export-Service");
        if (exportServices != null && exportServices.length() > 5) {
            String[] services;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Export-Service = " + exportServices);
            }
            for (String service : services = exportServices.split(", *")) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "service name = " + service);
                }
                pluginServices.add(new ExportService(service, jarFile.getName()));
            }
        }
        return pluginServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkJavaExecutableVersion(String javaFullQualifiedExecutablePath, String expectedVersionString) {
        String javaVersion = "java version";
        int actualVersion = 0;
        BufferedReader brerr = null;
        BufferedReader brout = null;
        try {
            String line;
            if (((String)javaFullQualifiedExecutablePath).indexOf("%WINDIR%") > -1) {
                javaFullQualifiedExecutablePath = System.getenv("WINDIR") + ((String)javaFullQualifiedExecutablePath).substring(((String)javaFullQualifiedExecutablePath).indexOf("%WINDIR%") + "%WINDIR%".length());
            }
            if (((String)javaFullQualifiedExecutablePath).indexOf("javaw") > -1) {
                javaFullQualifiedExecutablePath = ((String)javaFullQualifiedExecutablePath).substring(0, ((String)javaFullQualifiedExecutablePath).indexOf("javaw")) + "java" + ((String)javaFullQualifiedExecutablePath).substring(((String)javaFullQualifiedExecutablePath).indexOf("javaw") + "javaw".length());
            }
            Process process = new ProcessBuilder(new String[]{javaFullQualifiedExecutablePath, "-version"}).start();
            brerr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = brerr.readLine()) != null) {
                if (!line.startsWith("java version")) continue;
                actualVersion = FileUtils.parseJavaVersion(line.substring("java version".length() + 2));
            }
            brout = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = brout.readLine()) != null) {
            }
            process.waitFor();
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            try {
                if (brerr != null) {
                    brerr.close();
                }
                if (brout != null) {
                    brout.close();
                }
            }
            catch (IOException line) {}
        }
        log.log(Level.INFO, FileUtils.parseJavaVersion(expectedVersionString) + " <= " + actualVersion);
        return FileUtils.parseJavaVersion(expectedVersionString) <= actualVersion;
    }

    static int parseJavaVersion(String version) {
        int index;
        if (version == null) {
            return 0;
        }
        int major = 0;
        int minor = 0;
        int micro = 0;
        int start = 0;
        int versionStringLength = version.length();
        for (index = 0; index < versionStringLength && Character.isDigit(version.charAt(index)); ++index) {
        }
        try {
            if (start < versionStringLength) {
                major = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        start = ++index;
        while (index < versionStringLength && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < versionStringLength) {
                minor = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        start = ++index;
        while (index < versionStringLength && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < versionStringLength) {
                micro = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return major * 100 + minor * 10 + micro;
    }

    public static List<File> getFileListing(File rootDirectory, int recursionDepth) throws FileNotFoundException {
        FileUtils.validateDirectory(rootDirectory);
        List<File> result = FileUtils.getFileListingNoSort(rootDirectory, recursionDepth);
        Collections.sort(result);
        return result;
    }

    public static List<File> getFileListing(File rootDirectory, int recursionDepth, String filter) throws FileNotFoundException {
        FileUtils.validateDirectory(rootDirectory);
        List<File> result = FileUtils.getFileListingNoSort(rootDirectory, recursionDepth);
        Iterator<File> itherator = result.iterator();
        while (itherator.hasNext()) {
            File file = itherator.next();
            if (file.getName().contains(filter)) continue;
            itherator.remove();
        }
        Collections.sort(result);
        return result;
    }

    public static List<File> getDirectories(File rootDirectory) throws FileNotFoundException {
        File[] filesAndDirs;
        FileUtils.validateDirectory(rootDirectory);
        ArrayList<File> result = new ArrayList<File>();
        if (rootDirectory.isDirectory() && rootDirectory.canRead() && (filesAndDirs = rootDirectory.listFiles()) != null) {
            for (File file : filesAndDirs) {
                if (!file.isDirectory()) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, file.getAbsolutePath());
                }
                result.add(file);
            }
        }
        return result;
    }

    public static List<File> getDirListing(File rootDirectory) throws FileNotFoundException {
        FileUtils.validateDirectory(rootDirectory);
        List<File> result = FileUtils.getDirListingNoSort(rootDirectory);
        Collections.sort(result);
        return result;
    }

    private static List<File> getFileListingNoSort(File rootDirectory, int recursionDepth) throws FileNotFoundException {
        File[] filesAndDirs;
        int depth = recursionDepth;
        ArrayList<File> result = new ArrayList<File>();
        if (rootDirectory.isDirectory() && rootDirectory.canRead() && (filesAndDirs = rootDirectory.listFiles()) != null) {
            List<File> filesDirs = Arrays.asList(filesAndDirs);
            for (File file : filesDirs) {
                if (file.isFile()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, file.getAbsolutePath());
                    }
                    result.add(file);
                    continue;
                }
                if (!file.isDirectory() || recursionDepth <= 0) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, depth + " " + file.getAbsolutePath());
                }
                List<File> deeperList = FileUtils.getFileListingNoSort(file, --recursionDepth);
                result.addAll(deeperList);
                ++recursionDepth;
            }
        }
        return result;
    }

    private static List<File> getDirListingNoSort(File rootDirectory) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        if (rootDirectory.isDirectory() && rootDirectory.canRead()) {
            File[] filesAndDirs = rootDirectory.listFiles();
            List<File> filesDirs = Arrays.asList(filesAndDirs);
            for (File file : filesDirs) {
                if (!file.isDirectory()) continue;
                result.add(file);
            }
        }
        return result;
    }

    public static void validateDirectory(File directory) throws FileNotFoundException, IllegalArgumentException {
        if (directory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!directory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + String.valueOf(directory));
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + String.valueOf(directory));
        }
        if (!directory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + String.valueOf(directory));
        }
    }

    public static void cleanupPre() {
        if (GDE.IS_WINDOWS) {
            FileUtils.cleanFiles(GDE.JAVA_IO_TMPDIR, new String[]{"GDE", "bootstrap.log.*", "WinHelper*.dll", "Register*.exe"});
        } else if (GDE.IS_LINUX) {
            FileUtils.cleanFiles(GDE.JAVA_IO_TMPDIR, new String[]{"GDE", "bootstrap.log.*", "*register.sh"});
        } else if (GDE.IS_MAC) {
            FileUtils.cleanFiles(GDE.JAVA_IO_TMPDIR, new String[]{"GDE", "bootstrap.log.*"});
        }
    }

    public static void cleanupPost() {
        String jarBasePath = FileUtils.getJarBasePath();
        String jarFilePath = jarBasePath + "DataExplorer.jar";
        try {
            if (GDE.IS_WINDOWS) {
                String[] commandArray = new String[]{"\"" + System.getProperty("sun.boot.library.path") + GDE.FILE_SEPARATOR + "java\"", "-classpath", jarFilePath, "-DCLEAN_SETTINGS_WHILE_SHUTDOWN=" + Boolean.parseBoolean(System.getProperty("CLEAN_SETTINGS_WHILE_SHUTDOWN")), "gde.utils.FileUtils"};
                Runtime.getRuntime().exec(commandArray);
            } else {
                Runtime.getRuntime().exec(new String[]{"java", "-classpath", jarFilePath, "-DCLEAN_SETTINGS_WHILE_SHUTDOWN=" + Boolean.parseBoolean(System.getProperty("CLEAN_SETTINGS_WHILE_SHUTDOWN")), "gde.utils.FileUtils", "&"});
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "failed executing cleanup settings ");
        }
    }

    public static void main(String[] args) {
        System.out.println("isUpdateAvailable = " + String.valueOf(FileUtils.isUpdateAvailable()));
    }

    public static String getDeviceImportDirectory(IDevice device) {
        String devicePath = DataExplorer.getInstance().getActiveDevice() != null ? "/" + DataExplorer.getInstance().getActiveDevice().getName() : "";
        Object searchDirectory = Settings.getInstance().getDataFilePath() + devicePath + "/";
        String objectKey = DataExplorer.getInstance().getObjectKey();
        if (Settings.getInstance().isDeviceImportDirectoryObjectRelated() && DataExplorer.getInstance().isObjectoriented() && objectKey != null && !objectKey.equals("")) {
            String objectkeyPath = Settings.getInstance().getDataFilePath() + "/" + objectKey;
            FileUtils.checkDirectoryAndCreate(objectkeyPath);
            searchDirectory = objectkeyPath;
        } else if (FileUtils.checkDirectoryExist(device.getDeviceConfiguration().getDataBlockPreferredDataLocation())) {
            searchDirectory = device.getDeviceConfiguration().getDataBlockPreferredDataLocation();
        }
        searchDirectory = ((String)searchDirectory).replace('\\', '/');
        return searchDirectory;
    }

    public static FileDialog getImportDirectoryFileDialog(IDevice device, String dialogTitleMessage) {
        String devicePath = DataExplorer.getInstance().getActiveDevice() != null ? "/" + DataExplorer.getInstance().getActiveDevice().getName() : "";
        Object searchDirectory = Settings.getInstance().getDataFilePath() + devicePath + "/";
        String objectKey = DataExplorer.getInstance().getObjectKey();
        if (Settings.getInstance().isDeviceImportDirectoryObjectRelated() && DataExplorer.getInstance().isObjectoriented() && objectKey != null && !objectKey.equals("")) {
            String objectkeyPath = Settings.getInstance().getDataFilePath() + "/" + objectKey;
            FileUtils.checkDirectoryAndCreate(objectkeyPath);
            searchDirectory = objectkeyPath;
        } else if (FileUtils.checkDirectoryExist(device.getDeviceConfiguration().getDataBlockPreferredDataLocation())) {
            searchDirectory = device.getDeviceConfiguration().getDataBlockPreferredDataLocation();
        }
        searchDirectory = ((String)searchDirectory).replace('\\', '/');
        FileDialog fd = DataExplorer.getInstance().openFileOpenDialog(dialogTitleMessage, new String[]{device.getDeviceConfiguration().getDataBlockPreferredFileExtention(), "*.*"}, (String)searchDirectory, null, 2);
        if (!(Settings.getInstance().isDeviceImportDirectoryObjectRelated() && DataExplorer.getInstance().isObjectoriented() || ((String)searchDirectory).equals(fd.getFilterPath().replace('\\', '/')))) {
            device.getDeviceConfiguration().setDataBlockPreferredDataLocation(fd.getFilterPath());
        }
        return fd;
    }

    public static FileDialog getImportDirectoryFileDialog(IDevice device, String dialogTitleMessage, int swtStyle) {
        String devicePath = DataExplorer.getInstance().getActiveDevice() != null ? "/" + DataExplorer.getInstance().getActiveDevice().getName() : "";
        Object searchDirectory = Settings.getInstance().getDataFilePath() + devicePath + "/";
        String objectKey = DataExplorer.getInstance().getObjectKey();
        if (Settings.getInstance().isDeviceImportDirectoryObjectRelated() && DataExplorer.getInstance().isObjectoriented() && objectKey != null && !objectKey.equals("")) {
            String objectkeyPath = Settings.getInstance().getDataFilePath() + "/" + objectKey;
            FileUtils.checkDirectoryAndCreate(objectkeyPath);
            searchDirectory = objectkeyPath;
        } else if (FileUtils.checkDirectoryExist(device.getDeviceConfiguration().getDataBlockPreferredDataLocation())) {
            searchDirectory = device.getDeviceConfiguration().getDataBlockPreferredDataLocation();
        }
        searchDirectory = ((String)searchDirectory).replace('\\', '/');
        FileDialog fd = DataExplorer.getInstance().openFileOpenDialog(dialogTitleMessage, new String[]{device.getDeviceConfiguration().getDataBlockPreferredFileExtention(), "*.*"}, (String)searchDirectory, null, swtStyle);
        if (!(Settings.getInstance().isDeviceImportDirectoryObjectRelated() && DataExplorer.getInstance().isObjectoriented() || ((String)searchDirectory).equals(fd.getFilterPath().replace('\\', '/')))) {
            device.getDeviceConfiguration().setDataBlockPreferredDataLocation(fd.getFilterPath());
        }
        return fd;
    }

    public static FileDialog getImportDirectoryFileDialog(IDevice device, String dialogTitleMessage, String[] fileExtensions) {
        String devicePath = DataExplorer.getInstance().getActiveDevice() != null ? "/" + DataExplorer.getInstance().getActiveDevice().getName() : "";
        Object searchDirectory = Settings.getInstance().getDataFilePath() + devicePath + "/";
        String objectKey = DataExplorer.getInstance().getObjectKey();
        if (Settings.getInstance().isDeviceImportDirectoryObjectRelated() && DataExplorer.getInstance().isObjectoriented() && objectKey != null && !objectKey.equals("")) {
            String objectkeyPath = Settings.getInstance().getDataFilePath() + "/" + objectKey;
            FileUtils.checkDirectoryAndCreate(objectkeyPath);
            searchDirectory = objectkeyPath;
        } else if (FileUtils.checkDirectoryExist(device.getDeviceConfiguration().getDataBlockPreferredDataLocation())) {
            searchDirectory = device.getDeviceConfiguration().getDataBlockPreferredDataLocation();
        }
        searchDirectory = ((String)searchDirectory).replace('\\', '/');
        FileDialog fd = DataExplorer.getInstance().openFileOpenDialog(dialogTitleMessage, fileExtensions, (String)searchDirectory, null, 2);
        if (!(Settings.getInstance().isDeviceImportDirectoryObjectRelated() && DataExplorer.getInstance().isObjectoriented() || ((String)searchDirectory).equals(fd.getFilterPath().replace('\\', '/')))) {
            device.getDeviceConfiguration().setDataBlockPreferredDataLocation(fd.getFilterPath());
        }
        return fd;
    }

    public static FileDialog getImportDirectoryFileDialog(IDevice device, String dialogTitleMessage, String baseDirectory) {
        String devicePath = DataExplorer.getInstance().getActiveDevice() != null ? "/" + DataExplorer.getInstance().getActiveDevice().getName() : "";
        Object searchDirectory = Settings.getInstance().getDataFilePath() + devicePath + "/";
        String objectKey = DataExplorer.getInstance().getObjectKey();
        if (Settings.getInstance().isDeviceImportDirectoryObjectRelated() && DataExplorer.getInstance().isObjectoriented() && objectKey != null && !objectKey.equals("")) {
            String objectkeyPath = Settings.getInstance().getDataFilePath() + "/" + objectKey;
            FileUtils.checkDirectoryAndCreate(objectkeyPath);
            searchDirectory = objectkeyPath;
        } else if (!DataExplorer.getInstance().isObjectoriented()) {
            searchDirectory = device.getDeviceConfiguration().getDataBlockPreferredDataLocation();
            if (((String)searchDirectory).contains(baseDirectory)) {
                searchDirectory = ((String)searchDirectory).substring(0, ((String)searchDirectory).lastIndexOf(baseDirectory)) + baseDirectory + "/" + objectKey;
            }
        } else if (FileUtils.checkDirectoryExist(device.getDeviceConfiguration().getDataBlockPreferredDataLocation())) {
            searchDirectory = device.getDeviceConfiguration().getDataBlockPreferredDataLocation();
        }
        searchDirectory = ((String)searchDirectory).replace('\\', '/');
        Vector<String> extensionFilter = new Vector<String>();
        extensionFilter.addAll(Arrays.asList(device.getDeviceConfiguration().getDataBlockPreferredFileExtention().split(",")));
        extensionFilter.add(GDE.IS_WINDOWS ? "*.*" : "*");
        FileDialog fd = DataExplorer.getInstance().openFileOpenDialog(dialogTitleMessage, extensionFilter.toArray(new String[1]), (String)searchDirectory, null, 2);
        if (!(Settings.getInstance().isDeviceImportDirectoryObjectRelated() && DataExplorer.getInstance().isObjectoriented() || ((String)searchDirectory).equals(fd.getFilterPath().replace('\\', '/')))) {
            device.getDeviceConfiguration().setDataBlockPreferredDataLocation(fd.getFilterPath());
        }
        return fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] isUpdateAvailable() {
        BufferedReader in = null;
        String[] versionCheck = new String[]{"false", "Version 3.9.1".substring(8)};
        try {
            String inputLine;
            URL gdeDownload = new URL("https://www.nongnu.org/dataexplorer/download.html");
            in = new BufferedReader(new InputStreamReader(gdeDownload.openStream()));
            while ((inputLine = in.readLine()) != null) {
                if (!inputLine.contains("The latest stable version of DataExplorer is")) continue;
                String versionString = inputLine.substring(inputLine.lastIndexOf("<B>") + 3, inputLine.lastIndexOf("</B>"));
                int availableVersion = Integer.parseInt(versionString.replace(".", ""));
                log.log(Level.OFF, "actualVersion = " + GDE.VERSION_NUMBER + " - availableVersion = " + availableVersion);
                versionCheck = new String[]{Boolean.valueOf(GDE.VERSION_NUMBER < availableVersion).toString(), versionString};
            }
            in.close();
            in = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return versionCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(URL url, String targetFileName) {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            int count;
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("content-type", "binary/data");
            int size = conn.getContentLength();
            in = conn.getInputStream();
            out = new FileOutputStream(targetFileName);
            byte[] buffer = new byte[size / 20];
            int download = 0;
            int lastDownloadProgress = -1;
            GDE.getUiNotification().setStatusMessage(Messages.getString("GDE_MSGI0054"));
            int progressStatus = 0;
            while ((count = in.read(buffer)) > 0) {
                out.write(buffer, 0, count);
                progressStatus = (download += count) * 100 / size;
                if (lastDownloadProgress >= progressStatus || progressStatus % 5 != 0) continue;
                lastDownloadProgress = progressStatus;
                GDE.getUiNotification().setProgress(progressStatus);
            }
            GDE.getUiNotification().setStatusMessage("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static long size(Path path) {
        final AtomicLong size = new AtomicLong(0L);
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    size.addAndGet(attrs.size());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    log.log(Level.SEVERE, "skipped: " + String.valueOf(file) + " (" + String.valueOf(exc) + ")");
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    if (exc != null) {
                        log.log(Level.SEVERE, "had trouble traversing: " + String.valueOf(dir) + " (" + String.valueOf(exc) + ")");
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new AssertionError((Object)"walkFileTree will not throw IOException if the FileVisitor does not");
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        return size.get();
    }

    public static InputStream wrapIfZipStream(InputStream inputStream) throws IOException {
        InputStream markableStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        markableStream.mark(999);
        ZipInputStream zipInputStream = new ZipInputStream(markableStream);
        if (zipInputStream.getNextEntry() != null) {
            return zipInputStream;
        }
        markableStream.reset();
        return markableStream;
    }

    public static boolean isZipStream(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException();
        }
        inputStream.mark(999);
        byte[] buffer = new byte[4];
        inputStream.read(buffer);
        boolean isZipInputStream = buffer[0] == 80 && buffer[1] == 75 && buffer[2] == 3 && buffer[3] == 4;
        inputStream.reset();
        return isZipInputStream;
    }
}

