/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Slider
extends Control {
    long rangeHandle;
    int scrollType;
    boolean dragSent;

    public Slider(Composite composite, int n) {
        super(composite, Slider.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Slider.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    @Override
    void createHandle(int n) {
        long l;
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if ((l = GTK.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 10.0)) == 0L) {
            this.error(2);
        }
        this.handle = (this.style & 0x100) != 0 ? GTK.gtk_scrollbar_new(0, l) : GTK.gtk_scrollbar_new(1, l);
        if (this.handle == 0L) {
            this.error(2);
        }
        long l2 = this.rangeHandle = GTK.GTK4 ? GTK4.gtk_widget_get_first_child(this.handle) : this.handle;
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
        } else {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
        }
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        long l3 = super.gtk_button_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        this.scrollType = 0;
        this.dragSent = false;
        return l3;
    }

    @Override
    boolean gtk_change_value(long l, int n, double d, long l2) {
        this.scrollType = n;
        return false;
    }

    @Override
    long gtk_value_changed(long l) {
        Event event = new Event();
        this.dragSent = this.scrollType == 1;
        switch (this.scrollType) {
            case 0: {
                event.detail = 0;
                break;
            }
            case 1: {
                event.detail = 1;
                break;
            }
            case 14: {
                event.detail = 0x1000007;
                break;
            }
            case 15: {
                event.detail = 0x1000008;
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                event.detail = 0x1000006;
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                event.detail = 0x1000005;
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                event.detail = 0x1000002;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                event.detail = 0x1000001;
            }
        }
        if (!this.dragSent) {
            this.scrollType = 0;
        }
        this.sendSelectionEvent(13, event, false);
        return 0L;
    }

    @Override
    long gtk_event_after(long l, long l2) {
        int n = GDK.gdk_event_get_event_type(l2);
        n = Control.fixGdkEventTypeValues(n);
        switch (n) {
            case 7: {
                int[] nArray = new int[1];
                if (GTK.GTK4) {
                    nArray[0] = GDK.gdk_button_event_get_button(l2);
                } else {
                    GDK.gdk_event_get_button(l2, nArray);
                }
                if (nArray[0] == 1 && this.scrollType == 1) {
                    if (!this.dragSent) {
                        Event event = new Event();
                        event.detail = 1;
                        this.sendSelectionEvent(13, event, false);
                    }
                    this.sendSelectionEvent(13);
                }
                this.scrollType = 0;
                this.dragSent = false;
                break;
            }
        }
        return super.gtk_event_after(l, l2);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.rangeHandle, OS.change_value, this.display.getClosure(7), false);
        OS.g_signal_connect_closure(this.rangeHandle, OS.value_changed, this.display.getClosure(57), false);
    }

    @Override
    void register() {
        super.register();
        if (GTK.GTK4) {
            this.display.addWidget(this.rangeHandle, this);
        } else {
            long l = GTK.gtk_range_get_adjustment(this.handle);
            this.display.addWidget(l, this);
        }
    }

    @Override
    void deregister() {
        super.deregister();
        if (GTK.GTK4) {
            this.display.removeWidget(this.rangeHandle);
        } else {
            long l = GTK.gtk_range_get_adjustment(this.handle);
            this.display.removeWidget(l);
        }
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        this.checkWidget();
        GTK.gtk_widget_realize(this.handle);
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if ((this.style & 0x100) != 0) {
            if (n == -1) {
                point.x = 2 * point.x;
            }
        } else if (n2 == -1) {
            point.y = 2 * point.y;
        }
        return point;
    }

    public int getIncrement() {
        this.checkWidget();
        long l = GTK.gtk_range_get_adjustment(this.rangeHandle);
        return (int)GTK.gtk_adjustment_get_step_increment(l);
    }

    public int getMaximum() {
        this.checkWidget();
        long l = GTK.gtk_range_get_adjustment(this.rangeHandle);
        return (int)GTK.gtk_adjustment_get_upper(l);
    }

    public int getMinimum() {
        this.checkWidget();
        long l = GTK.gtk_range_get_adjustment(this.rangeHandle);
        return (int)GTK.gtk_adjustment_get_lower(l);
    }

    public int getPageIncrement() {
        this.checkWidget();
        long l = GTK.gtk_range_get_adjustment(this.rangeHandle);
        return (int)GTK.gtk_adjustment_get_page_increment(l);
    }

    public int getSelection() {
        this.checkWidget();
        return (int)GTK.gtk_range_get_value(this.rangeHandle);
    }

    public int getThumb() {
        this.checkWidget();
        long l = GTK.gtk_range_get_adjustment(this.rangeHandle);
        return (int)GTK.gtk_adjustment_get_page_size(l);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_range_set_increments(this.rangeHandle, n, this.getPageIncrement());
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        long l = GTK.gtk_range_get_adjustment(this.rangeHandle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        this.gtk_adjustment_get(l, gtkAdjustment);
        int n2 = (int)gtkAdjustment.lower;
        if (n <= n2) {
            return;
        }
        gtkAdjustment.upper = n;
        gtkAdjustment.page_size = Math.min((int)gtkAdjustment.page_size, n - n2);
        gtkAdjustment.value = Math.min((int)gtkAdjustment.value, (int)((double)n - gtkAdjustment.page_size));
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_adjustment_configure(l, gtkAdjustment.value, gtkAdjustment.lower, gtkAdjustment.upper, gtkAdjustment.step_increment, gtkAdjustment.page_increment, gtkAdjustment.page_size);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        long l = GTK.gtk_range_get_adjustment(this.rangeHandle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        this.gtk_adjustment_get(l, gtkAdjustment);
        int n2 = (int)gtkAdjustment.upper;
        if (n >= n2) {
            return;
        }
        gtkAdjustment.lower = n;
        gtkAdjustment.page_size = Math.min((int)gtkAdjustment.page_size, n2 - n);
        gtkAdjustment.value = Math.max((int)gtkAdjustment.value, n);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_adjustment_configure(l, gtkAdjustment.value, gtkAdjustment.lower, gtkAdjustment.upper, gtkAdjustment.step_increment, gtkAdjustment.page_increment, gtkAdjustment.page_size);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if (!((this.style & 0x4000000) == 0 && bl || (this.style & 0x100) == 0)) {
            GTK.gtk_range_set_inverted(this.rangeHandle, (this.style & 0x4000000) != 0);
        }
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_range_set_increments(this.rangeHandle, this.getIncrement(), n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setSelection(int n) {
        this.checkWidget();
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_range_set_value(this.rangeHandle, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setThumb(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        long l = GTK.gtk_range_get_adjustment(this.rangeHandle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        this.gtk_adjustment_get(l, gtkAdjustment);
        n = Math.min(n, (int)(gtkAdjustment.upper - gtkAdjustment.lower));
        gtkAdjustment.page_size = n;
        gtkAdjustment.value = Math.min((int)gtkAdjustment.value, (int)(gtkAdjustment.upper - (double)n));
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_adjustment_configure(l, gtkAdjustment.value, gtkAdjustment.lower, gtkAdjustment.upper, gtkAdjustment.step_increment, gtkAdjustment.page_increment, gtkAdjustment.page_size);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 < 0 || n3 < 0 || n4 < 1 || n5 < 1 || n6 < 1) {
            return;
        }
        n4 = Math.min(n4, n3 - n2);
        long l = GTK.gtk_range_get_adjustment(this.rangeHandle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        gtkAdjustment.value = Math.min(Math.max(n, n2), n3 - n4);
        gtkAdjustment.lower = n2;
        gtkAdjustment.upper = n3;
        gtkAdjustment.page_size = n4;
        gtkAdjustment.step_increment = n5;
        gtkAdjustment.page_increment = n6;
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_adjustment_configure(l, gtkAdjustment.value, gtkAdjustment.lower, gtkAdjustment.upper, gtkAdjustment.step_increment, gtkAdjustment.page_increment, gtkAdjustment.page_size);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }
}

