/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    ExpandItem[] items;
    ExpandItem lastFocus;
    int itemCount;
    int spacing;

    public ExpandBar(Composite composite, int n) {
        super(composite, n);
    }

    public void addExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(expandListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if (point.x == 0 && n == -1) {
            point.x = 64;
        }
        if (point.y == 0 && n2 == -1) {
            point.y = 64;
        }
        int n3 = this.gtk_container_get_border_width_or_margin(this.handle);
        point.x += 2 * n3;
        point.y += 2 * n3;
        return point;
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if (!GTK.GTK4) {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
        }
        this.handle = this.gtk_box_new(1, false, 0);
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((this.style & 0x200) != 0) {
            this.scrolledHandle = GTK.GTK4 ? GTK4.gtk_scrolled_window_new() : GTK3.gtk_scrolled_window_new(0L, 0L);
            if (this.scrolledHandle == 0L) {
                this.error(2);
            }
            GTK.gtk_scrolled_window_set_policy(this.scrolledHandle, 2, 1);
            if (GTK.GTK4) {
                OS.swt_fixed_add(this.fixedHandle, this.scrolledHandle);
                GTK4.gtk_scrolled_window_set_child(this.scrolledHandle, this.handle);
            } else {
                GTK3.gtk_container_add(this.fixedHandle, this.scrolledHandle);
                GTK3.gtk_container_add(this.scrolledHandle, this.handle);
            }
            if (!GTK.GTK4) {
                long l = GTK3.gtk_bin_get_child(this.scrolledHandle);
                GTK3.gtk_viewport_set_shadow_type(l, 0);
            }
        } else if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
        } else {
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
        }
        this.gtk_container_set_border_width(this.handle, 0);
        this.setFontDescription(this.defaultFont().handle);
    }

    void createItem(ExpandItem expandItem, int n, int n2) {
        if (0 > n2 || n2 > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ExpandItem[] expandItemArray = new ExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, expandItemArray, 0, this.items.length);
            this.items = expandItemArray;
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, this.itemCount - n2);
        this.items[n2] = expandItem;
        ++this.itemCount;
        expandItem.width = Math.max(0, this.getClientAreaInPixels().width - this.spacing * 2);
        this.layoutItems();
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.items = new ExpandItem[4];
    }

    void destroyItem(ExpandItem expandItem) {
        int n;
        for (n = 0; n < this.itemCount && this.items[n] != expandItem; ++n) {
        }
        if (n == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        this.layoutItems();
    }

    @Override
    long eventHandle() {
        return this.fixedHandle;
    }

    @Override
    boolean forceFocus(long l) {
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem expandItem = this.items[i];
            if (!expandItem.setFocus()) continue;
            return true;
        }
        return super.forceFocus(l);
    }

    @Override
    boolean hasFocus() {
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem expandItem = this.items[i];
            if (!expandItem.hasFocus()) continue;
            return true;
        }
        return super.hasFocus();
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (!GTK.GTK4 && this.scrolledHandle != 0L) {
            OS.g_signal_connect_closure(this.scrolledHandle, OS.size_allocate, this.display.getClosure(47), true);
        }
    }

    public ExpandItem getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] expandItemArray = new ExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, expandItemArray, 0, this.itemCount);
        return expandItemArray;
    }

    public int getSpacing() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.spacing);
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        int n;
        int n2;
        if (!this.hasFocus()) {
            return 0L;
        }
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        for (n2 = 0; n2 < this.itemCount && !this.items[n2].hasFocus(); ++n2) {
        }
        int[] nArray = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_key_event_get_keyval(l2);
        } else {
            GDK.gdk_event_get_keyval(l2, nArray);
        }
        boolean bl = false;
        switch (nArray[0]) {
            case 65361: 
            case 65362: {
                bl = false;
                break;
            }
            case 65363: 
            case 65364: {
                bl = true;
                break;
            }
            default: {
                return l3;
            }
        }
        int n3 = n2;
        int n4 = n = bl ? 1 : -1;
        while ((n2 = (n2 + n + this.itemCount) % this.itemCount) != n3) {
            ExpandItem expandItem = this.items[n2];
            if (!expandItem.setFocus()) continue;
            return l3;
        }
        return l3;
    }

    public int indexOf(ExpandItem expandItem) {
        this.checkWidget();
        if (expandItem == null) {
            this.error(4);
        }
        for (int i = 0; i < this.itemCount; ++i) {
            if (this.items[i] != expandItem) continue;
            return i;
        }
        return -1;
    }

    void layoutItems() {
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem expandItem = this.items[i];
            if (expandItem == null) continue;
            expandItem.resizeControl();
        }
    }

    @Override
    long gtk_size_allocate(long l, long l2) {
        long l3 = super.gtk_size_allocate(l, l2);
        this.layoutItems();
        return l3;
    }

    @Override
    long parentingHandle() {
        return this.fixedHandle;
    }

    @Override
    void releaseChildren(boolean bl) {
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem expandItem = this.items[i];
            if (expandItem == null || expandItem.isDisposed()) continue;
            expandItem.release(false);
        }
        super.releaseChildren(bl);
    }

    public void removeExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, expandListener);
        this.eventTable.unhook(18, expandListener);
    }

    @Override
    void reskinChildren(int n) {
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                ExpandItem expandItem = this.items[i];
                if (expandItem == null) continue;
                expandItem.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    @Override
    void setWidgetBackground() {
        GdkRGBA gdkRGBA = (this.state & 0x2000) != 0 ? this.getBackgroundGdkRGBA() : null;
        super.setBackgroundGdkRGBA(this.handle, gdkRGBA);
    }

    @Override
    void setFontDescription(long l) {
        super.setFontDescription(l);
        for (int i = 0; i < this.itemCount; ++i) {
            this.items[i].setFontDescription(l);
        }
        this.layoutItems();
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA gdkRGBA) {
        super.setForegroundGdkRGBA(gdkRGBA);
        for (int i = 0; i < this.itemCount; ++i) {
            this.items[i].setForegroundRGBA(gdkRGBA);
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                this.items[i].setOrientation(bl);
            }
        }
    }

    public void setSpacing(int n) {
        this.checkWidget();
        this.setSpacingInPixels(DPIUtil.autoScaleUp(n));
    }

    void setSpacingInPixels(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (n == this.spacing) {
            return;
        }
        this.spacing = n;
        GTK.gtk_box_set_spacing(this.handle, n);
        this.gtk_container_set_border_width(this.handle, n);
    }

    @Override
    void updateScrollBarValue(ScrollBar scrollBar) {
        this.layoutItems();
    }
}

