/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.File;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SyncDialogUtil;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";
    static final String SEPARATOR = File.separator;

    public DirectoryDialog(Shell shell) {
        this(shell, 65536);
    }

    public DirectoryDialog(Shell shell, int n) {
        super(shell, DirectoryDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        return this.openNativeChooserDialog();
    }

    String openNativeChooserDialog() {
        int n;
        long l;
        CharSequence charSequence;
        byte[] byArray = Converter.wcsToMbcs(this.title, true);
        long l2 = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        long l3 = 0L;
        l3 = GTK.gtk_file_chooser_native_new(byArray, l2, 2, null, null);
        if (l3 == 0L) {
            this.error(2);
        }
        if (this.filterPath != null && this.filterPath.length() > 0) {
            charSequence = new StringBuilder();
            if (!this.filterPath.startsWith(SEPARATOR)) {
                charSequence.append(SEPARATOR);
            }
            charSequence.append(this.filterPath);
            byte[] byArray2 = Converter.wcsToMbcs(charSequence.toString(), true);
            l = OS.realpath(byArray2, null);
            if (l != 0L) {
                if (GTK.GTK4) {
                    long l4 = OS.g_file_new_for_path(byArray2);
                    GTK4.gtk_file_chooser_set_current_folder(l3, l4, 0L);
                    OS.g_object_unref(l4);
                } else {
                    GTK3.gtk_file_chooser_set_current_folder(l3, l);
                }
                OS.g_free(l);
            }
        }
        this.GTK3setNativeDialogMessage(l3, this.message);
        charSequence = null;
        display.addIdleProc();
        int n2 = 0;
        l = 0L;
        if ((this.style & 0x4000000) != 0) {
            n2 = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l = OS.g_signal_add_emission_hook(n2, 0, display.emissionProc, l3, 0L);
        }
        if (GTK.GTK4) {
            n = SyncDialogUtil.run(display, l3, true);
        } else {
            display.externalEventLoop = true;
            display.sendPreExternalEventDispatchEvent();
            n = GTK3.gtk_native_dialog_run(l3);
            display.externalEventLoop = false;
            display.sendPostExternalEventDispatchEvent();
        }
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n2, l);
        }
        if (n == -3) {
            long l5;
            long l6;
            if (GTK.GTK4) {
                l6 = GTK4.gtk_file_chooser_get_file(l3);
                l5 = OS.g_file_get_path(l6);
            } else {
                l5 = GTK3.gtk_file_chooser_get_filename(l3);
            }
            if (l5 != 0L) {
                l6 = OS.g_filename_to_utf8(l5, -1L, null, null, null);
                if (l6 == 0L) {
                    l6 = OS.g_filename_display_name(l5);
                }
                if (l5 != l6) {
                    OS.g_free(l5);
                }
                if (l6 != 0L) {
                    long[] lArray = new long[1];
                    long l7 = OS.g_utf8_to_utf16(l6, -1L, null, lArray, null);
                    OS.g_free(l6);
                    if (l7 != 0L) {
                        int n3 = (int)lArray[0];
                        char[] cArray = new char[n3];
                        C.memmove(cArray, l7, (long)(n3 * 2));
                        OS.g_free(l7);
                        charSequence = new String(cArray);
                        this.filterPath = charSequence;
                    }
                }
            }
        }
        display.removeIdleProc();
        return charSequence;
    }

    void GTK3setNativeDialogMessage(long l, String string) {
        if (GTK.GTK4) {
            return;
        }
        if (string.length() > 0) {
            long l2;
            byte[] byArray = Converter.wcsToMbcs(string, true);
            long l3 = GTK.gtk_box_new(0, 0);
            if (l3 == 0L) {
                this.error(2);
            }
            if ((l2 = GTK.gtk_label_new(byArray)) == 0L) {
                this.error(2);
            }
            GTK3.gtk_container_add(l3, l2);
            GTK.gtk_widget_show(l2);
            GTK3.gtk_label_set_line_wrap(l2, true);
            GTK.gtk_box_set_homogeneous(l3, false);
            GTK.gtk_label_set_justify(l2, 2);
            GTK3.gtk_file_chooser_set_extra_widget(l, l3);
        }
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

