/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public final class GridData {
    public int verticalAlignment = 2;
    public int horizontalAlignment = 1;
    public int widthHint = -1;
    public int heightHint = -1;
    public int horizontalIndent = 0;
    public int verticalIndent = 0;
    public int horizontalSpan = 1;
    public int verticalSpan = 1;
    public boolean grabExcessHorizontalSpace = false;
    public boolean grabExcessVerticalSpace = false;
    public int minimumWidth = 0;
    public int minimumHeight = 0;
    public boolean exclude = false;
    public static final int BEGINNING = 1;
    public static final int CENTER = 2;
    public static final int END = 3;
    public static final int FILL = 4;
    public static final int VERTICAL_ALIGN_BEGINNING = 2;
    public static final int VERTICAL_ALIGN_CENTER = 4;
    public static final int VERTICAL_ALIGN_END = 8;
    public static final int VERTICAL_ALIGN_FILL = 16;
    public static final int HORIZONTAL_ALIGN_BEGINNING = 32;
    public static final int HORIZONTAL_ALIGN_CENTER = 64;
    public static final int HORIZONTAL_ALIGN_END = 128;
    public static final int HORIZONTAL_ALIGN_FILL = 256;
    public static final int GRAB_HORIZONTAL = 512;
    public static final int GRAB_VERTICAL = 1024;
    public static final int FILL_VERTICAL = 1040;
    public static final int FILL_HORIZONTAL = 768;
    public static final int FILL_BOTH = 1808;
    int cacheWidth = -1;
    int cacheHeight = -1;
    int defaultWhint;
    int defaultHhint;
    int defaultWidth = -1;
    int defaultHeight = -1;
    int currentWhint;
    int currentHhint;
    int currentWidth = -1;
    int currentHeight = -1;

    public GridData() {
    }

    public GridData(int n) {
        if ((n & 2) != 0) {
            this.verticalAlignment = 1;
        }
        if ((n & 4) != 0) {
            this.verticalAlignment = 2;
        }
        if ((n & 0x10) != 0) {
            this.verticalAlignment = 4;
        }
        if ((n & 8) != 0) {
            this.verticalAlignment = 3;
        }
        if ((n & 0x20) != 0) {
            this.horizontalAlignment = 1;
        }
        if ((n & 0x40) != 0) {
            this.horizontalAlignment = 2;
        }
        if ((n & 0x100) != 0) {
            this.horizontalAlignment = 4;
        }
        if ((n & 0x80) != 0) {
            this.horizontalAlignment = 3;
        }
        this.grabExcessHorizontalSpace = (n & 0x200) != 0;
        this.grabExcessVerticalSpace = (n & 0x400) != 0;
    }

    public GridData(int n, int n2, boolean bl, boolean bl2) {
        this(n, n2, bl, bl2, 1, 1);
    }

    public GridData(int n, int n2, boolean bl, boolean bl2, int n3, int n4) {
        this.horizontalAlignment = n;
        this.verticalAlignment = n2;
        this.grabExcessHorizontalSpace = bl;
        this.grabExcessVerticalSpace = bl2;
        this.horizontalSpan = n3;
        this.verticalSpan = n4;
    }

    public GridData(int n, int n2) {
        this.widthHint = n;
        this.heightHint = n2;
    }

    void computeSize(Control control, int n, int n2, boolean bl) {
        if (this.cacheWidth != -1 && this.cacheHeight != -1) {
            return;
        }
        if (n == this.widthHint && n2 == this.heightHint) {
            if (this.defaultWidth == -1 || this.defaultHeight == -1 || n != this.defaultWhint || n2 != this.defaultHhint) {
                Point point = control.computeSize(n, n2, bl);
                this.defaultWhint = n;
                this.defaultHhint = n2;
                this.defaultWidth = point.x;
                this.defaultHeight = point.y;
            }
            this.cacheWidth = this.defaultWidth;
            this.cacheHeight = this.defaultHeight;
            return;
        }
        if (this.currentWidth == -1 || this.currentHeight == -1 || n != this.currentWhint || n2 != this.currentHhint) {
            Point point = control.computeSize(n, n2, bl);
            this.currentWhint = n;
            this.currentHhint = n2;
            this.currentWidth = point.x;
            this.currentHeight = point.y;
        }
        this.cacheWidth = this.currentWidth;
        this.cacheHeight = this.currentHeight;
    }

    void flushCache() {
        this.cacheHeight = -1;
        this.cacheWidth = -1;
        this.defaultHeight = -1;
        this.defaultWidth = -1;
        this.currentHeight = -1;
        this.currentWidth = -1;
    }

    String getName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    public String toString() {
        Object object = "";
        switch (this.horizontalAlignment) {
            case 4: {
                object = "SWT.FILL";
                break;
            }
            case 1: {
                object = "SWT.BEGINNING";
                break;
            }
            case 16384: {
                object = "SWT.LEFT";
                break;
            }
            case 0x1000008: {
                object = "SWT.END";
                break;
            }
            case 3: {
                object = "GridData.END";
                break;
            }
            case 131072: {
                object = "SWT.RIGHT";
                break;
            }
            case 0x1000000: {
                object = "SWT.CENTER";
                break;
            }
            case 2: {
                object = "GridData.CENTER";
                break;
            }
            default: {
                object = "Undefined " + this.horizontalAlignment;
            }
        }
        Object object2 = "";
        switch (this.verticalAlignment) {
            case 4: {
                object2 = "SWT.FILL";
                break;
            }
            case 1: {
                object2 = "SWT.BEGINNING";
                break;
            }
            case 128: {
                object2 = "SWT.TOP";
                break;
            }
            case 0x1000008: {
                object2 = "SWT.END";
                break;
            }
            case 3: {
                object2 = "GridData.END";
                break;
            }
            case 1024: {
                object2 = "SWT.BOTTOM";
                break;
            }
            case 0x1000000: {
                object2 = "SWT.CENTER";
                break;
            }
            case 2: {
                object2 = "GridData.CENTER";
                break;
            }
            default: {
                object2 = "Undefined " + this.verticalAlignment;
            }
        }
        Object object3 = this.getName() + " {";
        object3 = (String)object3 + "horizontalAlignment=" + (String)object + " ";
        if (this.horizontalIndent != 0) {
            object3 = (String)object3 + "horizontalIndent=" + this.horizontalIndent + " ";
        }
        if (this.horizontalSpan != 1) {
            object3 = (String)object3 + "horizontalSpan=" + this.horizontalSpan + " ";
        }
        if (this.grabExcessHorizontalSpace) {
            object3 = (String)object3 + "grabExcessHorizontalSpace=" + this.grabExcessHorizontalSpace + " ";
        }
        if (this.widthHint != -1) {
            object3 = (String)object3 + "widthHint=" + this.widthHint + " ";
        }
        if (this.minimumWidth != 0) {
            object3 = (String)object3 + "minimumWidth=" + this.minimumWidth + " ";
        }
        object3 = (String)object3 + "verticalAlignment=" + (String)object2 + " ";
        if (this.verticalIndent != 0) {
            object3 = (String)object3 + "verticalIndent=" + this.verticalIndent + " ";
        }
        if (this.verticalSpan != 1) {
            object3 = (String)object3 + "verticalSpan=" + this.verticalSpan + " ";
        }
        if (this.grabExcessVerticalSpace) {
            object3 = (String)object3 + "grabExcessVerticalSpace=" + this.grabExcessVerticalSpace + " ";
        }
        if (this.heightHint != -1) {
            object3 = (String)object3 + "heightHint=" + this.heightHint + " ";
        }
        if (this.minimumHeight != 0) {
            object3 = (String)object3 + "minimumHeight=" + this.minimumHeight + " ";
        }
        if (this.exclude) {
            object3 = (String)object3 + "exclude=" + this.exclude + " ";
        }
        object3 = ((String)object3).trim();
        object3 = (String)object3 + "}";
        return object3;
    }
}

