/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_rectangle_int_t;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;

public final class GC
extends Resource {
    public long handle;
    Drawable drawable;
    GCData data;
    private double[] cairoTransformationMatrix;
    private double[] currentTransform;
    private Rectangle clipping;
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_CAP = 16;
    static final int LINE_JOIN = 32;
    static final int LINE_WIDTH = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int BACKGROUND_BG = 256;
    static final int DRAW_OFFSET = 512;
    static final int DRAW = 761;
    static final int FILL = 2;
    static final float[] LINE_DOT = new float[]{1.0f, 1.0f};
    static final float[] LINE_DASH = new float[]{3.0f, 1.0f};
    static final float[] LINE_DASHDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DASHDOTDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int n) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData gCData = new GCData();
        gCData.style = this.checkStyle(n);
        Device device = gCData.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = gCData.device = device;
        long l = drawable.internal_new_GC(gCData);
        this.init(drawable, gCData, l);
        this.init();
    }

    int checkStyle(int n) {
        if ((n & 0x2000000) != 0) {
            n &= 0xFBFFFFFF;
        }
        return n & 0x6000000;
    }

    static void addCairoString(long l, String string, float f, float f2, Font font) {
        byte[] byArray = Converter.wcsToMbcs(string, true);
        long l2 = OS.pango_cairo_create_layout(l);
        if (l2 == 0L) {
            SWT.error(2);
        }
        OS.pango_layout_set_text(l2, byArray, -1);
        OS.pango_layout_set_font_description(l2, font.handle);
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        Cairo.cairo_get_current_point(l, dArray, dArray2);
        if (dArray[0] != (double)f || dArray2[0] != (double)f2) {
            Cairo.cairo_move_to(l, f, f2);
        }
        OS.pango_cairo_layout_path(l, l2);
        OS.g_object_unref(l2);
    }

    void cairoClipRegion(long l) {
        if (l == 0L) {
            return;
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        GDK.gdk_cairo_get_clip_rectangle(l, gdkRectangle);
        cairo_rectangle_int_t cairo_rectangle_int_t2 = new cairo_rectangle_int_t();
        cairo_rectangle_int_t2.convertFromGdkRectangle(gdkRectangle);
        long l2 = this.data.regionSet;
        long l3 = Cairo.cairo_region_create_rectangle(cairo_rectangle_int_t2);
        Cairo.cairo_region_subtract(l3, l2);
        GDK.gdk_cairo_region(l, l3);
        Cairo.cairo_clip(l);
        Cairo.cairo_paint(l);
    }

    public static GC gtk_new(long l, GCData gCData) {
        GC gC = new GC();
        gC.device = gCData.device;
        gC.init(null, gCData, l);
        return gC;
    }

    public static GC gtk_new(Drawable drawable, GCData gCData) {
        GC gC = new GC();
        long l = drawable.internal_new_GC(gCData);
        gC.device = gCData.device;
        gC.init(drawable, gCData, l);
        return gC;
    }

    void checkGC(int n) {
        Object object;
        Object object2;
        int n2 = this.data.state;
        if ((n2 & n) == n) {
            return;
        }
        n2 = (n2 ^ n) & n;
        this.data.state |= n;
        long l = this.data.cairo;
        if ((n2 & 3) != 0) {
            object2 = null;
            if ((n2 & 1) != 0) {
                object2 = this.data.foregroundRGBA;
                object = this.data.foregroundPattern;
                this.data.state &= 0xFFFFFFFD;
            } else {
                object2 = this.data.backgroundRGBA;
                object = this.data.backgroundPattern;
                this.data.state &= 0xFFFFFFFE;
            }
            if (object != null) {
                if ((this.data.style & 0x8000000) != 0 && ((Pattern)object).surface != 0L) {
                    long l2 = Cairo.cairo_pattern_create_for_surface(((Pattern)object).surface);
                    if (l2 == 0L) {
                        SWT.error(2);
                    }
                    Cairo.cairo_pattern_set_extend(l2, 1);
                    double[] dArray = new double[]{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                    Cairo.cairo_pattern_set_matrix(l2, dArray);
                    Cairo.cairo_set_source(l, l2);
                    Cairo.cairo_pattern_destroy(l2);
                } else {
                    Cairo.cairo_set_source(l, ((Pattern)object).handle);
                }
            } else {
                Cairo.cairo_set_source_rgba(l, ((GdkRGBA)object2).red, ((GdkRGBA)object2).green, ((GdkRGBA)object2).blue, (float)this.data.alpha / 255.0f);
            }
        }
        if ((n2 & 4) != 0 && this.data.layout != 0L) {
            object2 = this.data.font;
            OS.pango_layout_set_font_description(this.data.layout, ((Font)object2).handle);
        }
        if ((n2 & 0x10) != 0) {
            int n3 = 0;
            switch (this.data.lineCap) {
                case 2: {
                    n3 = 1;
                    break;
                }
                case 1: {
                    n3 = 0;
                    break;
                }
                case 3: {
                    n3 = 2;
                }
            }
            Cairo.cairo_set_line_cap(l, n3);
        }
        if ((n2 & 0x20) != 0) {
            int n4 = 0;
            switch (this.data.lineJoin) {
                case 1: {
                    n4 = 0;
                    break;
                }
                case 2: {
                    n4 = 1;
                    break;
                }
                case 3: {
                    n4 = 2;
                }
            }
            Cairo.cairo_set_line_join(l, n4);
        }
        if ((n2 & 0x40) != 0) {
            Cairo.cairo_set_line_width(l, this.data.lineWidth == 0.0f ? (double)DPIUtil.autoScaleUp(this.drawable, 1) : (double)this.data.lineWidth);
            switch (this.data.lineStyle) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 |= 8;
                }
            }
        }
        if ((n2 & 8) != 0) {
            float f = 0.0f;
            object = null;
            float f2 = this.data.lineWidth;
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    object = f2 != 0.0f ? LINE_DASH : LINE_DASH_ZERO;
                    break;
                }
                case 3: {
                    object = f2 != 0.0f ? LINE_DOT : LINE_DOT_ZERO;
                    break;
                }
                case 4: {
                    object = f2 != 0.0f ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                    break;
                }
                case 5: {
                    object = f2 != 0.0f ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                    break;
                }
                case 6: {
                    object = this.data.lineDashes;
                }
            }
            if (object != null) {
                f = this.data.lineDashesOffset;
                double[] dArray = new double[((Object)object).length];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = f2 == 0.0f || this.data.lineStyle == 6 ? (double)object[i] : (double)(object[i] * f2);
                }
                Cairo.cairo_set_dash(l, dArray, dArray.length, f);
            } else {
                Cairo.cairo_set_dash(l, null, 0, 0.0);
            }
        }
        if ((n2 & 0x80) != 0) {
            Cairo.cairo_set_miter_limit(l, this.data.lineMiterLimit);
        }
        if ((n2 & 0x200) != 0) {
            double d;
            this.data.cairoYoffset = 0.0;
            this.data.cairoXoffset = 0.0;
            double[] dArray = new double[6];
            Cairo.cairo_get_matrix(l, dArray);
            object = new double[]{1.0};
            double[] dArray2 = new double[]{1.0};
            Cairo.cairo_user_to_device_distance(l, (double[])object, dArray2);
            Object object3 = object[0];
            if (object3 < 0.0) {
                object3 = -object3;
            }
            if ((d = (double)this.data.lineWidth * object3) == 0.0 || (int)d % 2 == 1) {
                this.data.cairoXoffset = 0.5 / object3;
            }
            if ((object3 = (Object)dArray2[0]) < 0.0) {
                object3 = -object3;
            }
            if ((d = (double)this.data.lineWidth * object3) == 0.0 || (int)d % 2 == 1) {
                this.data.cairoYoffset = 0.5 / object3;
            }
        }
    }

    long convertRgn(long l, double[] dArray) {
        long l2 = Cairo.cairo_region_create();
        if (this.isIdentity(dArray)) {
            Cairo.cairo_region_union(l2, l);
            return l2;
        }
        int[] nArray = new int[1];
        long[] lArray = new long[1];
        Region.cairo_region_get_rectangles(l, lArray, nArray);
        cairo_rectangle_int_t cairo_rectangle_int_t2 = new cairo_rectangle_int_t();
        int[] nArray2 = new int[8];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        for (int i = 0; i < nArray[0]; ++i) {
            Cairo.memmove(cairo_rectangle_int_t2, lArray[0] + (long)(i * cairo_rectangle_int_t.sizeof), (long)cairo_rectangle_int_t.sizeof);
            dArray2[0] = cairo_rectangle_int_t2.x;
            dArray3[0] = cairo_rectangle_int_t2.y;
            Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
            nArray2[0] = (int)dArray2[0];
            nArray2[1] = (int)dArray3[0];
            dArray2[0] = cairo_rectangle_int_t2.x + cairo_rectangle_int_t2.width;
            dArray3[0] = cairo_rectangle_int_t2.y;
            Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
            nArray2[2] = (int)Math.round(dArray2[0]);
            nArray2[3] = (int)dArray3[0];
            dArray2[0] = cairo_rectangle_int_t2.x + cairo_rectangle_int_t2.width;
            dArray3[0] = cairo_rectangle_int_t2.y + cairo_rectangle_int_t2.height;
            Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
            nArray2[4] = (int)Math.round(dArray2[0]);
            nArray2[5] = (int)Math.round(dArray3[0]);
            dArray2[0] = cairo_rectangle_int_t2.x;
            dArray3[0] = cairo_rectangle_int_t2.y + cairo_rectangle_int_t2.height;
            Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
            nArray2[6] = (int)dArray2[0];
            nArray2[7] = (int)Math.round(dArray3[0]);
            long l3 = Region.gdk_region_polygon(nArray2, nArray2.length / 2, 0);
            Cairo.cairo_region_union(l2, l3);
            Cairo.cairo_region_destroy(l3);
        }
        if (lArray[0] != 0L) {
            OS.g_free(lArray[0]);
        }
        return l2;
    }

    public void copyArea(Image image, int n, int n2) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Point point = DPIUtil.autoScaleUp(this.drawable, new Point(n, n2));
        this.copyAreaInPixels(image, point.x, point.y);
    }

    void copyAreaInPixels(Image image, int n, int n2) {
        long l = Cairo.cairo_create(image.surface);
        if (l == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_translate(l, -n, -n2);
        Cairo.cairo_push_group(l);
        if (this.data.image != null) {
            Cairo.cairo_set_source_surface(l, this.data.image.surface, 0.0, 0.0);
        } else if (this.data.drawable != 0L) {
            if (!GTK.GTK4) {
                GDK.gdk_cairo_set_source_window(l, this.data.drawable, 0, 0);
            }
        } else {
            Cairo.cairo_destroy(l);
            return;
        }
        Cairo.cairo_set_operator(l, 1);
        Cairo.cairo_paint(l);
        Cairo.cairo_pop_group_to_source(l);
        Cairo.cairo_paint(l);
        Cairo.cairo_destroy(l);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle rectangle = DPIUtil.autoScaleUp(this.drawable, new Rectangle(n, n2, n3, n4));
        Point point = DPIUtil.autoScaleUp(this.drawable, new Point(n5, n6));
        this.copyAreaInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, point.x, point.y);
    }

    void copyAreaInPixels(int n, int n2, int n3, int n4, int n5, int n6) {
        this.copyAreaInPixels(n, n2, n3, n4, n5, n6, true);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle rectangle = DPIUtil.autoScaleUp(this.drawable, new Rectangle(n, n2, n3, n4));
        Point point = DPIUtil.autoScaleUp(this.drawable, new Point(n5, n6));
        this.copyAreaInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, point.x, point.y, bl);
    }

    void copyAreaInPixels(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        int n7 = n5 - n;
        int n8 = n6 - n2;
        if (n7 == 0 && n8 == 0) {
            return;
        }
        long l = this.data.drawable;
        if (this.data.image != null) {
            Cairo.cairo_set_source_surface(this.handle, this.data.image.surface, n7, n8);
            Cairo.cairo_rectangle(this.handle, n5, n6, n3, n4);
            Cairo.cairo_set_operator(this.handle, 1);
            Cairo.cairo_fill(this.handle);
        } else if (l != 0L) {
            Cairo.cairo_save(this.handle);
            Cairo.cairo_rectangle(this.handle, n5, n6, n3, n4);
            Cairo.cairo_clip(this.handle);
            Cairo.cairo_translate(this.handle, n7, n8);
            Cairo.cairo_set_operator(this.handle, 1);
            Cairo.cairo_push_group(this.handle);
            if (!GTK.GTK4) {
                GDK.gdk_cairo_set_source_window(this.handle, l, 0, 0);
            }
            Cairo.cairo_paint(this.handle);
            Cairo.cairo_pop_group_to_source(this.handle);
            Cairo.cairo_rectangle(this.handle, n5 - n7, n6 - n8, n3, n4);
            Cairo.cairo_clip(this.handle);
            Cairo.cairo_paint(this.handle);
            Cairo.cairo_restore(this.handle);
            if (bl) {
                cairo_rectangle_int_t cairo_rectangle_int_t2 = new cairo_rectangle_int_t();
                cairo_rectangle_int_t2.x = n;
                cairo_rectangle_int_t2.y = n2;
                cairo_rectangle_int_t2.width = n3;
                cairo_rectangle_int_t2.height = n4;
                long l2 = Cairo.cairo_region_create_rectangle(cairo_rectangle_int_t2);
                if (!GTK.GTK4) {
                    long l3 = GDK.gdk_window_get_visible_region(l);
                    long l4 = Cairo.cairo_region_create_rectangle(cairo_rectangle_int_t2);
                    Cairo.cairo_region_intersect(l4, l3);
                    Cairo.cairo_region_subtract(l2, l3);
                    Cairo.cairo_region_translate(l2, n7, n8);
                    GDK.gdk_window_invalidate_region(l, l2, false);
                    Cairo.cairo_region_destroy(l3);
                    Cairo.cairo_region_destroy(l4);
                }
                Cairo.cairo_region_destroy(l2);
            }
        }
        if (this.data.image == null && bl) {
            boolean bl2 = n5 + n3 < n || n + n3 < n5 || n6 + n4 < n2 || n2 + n4 < n6;
            GdkRectangle gdkRectangle = new GdkRectangle();
            if (bl2) {
                gdkRectangle.x = n;
                gdkRectangle.y = n2;
                gdkRectangle.width = Math.max(0, n3);
                gdkRectangle.height = Math.max(0, n4);
                if (!GTK.GTK4) {
                    GDK.gdk_window_invalidate_rect(l, gdkRectangle, false);
                }
            } else {
                int n9;
                if (n7 != 0) {
                    n9 = n5 - n7;
                    if (n7 < 0) {
                        n9 = n5 + n3;
                    }
                    gdkRectangle.x = n9;
                    gdkRectangle.y = n2;
                    gdkRectangle.width = Math.abs(n7);
                    gdkRectangle.height = Math.max(0, n4);
                    if (!GTK.GTK4) {
                        GDK.gdk_window_invalidate_rect(l, gdkRectangle, false);
                    }
                }
                if (n8 != 0) {
                    n9 = n6 - n8;
                    if (n8 < 0) {
                        n9 = n6 + n4;
                    }
                    gdkRectangle.x = n;
                    gdkRectangle.y = n9;
                    gdkRectangle.width = Math.max(0, n3);
                    gdkRectangle.height = Math.abs(n8);
                    if (!GTK.GTK4) {
                        GDK.gdk_window_invalidate_rect(l, gdkRectangle, false);
                    }
                }
            }
        }
    }

    void createLayout() {
        long l;
        long l2;
        if (GTK.GTK4) {
            l2 = OS.pango_cairo_font_map_get_default();
            l = OS.pango_font_map_create_context(l2);
        } else {
            l = GDK.gdk_pango_context_get();
        }
        if (l == 0L) {
            SWT.error(2);
        }
        this.data.context = l;
        l2 = OS.pango_layout_new(l);
        if (l2 == 0L) {
            SWT.error(2);
        }
        this.data.layout = l2;
        OS.pango_context_set_language(l, GTK.gtk_get_default_language());
        OS.pango_context_set_base_dir(l, (this.data.style & 0x8000000) != 0 ? 1 : 0);
        OS.pango_layout_set_auto_dir(l2, false);
    }

    void disposeLayout() {
        this.data.string = null;
        if (this.data.context != 0L) {
            OS.g_object_unref(this.data.context);
        }
        if (this.data.layout != 0L) {
            OS.g_object_unref(this.data.layout);
        }
        this.data.context = 0L;
        this.data.layout = 0L;
    }

    @Override
    void destroy() {
        Image image;
        long l;
        if (this.data.disposeCairo) {
            l = this.data.cairo;
            Cairo.cairo_destroy(l);
        }
        this.data.cairo = 0L;
        l = this.data.clipRgn;
        if (l != 0L) {
            Cairo.cairo_region_destroy(l);
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
            if (image.transparentPixel != -1) {
                image.createMask();
            }
        }
        this.disposeLayout();
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.data.clipRgn = 0L;
        this.data.drawable = 0L;
        this.drawable = null;
        this.handle = 0L;
        this.data.image = null;
        this.data.string = null;
        this.data = null;
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle rectangle = DPIUtil.autoScaleUp(this.drawable, new Rectangle(n, n2, n3, n4));
        this.drawArcInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n5, n6);
    }

    void drawArcInPixels(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkGC(761);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        long l = this.data.cairo;
        double d = this.data.cairoXoffset;
        double d2 = this.data.cairoYoffset;
        if (n3 == n4) {
            if (n6 >= 0) {
                Cairo.cairo_arc_negative(l, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f), (float)n3 / 2.0f, (float)(-n5) * (float)Math.PI / 180.0f, (float)(-(n5 + n6)) * (float)Math.PI / 180.0f);
            } else {
                Cairo.cairo_arc(l, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f), (float)n3 / 2.0f, (float)(-n5) * (float)Math.PI / 180.0f, (float)(-(n5 + n6)) * (float)Math.PI / 180.0f);
            }
        } else {
            Cairo.cairo_save(l);
            Cairo.cairo_translate(l, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f));
            Cairo.cairo_scale(l, (float)n3 / 2.0f, (float)n4 / 2.0f);
            if (n6 >= 0) {
                Cairo.cairo_arc_negative(l, 0.0, 0.0, 1.0, (float)(-n5) * (float)Math.PI / 180.0f, (float)(-(n5 + n6)) * (float)Math.PI / 180.0f);
            } else {
                Cairo.cairo_arc(l, 0.0, 0.0, 1.0, (float)(-n5) * (float)Math.PI / 180.0f, (float)(-(n5 + n6)) * (float)Math.PI / 180.0f);
            }
            Cairo.cairo_restore(l);
        }
        Cairo.cairo_stroke(l);
    }

    public void drawFocus(int n, int n2, int n3, int n4) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle rectangle = DPIUtil.autoScaleUp(this.drawable, new Rectangle(n, n2, n3, n4));
        this.drawFocusInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void drawFocusInPixels(int n, int n2, int n3, int n4) {
        long l = this.data.cairo;
        this.checkGC(1);
        long l2 = GTK.gtk_widget_get_style_context(this.data.device.shellHandle);
        GTK.gtk_render_focus(l2, l, n, n2, n3, n4);
    }

    public void drawImage(Image image, int n, int n2) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        Point point = DPIUtil.autoScaleUp(this.drawable, new Point(n, n2));
        this.drawImageInPixels(image, point.x, point.y);
    }

    void drawImageInPixels(Image image, int n, int n2) {
        this.drawImage(image, 0, 0, -1, -1, n, n2, -1, -1, true);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (n3 == 0 || n4 == 0 || n7 == 0 || n8 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n7 < 0 || n8 < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rectangle = DPIUtil.autoScaleUp(this.drawable, new Rectangle(n5, n6, n7, n8));
        this.drawImage(image, n, n2, n3, n4, rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
    }

    void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        image.refreshImageForZoom();
        ImageData imageData = image.getImageData();
        int n9 = imageData.width;
        int n10 = imageData.height;
        if (bl) {
            n3 = n7 = n9;
            n4 = n8 = n10;
        } else {
            boolean bl2 = bl = n == 0 && n2 == 0 && n3 == n7 && n7 == n9 && n4 == n8 && n8 == n10;
            if (n + n3 > n9 + 1 || n2 + n4 > n10 + 1) {
                SWT.error(5);
            }
        }
        long l = this.data.cairo;
        if (this.data.alpha != 0) {
            image.createSurface();
            Cairo.cairo_save(l);
            if ((this.data.style & 0x8000000) != 0) {
                Cairo.cairo_scale(l, -1.0, 1.0);
                Cairo.cairo_translate(l, -2 * n5 - n7, 0.0);
            }
            Cairo.cairo_rectangle(l, n5, n6, n7, n8);
            Cairo.cairo_clip(l);
            if (n3 != n7 || n4 != n8) {
                float f = (float)n7 / (float)n3;
                float f2 = (float)n8 / (float)n4;
                Cairo.cairo_translate(l, n5 - (int)((float)n * f), n6 - (int)((float)n2 * f2));
                Cairo.cairo_scale(l, f, f2);
            } else {
                Cairo.cairo_translate(l, n5 - n, n6 - n2);
            }
            int n11 = 1;
            switch (this.data.interpolation) {
                case -1: {
                    n11 = 1;
                    break;
                }
                case 0: {
                    n11 = 3;
                    break;
                }
                case 1: {
                    n11 = 0;
                    break;
                }
                case 2: {
                    n11 = 2;
                }
            }
            long l2 = Cairo.cairo_pattern_create_for_surface(image.surface);
            if (l2 == 0L) {
                SWT.error(2);
            }
            if (n3 != n7 || n4 != n8) {
                Cairo.cairo_pattern_set_extend(l2, 3);
            }
            Cairo.cairo_pattern_set_filter(l2, n11);
            Cairo.cairo_set_source(l, l2);
            if (this.data.alpha != 255) {
                Cairo.cairo_paint_with_alpha(l, (float)this.data.alpha / 255.0f);
            } else {
                Cairo.cairo_paint(l);
            }
            Cairo.cairo_restore(l);
            Cairo.cairo_pattern_destroy(l2);
        }
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Point point = DPIUtil.autoScaleUp(this.drawable, new Point(n, n2));
        Point point2 = DPIUtil.autoScaleUp(this.drawable, new Point(n3, n4));
        this.drawLineInPixels(point.x, point.y, point2.x, point2.y);
    }

    void drawLineInPixels(int n, int n2, int n3, int n4) {
        this.checkGC(761);
        long l = this.data.cairo;
        double d = this.data.cairoXoffset;
        double d2 = this.data.cairoYoffset;
        if (Cairo.cairo_version() >= Cairo.CAIRO_VERSION_ENCODE(1, 12, 0)) {
            Cairo.cairo_set_antialias(l, 6);
        }
        Cairo.cairo_move_to(l, (double)n + d, (double)n2 + d2);
        Cairo.cairo_line_to(l, (double)n3 + d, (double)n4 + d2);
        Cairo.cairo_stroke(l);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle rectangle = DPIUtil.autoScaleUp(this.drawable, new Rectangle(n, n2, n3, n4));
        this.drawOvalInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void drawOvalInPixels(int n, int n2, int n3, int n4) {
        this.checkGC(761);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        long l = this.data.cairo;
        double d = this.data.cairoXoffset;
        double d2 = this.data.cairoYoffset;
        if (n3 == n4) {
            Cairo.cairo_arc_negative(l, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f), (float)n3 / 2.0f, 0.0, -6.2831854820251465);
        } else {
            Cairo.cairo_save(l);
            Cairo.cairo_translate(l, (double)n + d + (double)((float)n3 / 2.0f), (double)n2 + d2 + (double)((float)n4 / 2.0f));
            Cairo.cairo_scale(l, (float)n3 / 2.0f, (float)n4 / 2.0f);
            Cairo.cairo_arc_negative(l, 0.0, 0.0, 1.0, 0.0, -6.2831854820251465);
            Cairo.cairo_restore(l);
        }
        Cairo.cairo_stroke(l);
    }

    public void drawPath(Path path) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0L) {
            SWT.error(5);
        }
        this.initCairo();
        this.checkGC(761);
        long l = this.data.cairo;
        Cairo.cairo_save(l);
        double d = this.data.cairoXoffset;
        double d2 = this.data.cairoYoffset;
        Cairo.cairo_translate(l, d, d2);
        long l2 = Cairo.cairo_copy_path(path.handle);
        if (l2 == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(l, l2);
        Cairo.cairo_path_destroy(l2);
        Cairo.cairo_stroke(l);
        Cairo.cairo_restore(l);
    }

    public void drawPoint(int n, int n2) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Point point = DPIUtil.autoScaleUp(this.drawable, new Point(n, n2));
        this.drawPointInPixels(point.x, point.y);
    }

    void drawPointInPixels(int n, int n2) {
        this.checkGC(761);
        long l = this.data.cairo;
        Cairo.cairo_rectangle(l, n, n2, 1.0, 1.0);
        Cairo.cairo_fill(l);
    }

    public void drawPolygon(int[] nArray) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        int[] nArray2 = DPIUtil.autoScaleUp(this.drawable, nArray);
        this.drawPolygonInPixels(nArray2);
    }

    void drawPolygonInPixels(int[] nArray) {
        this.checkGC(761);
        long l = this.data.cairo;
        this.drawPolyline(l, nArray, true);
        Cairo.cairo_stroke(l);
    }

    public void drawPolyline(int[] nArray) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        int[] nArray2 = DPIUtil.autoScaleUp(this.drawable, nArray);
        this.drawPolylineInPixels(nArray2);
    }

    void drawPolylineInPixels(int[] nArray) {
        this.checkGC(761);
        long l = this.data.cairo;
        this.drawPolyline(l, nArray, false);
        Cairo.cairo_stroke(l);
    }

    void drawPolyline(long l, int[] nArray, boolean bl) {
        int n = nArray.length / 2;
        if (n == 0) {
            return;
        }
        double d = this.data.cairoXoffset;
        double d2 = this.data.cairoYoffset;
        Cairo.cairo_move_to(l, (double)nArray[0] + d, (double)nArray[1] + d2);
        int n2 = 1;
        int n3 = 2;
        while (n2 < n) {
            Cairo.cairo_line_to(l, (double)nArray[n3] + d, (double)nArray[n3 + 1] + d2);
            ++n2;
            n3 += 2;
        }
        if (bl) {
            Cairo.cairo_close_path(l);
        }
    }

    public void drawRectangle(int n, int n2, int n3, int n4) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.drawRectangle(new Rectangle(n, n2, n3, n4));
    }

    void drawRectangleInPixels(int n, int n2, int n3, int n4) {
        this.checkGC(761);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        long l = this.data.cairo;
        double d = this.data.cairoXoffset;
        double d2 = this.data.cairoYoffset;
        Cairo.cairo_rectangle(l, (double)n + d, (double)n2 + d2, n3, n4);
        Cairo.cairo_stroke(l);
    }

    public void drawRectangle(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        this.drawRectangleInPixels(DPIUtil.autoScaleUp(this.drawable, rectangle));
    }

    void drawRectangleInPixels(Rectangle rectangle) {
        this.drawRectangleInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawRoundRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle rectangle = DPIUtil.autoScaleUp(this.drawable, new Rectangle(n, n2, n3, n4));
        Point point = DPIUtil.autoScaleUp(this.drawable, new Point(n5, n6));
        this.drawRoundRectangleInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, point.x, point.y);
    }

    void drawRoundRectangleInPixels(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkGC(761);
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        if (n9 < 0) {
            n9 = 0 - n9;
            n7 -= n9;
        }
        if (n10 < 0) {
            n10 = 0 - n10;
            n8 -= n10;
        }
        if (n11 < 0) {
            n11 = 0 - n11;
        }
        if (n12 < 0) {
            n12 = 0 - n12;
        }
        long l = this.data.cairo;
        double d = this.data.cairoXoffset;
        double d2 = this.data.cairoYoffset;
        if (n11 == 0 || n12 == 0) {
            Cairo.cairo_rectangle(l, (double)n + d, (double)n2 + d2, n3, n4);
        } else {
            float f = (float)n11 / 2.0f;
            float f2 = (float)n12 / 2.0f;
            float f3 = (float)n9 / f;
            float f4 = (float)n10 / f2;
            Cairo.cairo_save(l);
            Cairo.cairo_translate(l, (double)n7 + d, (double)n8 + d2);
            Cairo.cairo_scale(l, f, f2);
            Cairo.cairo_move_to(l, f3 - 1.0f, 0.0);
            Cairo.cairo_arc(l, f3 - 1.0f, 1.0, 1.0, 4.71238898038469, Math.PI * 2);
            Cairo.cairo_arc(l, f3 - 1.0f, f4 - 1.0f, 1.0, 0.0, 1.5707963267948966);
            Cairo.cairo_arc(l, 1.0, f4 - 1.0f, 1.0, 1.5707963267948966, Math.PI);
            Cairo.cairo_arc(l, 1.0, 1.0, 1.0, Math.PI, 4.71238898038469);
            Cairo.cairo_close_path(l);
            Cairo.cairo_restore(l);
        }
        Cairo.cairo_stroke(l);
    }

    public void drawString(String string, int n, int n2) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.drawString(string, n, n2, false);
    }

    void drawStringInPixels(String string, int n, int n2) {
        this.drawStringInPixels(string, n, n2, false);
    }

    public void drawString(String string, int n, int n2, boolean bl) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        Point point = DPIUtil.autoScaleUp(this.drawable, new Point(n, n2));
        this.drawStringInPixels(string, point.x, point.y, bl);
    }

    void drawStringInPixels(String string, int n, int n2, boolean bl) {
        this.drawTextInPixels(string, n, n2, bl ? 1 : 0);
    }

    public void drawText(String string, int n, int n2) {
        this.drawText(string, n, n2, 6);
    }

    void drawTextInPixels(String string, int n, int n2) {
        this.drawTextInPixels(string, n, n2, 6);
    }

    public void drawText(String string, int n, int n2, boolean bl) {
        Point point = DPIUtil.autoScaleUp(this.drawable, new Point(n, n2));
        this.drawTextInPixels(string, point.x, point.y, bl);
    }

    void drawTextInPixels(String string, int n, int n2, boolean bl) {
        int n3 = 6;
        if (bl) {
            n3 |= 1;
        }
        this.drawTextInPixels(string, n, n2, n3);
    }

    public void drawText(String string, int n, int n2, int n3) {
        Point point = DPIUtil.autoScaleUp(this.drawable, new Point(n, n2));
        this.drawTextInPixels(string, point.x, point.y, n3);
    }

    void drawTextInPixels(String string, int n, int n2, int n3) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        long l = this.data.cairo;
        this.setString(string, n3);
        this.checkGC(4);
        if ((n3 & 1) == 0) {
            this.checkGC(2);
            if (this.data.stringWidth == -1) {
                this.computeStringSize();
            }
            Cairo.cairo_rectangle(l, n, n2, this.data.stringWidth, this.data.stringHeight);
            Cairo.cairo_fill(l);
        }
        this.checkGC(1);
        if ((this.data.style & 0x8000000) != 0) {
            Cairo.cairo_save(l);
            if (this.data.stringWidth == -1) {
                this.computeStringSize();
            }
            Cairo.cairo_scale(l, -1.0, 1.0);
            Cairo.cairo_translate(l, -2 * n - this.data.stringWidth, 0.0);
        }
        Cairo.cairo_move_to(l, n, n2);
        OS.pango_cairo_show_layout(l, this.data.layout);
        if ((this.data.style & 0x8000000) != 0) {
            Cairo.cairo_restore(l);
        }
        Cairo.cairo_new_path(l);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle rectangle = DPIUtil.autoScaleUp(this.drawable, new Rectangle(n, n2, n3, n4));
        this.fillArcInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n5, n6);
    }

    void fillArcInPixels(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkGC(2);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        long l = this.data.cairo;
        if (n3 == n4) {
            if (n6 >= 0) {
                Cairo.cairo_arc_negative(l, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f, (float)n3 / 2.0f, (float)(-n5) * (float)Math.PI / 180.0f, (float)(-(n5 + n6)) * (float)Math.PI / 180.0f);
            } else {
                Cairo.cairo_arc(l, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f, (float)n3 / 2.0f, (float)(-n5) * (float)Math.PI / 180.0f, (float)(-(n5 + n6)) * (float)Math.PI / 180.0f);
            }
            Cairo.cairo_line_to(l, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f);
        } else {
            Cairo.cairo_save(l);
            Cairo.cairo_translate(l, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f);
            Cairo.cairo_scale(l, (float)n3 / 2.0f, (float)n4 / 2.0f);
            if (n6 >= 0) {
                Cairo.cairo_arc_negative(l, 0.0, 0.0, 1.0, (float)(-n5) * (float)Math.PI / 180.0f, (float)(-(n5 + n6)) * (float)Math.PI / 180.0f);
            } else {
                Cairo.cairo_arc(l, 0.0, 0.0, 1.0, (float)(-n5) * (float)Math.PI / 180.0f, (float)(-(n5 + n6)) * (float)Math.PI / 180.0f);
            }
            Cairo.cairo_line_to(l, 0.0, 0.0);
            Cairo.cairo_restore(l);
        }
        Cairo.cairo_fill(l);
    }

    public void fillGradientRectangle(int n, int n2, int n3, int n4, boolean bl) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle rectangle = DPIUtil.autoScaleUp(this.drawable, new Rectangle(n, n2, n3, n4));
        this.fillGradientRectangleInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl);
    }

    void fillGradientRectangleInPixels(int n, int n2, int n3, int n4, boolean bl) {
        long l;
        RGB rGB;
        if (n3 == 0 || n4 == 0) {
            return;
        }
        RGB rGB2 = this.getBackground().getRGB();
        RGB rGB3 = rGB = this.getForeground().getRGB();
        RGB rGB4 = rGB2;
        boolean bl2 = false;
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
            if (!bl) {
                bl2 = true;
            }
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
            if (bl) {
                bl2 = true;
            }
        }
        if (bl2) {
            rGB3 = rGB2;
            rGB4 = rGB;
        }
        long l2 = this.data.cairo;
        if (DPIUtil.useCairoAutoScale() && (l = Cairo.cairo_get_target(l2)) != 0L) {
            float f = (float)DPIUtil.getDeviceZoom() / 100.0f;
            Cairo.cairo_surface_set_device_scale(l, f, f);
        }
        if (rGB3.equals(rGB4)) {
            this.fillRectangleInPixels(n, n2, n3, n4);
            return;
        }
        long l3 = bl ? Cairo.cairo_pattern_create_linear(0.0, 0.0, 0.0, 1.0) : Cairo.cairo_pattern_create_linear(0.0, 0.0, 1.0, 0.0);
        Cairo.cairo_pattern_add_color_stop_rgba(l3, 0.0, (float)rGB3.red / 255.0f, (float)rGB3.green / 255.0f, (float)rGB3.blue / 255.0f, (float)this.data.alpha / 255.0f);
        Cairo.cairo_pattern_add_color_stop_rgba(l3, 1.0, (float)rGB4.red / 255.0f, (float)rGB4.green / 255.0f, (float)rGB4.blue / 255.0f, (float)this.data.alpha / 255.0f);
        Cairo.cairo_save(l2);
        Cairo.cairo_translate(l2, n, n2);
        Cairo.cairo_scale(l2, n3, n4);
        Cairo.cairo_rectangle(l2, 0.0, 0.0, 1.0, 1.0);
        Cairo.cairo_set_source(l2, l3);
        Cairo.cairo_fill(l2);
        Cairo.cairo_restore(l2);
        Cairo.cairo_pattern_destroy(l3);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle rectangle = DPIUtil.autoScaleUp(this.drawable, new Rectangle(n, n2, n3, n4));
        this.fillOvalInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void fillOvalInPixels(int n, int n2, int n3, int n4) {
        this.checkGC(2);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        long l = this.data.cairo;
        if (n3 == n4) {
            Cairo.cairo_arc_negative(l, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f, (float)n3 / 2.0f, 0.0, 6.2831854820251465);
        } else {
            Cairo.cairo_save(l);
            Cairo.cairo_translate(l, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f);
            Cairo.cairo_scale(l, (float)n3 / 2.0f, (float)n4 / 2.0f);
            Cairo.cairo_arc_negative(l, 0.0, 0.0, 1.0, 0.0, 6.2831854820251465);
            Cairo.cairo_restore(l);
        }
        Cairo.cairo_fill(l);
    }

    public void fillPath(Path path) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0L) {
            SWT.error(5);
        }
        this.initCairo();
        this.checkGC(2);
        long l = this.data.cairo;
        long l2 = Cairo.cairo_copy_path(path.handle);
        if (l2 == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_append_path(l, l2);
        Cairo.cairo_path_destroy(l2);
        Cairo.cairo_fill(l);
    }

    public void fillPolygon(int[] nArray) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        int[] nArray2 = DPIUtil.autoScaleUp(this.drawable, nArray);
        this.fillPolygonInPixels(nArray2);
    }

    void fillPolygonInPixels(int[] nArray) {
        this.checkGC(2);
        long l = this.data.cairo;
        this.drawPolyline(l, nArray, true);
        Cairo.cairo_fill(l);
    }

    public void fillRectangle(int n, int n2, int n3, int n4) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.fillRectangle(new Rectangle(n, n2, n3, n4));
    }

    void fillRectangleInPixels(int n, int n2, int n3, int n4) {
        this.checkGC(2);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        long l = this.data.cairo;
        if (this.data.regionSet != 0L) {
            this.cairoClipRegion(l);
        } else {
            Cairo.cairo_rectangle(l, n, n2, n3, n4);
        }
        Cairo.cairo_fill(l);
    }

    public void fillRectangle(Rectangle rectangle) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.fillRectangleInPixels(DPIUtil.autoScaleUp(this.drawable, rectangle));
    }

    void fillRectangleInPixels(Rectangle rectangle) {
        this.fillRectangleInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void fillRoundRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Rectangle rectangle = DPIUtil.autoScaleUp(this.drawable, new Rectangle(n, n2, n3, n4));
        Point point = DPIUtil.autoScaleUp(this.drawable, new Point(n5, n6));
        this.fillRoundRectangleInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, point.x, point.y);
    }

    void fillRoundRectangleInPixels(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkGC(2);
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        if (n9 < 0) {
            n9 = 0 - n9;
            n7 -= n9;
        }
        if (n10 < 0) {
            n10 = 0 - n10;
            n8 -= n10;
        }
        if (n11 < 0) {
            n11 = 0 - n11;
        }
        if (n12 < 0) {
            n12 = 0 - n12;
        }
        long l = this.data.cairo;
        if (n11 == 0 || n12 == 0) {
            Cairo.cairo_rectangle(l, n, n2, n3, n4);
        } else {
            float f = (float)n11 / 2.0f;
            float f2 = (float)n12 / 2.0f;
            float f3 = (float)n9 / f;
            float f4 = (float)n10 / f2;
            Cairo.cairo_save(l);
            Cairo.cairo_translate(l, n7, n8);
            Cairo.cairo_scale(l, f, f2);
            Cairo.cairo_move_to(l, f3 - 1.0f, 0.0);
            Cairo.cairo_arc(l, f3 - 1.0f, 1.0, 1.0, 4.71238898038469, Math.PI * 2);
            Cairo.cairo_arc(l, f3 - 1.0f, f4 - 1.0f, 1.0, 0.0, 1.5707963267948966);
            Cairo.cairo_arc(l, 1.0, f4 - 1.0f, 1.0, 1.5707963267948966, Math.PI);
            Cairo.cairo_arc(l, 1.0, 1.0, 1.0, Math.PI, 4.71238898038469);
            Cairo.cairo_close_path(l);
            Cairo.cairo_restore(l);
        }
        Cairo.cairo_fill(l);
    }

    int fixMnemonic(char[] cArray) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        while (n < cArray.length) {
            if ((cArray[n2++] = cArray[n++]) != '&' || n == cArray.length) continue;
            if (cArray[n] == '&') {
                ++n;
                continue;
            }
            if (n3 == -1) {
                n3 = n2;
            }
            --n2;
        }
        while (n2 < cArray.length) {
            cArray[n2++] = '\u0000';
        }
        return n3;
    }

    public int getAdvanceWidth(char c) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.stringExtentInPixels((String)new String((char[])new char[]{c})).x;
    }

    public boolean getAdvanced() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.cairo != 0L;
    }

    public int getAlpha() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L) {
            return -1;
        }
        int n = Cairo.cairo_get_antialias(this.data.cairo);
        switch (n) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public Color getBackground() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return Color.gtk_new(this.data.device, this.data.backgroundRGBA);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.backgroundPattern;
    }

    public int getCharWidth(char c) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.stringExtentInPixels((String)new String((char[])new char[]{c})).x;
    }

    public Rectangle getClipping() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return DPIUtil.autoScaleDown(this.drawable, this.getClippingInPixels());
    }

    Rectangle getClippingInPixels() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.getSize(nArray, nArray2);
        n3 = nArray[0];
        n4 = nArray2[0];
        long l = this.data.cairo;
        long l2 = this.data.clipRgn;
        long l3 = this.data.damageRgn;
        if (l2 != 0L || l3 != 0L || l != 0L) {
            long l4 = Cairo.cairo_region_create();
            cairo_rectangle_int_t cairo_rectangle_int_t2 = new cairo_rectangle_int_t();
            cairo_rectangle_int_t2.width = n3;
            cairo_rectangle_int_t2.height = n4;
            Cairo.cairo_region_union_rectangle(l4, cairo_rectangle_int_t2);
            if (l3 != 0L) {
                Cairo.cairo_region_intersect(l4, l3);
            }
            if (l2 != 0L) {
                if (!Arrays.equals(this.data.clippingTransform, this.currentTransform)) {
                    double[] dArray;
                    if (this.currentTransform != null && this.data.clippingTransform == null) {
                        dArray = (double[])this.currentTransform.clone();
                        Cairo.cairo_matrix_invert(dArray);
                    } else if (this.currentTransform != null && this.data.clippingTransform != null) {
                        dArray = new double[6];
                        double[] dArray2 = (double[])this.currentTransform.clone();
                        Cairo.cairo_matrix_invert(dArray2);
                        Cairo.cairo_matrix_multiply(dArray, this.data.clippingTransform, dArray2);
                    } else {
                        dArray = (double[])this.data.clippingTransform.clone();
                    }
                    long l5 = l4;
                    l4 = this.convertRgn(l4, dArray);
                    Cairo.cairo_region_destroy(l5);
                    l2 = this.convertRgn(l2, dArray);
                    Cairo.cairo_region_intersect(l4, l2);
                    Cairo.cairo_region_destroy(l2);
                } else {
                    Cairo.cairo_region_intersect(l4, l2);
                }
            }
            Cairo.cairo_region_get_extents(l4, cairo_rectangle_int_t2);
            Cairo.cairo_region_destroy(l4);
            n = cairo_rectangle_int_t2.x;
            n2 = cairo_rectangle_int_t2.y;
            n3 = cairo_rectangle_int_t2.width;
            n4 = cairo_rectangle_int_t2.height;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public void getClipping(Region region) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        long l = region.handle;
        Cairo.cairo_region_subtract(l, l);
        long l2 = this.data.clipRgn;
        if (l2 == 0L) {
            cairo_rectangle_int_t cairo_rectangle_int_t2 = new cairo_rectangle_int_t();
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.getSize(nArray, nArray2);
            cairo_rectangle_int_t2.width = nArray[0];
            cairo_rectangle_int_t2.height = nArray2[0];
            Cairo.cairo_region_union_rectangle(l, cairo_rectangle_int_t2);
        } else {
            Cairo.cairo_region_union(l, l2);
        }
        if (this.data.damageRgn != 0L) {
            Cairo.cairo_region_intersect(l, this.data.damageRgn);
        }
    }

    public int getFillRule() {
        long l;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if ((l = this.data.cairo) == 0L) {
            return 1;
        }
        return Cairo.cairo_get_fill_rule(l) == 0 ? 2 : 1;
    }

    public Font getFont() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        int n;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.context == 0L) {
            this.createLayout();
        }
        this.checkGC(4);
        Font font = this.data.font;
        long l = this.data.context;
        long l2 = OS.pango_context_get_language(l);
        long l3 = OS.pango_context_get_metrics(l, font.handle, l2);
        FontMetrics fontMetrics = new FontMetrics();
        int n2 = OS.pango_font_metrics_get_ascent(l3);
        int n3 = OS.pango_font_metrics_get_descent(l3);
        fontMetrics.ascentInPoints = n = DPIUtil.autoScaleDown(this.drawable, OS.PANGO_PIXELS(n2));
        int n4 = DPIUtil.autoScaleDown(this.drawable, OS.PANGO_PIXELS(n2 + n3));
        fontMetrics.descentInPoints = n4 - n;
        fontMetrics.averageCharWidthInPoints = DPIUtil.autoScaleDown(this.drawable, OS.PANGO_PIXELS(OS.pango_font_metrics_get_approximate_char_width(l3)));
        OS.pango_font_metrics_unref(l3);
        return fontMetrics;
    }

    public Color getForeground() {
        if (this.handle == 0L) {
            SWT.error(24);
        }
        return Color.gtk_new(this.data.device, this.data.foregroundRGBA);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.interpolation;
    }

    public LineAttributes getLineAttributes() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        LineAttributes lineAttributes = this.getLineAttributesInPixels();
        lineAttributes.width = DPIUtil.autoScaleDown(this.drawable, lineAttributes.width);
        return lineAttributes;
    }

    LineAttributes getLineAttributesInPixels() {
        float[] fArray = null;
        if (this.data.lineDashes != null) {
            fArray = new float[this.data.lineDashes.length];
            System.arraycopy(this.data.lineDashes, 0, fArray, 0, fArray.length);
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, fArray, this.data.lineDashesOffset, this.data.lineMiterLimit);
    }

    public int getLineCap() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineDashes == null) {
            return null;
        }
        int[] nArray = new int[this.data.lineDashes.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)this.data.lineDashes[i];
        }
        return nArray;
    }

    public int getLineJoin() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return (int)DPIUtil.autoScaleDown(this.drawable, this.data.lineWidth);
    }

    int getLineWidthInPixels() {
        return (int)this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.style;
    }

    void getSize(int[] nArray, int[] nArray2) {
        if (this.data.width != -1 && this.data.height != -1) {
            nArray[0] = this.data.width;
            nArray2[0] = this.data.height;
            return;
        }
        if (this.data.drawable != 0L) {
            if (GTK.GTK4) {
                nArray[0] = GDK.gdk_surface_get_width(this.data.drawable);
                nArray2[0] = GDK.gdk_surface_get_height(this.data.drawable);
            } else {
                nArray[0] = GDK.gdk_window_get_width(this.data.drawable);
                nArray2[0] = GDK.gdk_window_get_height(this.data.drawable);
            }
            return;
        }
        long l = Cairo.cairo_get_target(this.handle);
        switch (Cairo.cairo_surface_get_type(l)) {
            case 0: {
                nArray[0] = Cairo.cairo_image_surface_get_width(l);
                nArray2[0] = Cairo.cairo_image_surface_get_height(l);
                break;
            }
            case 3: {
                nArray[0] = Cairo.cairo_xlib_surface_get_width(l);
                nArray2[0] = Cairo.cairo_xlib_surface_get_height(l);
            }
        }
    }

    public int getTextAntialias() {
        long l;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L) {
            return -1;
        }
        int n = 0;
        if (this.data.context != 0L && (l = OS.pango_cairo_context_get_font_options(this.data.context)) != 0L) {
            n = Cairo.cairo_font_options_get_antialias(l);
        }
        switch (n) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public void getTransform(Transform transform) {
        long l;
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((l = this.data.cairo) != 0L) {
            transform.handle = this.currentTransform != null ? (double[])this.currentTransform.clone() : new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.xorMode;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    double[] identity() {
        double[] dArray = new double[6];
        if ((this.data.style & 0x8000000) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.getSize(nArray, nArray2);
            Cairo.cairo_matrix_init(dArray, -1.0, 0.0, 0.0, 1.0, nArray[0], 0.0);
        } else {
            Cairo.cairo_matrix_init_identity(dArray);
        }
        if (this.data.identity != null) {
            Cairo.cairo_matrix_multiply(dArray, this.data.identity, dArray);
        }
        return dArray;
    }

    void init(Drawable drawable, GCData gCData, long l) {
        Image image;
        if (gCData.foregroundRGBA != null) {
            gCData.state &= 0xFFFFFFFE;
        }
        if (gCData.backgroundRGBA != null) {
            gCData.state &= 0xFFFFFEFD;
        }
        if (gCData.font != null) {
            gCData.state &= 0xFFFFFFFB;
        }
        if ((image = gCData.image) != null) {
            image.memGC = this;
            if (image.transparentPixel != -1) {
                image.destroyMask();
            }
        }
        this.drawable = drawable;
        this.data = gCData;
        long l2 = gCData.cairo = (this.handle = l);
        Cairo.cairo_set_fill_rule(l2, 1);
        gCData.state &= 0xFFFFFD80;
        this.setClipping(gCData.clipRgn);
        this.initCairo();
        if ((gCData.style & 0x8000000) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.getSize(nArray, nArray2);
            Cairo.cairo_translate(l2, nArray[0], 0.0);
            Cairo.cairo_scale(l2, -1.0, 1.0);
        }
        if (this.cairoTransformationMatrix == null) {
            this.cairoTransformationMatrix = new double[6];
        }
        Cairo.cairo_get_matrix(gCData.cairo, this.cairoTransformationMatrix);
        this.clipping = this.getClipping();
    }

    void initCairo() {
        long l = this.data.cairo;
        if (l != 0L) {
            return;
        }
        if (GTK.GTK4) {
            long l2 = Cairo.cairo_image_surface_create(2, this.data.width, this.data.height);
            this.data.cairo = l = Cairo.cairo_create(l2);
        } else {
            this.data.cairo = l = Cairo.cairo_create(this.data.drawable);
        }
        if (l == 0L) {
            SWT.error(2);
        }
        this.data.disposeCairo = true;
        Cairo.cairo_set_fill_rule(l, 1);
        this.data.state &= 0xFFFFFD80;
        this.setCairoClip(this.data.damageRgn, this.data.clipRgn);
    }

    void computeStringSize() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_pixel_size(this.data.layout, nArray, nArray2);
        this.data.stringHeight = nArray2[0];
        this.data.stringWidth = nArray[0];
    }

    public boolean isClipped() {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        return this.data.clipRgn != 0L;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    boolean isIdentity(double[] dArray) {
        if (dArray == null) {
            return true;
        }
        return dArray[0] == 1.0 && dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[3] == 1.0 && dArray[4] == 0.0 && dArray[5] == 0.0;
    }

    public void setAdvanced(boolean bl) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (!bl) {
            this.setAlpha(255);
            this.setAntialias(-1);
            this.setBackgroundPattern(null);
            this.resetClipping();
            this.setForegroundPattern(null);
            this.setInterpolation(-1);
            this.setTextAntialias(-1);
            this.setTransform(null);
        }
    }

    public void setAlpha(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && (n & 0xFF) == 255) {
            return;
        }
        this.initCairo();
        this.data.alpha = n & 0xFF;
        this.data.state &= 0xFFFFFEFC;
    }

    public void setAntialias(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && n == -1) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case -1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        long l = this.data.cairo;
        Cairo.cairo_set_antialias(l, n2);
    }

    public void setBackground(Color color) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.backgroundRGBA = color.handle;
        this.data.backgroundPattern = null;
        this.data.state &= 0xFFFFFEFD;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0L && pattern == null) {
            return;
        }
        this.initCairo();
        if (this.data.backgroundPattern == pattern) {
            return;
        }
        this.data.backgroundPattern = pattern;
        this.data.state &= 0xFFFFFFFD;
    }

    static void setCairoFont(long l, Font font) {
        if (font == null || font.isDisposed()) {
            return;
        }
        GC.setCairoFont(l, font.handle);
    }

    static void setCairoFont(long l, long l2) {
        long l3 = OS.pango_font_description_get_family(l2);
        int n = C.strlen(l3);
        byte[] byArray = new byte[n + 1];
        C.memmove(byArray, l3, (long)n);
        double d = OS.PANGO_PIXELS(OS.pango_font_description_get_size(l2)) * 96 / 72;
        int n2 = OS.pango_font_description_get_style(l2);
        int n3 = OS.pango_font_description_get_weight(l2);
        int n4 = 0;
        if (n2 == 2) {
            n4 = 1;
        }
        if (n2 == 1) {
            n4 = 2;
        }
        int n5 = 0;
        if (n3 == 700) {
            n5 = 1;
        }
        Cairo.cairo_select_font_face(l, byArray, n4, n5);
        Cairo.cairo_set_font_size(l, d);
    }

    static void setCairoRegion(long l, long l2) {
        GDK.gdk_cairo_region(l, l2);
    }

    static void setCairoPatternColor(long l, int n, Color color, int n2) {
        GdkRGBA gdkRGBA = color.handle;
        Cairo.cairo_pattern_add_color_stop_rgba(l, n, gdkRGBA.red, gdkRGBA.green, gdkRGBA.blue, (float)n2 / 255.0f);
    }

    void setCairoClip(long l, long l2) {
        long l3 = this.data.cairo;
        Cairo.cairo_reset_clip(l3);
        if (l != 0L) {
            double[] dArray = new double[6];
            Cairo.cairo_get_matrix(l3, dArray);
            double[] dArray2 = new double[6];
            Cairo.cairo_matrix_init_identity(dArray2);
            Cairo.cairo_set_matrix(l3, dArray2);
            GC.setCairoRegion(l3, l);
            Cairo.cairo_clip(l3);
            Cairo.cairo_set_matrix(l3, dArray);
        }
        if (l2 != 0L) {
            long l4 = Cairo.cairo_region_create();
            Cairo.cairo_region_union(l4, l2);
            this.limitClipping(l4);
            GC.setCairoRegion(l3, l4);
            Cairo.cairo_clip(l3);
            Cairo.cairo_region_destroy(l4);
        }
    }

    private void limitClipping(long l) {
        Region region = new Region();
        if (this.currentTransform != null) {
            double[] dArray = (double[])this.currentTransform.clone();
            Cairo.cairo_matrix_invert(dArray);
            int[] nArray = GC.transformRectangle(dArray, this.clipping);
            if (GC.hasNoRotation(dArray)) {
                Rectangle rectangle = GC.getTransformedClippingRectangle(nArray);
                region.add(rectangle);
            } else {
                region.add(nArray);
            }
        } else {
            region.add(this.clipping);
        }
        Cairo.cairo_region_intersect(l, region.handle);
        region.dispose();
    }

    private static int[] transformRectangle(double[] dArray, Rectangle rectangle) {
        Point[] pointArray = new Point[]{new Point(rectangle.x, rectangle.y), new Point(rectangle.x + rectangle.width, rectangle.y), new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height), new Point(rectangle.x, rectangle.y + rectangle.height)};
        return GC.transformPoints(dArray, pointArray);
    }

    private static int[] transformPoints(double[] dArray, Point[] pointArray) {
        int[] nArray = new int[pointArray.length * 2];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        for (int i = 0; i < pointArray.length; ++i) {
            dArray2[0] = pointArray[i].x;
            dArray3[0] = pointArray[i].y;
            Cairo.cairo_matrix_transform_point(dArray, dArray2, dArray3);
            nArray[i * 2 + 0] = (int)Math.round(dArray2[0]);
            nArray[i * 2 + 1] = (int)Math.round(dArray3[0]);
        }
        return nArray;
    }

    private static boolean hasNoRotation(double[] dArray) {
        double d = dArray[1];
        double d2 = dArray[2];
        return d == 0.0 && d2 == 0.0;
    }

    private static Rectangle getTransformedClippingRectangle(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = nArray[4];
        int n6 = nArray[5];
        int n7 = nArray[6];
        int n8 = nArray[7];
        int n9 = Math.min(Math.min(n, n3), Math.min(n5, n7));
        int n10 = Math.min(Math.min(n2, n4), Math.min(n6, n8));
        int n11 = Math.abs(n - n3);
        int n12 = Math.abs(n2 - n8);
        Rectangle rectangle = new Rectangle(n9, n10, n11, n12);
        return rectangle;
    }

    void setClipping(long l) {
        if (l == 0L) {
            if (this.data.clipRgn != 0L) {
                Cairo.cairo_region_destroy(this.data.clipRgn);
                this.data.clipRgn = 0L;
            }
            this.data.clippingTransform = null;
            this.setCairoClip(this.data.damageRgn, 0L);
        } else {
            if (this.data.clipRgn == 0L) {
                this.data.clipRgn = Cairo.cairo_region_create();
            }
            Cairo.cairo_region_subtract(this.data.clipRgn, this.data.clipRgn);
            Cairo.cairo_region_union(this.data.clipRgn, l);
            this.data.clippingTransform = (double[])(this.currentTransform != null ? (double[])this.currentTransform.clone() : null);
            this.setCairoClip(this.data.damageRgn, l);
        }
    }

    public void setClipping(int n, int n2, int n3, int n4) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.setClippingInPixels(DPIUtil.autoScaleUp(this.drawable, n), DPIUtil.autoScaleUp(this.drawable, n2), DPIUtil.autoScaleUp(this.drawable, n3), DPIUtil.autoScaleUp(this.drawable, n4));
    }

    void setClippingInPixels(int n, int n2, int n3, int n4) {
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        cairo_rectangle_int_t cairo_rectangle_int_t2 = new cairo_rectangle_int_t();
        cairo_rectangle_int_t2.x = n;
        cairo_rectangle_int_t2.y = n2;
        cairo_rectangle_int_t2.width = n3;
        cairo_rectangle_int_t2.height = n4;
        long l = Cairo.cairo_region_create();
        Cairo.cairo_region_union_rectangle(l, cairo_rectangle_int_t2);
        this.setClipping(l);
        Cairo.cairo_region_destroy(l);
    }

    public void setClipping(Path path) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(44);
        }
        this.resetClipping();
        if (path != null) {
            this.initCairo();
            long l = this.data.cairo;
            long l2 = Cairo.cairo_copy_path(path.handle);
            if (l2 == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_append_path(l, l2);
            Cairo.cairo_path_destroy(l2);
            Cairo.cairo_clip(l);
        }
    }

    public void setClipping(Rectangle rectangle) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.setClippingInPixels(DPIUtil.autoScaleUp(this.drawable, rectangle));
    }

    void setClippingInPixels(Rectangle rectangle) {
        if (rectangle == null) {
            this.resetClipping();
        } else {
            this.setClippingInPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void resetClipping() {
        this.setClipping(this.clipping);
    }

    public void setClipping(Region region) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        if (region != null) {
            this.setClipping(region.handle);
        } else {
            this.resetClipping();
        }
    }

    public void setFont(Font font) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    public void setFillRule(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        int n2 = 1;
        switch (n) {
            case 2: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        Cairo.cairo_set_fill_rule(this.data.cairo, n2);
    }

    public void setForeground(Color color) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.foregroundRGBA = color.handle;
        this.data.foregroundPattern = null;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0L && pattern == null) {
            return;
        }
        this.initCairo();
        if (this.data.foregroundPattern == pattern) {
            return;
        }
        this.data.foregroundPattern = pattern;
        this.data.state &= 0xFFFFFFFE;
    }

    public void setInterpolation(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && n == -1) {
            return;
        }
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        this.data.interpolation = n;
    }

    public void setLineAttributes(LineAttributes lineAttributes) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (lineAttributes == null) {
            SWT.error(4);
        }
        lineAttributes.width = DPIUtil.autoScaleUp(this.drawable, lineAttributes.width);
        this.setLineAttributesInPixels(lineAttributes);
    }

    void setLineAttributesInPixels(LineAttributes lineAttributes) {
        float f;
        int n;
        int n2;
        int n3;
        int n4 = 0;
        float f2 = lineAttributes.width;
        if (f2 != this.data.lineWidth) {
            n4 |= 0x240;
        }
        if ((n3 = lineAttributes.style) != this.data.lineStyle) {
            n4 |= 8;
            switch (n3) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (lineAttributes.dash != null) break;
                    n3 = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((n2 = lineAttributes.join) != this.data.lineJoin) {
            n4 |= 0x20;
            switch (n2) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((n = lineAttributes.cap) != this.data.lineCap) {
            n4 |= 0x10;
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        float[] fArray = lineAttributes.dash;
        float[] fArray2 = this.data.lineDashes;
        if (fArray != null && fArray.length > 0) {
            boolean bl = fArray2 == null || fArray2.length != fArray.length;
            for (int i = 0; i < fArray.length; ++i) {
                float f3 = fArray[i];
                if (f3 <= 0.0f) {
                    SWT.error(5);
                }
                if (bl || fArray2[i] == f3) continue;
                bl = true;
            }
            if (bl) {
                float[] fArray3 = new float[fArray.length];
                System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
                fArray = fArray3;
                n4 |= 8;
            } else {
                fArray = fArray2;
            }
        } else if (fArray2 != null && fArray2.length > 0) {
            n4 |= 8;
        } else {
            fArray = fArray2;
        }
        float f4 = lineAttributes.dashOffset;
        if (f4 != this.data.lineDashesOffset) {
            n4 |= 8;
        }
        if ((f = lineAttributes.miterLimit) != this.data.lineMiterLimit) {
            n4 |= 0x80;
        }
        this.initCairo();
        if (n4 == 0) {
            return;
        }
        this.data.lineWidth = f2;
        this.data.lineStyle = n3;
        this.data.lineCap = n;
        this.data.lineJoin = n2;
        this.data.lineDashes = fArray;
        this.data.lineDashesOffset = f4;
        this.data.lineMiterLimit = f;
        this.data.state &= ~n4;
    }

    public void setLineCap(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineCap == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = n;
        this.data.state &= 0xFFFFFFEF;
    }

    public void setLineDash(int[] nArray) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        float[] fArray = this.data.lineDashes;
        if (nArray != null && nArray.length > 0) {
            int n;
            boolean bl = this.data.lineStyle != 6 || fArray == null || fArray.length != nArray.length;
            for (n = 0; n < nArray.length; ++n) {
                int n2 = nArray[n];
                if (n2 <= 0) {
                    SWT.error(5);
                }
                if (bl || fArray[n] == (float)n2) continue;
                bl = true;
            }
            if (!bl) {
                return;
            }
            this.data.lineDashes = new float[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                this.data.lineDashes[n] = nArray[n];
            }
            this.data.lineStyle = 6;
        } else {
            if (this.data.lineStyle == 1 && (fArray == null || fArray.length == 0)) {
                return;
            }
            this.data.lineDashes = null;
            this.data.lineStyle = 1;
        }
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineJoin(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineJoin == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = n;
        this.data.state &= 0xFFFFFFDF;
    }

    public void setLineStyle(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.lineStyle == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (this.data.lineDashes != null) break;
                n = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = n;
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineWidth(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        this.setLineWidthInPixels(DPIUtil.autoScaleUp(this.drawable, n));
    }

    void setLineWidthInPixels(int n) {
        if (this.data.lineWidth == (float)n) {
            return;
        }
        this.data.lineWidth = n;
        this.data.state &= 0xFFFFFDBF;
    }

    void setString(String string, int n) {
        byte[] byArray;
        int n2;
        if (this.data.layout == 0L) {
            this.createLayout();
        }
        if (string == this.data.string && (n & 0xFFFFFFFE) == (this.data.drawFlags & 0xFFFFFFFE)) {
            return;
        }
        int n3 = string.length();
        long l = this.data.layout;
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        if ((n & 8) != 0 && (n2 = this.fixMnemonic(cArray)) != -1) {
            char[] cArray2 = new char[n2 - 1];
            System.arraycopy(cArray, 0, cArray2, 0, cArray2.length);
            byte[] byArray2 = Converter.wcsToMbcs(cArray2, false);
            char[] cArray3 = new char[cArray.length - n2];
            System.arraycopy(cArray, n2 - 1, cArray3, 0, cArray3.length);
            byte[] byArray3 = Converter.wcsToMbcs(cArray3, false);
            byArray = new byte[byArray2.length + byArray3.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray, byArray2.length, byArray3.length);
            long l2 = OS.pango_attr_list_new();
            long l3 = OS.pango_attr_underline_new(3);
            PangoAttribute pangoAttribute = new PangoAttribute();
            OS.memmove(pangoAttribute, l3, (long)PangoAttribute.sizeof);
            pangoAttribute.start_index = byArray2.length;
            pangoAttribute.end_index = byArray2.length + 1;
            OS.memmove(l3, pangoAttribute, (long)PangoAttribute.sizeof);
            OS.pango_attr_list_insert(l2, l3);
            OS.pango_layout_set_attributes(l, l2);
            OS.pango_attr_list_unref(l2);
        } else {
            byArray = Converter.wcsToMbcs(cArray, false);
            OS.pango_layout_set_attributes(l, 0L);
        }
        OS.pango_layout_set_text(l, byArray, byArray.length);
        OS.pango_layout_set_single_paragraph_mode(l, (n & 2) == 0);
        OS.pango_layout_set_tabs(l, (n & 4) != 0 ? 0L : this.data.device.emptyTab);
        this.data.string = string;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
        this.data.drawFlags = n;
    }

    public void setTextAntialias(int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.data.cairo == 0L && n == -1) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case -1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.initCairo();
        long l = Cairo.cairo_font_options_create();
        Cairo.cairo_font_options_set_antialias(l, n2);
        if (this.data.context == 0L) {
            this.createLayout();
        }
        OS.pango_cairo_context_set_font_options(this.data.context, l);
        Cairo.cairo_font_options_destroy(l);
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.cairo == 0L && transform == null) {
            return;
        }
        this.initCairo();
        long l = this.data.cairo;
        if (this.currentTransform != null) {
            Cairo.cairo_set_matrix(l, this.cairoTransformationMatrix);
            this.currentTransform = null;
        }
        if (transform != null) {
            this.currentTransform = (double[])transform.handle.clone();
            double[] dArray = this.identity();
            Cairo.cairo_matrix_multiply(dArray, transform.handle, dArray);
            Cairo.cairo_transform(l, dArray);
        }
        this.data.state &= 0xFFFFFDFF;
    }

    public void setXORMode(boolean bl) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        Cairo.cairo_set_operator(this.handle, bl ? 23 : 2);
        this.data.xorMode = bl;
    }

    public Point stringExtent(String string) {
        return DPIUtil.autoScaleDown(this.drawable, this.stringExtentInPixels(string));
    }

    Point stringExtentInPixels(String string) {
        return this.textExtentInPixels(string, 0);
    }

    public Point textExtent(String string) {
        return DPIUtil.autoScaleDown(this.drawable, this.textExtentInPixels(string));
    }

    Point textExtentInPixels(String string) {
        return this.textExtentInPixels(string, 6);
    }

    public Point textExtent(String string, int n) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        return DPIUtil.autoScaleDown(this.drawable, this.textExtentInPixels(string, n));
    }

    Point textExtentInPixels(String string, int n) {
        this.setString(string, n);
        this.checkGC(4);
        if (this.data.stringWidth == -1) {
            this.computeStringSize();
        }
        return new Point(this.data.stringWidth, this.data.stringHeight);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

