/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;

public final class Cursor
extends Resource {
    public long handle;

    Cursor(Device device) {
        super(device);
    }

    public Cursor(Device device, int n) {
        super(device);
        String string = null;
        String string2 = null;
        switch (n) {
            case 3: {
                string = "left_ptr_watch";
                break;
            }
            case 0: {
                string = "left_ptr";
                break;
            }
            case 1: {
                string = "watch";
                break;
            }
            case 2: {
                string = "crosshair";
                break;
            }
            case 21: {
                string = "hand2";
                break;
            }
            case 4: {
                string = "question_arrow";
                break;
            }
            case 5: {
                string = "fleur";
                break;
            }
            case 6: {
                string = "size_bdiag";
                break;
            }
            case 7: {
                string = "sb_v_double_arrow";
                break;
            }
            case 8: {
                string = "size_fdiag";
                break;
            }
            case 9: {
                string = "sb_h_double_arrow";
                break;
            }
            case 10: {
                string = "top_side";
                break;
            }
            case 11: {
                string = "bottom_side";
                break;
            }
            case 12: {
                string = "right_side";
                break;
            }
            case 13: {
                string = "left_side";
                break;
            }
            case 14: {
                string = "top_right_corner";
                break;
            }
            case 15: {
                string = "bottom_right_corner";
                break;
            }
            case 16: {
                string = "bottom_left_corner";
                break;
            }
            case 17: {
                string = "top_left_corner";
                break;
            }
            case 18: {
                string = "sb_up_arrow";
                string2 = "up-arrow";
                break;
            }
            case 19: {
                string = "xterm";
                break;
            }
            case 20: {
                string = "crossed_circle";
                string2 = "not-allowed";
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        for (String string3 : new String[]{string, string2, "left_ptr", "default"}) {
            if (string3 == null) continue;
            this.handle = GTK.GTK4 ? GDK.gdk_cursor_new_from_name(string3, 0L) : GDK.gdk_cursor_new_from_name(GDK.gdk_display_get_default(), string3);
            if (this.handle != 0L) break;
        }
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData imageData, ImageData imageData2, int n, int n2) {
        super(device);
        byte by;
        int n3;
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            if (imageData.getTransparencyType() != 2) {
                SWT.error(4);
            }
            imageData2 = imageData.getTransparencyMask();
        }
        if (imageData2.width != imageData.width || imageData2.height != imageData.height) {
            SWT.error(5);
        }
        if (n >= imageData.width || n < 0 || n2 >= imageData.height || n2 < 0) {
            SWT.error(5);
        }
        imageData = ImageData.convertMask(imageData);
        imageData2 = ImageData.convertMask(imageData2);
        byte[] byArray = new byte[imageData.data.length];
        byte[] byArray2 = new byte[imageData2.data.length];
        byte[] byArray3 = imageData.data;
        for (n3 = 0; n3 < byArray3.length; ++n3) {
            by = byArray3[n3];
            byArray[n3] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            byArray[n3] = ~byArray[n3];
        }
        byArray = ImageData.convertPad(byArray, imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, 1);
        byArray3 = imageData2.data;
        for (n3 = 0; n3 < byArray3.length; ++n3) {
            by = byArray3[n3];
            byArray2[n3] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            byArray2[n3] = ~byArray2[n3];
        }
        byArray2 = ImageData.convertPad(byArray2, imageData2.width, imageData2.height, imageData2.depth, imageData2.scanlinePad, 1);
        this.handle = this.createCursor(byArray, byArray2, imageData.width, imageData.height, n, n2, true);
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    public Cursor(Device device, ImageData imageData, int n, int n2) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        if (n >= imageData.width || n < 0 || n2 >= imageData.height || n2 < 0) {
            SWT.error(5);
        }
        long l = GDK.gdk_display_get_default();
        int n3 = imageData.width;
        int n4 = imageData.height;
        PaletteData paletteData = imageData.palette;
        long l2 = GDK.gdk_pixbuf_new(0, true, 8, n3, n4);
        if (l2 == 0L) {
            SWT.error(2);
        }
        int n5 = GDK.gdk_pixbuf_get_rowstride(l2);
        long l3 = GDK.gdk_pixbuf_get_pixels(l2);
        byte[] byArray = imageData.data;
        if (!paletteData.isDirect || imageData.depth != 24 || n5 != imageData.bytesPerLine || paletteData.redMask != -16777216 || paletteData.greenMask != 0xFF0000 || paletteData.blueMask != 65280) {
            int n6;
            int n7;
            Object object;
            byArray = new byte[imageData.width * imageData.height * 4];
            if (paletteData.isDirect) {
                ImageData.blit(imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), imageData.width, imageData.height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, byArray, 32, imageData.width * 4, 1, imageData.width, imageData.height, -16777216, 0xFF0000, 65280, false, false);
            } else {
                object = paletteData.getRGBs();
                n7 = ((RGB[])object).length;
                byte[] byArray2 = new byte[n7];
                byte[] byArray3 = new byte[n7];
                byte[] byArray4 = new byte[n7];
                for (n6 = 0; n6 < ((RGB[])object).length; ++n6) {
                    RGB rGB = object[n6];
                    if (rGB == null) continue;
                    byArray2[n6] = (byte)rGB.red;
                    byArray3[n6] = (byte)rGB.green;
                    byArray4[n6] = (byte)rGB.blue;
                }
                ImageData.blit(imageData.width, imageData.height, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), byArray2, byArray3, byArray4, byArray, 32, imageData.width * 4, 1, -16777216, 0xFF0000, 65280);
            }
            if (imageData.maskData != null || imageData.transparentPixel != -1) {
                object = imageData.getTransparencyMask();
                byte[] byArray5 = object.data;
                int n8 = object.bytesPerLine;
                int n9 = 3;
                int n10 = 0;
                for (n6 = 0; n6 < imageData.height; ++n6) {
                    for (int i = 0; i < imageData.width; ++i) {
                        byArray[n9] = (byArray5[n10 + (i >> 3)] & 1 << 7 - (i & 7)) != 0 ? -1 : 0;
                        n9 += 4;
                    }
                    n10 += n8;
                }
            } else if (imageData.alpha != -1) {
                byte by = (byte)imageData.alpha;
                for (n7 = 3; n7 < byArray.length; n7 += 4) {
                    byArray[n7] = by;
                }
            } else if (imageData.alphaData != null) {
                object = imageData.alphaData;
                for (n7 = 3; n7 < byArray.length; n7 += 4) {
                    byArray[n7] = (byte)object[n7 / 4];
                }
            } else {
                for (int i = 3; i < byArray.length; i += 4) {
                    byArray[i] = -1;
                }
            }
        }
        C.memmove(l3, byArray, (long)(n5 * n4));
        if (GTK.GTK4) {
            long l4 = GDK.gdk_texture_new_for_pixbuf(l2);
            this.handle = GDK.gdk_cursor_new_from_texture(l4, n, n2, 0L);
            OS.g_object_unref(l4);
        } else {
            this.handle = GDK.gdk_cursor_new_from_pixbuf(l, l2, n, n2);
        }
        OS.g_object_unref(l2);
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    long createCursor(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, boolean bl) {
        long l;
        int n5;
        byte by;
        int n6;
        for (n6 = 0; n6 < byArray.length; ++n6) {
            by = byArray[n6];
            byArray[n6] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            byArray[n6] = ~byArray[n6];
        }
        for (n6 = 0; n6 < byArray2.length; ++n6) {
            by = byArray2[n6];
            byArray2[n6] = (byte)((by & 0x80) >> 7 | (by & 0x40) >> 5 | (by & 0x20) >> 3 | (by & 0x10) >> 1 | (by & 8) << 1 | (by & 4) << 3 | (by & 2) << 5 | (by & 1) << 7);
            byArray2[n6] = ~byArray2[n6];
        }
        PaletteData paletteData = new PaletteData(new RGB(0, 0, 0), new RGB(255, 255, 255));
        ImageData imageData = new ImageData(n, n2, 1, paletteData, 1, byArray);
        ImageData imageData2 = new ImageData(n, n2, 1, paletteData, 1, byArray2);
        byte[] byArray3 = new byte[imageData.width * imageData.height * 4];
        for (int i = 0; i < imageData.height; ++i) {
            int n7 = i * imageData.width * 4;
            for (n5 = 0; n5 < imageData.width; ++n5) {
                int n8 = imageData.getPixel(n5, i);
                int n9 = imageData2.getPixel(n5, i);
                if (n8 == 0 && n9 == 0) {
                    byArray3[n7 + 3] = -1;
                } else if (n8 == 0 && n9 == 1) {
                    byArray3[n7 + 3] = -1;
                    byArray3[n7 + 2] = -1;
                    byArray3[n7 + 1] = -1;
                    byArray3[n7] = -1;
                } else if (n8 != 1 || n9 == 0) {
                    // empty if block
                }
                n7 += 4;
            }
        }
        long l2 = GDK.gdk_pixbuf_new(0, true, 8, n, n2);
        if (l2 == 0L) {
            SWT.error(2);
        }
        n5 = GDK.gdk_pixbuf_get_rowstride(l2);
        long l3 = GDK.gdk_pixbuf_get_pixels(l2);
        C.memmove(l3, byArray3, (long)(n5 * n2));
        if (GTK.GTK4) {
            long l4 = GDK.gdk_texture_new_for_pixbuf(l2);
            l = GDK.gdk_cursor_new_from_texture(l4, n3, n4, 0L);
            OS.g_object_unref(l4);
        } else {
            l = GDK.gdk_cursor_new_from_pixbuf(GDK.gdk_display_get_default(), l2, n3, n4);
        }
        OS.g_object_unref(l2);
        return l;
    }

    @Override
    void destroy() {
        OS.g_object_unref(this.handle);
        this.handle = 0L;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public static Cursor gtk_new(Device device, long l) {
        Cursor cursor = new Cursor(device);
        cursor.handle = l;
        return cursor;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }
}

