/*
 * Decompiled with CFR 0.152.
 */
package gde.comm;

import gde.GDE;
import gde.comm.DeviceCommPort;
import gde.comm.DeviceJavaSerialCommPortImpl;
import gde.comm.IDeviceCommPort;
import gde.config.Settings;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.TcpPortType;
import gde.exception.ApplicationConfigurationException;
import gde.exception.FailedQueryException;
import gde.exception.ReadWriteOutOfSyncException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.usb.UsbClaimException;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotClaimedException;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsbException;

public class DeviceTcpPortImpl
extends DeviceCommPort
implements IDeviceCommPort {
    static final String $CLASS_NAME = DeviceTcpPortImpl.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    protected final DeviceConfiguration deviceConfig;
    protected final DataExplorer application;
    final Settings settings;
    protected Socket socket = null;
    protected int xferErrors = 0;
    protected int queryErrors = 0;
    protected int timeoutErrors = 0;
    boolean isConnected = false;
    TcpPortType tcpPortType;
    Thread closeThread;
    InputStream inputStream = null;
    OutputStream outputStream = null;

    public DeviceTcpPortImpl(DeviceConfiguration currentDeviceConfig, DataExplorer currentApplication) {
        this.deviceConfig = currentDeviceConfig;
        this.application = currentApplication;
        this.settings = Settings.getInstance();
    }

    public DeviceTcpPortImpl() {
        this.deviceConfig = null;
        this.application = null;
        this.settings = null;
    }

    @Override
    public Socket open() throws ApplicationConfigurationException, SerialPortException {
        String $METHOD_NAME = "open";
        this.timeoutErrors = 0;
        this.xferErrors = 0;
        try {
            this.tcpPortType = this.deviceConfig.getTcpPortType();
            if (this.tcpPortType != null && !this.tcpPortType.getAddress().contains(".") && !this.tcpPortType.getPort().isEmpty()) {
                throw new ApplicationConfigurationException("checkout network configuration, host/address and port");
            }
            String hostAddress = this.tcpPortType.getAddress();
            int port = Integer.parseInt(this.tcpPortType.getPort());
            this.socket = new Socket(hostAddress, port);
            log.logp(Level.FINE, DeviceJavaSerialCommPortImpl.$CLASS_NAME, "open", String.format("hostAddress = %s; port = %s", this.tcpPortType.getAddress(), this.tcpPortType.getPort()));
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
            this.isConnected = true;
            if (this.application != null) {
                this.application.setPortConnected(true);
            }
        }
        catch (ApplicationConfigurationException e) {
            log.logp(Level.SEVERE, DeviceJavaSerialCommPortImpl.$CLASS_NAME, "open", e.getMessage(), e);
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException port) {
                    // empty catch block
                }
            }
            throw e;
        }
        catch (Throwable e) {
            SerialPortException en = new SerialPortException(e.getMessage());
            log.logp(Level.SEVERE, $CLASS_NAME, "open", e.getMessage(), e);
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw en;
        }
        return this.socket;
    }

    @Override
    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.isConnected = false;
        if (this.application != null) {
            this.application.setPortConnected(false);
        }
    }

    @Override
    public synchronized void write(byte[] writeBuffer) throws IOException {
        String $METHOD_NAME = "write";
        try {
            if (this.application != null) {
                this.application.setSerialTxOn();
            }
            this.cleanInputStream();
            this.outputStream.write(writeBuffer);
            this.outputStream.flush();
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "write", "Write : " + StringHelper.byte2Hex2CharString(writeBuffer, writeBuffer.length));
            }
        }
        catch (IOException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "write", e.getMessage(), e);
            throw e;
        }
        finally {
            if (this.application != null) {
                this.application.setSerialTxOff();
            }
        }
    }

    @Override
    public synchronized void write(byte[] writeBuffer, long gap_ms) throws IOException {
        String $METHOD_NAME = "write";
        try {
            if (this.application != null) {
                this.application.setSerialTxOn();
            }
            this.cleanInputStream();
            for (int i = 0; i < writeBuffer.length; ++i) {
                this.outputStream.write(writeBuffer[i]);
                WaitTimer.delay(gap_ms);
            }
            if (GDE.IS_LINUX && GDE.IS_ARCH_DATA_MODEL_64) {
                this.outputStream.flush();
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "write", "Write : " + StringHelper.byte2Hex2CharString(writeBuffer, writeBuffer.length));
            }
        }
        catch (IOException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "write", e.getMessage(), e);
            throw e;
        }
        finally {
            if (this.application != null) {
                this.application.setSerialTxOff();
            }
        }
    }

    @Override
    public int cleanInputStream() throws IOException {
        String $METHOD_NAME = "cleanInputStream";
        int num = 0;
        num = this.inputStream.available();
        if (num != 0) {
            this.inputStream.read(new byte[num]);
            log.logp(Level.WARNING, $CLASS_NAME, "cleanInputStream", "clean inputStream left bytes -> " + num);
        }
        return num;
    }

    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec) throws IOException, TimeOutException {
        String $METHOD_NAME = "read";
        int sleepTime = 2;
        int bytes = readBuffer.length;
        int readBytes = 0;
        int timeOutCounter = timeout_msec / (sleepTime + 18);
        try {
            if (this.application != null) {
                this.application.setSerialRxOn();
            }
            this.wait4Bytes(bytes, timeout_msec - timeout_msec / 5);
            while (bytes != readBytes && timeOutCounter-- > 0) {
                if (this.inputStream.available() > 0) {
                    readBytes += this.inputStream.read(readBuffer, 0 + readBytes, bytes - readBytes);
                }
                if (bytes != readBytes) {
                    WaitTimer.delay(sleepTime);
                }
                if (timeOutCounter > 0) continue;
                TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{bytes, timeout_msec}));
                log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
                log.logp(Level.SEVERE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
                throw e;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
            }
        }
        catch (IOException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        finally {
            if (this.application != null) {
                this.application.setSerialRxOff();
            }
        }
        return readBuffer;
    }

    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec, boolean checkFailedQuery) throws IOException, FailedQueryException, TimeOutException {
        String $METHOD_NAME = "read";
        int sleepTime = 10;
        int bytes = readBuffer.length;
        int readBytes = 0;
        int timeOutCounter = timeout_msec / (sleepTime + 18);
        try {
            if (this.application != null) {
                this.application.setSerialRxOn();
            }
            WaitTimer.delay(2L);
            while (bytes != readBytes && timeOutCounter-- > 0) {
                if (this.inputStream.available() > 0) {
                    readBytes += this.inputStream.read(readBuffer, 0 + readBytes, bytes - readBytes);
                }
                if (bytes != readBytes) {
                    WaitTimer.delay(sleepTime);
                }
                if (timeOutCounter > 0) continue;
                TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{bytes, timeout_msec}));
                log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
                log.logp(Level.SEVERE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
                throw e;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
            }
        }
        catch (IOException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        finally {
            if (this.application != null) {
                this.application.setSerialRxOff();
            }
        }
        return readBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec, Vector<Long> waitTimes) throws IOException, TimeOutException {
        String $METHOD_NAME = "read";
        int sleepTime = 4;
        int bytes = readBuffer.length;
        int readBytes = 0;
        int timeOutCounter = timeout_msec / sleepTime;
        try {
            if (this.application != null) {
                this.application.setSerialRxOn();
            }
            long startTime_ms = new Date().getTime();
            this.wait4Bytes(timeout_msec);
            while (bytes != readBytes && timeOutCounter-- > 0) {
                if (bytes == (readBytes += this.inputStream.read(readBuffer, readBytes, bytes - readBytes))) continue;
                WaitTimer.delay(sleepTime);
            }
            if (timeOutCounter <= 0) {
                TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{bytes, timeout_msec}));
                log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
                log.logp(Level.SEVERE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
                throw e;
            }
            long ms = new Date().getTime() - startTime_ms;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "read", "waitTime = " + ms);
            }
            waitTimes.add(ms);
            log.logp(Level.FINE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
        }
        catch (IOException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        catch (InterruptedException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "read", e.getMessage(), e);
        }
        finally {
            if (this.application != null) {
                this.application.setSerialRxOff();
            }
        }
        return readBuffer;
    }

    @Override
    public long wait4Bytes(int timeout_msec) throws InterruptedException, TimeOutException, IOException {
        String $METHOD_NAME = "wait4Bytes";
        int sleepTime = 1;
        int timeOutCounter = timeout_msec / sleepTime;
        while (0 == this.inputStream.available()) {
            WaitTimer.delay(sleepTime);
            if (timeOutCounter-- > 0) continue;
            TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{"*", timeout_msec}));
            log.logp(Level.WARNING, $CLASS_NAME, "wait4Bytes", e.getMessage(), e);
            throw e;
        }
        return System.currentTimeMillis();
    }

    @Override
    public int wait4Bytes(int numBytes, int timeout_msec) throws IOException {
        String $METHOD_NAME = "wait4Bytes";
        int sleepTime = 1;
        int timeOutCounter = timeout_msec / sleepTime;
        int resBytes = 0;
        while ((resBytes = this.inputStream.available()) < numBytes) {
            WaitTimer.delay(sleepTime);
            if (--timeOutCounter > 0) continue;
            log.logp(Level.WARNING, $CLASS_NAME, "wait4Bytes", String.format("only %d of %d Bytes are available in %d msec", resBytes, numBytes, timeout_msec));
            break;
        }
        return resBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec, int stableIndex) throws IOException, TimeOutException {
        String $METHOD_NAME = "read";
        int sleepTime = 4;
        int numAvailableBytes = readBuffer.length;
        int readBytes = 0;
        int timeOutCounter = timeout_msec / sleepTime;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "entry");
        }
        if (stableIndex >= timeOutCounter) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", Messages.getString("GDE_MSGE0013"));
        }
        try {
            if (this.application != null) {
                this.application.setSerialRxOn();
            }
            if ((numAvailableBytes = this.waitForStableReceiveBuffer(numAvailableBytes, timeout_msec, stableIndex)) > readBuffer.length) {
                readBuffer = new byte[numAvailableBytes];
            }
            while (readBytes < numAvailableBytes && timeOutCounter-- > 0) {
                if (numAvailableBytes == (readBytes += this.inputStream.read(readBuffer, 0 + readBytes, numAvailableBytes - readBytes))) continue;
                WaitTimer.delay(sleepTime);
            }
            if (timeOutCounter <= 0) {
                TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{numAvailableBytes, timeout_msec}));
                log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
                log.logp(Level.SEVERE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
                throw e;
            }
            if (readBytes < readBuffer.length) {
                byte[] tmpBuffer = new byte[readBytes];
                System.arraycopy(readBuffer, 0, tmpBuffer, 0, readBytes);
                readBuffer = tmpBuffer;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
            }
        }
        catch (IndexOutOfBoundsException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        catch (IOException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        catch (InterruptedException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "read", e.getMessage(), e);
        }
        finally {
            if (this.application != null) {
                this.application.setSerialRxOff();
            }
        }
        return readBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] read(byte[] readBuffer, int timeout_msec, int stableIndex, int minCountBytes) throws IOException, TimeOutException {
        String $METHOD_NAME = "read";
        int sleepTime = 4;
        int expectedBytes = readBuffer.length;
        int readBytes = 0;
        int timeOutCounter = timeout_msec / sleepTime;
        if (stableIndex >= timeOutCounter) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", Messages.getString("GDE_MSGE0013"));
        }
        try {
            if (this.application != null) {
                this.application.setSerialRxOn();
            }
            expectedBytes = this.waitForStableReceiveBuffer(expectedBytes, timeout_msec, stableIndex, minCountBytes);
            while (readBytes < expectedBytes && timeOutCounter-- > 0) {
                if (expectedBytes == (readBytes += this.inputStream.read(readBuffer, 0 + readBytes, expectedBytes - readBytes))) continue;
                WaitTimer.delay(sleepTime);
            }
            if (timeOutCounter <= 0) {
                TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{expectedBytes, timeout_msec}));
                log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
                log.logp(Level.SEVERE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
                throw e;
            }
            if (readBytes < readBuffer.length) {
                byte[] tmpBuffer = new byte[readBytes];
                System.arraycopy(readBuffer, 0, tmpBuffer, 0, readBytes);
                readBuffer = tmpBuffer;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "read", "  Read : " + StringHelper.byte2Hex2CharString(readBuffer, readBytes));
            }
        }
        catch (IndexOutOfBoundsException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        catch (IOException e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "read", e.getMessage(), e);
            throw e;
        }
        catch (InterruptedException e) {
            log.logp(Level.WARNING, $CLASS_NAME, "read", e.getMessage(), e);
        }
        finally {
            if (this.application != null) {
                this.application.setSerialRxOff();
            }
        }
        return readBuffer;
    }

    @Override
    public int waitForStableReceiveBuffer(int expectedBytes, int timeout_msec, int stableIndex) throws InterruptedException, TimeOutException, IOException {
        String $METHOD_NAME = "waitForStableReceiveBuffer";
        int sleepTime = 1;
        int timeOutCounter = timeout_msec / sleepTime;
        int stableCounter = stableIndex;
        boolean isStable = false;
        boolean isTimedOut = false;
        int byteCounter = 0;
        int numBytesAvailable = 0;
        while (byteCounter < expectedBytes && !isStable && !isTimedOut) {
            WaitTimer.delay(sleepTime);
            numBytesAvailable = this.inputStream.available();
            if (byteCounter == numBytesAvailable && byteCounter > 0) {
                if (log.isLoggable(Level.FINER)) {
                    log.logp(Level.FINER, $CLASS_NAME, "waitForStableReceiveBuffer", "stableCounter = " + stableCounter + " byteCounter = " + byteCounter);
                }
                --stableCounter;
            } else {
                stableCounter = stableIndex;
            }
            if (stableCounter == 0) {
                isStable = true;
            }
            byteCounter = numBytesAvailable;
            if (--timeOutCounter != 0) continue;
            log.logp(Level.SEVERE, $CLASS_NAME, "waitForStableReceiveBuffer", String.format("byteCounter = %d numBytesAvailable = %d", byteCounter, numBytesAvailable));
            TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{expectedBytes, timeout_msec}));
            throw e;
        }
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, $CLASS_NAME, "waitForStableReceiveBuffer", "byteCounter = " + byteCounter + " timeOutCounter = " + timeOutCounter);
        }
        return byteCounter;
    }

    @Override
    public int waitForStableReceiveBuffer(int expectedBytes, int timeout_msec, int stableIndex, int minCount) throws InterruptedException, TimeOutException, IOException {
        String $METHOD_NAME = "waitForStableReceiveBuffer";
        int sleepTime = 1;
        int timeOutCounter = timeout_msec / sleepTime;
        int stableCounter = stableIndex;
        boolean isStable = false;
        boolean isTimedOut = false;
        int byteCounter = 0;
        int numBytesAvailable = 0;
        while (byteCounter < expectedBytes && !isStable && !isTimedOut) {
            WaitTimer.delay(sleepTime);
            numBytesAvailable = this.inputStream.available();
            if (byteCounter == numBytesAvailable && byteCounter > minCount) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, $CLASS_NAME, "waitForStableReceiveBuffer", "stableCounter = " + stableCounter + " byteCounter = " + byteCounter);
                }
                --stableCounter;
            } else {
                stableCounter = stableIndex;
            }
            if (stableCounter == 0) {
                isStable = true;
            }
            byteCounter = numBytesAvailable;
            if (--timeOutCounter != 0) continue;
            TimeOutException e = new TimeOutException(Messages.getString("GDE_MSGE0011", new Object[]{expectedBytes, timeout_msec}));
            log.logp(Level.SEVERE, $CLASS_NAME, "waitForStableReceiveBuffer", e.getMessage(), e);
            throw e;
        }
        log.logp(Level.FINE, $CLASS_NAME, "waitForStableReceiveBuffer", "byteCounter = " + byteCounter + " timeOutCounter = " + timeOutCounter);
        return byteCounter;
    }

    public void checkForLeftBytes() throws ReadWriteOutOfSyncException, IOException {
        String $METHOD_NAME = "checkForLeftBytes";
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, $CLASS_NAME, "checkForLeftBytes", "inputStream available bytes = " + this.inputStream.available());
        }
        if (this.inputStream.available() != 0) {
            throw new ReadWriteOutOfSyncException(Messages.getString("GDE_MSGE0014"));
        }
    }

    @Override
    public int getAvailableBytes() throws IOException {
        return this.inputStream.available();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    public String getSerialPortStr() {
        return "";
    }

    @Override
    public int getXferErrors() {
        return this.xferErrors;
    }

    @Override
    public void addXferError() {
        ++this.xferErrors;
    }

    @Override
    public void addTimeoutError() {
        ++this.timeoutErrors;
    }

    @Override
    public int getTimeoutErrors() {
        return this.timeoutErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Logger logger = Logger.getLogger("");
        logger.setLevel(Level.OFF);
        DeviceTcpPortImpl impl = new DeviceTcpPortImpl();
        byte[] buffer = new byte[1024];
        byte[] writeBuf = new byte[]{81, 13, 10};
        try {
            impl.socket = new Socket("192.168.25.40", 23000);
            OutputStream output = impl.socket.getOutputStream();
            InputStream input = impl.socket.getInputStream();
            for (int i = 0; i < 5; ++i) {
                System.out.println(StringHelper.byte2Hex2CharString(writeBuf, writeBuf.length));
                System.out.print(new String(writeBuf));
                output.write(writeBuf);
                output.flush();
                if (input.read(buffer) <= 0) continue;
                System.out.println(new String(buffer));
            }
            impl.socket.close();
            impl.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            impl.close();
        }
    }

    @Override
    public Set<UsbDevice> findUsbDevices(short vendorId, short productId) throws UsbException {
        return null;
    }

    @Override
    public Set<UsbDevice> findDevices(UsbHub hub, short vendorId, short productId) {
        return null;
    }

    @Override
    public void dumpUsbDevices(short vendorId, short productId) throws UsbException {
    }

    @Override
    public UsbInterface openUsbPort(IDevice activeDevice) throws UsbClaimException, UsbException {
        return null;
    }

    @Override
    public DeviceHandle openLibUsbPort(IDevice activeDevice) throws LibUsbException, UsbException {
        return null;
    }

    @Override
    public void closeUsbPort(UsbInterface usbInterface) throws UsbClaimException, UsbException {
    }

    @Override
    public void closeLibUsbPort(DeviceHandle libUsbDeviceHanlde, boolean cacheSelectedUsbDevice) throws LibUsbException, UsbException {
    }

    @Override
    public int write(UsbInterface iface, byte endpointAddress, byte[] data) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        return 0;
    }

    @Override
    public int read(UsbInterface iface, byte endpointAddress, byte[] data) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        return 0;
    }

    @Override
    public int read(UsbInterface iface, byte endpointAddress, byte[] data, int timeout_msec) throws UsbNotActiveException, UsbNotClaimedException, UsbDisconnectedException, UsbException {
        return 0;
    }

    @Override
    public void write(DeviceHandle handle, byte outEndpoint, byte[] data, long timeout_ms) throws IllegalStateException, TimeOutException {
    }

    @Override
    public int read(DeviceHandle handle, byte inEndpoint, byte[] data, long timeout_ms) throws IllegalStateException, TimeOutException {
        return 0;
    }
}

