/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonPatch;
import javax.json.JsonPatchBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.glassfish.json.JsonPatchImpl;

public final class JsonPatchBuilderImpl
implements JsonPatchBuilder {
    private final JsonArrayBuilder builder;

    public JsonPatchBuilderImpl(JsonArray patch2) {
        this.builder = Json.createArrayBuilder(patch2);
    }

    public JsonPatchBuilderImpl() {
        this.builder = Json.createArrayBuilder();
    }

    public <T extends JsonStructure> T apply(T target) {
        return this.build().apply(target);
    }

    @Override
    public JsonPatchBuilder add(String path2, JsonValue value) {
        this.builder.add(Json.createObjectBuilder().add("op", JsonPatch.Operation.ADD.operationName()).add("path", path2).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder add(String path2, String value) {
        this.builder.add(Json.createObjectBuilder().add("op", JsonPatch.Operation.ADD.operationName()).add("path", path2).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder add(String path2, int value) {
        this.builder.add(Json.createObjectBuilder().add("op", JsonPatch.Operation.ADD.operationName()).add("path", path2).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder add(String path2, boolean value) {
        this.builder.add(Json.createObjectBuilder().add("op", JsonPatch.Operation.ADD.operationName()).add("path", path2).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder remove(String path2) {
        this.builder.add(Json.createObjectBuilder().add("op", JsonPatch.Operation.REMOVE.operationName()).add("path", path2));
        return this;
    }

    @Override
    public JsonPatchBuilder replace(String path2, JsonValue value) {
        this.builder.add(Json.createObjectBuilder().add("op", JsonPatch.Operation.REPLACE.operationName()).add("path", path2).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder replace(String path2, String value) {
        this.builder.add(Json.createObjectBuilder().add("op", JsonPatch.Operation.REPLACE.operationName()).add("path", path2).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder replace(String path2, int value) {
        this.builder.add(Json.createObjectBuilder().add("op", JsonPatch.Operation.REPLACE.operationName()).add("path", path2).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder replace(String path2, boolean value) {
        this.builder.add(Json.createObjectBuilder().add("op", JsonPatch.Operation.REPLACE.operationName()).add("path", path2).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder move(String path2, String from) {
        this.builder.add(Json.createObjectBuilder().add("op", JsonPatch.Operation.MOVE.operationName()).add("path", path2).add("from", from));
        return this;
    }

    @Override
    public JsonPatchBuilder copy(String path2, String from) {
        this.builder.add(Json.createObjectBuilder().add("op", JsonPatch.Operation.COPY.operationName()).add("path", path2).add("from", from));
        return this;
    }

    @Override
    public JsonPatchBuilder test(String path2, JsonValue value) {
        this.builder.add(Json.createObjectBuilder().add("op", JsonPatch.Operation.TEST.operationName()).add("path", path2).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder test(String path2, String value) {
        this.builder.add(Json.createObjectBuilder().add("op", JsonPatch.Operation.TEST.operationName()).add("path", path2).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder test(String path2, int value) {
        this.builder.add(Json.createObjectBuilder().add("op", JsonPatch.Operation.TEST.operationName()).add("path", path2).add("value", value));
        return this;
    }

    @Override
    public JsonPatchBuilder test(String path2, boolean value) {
        this.builder.add(Json.createObjectBuilder().add("op", JsonPatch.Operation.TEST.operationName()).add("path", path2).add("value", value));
        return this;
    }

    public JsonArray buildAsJsonArray() {
        return this.builder.build();
    }

    @Override
    public JsonPatch build() {
        return new JsonPatchImpl(this.buildAsJsonArray());
    }
}

