/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.custom.CLayoutData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

class CBannerLayout
extends Layout {
    CBannerLayout() {
    }

    @Override
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        CBanner banner = (CBanner)composite;
        Control left2 = banner.left;
        Control right2 = banner.right;
        Control bottom2 = banner.bottom;
        boolean showCurve = left2 != null && right2 != null;
        int height = hHint;
        int width = wHint;
        Point bottomSize = new Point(0, 0);
        if (bottom2 != null) {
            int trim = this.computeTrim(bottom2);
            int w = wHint == -1 ? -1 : Math.max(0, width - trim);
            bottomSize = this.computeChildSize(bottom2, w, -1, flushCache);
        }
        Point rightSize = new Point(0, 0);
        if (right2 != null) {
            int trim = this.computeTrim(right2);
            int w = -1;
            if (banner.rightWidth != -1) {
                w = banner.rightWidth - trim;
                if (left2 != null) {
                    w = Math.min(w, width - banner.curve_width + 2 * banner.curve_indent - 10 - trim);
                }
                w = Math.max(0, w);
            }
            rightSize = this.computeChildSize(right2, w, -1, flushCache);
            if (wHint != -1) {
                width -= rightSize.x + banner.curve_width - 2 * banner.curve_indent;
            }
        }
        Point leftSize = new Point(0, 0);
        if (left2 != null) {
            int trim = this.computeTrim(left2);
            int w = wHint == -1 ? -1 : Math.max(0, width - trim);
            leftSize = this.computeChildSize(left2, w, -1, flushCache);
        }
        width = leftSize.x + rightSize.x;
        height = bottomSize.y;
        if (bottom2 != null && (left2 != null || right2 != null)) {
            height += 3;
        }
        height = left2 != null ? (right2 == null ? (height += leftSize.y) : (height += Math.max(leftSize.y, banner.rightMinHeight == -1 ? rightSize.y : banner.rightMinHeight))) : (height += rightSize.y);
        if (showCurve) {
            width += banner.curve_width - 2 * banner.curve_indent;
            height += 7;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    Point computeChildSize(Control control, int wHint, int hHint, boolean flushCache) {
        Object data2 = control.getLayoutData();
        if (data2 == null || !(data2 instanceof CLayoutData)) {
            data2 = new CLayoutData();
            control.setLayoutData(data2);
        }
        return ((CLayoutData)data2).computeSize(control, wHint, hHint, flushCache);
    }

    int computeTrim(Control c) {
        if (c instanceof Scrollable) {
            Rectangle rect = ((Scrollable)c).computeTrim(0, 0, 0, 0);
            return rect.width;
        }
        return c.getBorderWidth() * 2;
    }

    @Override
    protected boolean flushCache(Control control) {
        Object data2 = control.getLayoutData();
        if (data2 != null && data2 instanceof CLayoutData) {
            ((CLayoutData)data2).flushCache();
        }
        return true;
    }

    @Override
    protected void layout(Composite composite, boolean flushCache) {
        CBanner banner = (CBanner)composite;
        Control left2 = banner.left;
        Control right2 = banner.right;
        Control bottom2 = banner.bottom;
        Point size = banner.getSize();
        boolean showCurve = left2 != null && right2 != null;
        int width = size.x - 2 * banner.getBorderWidth();
        int height = size.y - 2 * banner.getBorderWidth();
        Point bottomSize = new Point(0, 0);
        if (bottom2 != null) {
            int trim = this.computeTrim(bottom2);
            int w = Math.max(0, width - trim);
            bottomSize = this.computeChildSize(bottom2, w, -1, flushCache);
            height -= bottomSize.y + 1 + 2;
        }
        if (showCurve) {
            height -= 7;
        }
        height = Math.max(0, height);
        Point rightSize = new Point(0, 0);
        if (right2 != null) {
            int trim = this.computeTrim(right2);
            int w = -1;
            if (banner.rightWidth != -1) {
                w = banner.rightWidth - trim;
                if (left2 != null) {
                    w = Math.min(w, width - banner.curve_width + 2 * banner.curve_indent - 10 - trim);
                }
                w = Math.max(0, w);
            }
            rightSize = this.computeChildSize(right2, w, -1, flushCache);
            width -= rightSize.x - banner.curve_indent + banner.curve_width - banner.curve_indent;
        }
        Point leftSize = new Point(0, 0);
        if (left2 != null) {
            int trim = this.computeTrim(left2);
            int w = Math.max(0, width - trim);
            leftSize = this.computeChildSize(left2, w, -1, flushCache);
        }
        int x = 0;
        int y = 0;
        int oldStart = banner.curveStart;
        Rectangle leftRect = null;
        Rectangle rightRect = null;
        Rectangle bottomRect = null;
        if (bottom2 != null) {
            bottomRect = new Rectangle(x, y + size.y - bottomSize.y, bottomSize.x, bottomSize.y);
        }
        if (showCurve) {
            y += 4;
        }
        if (left2 != null) {
            leftRect = new Rectangle(x, y, leftSize.x, leftSize.y);
            banner.curveStart = x + leftSize.x - banner.curve_indent;
            x += leftSize.x - banner.curve_indent + banner.curve_width - banner.curve_indent;
        }
        if (right2 != null) {
            if (left2 != null) {
                rightSize.y = Math.max(leftSize.y, banner.rightMinHeight == -1 ? rightSize.y : banner.rightMinHeight);
            }
            rightRect = new Rectangle(x, y, rightSize.x, rightSize.y);
        }
        if (banner.curveStart < oldStart) {
            banner.redraw(banner.curveStart - 200, 0, oldStart + banner.curve_width - banner.curveStart + 200 + 5, size.y, false);
        }
        if (banner.curveStart > oldStart) {
            banner.redraw(oldStart - 200, 0, banner.curveStart + banner.curve_width - oldStart + 200 + 5, size.y, false);
        }
        banner.update();
        banner.curveRect = new Rectangle(banner.curveStart, 0, banner.curve_width, size.y);
        if (bottomRect != null) {
            bottom2.setBounds(bottomRect);
        }
        if (rightRect != null) {
            right2.setBounds(rightRect);
        }
        if (leftRect != null) {
            left2.setBounds(leftRect);
        }
    }
}

