/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.menu;

import gde.config.Settings;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ObjectImageContextMenu {
    static final Logger log = Logger.getLogger(ObjectImageContextMenu.class.getName());
    public static final String OBJECT_IMAGE_PATH = "OBJECT_IMAGE_PATH";
    public static final String OBJECT_IMAGE_CHANGED = "OBJECT_IMAGE_CHANGED";
    Menu menu;
    final DataExplorer application = DataExplorer.getInstance();

    public void createMenu(Menu popupMenu) {
        this.menu = popupMenu;
        MenuItem newItem = new MenuItem(this.menu, 8);
        newItem.setText(Messages.getString("GDE_MSGT0430"));
        newItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "newItem action performed! " + String.valueOf(e));
                ObjectImageContextMenu.this.chooseImageFile();
            }
        });
        MenuItem deleteItem = new MenuItem(this.menu, 8);
        deleteItem.setText(Messages.getString("GDE_MSGT0432"));
        deleteItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int answer = ObjectImageContextMenu.this.application.openYesNoMessageDialog(Messages.getString("GDE_MSGW0047"));
                if (answer == 64) {
                    log.log(Level.FINEST, "deleteItem action performed! " + String.valueOf(e));
                    ObjectImageContextMenu.this.menu.setData(ObjectImageContextMenu.OBJECT_IMAGE_CHANGED, (Object)true);
                    ObjectImageContextMenu.this.menu.setData(ObjectImageContextMenu.OBJECT_IMAGE_PATH, null);
                    ObjectImageContextMenu.this.application.updateObjectImage();
                }
            }
        });
    }

    public void chooseImageFile() {
        FileDialog imgFileDialog = this.application.openFileOpenDialog(Messages.getString("GDE_MSGT0431"), new String[]{"*.jpg", "*.png", "*.gif"}, Settings.getInstance().getObjectImageFilePath(), null, 4);
        String imgFilePath = imgFileDialog.getFilterPath();
        log.log(Level.FINE, "imgFilePath = " + imgFilePath);
        if (imgFileDialog.getFileName().length() > 4) {
            if (!Settings.getInstance().getObjectImageFilePath().equalsIgnoreCase(imgFileDialog.getFilterPath().replace('\\', '/'))) {
                Settings.getInstance().setObjectImageFilePath(imgFileDialog.getFilterPath().replace('\\', '/'));
            }
            this.menu.setData(OBJECT_IMAGE_CHANGED, (Object)true);
            this.menu.setData(OBJECT_IMAGE_PATH, (Object)(imgFilePath + "/" + imgFileDialog.getFileName()));
            this.application.updateObjectImage();
        }
    }
}

