/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class TreeItem
extends Item {
    Tree parent;
    Font font;
    Font[] cellFont;
    String[] strings;
    boolean cached;
    boolean grayed;
    boolean isExpanded;
    boolean updated;
    boolean settingData;
    static final int EXPANDER_EXTRA_PADDING = 4;

    public TreeItem(Tree tree, int n) {
        this(TreeItem.checkNull(tree), 0L, n, -1, true);
    }

    public TreeItem(Tree tree, int n, int n2) {
        this(TreeItem.checkNull(tree), 0L, n, TreeItem.checkIndex(n2), true);
    }

    public TreeItem(TreeItem treeItem, int n) {
        this(TreeItem.checkNull((TreeItem)treeItem).parent, treeItem.handle, n, -1, true);
    }

    public TreeItem(TreeItem treeItem, int n, int n2) {
        this(TreeItem.checkNull((TreeItem)treeItem).parent, treeItem.handle, n, TreeItem.checkIndex(n2), true);
    }

    TreeItem(Tree tree, long l, int n, int n2, boolean bl) {
        super(tree, n);
        this.parent = tree;
        if (bl) {
            tree.createItem(this, l, n2);
        } else {
            this.handle = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            GTK.gtk_tree_model_iter_nth_child(tree.modelHandle, this.handle, l, n2);
        }
    }

    static int checkIndex(int n) {
        if (n < 0) {
            SWT.error(6);
        }
        return n;
    }

    static TreeItem checkNull(TreeItem treeItem) {
        if (treeItem == null) {
            SWT.error(4);
        }
        return treeItem;
    }

    static Tree checkNull(Tree tree) {
        if (tree == null) {
            SWT.error(4);
        }
        return tree;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    Color _getBackground() {
        long[] lArray = new long[1];
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, 4, lArray, -1);
        if (lArray[0] == 0L) {
            return this.parent.getBackground();
        }
        GdkRGBA gdkRGBA = new GdkRGBA();
        OS.memmove(gdkRGBA, lArray[0], (long)GdkRGBA.sizeof);
        GDK.gdk_rgba_free(lArray[0]);
        return Color.gtk_new(this.display, gdkRGBA);
    }

    Color _getBackground(int n) {
        int n2 = Math.max(1, this.parent.columnCount);
        if (0 > n || n > n2 - 1) {
            return this._getBackground();
        }
        long[] lArray = new long[1];
        int n3 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, n3 + 3, lArray, -1);
        if (lArray[0] == 0L) {
            return this._getBackground();
        }
        GdkRGBA gdkRGBA = new GdkRGBA();
        OS.memmove(gdkRGBA, lArray[0], (long)GdkRGBA.sizeof);
        GDK.gdk_rgba_free(lArray[0]);
        return Color.gtk_new(this.display, gdkRGBA);
    }

    boolean _getChecked() {
        int[] nArray = new int[1];
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, 1, nArray, -1);
        return nArray[0] != 0;
    }

    Color _getForeground() {
        long[] lArray = new long[1];
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, 3, lArray, -1);
        if (lArray[0] == 0L) {
            return this.parent.getForeground();
        }
        GdkRGBA gdkRGBA = new GdkRGBA();
        OS.memmove(gdkRGBA, lArray[0], (long)GdkRGBA.sizeof);
        GDK.gdk_rgba_free(lArray[0]);
        return Color.gtk_new(this.display, gdkRGBA);
    }

    Color _getForeground(int n) {
        int n2 = Math.max(1, this.parent.columnCount);
        if (0 > n || n > n2 - 1) {
            return this._getForeground();
        }
        long[] lArray = new long[1];
        int n3 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, n3 + 2, lArray, -1);
        if (lArray[0] == 0L) {
            return this._getForeground();
        }
        GdkRGBA gdkRGBA = new GdkRGBA();
        OS.memmove(gdkRGBA, lArray[0], (long)GdkRGBA.sizeof);
        GDK.gdk_rgba_free(lArray[0]);
        return Color.gtk_new(this.display, gdkRGBA);
    }

    Image _getImage(int n) {
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (0 > n || n > n2 - 1) {
            return null;
        }
        long[] lArray = new long[1];
        int n3 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, n3 + 5, lArray, -1);
        if (lArray[0] == 0L) {
            return null;
        }
        int n4 = this.parent.imageList.indexOf(lArray[0]);
        if (n4 == -1) {
            return null;
        }
        return this.parent.imageList.get(n4);
    }

    String _getText(int n) {
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (0 > n || n > n2 - 1) {
            return "";
        }
        long[] lArray = new long[1];
        int n3 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, n3 + 1, lArray, -1);
        if (lArray[0] == 0L) {
            return "";
        }
        int n4 = C.strlen(lArray[0]);
        byte[] byArray = new byte[n4];
        C.memmove(byArray, lArray[0], (long)n4);
        OS.g_free(lArray[0]);
        return new String(Converter.mbcsToWcs(byArray));
    }

    void clear() {
        if (this.parent.currentItem == this) {
            return;
        }
        if (this.cached || (this.parent.style & 0x10000000) == 0) {
            int n;
            int n2 = GTK.gtk_tree_model_get_n_columns(this.parent.modelHandle);
            for (n = 1; n < 3; ++n) {
                GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, n, 0, -1);
            }
            for (n = 3; n < n2; ++n) {
                GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, n, 0L, -1);
            }
        }
        this.cached = false;
        this.font = null;
        this.strings = null;
        this.cellFont = null;
    }

    public void clear(int n, boolean bl) {
        this.checkWidget();
        this.parent.clear(this.handle, n, bl);
    }

    public void clearAll(boolean bl) {
        this.checkWidget();
        this.parent.clearAll(bl, this.handle);
    }

    @Override
    void destroyWidget() {
        this.parent.releaseItem(this, false);
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getBackground();
    }

    public Color getBackground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getBackground(n);
    }

    public Rectangle getBounds(int n) {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels(n));
    }

    Rectangle getBoundsInPixels(int n) {
        Object object;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        long l = this.parent.handle;
        long l2 = 0L;
        l2 = n >= 0 && n < this.parent.columnCount ? this.parent.columns[n].handle : GTK.gtk_tree_view_get_column(l, n);
        if (l2 == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        long l3 = GTK.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        GTK.gtk_widget_realize(l);
        GdkRectangle gdkRectangle = new GdkRectangle();
        GTK.gtk_tree_view_get_cell_area(l, l3, l2, gdkRectangle);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            gdkRectangle.x = this.parent.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
        }
        GTK.gtk_tree_path_free(l3);
        if (n == 0 && (this.parent.style & 0x20) != 0) {
            int[] nArray = new int[1];
            object = new int[1];
            this.gtk_tree_view_column_cell_get_position(l2, this.parent.checkRenderer, nArray, (int[])object);
            gdkRectangle.x += nArray[0] + object[0];
            gdkRectangle.width -= nArray[0] + object[0];
        }
        int n2 = GTK.gtk_tree_view_column_get_visible(l2) ? gdkRectangle.width + 1 : 0;
        object = new Rectangle(gdkRectangle.x, gdkRectangle.y, n2, gdkRectangle.height + 1);
        return object;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        int n;
        long l;
        long l2;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((l2 = GTK.gtk_tree_view_get_column(l = this.parent.handle, 0)) == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        long l3 = this.parent.getTextRenderer(l2);
        long l4 = this.parent.getPixbufRenderer(l2);
        if (l3 == 0L || l4 == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        long l5 = GTK.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        GTK.gtk_widget_realize(l);
        boolean bl = GTK.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle) > 0;
        boolean bl2 = GTK.gtk_tree_view_row_expanded(l, l5);
        GTK.gtk_tree_view_column_cell_set_cell_data(l2, this.parent.modelHandle, this.handle, bl, bl2);
        GdkRectangle gdkRectangle = new GdkRectangle();
        GTK.gtk_tree_view_get_cell_area(l, l5, l2, gdkRectangle);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            gdkRectangle.x = this.parent.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
        }
        int n2 = gdkRectangle.x + gdkRectangle.width;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.parent.ignoreSize = true;
        this.gtk_cell_renderer_get_preferred_size(l3, l, nArray2, null);
        this.parent.ignoreSize = false;
        gdkRectangle.width = nArray2[0];
        int[] nArray3 = new int[1];
        GTK.gtk_tree_path_free(l5);
        if (GTK.GTK4) {
            long l6 = GTK.gtk_separator_new(0);
            GtkAllocation gtkAllocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(l6, gtkAllocation);
            n = gtkAllocation.height;
        } else {
            GTK3.gtk_widget_style_get(l, OS.horizontal_separator, nArray3, 0L);
            n = nArray3[0];
        }
        gdkRectangle.x += n;
        this.gtk_tree_view_column_cell_get_position(l2, l3, nArray, null);
        gdkRectangle.x += nArray[0];
        if (this.parent.columnCount > 0 && gdkRectangle.x + gdkRectangle.width > n2) {
            gdkRectangle.width = Math.max(0, n2 - gdkRectangle.x);
        }
        int n3 = GTK.gtk_tree_view_column_get_visible(l2) ? gdkRectangle.width + 1 : 0;
        Rectangle rectangle = new Rectangle(gdkRectangle.x, gdkRectangle.y, n3, gdkRectangle.height + 1);
        return rectangle;
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this._getChecked();
    }

    public boolean getExpanded() {
        this.checkWidget();
        long l = GTK.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        boolean bl = GTK.gtk_tree_view_row_expanded(this.parent.handle, l);
        GTK.gtk_tree_path_free(l);
        return bl;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (0 > n || n > n2 - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[n] == null) {
            return this.getFont();
        }
        return this.cellFont[n];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getForeground();
    }

    public Color getForeground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getForeground(n);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    @Override
    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getImage(0);
    }

    public Image getImage(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getImage(n);
    }

    public Rectangle getImageBounds(int n) {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getImageBoundsInPixels(n));
    }

    Rectangle getImageBoundsInPixels(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        long l = this.parent.handle;
        long l2 = 0L;
        l2 = n >= 0 && n < this.parent.getColumnCount() ? this.parent.columns[n].handle : GTK.gtk_tree_view_get_column(l, n);
        if (l2 == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        long l3 = this.parent.getPixbufRenderer(l2);
        if (l3 == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        long l4 = GTK.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        GTK.gtk_widget_realize(l);
        GTK.gtk_tree_view_get_cell_area(l, l4, l2, gdkRectangle);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            gdkRectangle.x = this.parent.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
        }
        GTK.gtk_tree_path_free(l4);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.gtk_tree_view_column_cell_get_position(l2, l3, nArray, nArray2);
        if (this.parent.pixbufSizeSet) {
            if (nArray[0] > 0) {
                gdkRectangle.x += nArray[0];
            }
        } else {
            long l5 = this.parent.getTextRenderer(l2);
            if (l5 == 0L) {
                return new Rectangle(0, 0, 0, 0);
            }
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            this.gtk_tree_view_column_cell_get_position(l2, l5, nArray3, nArray4);
            gdkRectangle.x += nArray3[0];
        }
        gdkRectangle.width = nArray2[0];
        int n2 = GTK.gtk_tree_view_column_get_visible(l2) ? gdkRectangle.width : 0;
        Rectangle rectangle = new Rectangle(gdkRectangle.x, gdkRectangle.y, n2, gdkRectangle.height + 1);
        if (this.parent != null && this.parent.getHeaderVisible() && GTK.GTK4) {
            rectangle.y += this.parent.getHeaderHeight();
        }
        return rectangle;
    }

    public int getItemCount() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return GTK.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle);
    }

    public TreeItem getItem(int n) {
        int n2;
        this.checkWidget();
        if (n < 0) {
            this.error(6);
        }
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (n >= (n2 = GTK.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle))) {
            this.error(6);
        }
        return this.parent._getItem(this.handle, n);
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.parent.getItems(this.handle);
    }

    @Override
    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        long l = GTK.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        TreeItem treeItem = null;
        int n = GTK.gtk_tree_path_get_depth(l);
        if (n > 1) {
            GTK.gtk_tree_path_up(l);
            long l2 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (GTK.gtk_tree_model_get_iter(this.parent.modelHandle, l2, l)) {
                treeItem = this.parent._getItem(l2);
            }
            OS.g_free(l2);
        }
        GTK.gtk_tree_path_free(l);
        return treeItem;
    }

    @Override
    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getText(0);
    }

    public String getText(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (this.strings != null && 0 <= n && n < this.strings.length) {
            String string = this.strings[n];
            return string != null ? string : "";
        }
        return this._getText(n);
    }

    public Rectangle getTextBounds(int n) {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getTextBoundsInPixels(n));
    }

    Rectangle getTextBoundsInPixels(int n) {
        int n2;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (0 > n || n > n3 - 1) {
            return new Rectangle(0, 0, 0, 0);
        }
        long l = this.parent.handle;
        long l2 = 0L;
        l2 = n >= 0 && n < this.parent.columnCount ? this.parent.columns[n].handle : GTK.gtk_tree_view_get_column(l, n);
        if (l2 == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        long l3 = this.parent.getTextRenderer(l2);
        long l4 = this.parent.getPixbufRenderer(l2);
        if (l3 == 0L || l4 == 0L) {
            return new Rectangle(0, 0, 0, 0);
        }
        long l5 = GTK.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        GTK.gtk_widget_realize(l);
        boolean bl = GTK.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle) > 0;
        boolean bl2 = GTK.gtk_tree_view_row_expanded(l, l5);
        GTK.gtk_tree_view_column_cell_set_cell_data(l2, this.parent.modelHandle, this.handle, bl, bl2);
        GdkRectangle gdkRectangle = new GdkRectangle();
        GTK.gtk_tree_view_get_cell_area(l, l5, l2, gdkRectangle);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            gdkRectangle.x = this.parent.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
        }
        int n4 = gdkRectangle.x + gdkRectangle.width;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.parent.ignoreSize = true;
        this.gtk_cell_renderer_get_preferred_size(l3, l, nArray2, null);
        this.parent.ignoreSize = false;
        int[] nArray3 = new int[1];
        GTK.gtk_tree_path_free(l5);
        if (GTK.GTK4) {
            long l6 = GTK.gtk_separator_new(0);
            GtkAllocation gtkAllocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(l6, gtkAllocation);
            n2 = gtkAllocation.height;
        } else {
            GTK3.gtk_widget_style_get(l, OS.horizontal_separator, nArray3, 0L);
            n2 = nArray3[0];
        }
        gdkRectangle.x += n2;
        this.gtk_tree_view_column_cell_get_position(l2, l3, nArray, null);
        Image image = this._getImage(n);
        int n5 = 0;
        if (image != null) {
            n5 = DPIUtil.useCairoAutoScale() ? image.getBounds().width : image.getBoundsInPixels().width;
        }
        gdkRectangle.x = nArray[0] < n5 ? (gdkRectangle.x += n5) : (gdkRectangle.x += nArray[0]);
        if (this.parent.columnCount > 0 && gdkRectangle.x + gdkRectangle.width > n4) {
            gdkRectangle.width = Math.max(0, n4 - gdkRectangle.x);
        }
        int n6 = GTK.gtk_tree_view_column_get_visible(l2) ? gdkRectangle.width + 1 : 0;
        return new Rectangle(gdkRectangle.x, gdkRectangle.y, n6, gdkRectangle.height + 1);
    }

    public int indexOf(TreeItem treeItem) {
        long l;
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        int n = -1;
        boolean bl = false;
        long l2 = GTK.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        long l3 = GTK.gtk_tree_model_get_path(this.parent.modelHandle, treeItem.handle);
        int n2 = GTK.gtk_tree_path_get_depth(l3);
        if (n2 > 1 && GTK.gtk_tree_path_up(l3) && GTK.gtk_tree_path_compare(l2, l3) == 0L) {
            bl = true;
        }
        GTK.gtk_tree_path_free(l2);
        GTK.gtk_tree_path_free(l3);
        if (!bl) {
            return n;
        }
        long l4 = GTK.gtk_tree_model_get_path(this.parent.modelHandle, treeItem.handle);
        if (n2 > 1 && (l = GTK.gtk_tree_path_get_indices(l4)) != 0L) {
            int[] nArray = new int[n2];
            C.memmove(nArray, l, (long)(4 * nArray.length));
            n = nArray[nArray.length - 1];
        }
        GTK.gtk_tree_path_free(l4);
        return n;
    }

    @Override
    void releaseChildren(boolean bl) {
        if (bl) {
            this.parent.releaseItems(this.handle);
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseHandle() {
        if (this.handle != 0L) {
            OS.g_free(this.handle);
        }
        this.handle = 0L;
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.font = null;
        this.cellFont = null;
        this.strings = null;
    }

    @Override
    public void dispose() {
        Widget widget = null;
        if (this.parent != null && this.parent.getItemCount() > 0 && this.parent.getSelectionCount() == 0) {
            widget = this.parent;
        }
        super.dispose();
        if (widget != null && !widget.isDisposed()) {
            ((Tree)widget).deselectAll();
        }
    }

    public void removeAll() {
        this.checkWidget();
        long l = this.parent.modelHandle;
        int n = GTK.gtk_tree_model_iter_n_children(l, this.handle);
        if (n == 0) {
            return;
        }
        long l2 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (l2 == 0L) {
            this.error(2);
        }
        long l3 = GTK.gtk_tree_view_get_selection(this.parent.handle);
        int[] nArray = new int[1];
        while (GTK.gtk_tree_model_iter_children(l, l2, this.handle)) {
            Widget widget;
            GTK.gtk_tree_model_get(l, l2, 0, nArray, -1);
            Widget widget2 = widget = nArray[0] != -1 ? this.parent.items[nArray[0]] : null;
            if (widget != null && !widget.isDisposed()) {
                ((TreeItem)widget).dispose();
                continue;
            }
            OS.g_signal_handlers_block_matched(l3, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_tree_store_remove(l, l2);
            OS.g_signal_handlers_unblock_matched(l3, 16, 0, 0, 0L, 0L, 6L);
        }
        OS.g_free(l2);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getBackground().equals(color)) {
            return;
        }
        GdkRGBA gdkRGBA = color != null ? color.handle : null;
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, 4, gdkRGBA, -1);
        this.cached = true;
    }

    public void setBackground(int n, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getBackground(n).equals(color)) {
            return;
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (0 > n || n > n2 - 1) {
            return;
        }
        int n3 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        GdkRGBA gdkRGBA = color != null ? color.handle : null;
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, n3 + 3, gdkRGBA, -1);
        this.cached = true;
        this.updated = true;
        if (color != null) {
            boolean bl;
            boolean bl2 = bl = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[n].customDraw;
            if (!bl) {
                if ((this.parent.style & 0x10000000) == 0) {
                    long l = this.parent.handle;
                    long l2 = 0L;
                    l2 = this.parent.columnCount > 0 ? this.parent.columns[n].handle : GTK.gtk_tree_view_get_column(l, n);
                    if (l2 == 0L) {
                        return;
                    }
                    long l3 = this.parent.getTextRenderer(l2);
                    long l4 = this.parent.getPixbufRenderer(l2);
                    GTK.gtk_tree_view_column_set_cell_data_func(l2, l3, this.display.cellDataProc, l, 0L);
                    GTK.gtk_tree_view_column_set_cell_data_func(l2, l4, this.display.cellDataProc, l, 0L);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[n].customDraw = true;
                }
            }
        }
    }

    public void setChecked(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this._getChecked() == bl) {
            return;
        }
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, 1, bl, -1);
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, 2, !bl ? false : this.grayed, -1);
        this.cached = true;
    }

    public void setExpanded(boolean bl) {
        this.checkWidget();
        long l = GTK.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        if (bl != GTK.gtk_tree_view_row_expanded(this.parent.handle, l)) {
            if (bl) {
                OS.g_signal_handlers_block_matched(this.parent.handle, 16, 0, 0, 0L, 0L, 51L);
                GTK.gtk_tree_view_expand_row(this.parent.handle, l, false);
                OS.g_signal_handlers_unblock_matched(this.parent.handle, 16, 0, 0, 0L, 0L, 51L);
            } else {
                OS.g_signal_handlers_block_matched(this.parent.handle, 16, 0, 0, 0L, 0L, 50L);
                GTK.gtk_widget_realize(this.parent.handle);
                GTK.gtk_tree_view_collapse_row(this.parent.handle, l);
                OS.g_signal_handlers_unblock_matched(this.parent.handle, 16, 0, 0, 0L, 0L, 50L);
            }
        }
        GTK.gtk_tree_path_free(l);
        this.isExpanded = bl;
    }

    public void setFont(Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        long l = font != null ? font.handle : 0L;
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, 5, l, -1);
        this.cached = true;
    }

    public void setFont(int n, Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (0 > n || n > n2 - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[n2];
        }
        if ((font2 = this.cellFont[n]) == font) {
            return;
        }
        this.cellFont[n] = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        int n3 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        long l = font != null ? font.handle : 0L;
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, n3 + 4, l, -1);
        this.cached = true;
        if (font != null) {
            boolean bl;
            boolean bl2 = bl = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[n].customDraw;
            if (!bl) {
                if ((this.parent.style & 0x10000000) == 0) {
                    long l2 = this.parent.handle;
                    long l3 = 0L;
                    l3 = this.parent.columnCount > 0 ? this.parent.columns[n].handle : GTK.gtk_tree_view_get_column(l2, n);
                    if (l3 == 0L) {
                        return;
                    }
                    long l4 = this.parent.getTextRenderer(l3);
                    long l5 = this.parent.getPixbufRenderer(l3);
                    GTK.gtk_tree_view_column_set_cell_data_func(l3, l4, this.display.cellDataProc, l2, 0L);
                    GTK.gtk_tree_view_column_set_cell_data_func(l3, l5, this.display.cellDataProc, l2, 0L);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[n].customDraw = true;
                }
            }
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getForeground().equals(color)) {
            return;
        }
        GdkRGBA gdkRGBA = color != null ? color.handle : null;
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, 3, gdkRGBA, -1);
        this.cached = true;
    }

    public void setForeground(int n, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getForeground(n).equals(color)) {
            return;
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (0 > n || n > n2 - 1) {
            return;
        }
        int n3 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        GdkRGBA gdkRGBA = color != null ? color.handle : null;
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, n3 + 2, gdkRGBA, -1);
        this.cached = true;
        this.updated = true;
        if (color != null) {
            boolean bl;
            boolean bl2 = bl = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[n].customDraw;
            if (!bl) {
                if ((this.parent.style & 0x10000000) == 0) {
                    long l = this.parent.handle;
                    long l2 = 0L;
                    l2 = this.parent.columnCount > 0 ? this.parent.columns[n].handle : GTK.gtk_tree_view_get_column(l, n);
                    if (l2 == 0L) {
                        return;
                    }
                    long l3 = this.parent.getTextRenderer(l2);
                    long l4 = this.parent.getPixbufRenderer(l2);
                    GTK.gtk_tree_view_column_set_cell_data_func(l2, l3, this.display.cellDataProc, l, 0L);
                    GTK.gtk_tree_view_column_set_cell_data_func(l2, l4, this.display.cellDataProc, l, 0L);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[n].customDraw = true;
                }
            }
        }
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == bl) {
            return;
        }
        this.grayed = bl;
        int[] nArray = new int[1];
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, 1, nArray, -1);
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, 2, nArray[0] == 0 ? false : bl, -1);
        this.cached = true;
    }

    public void setImage(int n, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (image != null && image.type == 1 && image.equals(this._getImage(n))) {
            return;
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (0 > n || n > n2 - 1) {
            return;
        }
        long l = 0L;
        long l2 = 0L;
        if (image != null) {
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            int n3 = imageList.indexOf(image);
            long l3 = ImageList.convertSurface(image);
            Cairo.cairo_surface_destroy(l3);
            if (n3 == -1) {
                n3 = imageList.add(image);
            }
            l2 = imageList.getSurface(n3);
            l = ImageList.createPixbuf(l2);
        }
        int n4 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        long l4 = this.parent.handle;
        long l5 = GTK.gtk_tree_view_get_column(l4, n);
        long l6 = this.parent.getPixbufRenderer(l5);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GTK.gtk_cell_renderer_get_fixed_size(l6, nArray, nArray2);
        if (!this.parent.pixbufSizeSet) {
            if (image != null) {
                int n5;
                int n6;
                if (DPIUtil.useCairoAutoScale()) {
                    n6 = image.getBounds().width;
                    n5 = image.getBounds().height;
                } else {
                    n6 = image.getBoundsInPixels().width;
                    n5 = image.getBoundsInPixels().height;
                }
                if (n6 > nArray[0] || n5 > nArray2[0]) {
                    GTK.gtk_cell_renderer_set_fixed_size(l6, n6, n5);
                    this.parent.pixbufSizeSet = true;
                    this.parent.pixbufHeight = n5;
                    this.parent.pixbufWidth = n6;
                    if ((this.parent.style & 0x10000000) != 0) {
                        boolean bl = n4 == 6 && (this.parent.style & 0x20) != 0;
                        this.parent.createRenderers(l5, n4, bl, this.parent.style);
                    }
                }
            }
        } else if (this.parent.pixbufWidth > Math.max(nArray[0], 0) || this.parent.pixbufHeight > Math.max(nArray2[0], 0)) {
            GTK.gtk_cell_renderer_set_fixed_size(l6, this.parent.pixbufWidth, this.parent.pixbufHeight);
        }
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, n4 + 0, l, -1);
        if (l != 0L) {
            OS.g_object_unref(l);
        }
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, n4 + 5, l2, -1);
        this.cached = true;
        this.updated = true;
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        for (int i = 0; i < imageArray.length; ++i) {
            this.setImage(i, imageArray[i]);
        }
    }

    public void setItemCount(int n) {
        this.checkWidget();
        n = Math.max(0, n);
        this.parent.setItemCount(this.handle, n);
    }

    public void setText(int n, String object) {
        this.checkWidget();
        if (object == null) {
            this.error(4);
        }
        if (this.strings == null ? this._getText(n).equals(object) : this.getText(n).equals(object)) {
            return;
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (0 > n || n > n2 - 1) {
            return;
        }
        if (0 <= n && n < n2) {
            if (this.strings == null) {
                this.strings = new String[n2];
            }
            if (((String)object).equals(this.strings[n])) {
                return;
            }
            this.strings[n] = object;
        }
        if (object != null && ((String)object).length() > 8192) {
            object = ((String)object).substring(0, 8192 - "...".length()) + "...";
        }
        byte[] byArray = Converter.wcsToMbcs((String)object, true);
        int n3 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        GTK.gtk_tree_store_set(this.parent.modelHandle, this.handle, n3 + 1, byArray, -1);
        this.cached = true;
        this.updated = true;
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            this.setText(i, string);
        }
    }
}

