/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.SWTGeometry;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_rectangle_int_t;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GeometryInterface;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XFocusChangeEvent;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GdkEventWindowState;
import org.eclipse.swt.internal.gtk3.GdkGeometry;
import org.eclipse.swt.internal.gtk3.GdkWindowAttr;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Shell
extends Decorations {
    long shellHandle;
    long tooltipsHandle;
    long tooltipWindow;
    long group;
    long modalGroup;
    boolean mapped;
    boolean moved;
    boolean resized;
    boolean opened;
    boolean fullScreen;
    boolean showWithParent;
    boolean modified;
    boolean center;
    int oldX;
    int oldY;
    int oldWidth;
    int oldHeight;
    GeometryInterface geometry;
    Control lastActive;
    ToolTip[] toolTips;
    boolean ignoreFocusOut;
    boolean ignoreFocusIn;
    boolean ignoreFocusOutAfterGrab;
    boolean grabbedFocus;
    Region originalRegion;
    static final int MAXIMUM_TRIM = 128;
    static final int BORDER = 3;
    static final double SHELL_TO_MONITOR_RATIO = 0.625;

    public Shell() {
        this((Display)null);
    }

    public Shell(int n) {
        this((Display)null, n);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int n) {
        this(display, null, n, 0L, false);
    }

    Shell(Display display, Shell shell, int n, long l, boolean bl) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (shell != null && shell.isDisposed()) {
            this.error(5);
        }
        this.center = shell != null && (n & 0x10000000) != 0;
        this.style = Shell.checkStyle(shell, n);
        this.parent = shell;
        this.display = display;
        if (l != 0L) {
            if (bl) {
                this.handle = l;
            } else {
                this.shellHandle = l;
                this.state |= 0x400000;
            }
        }
        this.geometry = !GTK.GTK4 ? new GdkGeometry() : new SWTGeometry();
        this.reskinWidget();
        this.createWidget(0);
    }

    public Shell(Shell shell) {
        this(shell, 2144);
    }

    public Shell(Shell shell, int n) {
        this(shell != null ? shell.display : null, shell, n, 0L, false);
    }

    public static Shell gtk_new(Display display, long l) {
        return new Shell(display, null, 8, l, true);
    }

    public static Shell internal_new(Display display, long l) {
        return new Shell(display, null, 8, l, false);
    }

    static int checkStyle(Shell shell, int n) {
        n = Decorations.checkStyle(n);
        if (shell != null && ((n &= 0xBFFFFFFF) & 0x4000) != 0) {
            n &= 0xFFFFFB1F;
        }
        int n2 = 229376;
        if ((n & 0x10000000) != 0) {
            n &= 0xEFFFFFFF;
            if (((n |= shell == null ? 1264 : 2144) & n2) == 0) {
                n |= shell == null ? 65536 : 32768;
            }
        }
        int n3 = n & ~n2;
        if ((n & 0x20000) != 0) {
            return n3 | 0x20000;
        }
        if ((n & 0x10000) != 0) {
            return n3 | 0x10000;
        }
        if ((n & 0x8000) != 0) {
            return n3 | 0x8000;
        }
        return n3;
    }

    public void addShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(shellListener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    void addToolTip(ToolTip toolTip) {
        if (this.toolTips == null) {
            this.toolTips = new ToolTip[4];
        }
        for (int i = 0; i < this.toolTips.length; ++i) {
            if (this.toolTips[i] != null) continue;
            this.toolTips[i] = toolTip;
            return;
        }
        ToolTip[] toolTipArray = new ToolTip[this.toolTips.length + 4];
        toolTipArray[this.toolTips.length] = toolTip;
        System.arraycopy(this.toolTips, 0, toolTipArray, 0, this.toolTips.length);
        this.toolTips = toolTipArray;
    }

    void adjustTrim() {
        if (this.display.ignoreTrim) {
            return;
        }
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.shellHandle, gtkAllocation);
        int n = gtkAllocation.width;
        int n2 = gtkAllocation.height;
        GdkRectangle gdkRectangle = new GdkRectangle();
        if (!GTK.GTK4) {
            long l = this.gtk_widget_get_window(this.shellHandle);
            GDK.gdk_window_get_frame_extents(l, gdkRectangle);
        }
        int n3 = Math.max(0, gdkRectangle.width - n);
        int n4 = Math.max(0, gdkRectangle.height - n2);
        if (n3 > 128 || n4 > 128 || this.isCustomResize()) {
            this.display.ignoreTrim = true;
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if ((this.style & 8) == 0) {
            bl = (this.style & 0x4E0) != 0;
            bl2 = (this.style & 0x10) != 0;
            boolean bl4 = bl3 = (this.style & 0x800) != 0;
        }
        int n5 = bl ? (bl2 ? 4 : (bl3 ? 3 : 5)) : (bl2 ? 2 : (bl3 ? 1 : 0));
        Rectangle rectangle = this.getBoundsInPixels();
        int n6 = this.display.trimWidths[n5] - n3;
        int n7 = this.display.trimHeights[n5] - n4;
        if (n6 == 0 && n7 == 0) {
            return;
        }
        rectangle.width += n6;
        rectangle.height += n7;
        this.oldWidth += n6;
        this.oldHeight += n7;
        if (!this.getMaximized()) {
            this.resizeBounds(n + n6, n2 + n7, false);
        }
        this.display.trimWidths[n5] = n3;
        this.display.trimHeights[n5] = n4;
    }

    void bringToTop(boolean bl) {
        if (!GTK.gtk_widget_get_visible(this.shellHandle)) {
            return;
        }
        Display display = this.display;
        Shell shell = display.activeShell;
        if (shell == this) {
            return;
        }
        if (!bl) {
            long l;
            if (shell == null) {
                return;
            }
            if (!display.activePending && (l = GTK.gtk_window_get_focus(shell.shellHandle)) != 0L && !GTK.gtk_widget_has_focus(l)) {
                return;
            }
        }
        boolean bl2 = false;
        if (shell != null) {
            display.activeShell = null;
            display.activePending = true;
        }
        long l = GTK.GTK4 ? this.gtk_widget_get_surface(this.shellHandle) : this.gtk_widget_get_window(this.shellHandle);
        if (bl2 || (this.style & 0x4000) != 0) {
            if (OS.isX11()) {
                long l2 = GDK.gdk_window_get_display(l);
                long l3 = GDK.gdk_x11_display_get_xdisplay(l2);
                long l4 = GTK.GTK4 ? GDK.gdk_x11_surface_get_xid(l) : GDK.gdk_x11_window_get_xid(l);
                GDK.gdk_x11_display_error_trap_push(l2);
                OS.XSetInputFocus(l3, l4, 2, 0);
                GDK.gdk_x11_display_error_trap_pop_ignored(l2);
            } else {
                long l5;
                if (GTK.GTK4) {
                    l5 = GDK.gdk_surface_get_display(l);
                } else {
                    GTK3.gtk_grab_add(this.shellHandle);
                    l5 = GDK.gdk_window_get_display(l);
                }
                long l6 = GDK.gdk_display_get_default_seat(l5);
                if (!GTK.GTK4) {
                    GDK.gdk_window_show(l);
                }
                GDK.gdk_seat_grab(l6, l, 15, true, 0L, 0L, 0L, 0L);
                this.grabbedFocus = true;
                this.ignoreFocusOutAfterGrab = true;
            }
        } else if (GTK.GTK4) {
            GTK4.gdk_toplevel_focus(l, display.lastUserEventTime);
        } else {
            GDK.gdk_window_focus(l, display.lastUserEventTime);
        }
        display.activeShell = this;
        display.activePending = true;
    }

    void center() {
        if (this.parent == null) {
            return;
        }
        Rectangle rectangle = this.getBoundsInPixels();
        Rectangle rectangle2 = this.display.mapInPixels(this.parent, null, this.parent.getClientAreaInPixels());
        int n = Math.max(rectangle2.x, rectangle2.x + (rectangle2.width - rectangle.width) / 2);
        int n2 = Math.max(rectangle2.y, rectangle2.y + (rectangle2.height - rectangle.height) / 2);
        Rectangle rectangle3 = DPIUtil.autoScaleUp(this.parent.getMonitor().getClientArea());
        n = n + rectangle.width > rectangle3.x + rectangle3.width ? Math.max(rectangle3.x, rectangle3.x + rectangle3.width - rectangle.width) : Math.max(n, rectangle3.x);
        n2 = n2 + rectangle.height > rectangle3.y + rectangle3.height ? Math.max(rectangle3.y, rectangle3.y + rectangle3.height - rectangle.height) : Math.max(n2, rectangle3.y);
        this.setLocationInPixels(n, n2);
    }

    @Override
    void checkBorder() {
    }

    @Override
    void checkOpen() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    @Override
    Rectangle computeTrimInPixels(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrimInPixels(n, n2, n3, n4);
        int n5 = 0;
        if ((this.style & 0xCF8) == 0 || this.isCustomResize()) {
            n5 = this.gtk_container_get_border_width_or_margin(this.shellHandle);
        }
        int n6 = this.trimWidth();
        int n7 = this.trimHeight();
        rectangle.x -= n6 / 2 + n5;
        rectangle.y -= n7 - n6 / 2 + n5;
        rectangle.width += n6 + n5 * 2;
        rectangle.height += n7 + n5 * 2;
        if (this.menuBar != null) {
            this.forceResize();
            GtkAllocation gtkAllocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.menuBar.handle, gtkAllocation);
            int n8 = gtkAllocation.height;
            rectangle.y -= n8;
            rectangle.height += n8;
        }
        return rectangle;
    }

    @Override
    void createHandle(int n) {
        this.state |= 0xA;
        if (this.shellHandle == 0L) {
            boolean bl;
            boolean bl2 = bl = this.parent != null;
            if (this.handle == 0L) {
                int n2 = 0;
                if (bl && (this.style & 0x4000) != 0) {
                    n2 = 1;
                }
                this.shellHandle = GTK.GTK4 ? GTK4.gtk_window_new() : GTK3.gtk_window_new(n2);
            } else {
                this.shellHandle = GTK.gtk_plug_new(this.handle);
            }
            if (this.shellHandle == 0L) {
                this.error(2);
            }
            if (bl) {
                if (GTK.GTK4) {
                    GTK.gtk_window_set_transient_for(this.shellHandle, this.parent.topHandle());
                    GTK.gtk_window_set_destroy_with_parent(this.shellHandle, true);
                } else {
                    if (OS.isWayland()) {
                        Composite composite = this.parent;
                        while (composite != null && (composite.style & 0x4000) != 0) {
                            composite = this.parent.getParent();
                        }
                        if (composite != null) {
                            GTK.gtk_window_set_transient_for(this.shellHandle, composite.topHandle());
                        } else {
                            GTK.gtk_window_set_transient_for(this.shellHandle, this.parent.topHandle());
                        }
                        GTK3.gtk_window_set_attached_to(this.shellHandle, this.parent.topHandle());
                        if (this.parent != composite && this.isMappedToPopup()) {
                            this.parent.popupChild = this;
                        }
                    } else {
                        GTK.gtk_window_set_transient_for(this.shellHandle, this.parent.topHandle());
                    }
                    GTK.gtk_window_set_destroy_with_parent(this.shellHandle, true);
                    if ((this.style & 0x80) == 0) {
                        GTK3.gtk_window_set_skip_taskbar_hint(this.shellHandle, true);
                    }
                }
            } else if ((this.style & 0x4000) != 0 && !GTK.GTK4) {
                GTK3.gtk_window_set_keep_above(this.shellHandle, true);
            }
            GTK.gtk_window_set_title(this.shellHandle, new byte[1]);
            if ((this.style & 0x10) != 0) {
                GTK.gtk_window_set_resizable(this.shellHandle, true);
            } else {
                GTK.gtk_window_set_resizable(this.shellHandle, false);
            }
            if ((this.style & 0xCF8) == 0) {
                this.gtk_container_set_border_width(this.shellHandle, 1);
            }
            if ((this.style & 4) != 0) {
                GTK3.gtk_window_set_type_hint(this.shellHandle, 5);
            }
            if ((this.style & 8) != 0) {
                GTK.gtk_window_set_decorated(this.shellHandle, false);
            }
            if (!OS.isX11() && (this.style & 0x4F0) == 0) {
                GTK.gtk_window_set_decorated(this.shellHandle, false);
            }
            if (this.isCustomResize()) {
                this.gtk_container_set_border_width(this.shellHandle, 3);
            }
        }
        this.createHandle(n, false, true);
        this.vboxHandle = this.gtk_box_new(1, false, 0);
        if (this.vboxHandle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            GTK4.gtk_box_append(this.vboxHandle, this.scrolledHandle);
        } else {
            GTK3.gtk_container_add(this.vboxHandle, this.scrolledHandle);
            this.gtk_box_set_child_packing(this.vboxHandle, this.scrolledHandle, true, true, 0, 1);
        }
        this.group = GTK.gtk_window_group_new();
        if (this.group == 0L) {
            this.error(2);
        }
        GTK.gtk_widget_realize(this.shellHandle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    long filterProc(long l, long l2, long l3) {
        if (OS.isWayland()) {
            return 0L;
        }
        int n = OS.X_EVENT_TYPE(l);
        if (n != 10 && n != 9) {
            return 0L;
        }
        XFocusChangeEvent xFocusChangeEvent = new XFocusChangeEvent();
        OS.memmove(xFocusChangeEvent, l, (long)XFocusChangeEvent.sizeof);
        switch (n) {
            case 9: {
                if (xFocusChangeEvent.mode != 0 && xFocusChangeEvent.mode != 3) return 0L;
                switch (xFocusChangeEvent.detail) {
                    case 0: 
                    case 3: 
                    case 4: {
                        this.display.activeShell = this;
                        this.display.activePending = false;
                        this.sendEvent(26);
                        if (this.isDisposed()) {
                            return 0L;
                        }
                        if (!this.isCustomResize()) return 0L;
                        GDK.gdk_window_invalidate_rect(this.gtk_widget_get_window(this.shellHandle), null, false);
                    }
                }
                return 0L;
            }
            case 10: {
                if (xFocusChangeEvent.mode != 0 && xFocusChangeEvent.mode != 3) return 0L;
                switch (xFocusChangeEvent.detail) {
                    case 1: 
                    case 3: 
                    case 4: {
                        Display display = this.display;
                        this.sendEvent(27);
                        this.setActiveControl(null);
                        if (display.activeShell == this) {
                            display.activeShell = null;
                            display.activePending = false;
                        }
                        if (this.isDisposed()) {
                            return 0L;
                        }
                        if (!this.isCustomResize()) return 0L;
                        GDK.gdk_window_invalidate_rect(this.gtk_widget_get_window(this.shellHandle), null, false);
                    }
                }
            }
        }
        return 0L;
    }

    @Override
    Control findBackgroundControl() {
        return (this.state & 0x2000) != 0 || this.backgroundImage != null ? this : null;
    }

    @Override
    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    public ToolBar getToolBar() {
        this.checkWidget();
        return null;
    }

    @Override
    boolean hasBorder() {
        return false;
    }

    @Override
    void hookEvents() {
        long l;
        super.hookEvents();
        OS.g_signal_connect(this.shellHandle, OS.dpi_changed, this.display.notifyProc, 104L);
        if (GTK.GTK4) {
            GTK.gtk_widget_realize(this.shellHandle);
            l = this.gtk_widget_get_surface(this.shellHandle);
            OS.g_signal_connect(l, OS.notify_state, this.display.notifyProc, this.shellHandle);
            OS.g_signal_connect(l, OS.compute_size, this.display.computeSizeProc, this.shellHandle);
            OS.g_signal_connect(this.shellHandle, OS.notify_default_height, this.display.notifyProc, 105L);
            OS.g_signal_connect(this.shellHandle, OS.notify_default_width, this.display.notifyProc, 106L);
            OS.g_signal_connect(this.shellHandle, OS.notify_maximized, this.display.notifyProc, 107L);
        } else {
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[59], 0, this.display.getClosure(59), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[10], 0, this.display.getClosure(10), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[31], 0, this.display.shellMapProcClosure, false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[47], 0, this.display.getClosure(47), false);
        }
        if (GTK.GTK4) {
            OS.g_signal_connect_closure(this.shellHandle, OS.close_request, this.display.getClosure(99), false);
            OS.g_signal_connect(this.shellHandle, OS.notify_is_active, this.display.windowActiveProc, 86L);
            l = GTK4.gtk_event_controller_key_new();
            GTK4.gtk_widget_add_controller(this.shellHandle, l);
            GTK.gtk_event_controller_set_propagation_phase(l, 3);
            OS.g_signal_connect(l, OS.key_pressed, this.display.keyPressReleaseProc, 89L);
            long l2 = GTK4.gtk_event_controller_focus_new();
            GTK4.gtk_widget_add_controller(this.shellHandle, l2);
            OS.g_signal_connect(l2, OS.enter, this.display.focusProc, 86L);
            OS.g_signal_connect(l2, OS.leave, this.display.focusProc, 87L);
            long l3 = GTK4.gtk_event_controller_motion_new();
            GTK4.gtk_widget_add_controller(this.shellHandle, l3);
            long l4 = this.display.enterMotionCallback.getAddress();
            OS.g_signal_connect(l3, OS.enter, l4, 95L);
            if (this.isCustomResize()) {
                long l5 = GTK4.gtk_event_controller_motion_new();
                GTK4.gtk_widget_add_controller(this.shellHandle, l5);
                GTK.gtk_event_controller_set_propagation_phase(l5, 3);
                OS.g_signal_connect(l5, OS.motion, l4, 97L);
                long l6 = this.display.leaveCallback.getAddress();
                OS.g_signal_connect(l3, OS.leave, l6, 96L);
            }
        } else {
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[11], 0, this.display.getClosure(11), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[27], 0, this.display.getClosure(27), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[21], 0, this.display.getClosure(21), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[22], 0, this.display.getClosure(22), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[14], 0, this.display.getClosure(14), false);
        }
        OS.g_signal_connect_closure(this.shellHandle, OS.move_focus, this.display.getClosure(35), false);
        if (this.isCustomResize() && !GTK.GTK4) {
            int n = 13060;
            GTK3.gtk_widget_add_events(this.shellHandle, n);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[33], 0, this.display.getClosure(33), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[29], 0, this.display.getClosure(29), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[18], 0, this.display.getClosure(18), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
        }
    }

    @Override
    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    boolean isUndecorated() {
        return (this.style & 0xCF0) == 0 || (this.style & 0x4008) != 0;
    }

    boolean isCustomResize() {
        return (this.style & 8) == 0 && (this.style & 0x4010) == 16400;
    }

    @Override
    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    boolean isMappedToPopup() {
        return this.parent != null && (this.parent.style & 0x4000) != 0;
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.shellHandle, this);
    }

    @Override
    void releaseParent() {
    }

    @Override
    public void requestLayout() {
        this.layout(null, 4);
    }

    @Override
    long topHandle() {
        return this.shellHandle;
    }

    @Override
    long paintHandle() {
        if (GTK.GTK4) {
            return this.handle;
        }
        return super.paintHandle();
    }

    void fixActiveShell() {
        if (this.display.activeShell == this && (this.style & 0x4000) != 0) {
            Shell shell = null;
            if (this.parent != null && this.parent.isVisible()) {
                shell = this.parent.getShell();
            }
            if (shell == null && this.isUndecorated()) {
                Shell[] shellArray = this.display.getShells();
                for (int i = 0; i < shellArray.length; ++i) {
                    if (shellArray[i] == null || !shellArray[i].isVisible()) continue;
                    shell = shellArray[i];
                    break;
                }
            }
            if (shell != null) {
                shell.bringToTop(false);
            }
        }
    }

    void fixShell(Shell shell, Control control) {
        String string;
        if (this == shell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
        if ((string = control.toolTipText) != null) {
            control.setToolTipText(this, null);
            control.setToolTipText(shell, string);
        }
    }

    @Override
    void fixStyle(long l) {
    }

    @Override
    void forceResize() {
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.vboxHandle, gtkAllocation);
        if (OS.isWayland()) {
            int n = this.gtk_container_get_border_width_or_margin(this.shellHandle);
            int n2 = this.oldWidth - 2 * n;
            int n3 = this.oldHeight - 2 * n;
            if (n2 != gtkAllocation.width || n3 != gtkAllocation.height) {
                gtkAllocation.width = Math.max(n2, gtkAllocation.width);
                gtkAllocation.height = Math.max(n3, gtkAllocation.height);
            }
        }
        this.forceResize(gtkAllocation.width, gtkAllocation.height);
    }

    void forceResize(int n, int n2) {
        int n3;
        int n4 = 0;
        if ((this.style & 0x8000000) != 0) {
            n4 = this.getClientWidth();
        }
        GtkAllocation gtkAllocation = new GtkAllocation();
        gtkAllocation.x = n3 = this.gtk_container_get_border_width_or_margin(this.shellHandle);
        gtkAllocation.y = n3;
        gtkAllocation.width = n;
        gtkAllocation.height = n2;
        GtkRequisition gtkRequisition = new GtkRequisition();
        GtkRequisition gtkRequisition2 = new GtkRequisition();
        GTK.gtk_widget_get_preferred_size(this.vboxHandle, gtkRequisition, gtkRequisition2);
        if (OS.isWayland()) {
            if (GTK.GTK4) {
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                boolean bl = GTK4.gtk_widget_translate_coordinates(this.vboxHandle, this.shellHandle, 0.0, 0.0, dArray, dArray2);
                if (bl && !this.isMappedToPopup()) {
                    gtkAllocation.x = (int)((double)gtkAllocation.x + dArray[0]);
                    gtkAllocation.y = (int)((double)gtkAllocation.y + dArray2[0]);
                    gtkAllocation.height = (int)((double)gtkAllocation.height - dArray2[0]);
                }
            } else {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                GTK3.gtk_widget_translate_coordinates(this.vboxHandle, this.shellHandle, 0, 0, nArray, nArray2);
                if (nArray[0] != -1 && nArray2[0] != -1 && !this.isMappedToPopup()) {
                    gtkAllocation.x += nArray[0];
                    gtkAllocation.y += nArray2[0];
                }
            }
        }
        this.gtk_widget_size_allocate(this.vboxHandle, gtkAllocation, -1);
        if ((this.style & 0x8000000) != 0) {
            this.moveChildren(n4);
        }
    }

    public int getAlpha() {
        boolean bl;
        this.checkWidget();
        if (GTK.GTK4) {
            long l = GDK.gdk_display_get_default();
            bl = GDK.gdk_display_is_composited(l);
        } else {
            long l = GTK3.gtk_widget_get_screen(this.shellHandle);
            bl = GDK.gdk_screen_is_composited(l);
        }
        if (bl) {
            return (int)(GTK.gtk_widget_get_opacity(this.shellHandle) * 255.0);
        }
        return 255;
    }

    int getResizeMode(double d, double d2) {
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.shellHandle, gtkAllocation);
        int n = gtkAllocation.width;
        int n2 = gtkAllocation.height;
        int n3 = this.gtk_container_get_border_width_or_margin(this.shellHandle);
        int n4 = 0;
        if (d2 >= (double)(n2 - n3)) {
            n4 = 11;
            if (d >= (double)(n - n3 - 16)) {
                n4 = 15;
            } else if (d <= (double)(n3 + 16)) {
                n4 = 16;
            }
        } else if (d >= (double)(n - n3)) {
            n4 = 12;
            if (d2 >= (double)(n2 - n3 - 16)) {
                n4 = 15;
            } else if (d2 <= (double)(n3 + 16)) {
                n4 = 14;
            }
        } else if (d2 <= (double)n3) {
            n4 = 10;
            if (d <= (double)(n3 + 16)) {
                n4 = 17;
            } else if (d >= (double)(n - n3 - 16)) {
                n4 = 14;
            }
        } else if (d <= (double)n3) {
            n4 = 13;
            if (d2 <= (double)(n3 + 16)) {
                n4 = 17;
            } else if (d2 >= (double)(n2 - n3 - 16)) {
                n4 = 16;
            }
        }
        return n4;
    }

    public boolean getFullScreen() {
        this.checkWidget();
        return this.fullScreen;
    }

    @Override
    Point getLocationInPixels() {
        this.checkWidget();
        if (!this.getVisible() && this.moved) {
            this.setLocationInPixels(this.oldX, this.oldY);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (!GTK.GTK4) {
            GTK3.gtk_window_get_position(this.shellHandle, nArray, nArray2);
        }
        return new Point(nArray[0], nArray2[0]);
    }

    @Override
    public boolean getMaximized() {
        this.checkWidget();
        return !this.fullScreen && super.getMaximized();
    }

    public Point getMinimumSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getMinimumSizeInPixels());
    }

    Point getMinimumSizeInPixels() {
        this.checkWidget();
        int n = Math.max(1, this.geometry.getMinWidth() + this.trimWidth());
        int n2 = Math.max(1, this.geometry.getMinHeight() + this.trimHeight());
        return new Point(n, n2);
    }

    public Point getMaximumSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getMaximumSizeInPixels());
    }

    Point getMaximumSizeInPixels() {
        this.checkWidget();
        int n = Math.min(Integer.MAX_VALUE, this.geometry.getMaxWidth() + this.trimWidth());
        int n2 = Math.min(Integer.MAX_VALUE, this.geometry.getMaxHeight() + this.trimHeight());
        return new Point(n, n2);
    }

    Shell getModalShell() {
        Shell shell = null;
        Shell[] shellArray = this.display.modalShells;
        if (shellArray != null) {
            int n = 196608;
            int n2 = shellArray.length;
            while (--n2 >= 0) {
                Shell shell2 = shellArray[n2];
                if (shell2 == null) continue;
                if ((shell2.style & n) != 0) {
                    Composite composite = this;
                    while (composite != null && composite != shell2) {
                        composite = composite.parent;
                    }
                    if (composite == shell2) break;
                    return shell2;
                }
                if ((shell2.style & 0x8000) == 0) continue;
                if (shell == null) {
                    shell = this.getShell();
                }
                if (shell2.parent != shell) continue;
                return shell2;
            }
        }
        return null;
    }

    public boolean getModified() {
        this.checkWidget();
        return this.modified;
    }

    @Override
    Point getSizeInPixels() {
        this.checkWidget();
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.vboxHandle, gtkAllocation);
        int n = gtkAllocation.width;
        int n2 = gtkAllocation.height;
        int n3 = 0;
        if ((this.style & 0xCF8) == 0 || this.isCustomResize()) {
            n3 = this.gtk_container_get_border_width_or_margin(this.shellHandle);
        }
        return new Point(n + this.trimWidth() + 2 * n3, n2 + this.trimHeight() + 2 * n3);
    }

    @Override
    public boolean getVisible() {
        this.checkWidget();
        return GTK.gtk_widget_get_visible(this.shellHandle);
    }

    @Override
    public Region getRegion() {
        this.checkWidget();
        if (this.originalRegion != null) {
            return this.originalRegion;
        }
        return this.region;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    @Override
    Shell _getShell() {
        return this;
    }

    public Shell[] getShells() {
        Shell[] shellArray;
        this.checkWidget();
        int n = 0;
        Shell[] shellArray2 = shellArray = this.display.getShells();
        int n2 = shellArray2.length;
        for (int i = 0; i < n2; ++i) {
            Shell shell;
            Composite composite = shell = shellArray2[i];
            while ((composite = composite.getParent()) != null && composite != this) {
            }
            if (composite != this) continue;
            ++n;
        }
        int n3 = 0;
        Shell[] shellArray3 = new Shell[n];
        Shell[] shellArray4 = shellArray;
        int n4 = shellArray4.length;
        for (int i = 0; i < n4; ++i) {
            Shell shell;
            Composite composite = shell = shellArray4[i];
            while ((composite = composite.getParent()) != null && composite != this) {
            }
            if (composite != this) continue;
            shellArray3[n3++] = shell;
        }
        return shellArray3;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        if (l == this.shellHandle) {
            if (this.isCustomResize()) {
                if (OS.isX11() && (this.style & 0x4000) != 0 && (this.style & 0x80000) == 0) {
                    this.forceActive();
                }
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                GDK.gdk_event_get_root_coords(l2, dArray, dArray2);
                int[] nArray = new int[1];
                GDK.gdk_event_get_button(l2, nArray);
                if (nArray[0] == 1) {
                    this.display.resizeLocationX = dArray[0];
                    this.display.resizeLocationY = dArray2[0];
                    int[] nArray2 = new int[1];
                    int[] nArray3 = new int[1];
                    GTK3.gtk_window_get_position(this.shellHandle, nArray2, nArray3);
                    this.display.resizeBoundsX = nArray2[0];
                    this.display.resizeBoundsY = nArray3[0];
                    GtkAllocation gtkAllocation = new GtkAllocation();
                    GTK.gtk_widget_get_allocation(this.shellHandle, gtkAllocation);
                    this.display.resizeBoundsWidth = gtkAllocation.width;
                    this.display.resizeBoundsHeight = gtkAllocation.height;
                }
            }
            if (this.requiresUngrab()) {
                long l3 = GDK.gdk_event_get_seat(l2);
                GDK.gdk_seat_ungrab(l3);
                GTK3.gtk_grab_remove(this.shellHandle);
            }
            return 0L;
        }
        return super.gtk_button_press_event(l, l2);
    }

    @Override
    long gtk_configure_event(long l, long l2) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GTK3.gtk_window_get_position(this.shellHandle, nArray, nArray2);
        if (!this.isVisible()) {
            return 0L;
        }
        if (!this.moved || this.oldX != nArray[0] || this.oldY != nArray2[0]) {
            this.moved = true;
            this.oldX = nArray[0];
            this.oldY = nArray2[0];
            this.sendEvent(10);
        }
        return 0L;
    }

    @Override
    long gtk_close_request(long l) {
        if (this.isEnabled()) {
            this.closeWidget();
        }
        return 1L;
    }

    @Override
    long gtk_delete_event(long l, long l2) {
        if (this.isEnabled()) {
            this.closeWidget();
        }
        return 1L;
    }

    @Override
    long gtk_enter_notify_event(long l, long l2) {
        if (l != this.shellHandle) {
            return super.gtk_enter_notify_event(l, l2);
        }
        return 0L;
    }

    @Override
    long gtk_draw(long l, long l2) {
        if (l == this.shellHandle) {
            if (this.isCustomResize()) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                long l3 = this.gtk_widget_get_window(l);
                this.gdk_window_get_size(l3, nArray, nArray2);
                int n = this.gtk_container_get_border_width_or_margin(l);
                long l4 = GTK.gtk_widget_get_style_context(this.shellHandle);
                GTK.gtk_style_context_save(l4);
                GTK.gtk_render_frame(l4, l2, 0.0, 0.0, nArray[0], n);
                GTK.gtk_render_frame(l4, l2, 0.0, nArray2[0] - n, nArray[0], n);
                GTK.gtk_render_frame(l4, l2, 0.0, n, n, nArray2[0] - n - n);
                GTK.gtk_render_frame(l4, l2, nArray[0] - n, n, n, nArray2[0] - n - n);
                GTK.gtk_render_frame(l4, l2, 10.0, 10.0, nArray[0] - 20, nArray2[0] - 20);
                GTK.gtk_style_context_restore(l4);
                return 1L;
            }
            if (GTK.GTK4) {
                super.gtk_draw(l, l2);
            }
            return 0L;
        }
        return super.gtk_draw(l, l2);
    }

    @Override
    long gtk_focus(long l, long l2) {
        switch ((int)l2) {
            case 0: 
            case 1: {
                Control control = this.display.getFocusControl();
                if (control == null || (control.state & 2) == 0 || (control.style & 0x1000000) == 0 || control.getShell() != this) break;
                int n = l2 == 0L ? 16 : 8;
                control.traverse(n);
                return 1L;
            }
        }
        return super.gtk_focus(l, l2);
    }

    @Override
    long gtk_focus_in_event(long l, long l2) {
        if (l != this.shellHandle) {
            return super.gtk_focus_in_event(l, l2);
        }
        this.display.activeShell = this;
        this.display.activePending = false;
        if (!this.ignoreFocusIn) {
            this.sendEvent(26);
        } else {
            this.ignoreFocusIn = false;
        }
        this.restoreFocus();
        return 0L;
    }

    @Override
    long gtk_focus_out_event(long l, long l2) {
        if (l != this.shellHandle) {
            return super.gtk_focus_out_event(l, l2);
        }
        Display display = this.display;
        if (!this.ignoreFocusOut && !this.ignoreFocusOutAfterGrab) {
            this.sendEvent(27);
            this.setActiveControl(null);
        }
        this.ignoreFocusOutAfterGrab = false;
        if (display.activeShell == this && !this.ignoreFocusOut) {
            display.activeShell = null;
            display.activePending = false;
        }
        return 0L;
    }

    @Override
    long gtk_leave_notify_event(long l, long l2) {
        if (l == this.shellHandle) {
            if (this.isCustomResize()) {
                int[] nArray = new int[1];
                if (GTK.GTK4) {
                    nArray[0] = GDK.gdk_event_get_modifier_state(l2);
                } else {
                    GDK.gdk_event_get_state(l2, nArray);
                }
                if ((nArray[0] & 0x100) == 0) {
                    if (GTK.GTK4) {
                        GTK4.gtk_widget_set_cursor(this.shellHandle, 0L);
                    } else {
                        long l3 = this.gtk_widget_get_window(this.shellHandle);
                        GDK.gdk_window_set_cursor(l3, 0L);
                    }
                    this.display.resizeMode = 0;
                }
            }
            return 0L;
        }
        return super.gtk_leave_notify_event(l, l2);
    }

    @Override
    long gtk_map(long l) {
        if (GTK.GTK4) {
            this.mapped = true;
        }
        return super.gtk_map(l);
    }

    @Override
    long gtk_move_focus(long l, long l2) {
        Control control = this.display.getFocusControl();
        if (control != null) {
            long l3 = control.focusHandle();
            GTK.gtk_widget_child_focus(l3, (int)l2);
        }
        OS.g_signal_stop_emission_by_name(this.shellHandle, OS.move_focus);
        return 1L;
    }

    @Override
    long gtk_motion_notify_event(long l, long l2) {
        if (l == this.shellHandle) {
            if (this.isCustomResize()) {
                int[] nArray = new int[1];
                if (GTK.GTK4) {
                    nArray[0] = GDK.gdk_event_get_modifier_state(l2);
                } else {
                    GDK.gdk_event_get_state(l2, nArray);
                }
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                GDK.gdk_event_get_root_coords(l2, dArray, dArray2);
                if ((nArray[0] & 0x100) != 0) {
                    int n = this.gtk_container_get_border_width_or_margin(this.shellHandle);
                    int n2 = (int)(dArray[0] - this.display.resizeLocationX);
                    int n3 = (int)(dArray2[0] - this.display.resizeLocationY);
                    int n4 = this.display.resizeBoundsX;
                    int n5 = this.display.resizeBoundsY;
                    int n6 = this.display.resizeBoundsWidth;
                    int n7 = this.display.resizeBoundsHeight;
                    int n8 = Math.max(n6 - n2, Math.max(this.geometry.getMinWidth(), n + n));
                    int n9 = Math.max(n7 - n3, Math.max(this.geometry.getMinHeight(), n + n));
                    switch (this.display.resizeMode) {
                        case 13: {
                            n4 += n6 - n8;
                            n6 = n8;
                            break;
                        }
                        case 17: {
                            n4 += n6 - n8;
                            n6 = n8;
                            n5 += n7 - n9;
                            n7 = n9;
                            break;
                        }
                        case 10: {
                            n5 += n7 - n9;
                            n7 = n9;
                            break;
                        }
                        case 14: {
                            n6 = Math.max(n6 + n2, Math.max(this.geometry.getMinWidth(), n + n));
                            n5 += n7 - n9;
                            n7 = n9;
                            break;
                        }
                        case 12: {
                            n6 = Math.max(n6 + n2, Math.max(this.geometry.getMinWidth(), n + n));
                            break;
                        }
                        case 15: {
                            n6 = Math.max(n6 + n2, Math.max(this.geometry.getMinWidth(), n + n));
                            n7 = Math.max(n7 + n3, Math.max(this.geometry.getMinHeight(), n + n));
                            break;
                        }
                        case 11: {
                            n7 = Math.max(n7 + n3, Math.max(this.geometry.getMinHeight(), n + n));
                            break;
                        }
                        case 16: {
                            n4 += n6 - n8;
                            n6 = n8;
                            n7 = Math.max(n7 + n3, Math.max(this.geometry.getMinHeight(), n + n));
                        }
                    }
                    if (n4 != this.display.resizeBoundsX || n5 != this.display.resizeBoundsY) {
                        if (!GTK.GTK4) {
                            GDK.gdk_window_move_resize(this.gtk_widget_get_window(this.shellHandle), n4, n5, n6, n7);
                        }
                    } else {
                        GTK3.gtk_window_resize(this.shellHandle, n6, n7);
                    }
                } else {
                    double[] dArray3 = new double[1];
                    double[] dArray4 = new double[1];
                    if (GTK.GTK4) {
                        GDK.gdk_event_get_position(l2, dArray3, dArray4);
                    } else {
                        GDK.gdk_event_get_coords(l2, dArray3, dArray4);
                    }
                    int n = this.getResizeMode(dArray3[0], dArray4[0]);
                    if (n != this.display.resizeMode) {
                        long l3 = this.display.getSystemCursor((int)n).handle;
                        if (GTK.GTK4) {
                            GTK4.gtk_widget_set_cursor(this.shellHandle, l3);
                        } else {
                            long l4 = this.gtk_widget_get_window(this.shellHandle);
                            GDK.gdk_window_set_cursor(l4, l3);
                        }
                        this.display.resizeMode = n;
                    }
                }
            }
            return 0L;
        }
        return super.gtk_motion_notify_event(l, l2);
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        if (l == this.shellHandle) {
            Control control;
            if ((this.state & 0x10) != 0) {
                return 1L;
            }
            if (this.menuBar != null && !this.menuBar.isDisposed() && (control = this.display.getFocusControl()) != null && (control.hooks(1) || control.filters(1))) {
                long[] lArray = new long[1];
                long l3 = GTK.gtk_settings_get_default();
                OS.g_object_get(l3, GTK.gtk_menu_bar_accel, lArray, 0L);
                if (lArray[0] != 0L) {
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    GTK.gtk_accelerator_parse(lArray[0], nArray, nArray2);
                    OS.g_free(lArray[0]);
                    if (nArray[0] != 0) {
                        int[] nArray3 = new int[1];
                        int[] nArray4 = new int[1];
                        if (GTK.GTK4) {
                            nArray3[0] = GDK.gdk_key_event_get_keyval(l2);
                            nArray4[0] = GDK.gdk_event_get_modifier_state(l2);
                        } else {
                            GDK.gdk_event_get_keyval(l2, nArray3);
                            GDK.gdk_event_get_state(l2, nArray4);
                        }
                        int n = GTK.gtk_accelerator_get_default_mod_mask();
                        if (nArray3[0] == nArray[0] && (nArray4[0] & n) == (nArray2[0] & n)) {
                            return control.gtk_key_press_event(control.focusHandle(), l2);
                        }
                    }
                }
            }
            return 0L;
        }
        return super.gtk_key_press_event(l, l2);
    }

    @Override
    long gtk_size_allocate(long l, long l2) {
        GdkRectangle gdkRectangle = new GdkRectangle();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (GTK.GTK4) {
            if (!GTK4.gtk_window_is_maximized(this.shellHandle)) {
                GTK.gtk_window_get_default_size(this.shellHandle, nArray, nArray2);
            } else {
                long l3 = GDK.gdk_display_get_default();
                long l4 = GDK.gdk_display_get_monitor_at_surface(l3, this.paintSurface());
                GDK.gdk_monitor_get_geometry(l4, gdkRectangle);
                long l5 = GTK4.gtk_widget_get_next_sibling(GTK4.gtk_widget_get_first_child(this.shellHandle));
                int[] nArray3 = new int[1];
                GTK4.gtk_widget_measure(l5, 1, 0, null, nArray3, null, null);
                nArray[0] = gdkRectangle.width;
                nArray2[0] = gdkRectangle.height - nArray3[0];
            }
        } else {
            GTK3.gtk_window_get_size(this.shellHandle, nArray, nArray2);
        }
        int n = nArray[0];
        int n2 = nArray2[0];
        if (!(this.resized && this.oldWidth == n && this.oldHeight == n2 || OS.isWayland() && (this.style & 0x10) == 0)) {
            this.oldWidth = n;
            this.oldHeight = n2;
            this.resizeBounds(n, n2, true);
        }
        return 0L;
    }

    private void updateDecorations(long l) {
        String string;
        if (OS.isX11() && (string = System.getenv("GTK_CSD")) != null && string.equals("1")) {
            return;
        }
        int n = 0;
        int n2 = 0;
        if ((this.style & 8) == 0) {
            if ((this.style & 0x80) != 0) {
                n |= 0x20;
                n2 |= 8;
            }
            if ((this.style & 0x400) != 0) {
                n |= 0x40;
                n2 |= 0x10;
            }
            if ((this.style & 0x10) != 0) {
                n |= 4;
                n2 |= 2;
            }
            if ((this.style & 0x800) != 0) {
                n |= 2;
            }
            if ((this.style & 0x40) != 0) {
                n |= 0x10;
            }
            if ((this.style & 0x20) != 0) {
                n |= 8;
            }
            if ((this.style & 0x40) != 0) {
                n2 |= 0x20;
            }
            if ((this.style & 0x10) != 0) {
                n |= 2;
            }
            if ((this.style & 0x800000) == 0) {
                n2 |= 4;
            }
        }
        if (!GTK.GTK4) {
            GDK.gdk_window_set_decorations(l, n);
            GDK.gdk_window_set_functions(l, n2);
        }
    }

    @Override
    long gtk_realize(long l) {
        long l2 = super.gtk_realize(l);
        long l3 = GTK.GTK4 ? this.gtk_widget_get_surface(this.shellHandle) : this.gtk_widget_get_window(this.shellHandle);
        if ((this.style & 0x4F0) != 1264) {
            this.updateDecorations(l3);
        } else if ((this.style & 0x800000) != 0 && !GTK.GTK4) {
            GDK.gdk_window_set_functions(l3, 5);
        }
        if ((this.style & 0x4000) != 0 && !GTK.GTK4) {
            GTK3.gtk_window_set_keep_above(this.shellHandle, true);
        }
        return l2;
    }

    @Override
    long gtk_window_state_event(long l, long l2) {
        GdkEventWindowState gdkEventWindowState = new GdkEventWindowState();
        GTK3.memmove(gdkEventWindowState, l2, (long)GdkEventWindowState.sizeof);
        this.minimized = (gdkEventWindowState.new_window_state & 2) != 0;
        this.maximized = (gdkEventWindowState.new_window_state & 4) != 0;
        boolean bl = this.fullScreen = (gdkEventWindowState.new_window_state & 0x10) != 0;
        if ((gdkEventWindowState.changed_mask & 2) != 0) {
            if (this.minimized) {
                this.sendEvent(19);
            } else {
                this.sendEvent(20);
            }
            this.updateMinimized(this.minimized);
        }
        return 0L;
    }

    @Override
    long notifyState(long l, long l2) {
        assert (GTK.GTK4);
        int n = GTK4.gdk_toplevel_get_state(l);
        this.minimized = (n & 2) != 0;
        this.maximized = (n & 4) != 0;
        boolean bl = this.fullScreen = (n & 0x10) != 0;
        if ((n & 2) != 0) {
            if (this.minimized) {
                this.sendEvent(19);
            } else {
                this.sendEvent(20);
            }
            this.updateMinimized(this.minimized);
        }
        return 0L;
    }

    public void open() {
        Control control;
        this.checkWidget();
        this.setVisible(true);
        this.bringToTop(true);
        if (this.isDisposed()) {
            return;
        }
        boolean bl = this.restoreFocus();
        if (!bl) {
            bl = this.traverseGroup(true);
        }
        if (bl && (control = this.display.getFocusControl()) instanceof Button && (control.style & 8) != 0) {
            bl = false;
        }
        if (!bl) {
            if ((this.style & 0x4000) == 0) {
                this.display.focusEvent = 0;
            }
            if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
                this.defaultButton.setFocus();
            } else {
                this.setFocus();
            }
        }
    }

    @Override
    public boolean print(GC gC) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        if (!GTK.GTK4 && OS.isX11()) {
            Rectangle rectangle = gC.getClipping();
            long l = this.gtk_widget_get_window(this.shellHandle);
            GdkRectangle gdkRectangle = new GdkRectangle();
            GDK.gdk_window_get_frame_extents(l, gdkRectangle);
            if (rectangle.height < gdkRectangle.height || rectangle.width < gdkRectangle.width) {
                System.err.println("Warning: the GC provided to Shell.print() has a smaller clipping than what is needed to print the Shell trimmings and content. Only the client area will be printed.");
                return super.print(gC);
            }
            long l2 = GDK.gdk_get_default_root_window();
            long l3 = GDK.gdk_pixbuf_get_from_window(l2, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
            if (l3 != 0L) {
                GDK.gdk_cairo_set_source_pixbuf(gC.handle, l3, 0.0, 0.0);
                Cairo.cairo_paint(gC.handle);
                OS.g_object_unref(l3);
                return true;
            }
        }
        return false;
    }

    public void removeShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, shellListener);
        this.eventTable.unhook(19, shellListener);
        this.eventTable.unhook(20, shellListener);
        this.eventTable.unhook(26, shellListener);
        this.eventTable.unhook(27, shellListener);
    }

    void removeTooTip(ToolTip toolTip) {
        if (this.toolTips == null) {
            return;
        }
        for (int i = 0; i < this.toolTips.length; ++i) {
            if (this.toolTips[i] != toolTip) continue;
            this.toolTips[i] = null;
            return;
        }
    }

    @Override
    void reskinChildren(int n) {
        Widget widget;
        int n2;
        Shell[] shellArray = this.getShells();
        for (n2 = 0; n2 < shellArray.length; ++n2) {
            widget = shellArray[n2];
            if (widget == null) continue;
            widget.reskin(n);
        }
        if (this.toolTips != null) {
            for (n2 = 0; n2 < this.toolTips.length; ++n2) {
                widget = this.toolTips[n2];
                if (widget == null) continue;
                widget.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    public void setActive() {
        this.checkWidget();
        this.bringToTop(false);
    }

    void setActiveControl(Control control) {
        this.setActiveControl(control, 0);
    }

    void setActiveControl(Control control, int n) {
        int n2;
        int n3;
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] controlArray = control == null ? new Control[]{} : control.getPath();
        Control[] controlArray2 = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int n4 = Math.min(controlArray.length, controlArray2.length);
        for (n3 = 0; n3 < n4 && controlArray[n3] == controlArray2[n3]; ++n3) {
        }
        for (n2 = controlArray2.length - 1; n2 >= n3; --n2) {
            if (controlArray2[n2].isDisposed()) continue;
            controlArray2[n2].sendEvent(27);
        }
        for (n2 = controlArray.length - 1; n2 >= n3; --n2) {
            if (controlArray[n2].isDisposed()) continue;
            Event event = new Event();
            event.detail = n;
            controlArray[n2].sendEvent(26, event);
        }
    }

    public void setAlpha(int n) {
        boolean bl;
        this.checkWidget();
        if (GTK.GTK4) {
            long l = GDK.gdk_display_get_default();
            bl = GDK.gdk_display_is_composited(l);
        } else {
            long l = GTK3.gtk_widget_get_screen(this.shellHandle);
            bl = GDK.gdk_screen_is_composited(l);
        }
        if (bl) {
            GTK.gtk_widget_set_opacity(this.shellHandle, (double)n / 255.0);
        }
    }

    void resizeBounds(int n, int n2, boolean bl) {
        int n3 = this.gtk_container_get_border_width_or_margin(this.shellHandle);
        if (GTK.GTK4) {
            if (this.parent != null) {
                GtkAllocation gtkAllocation = new GtkAllocation();
                GtkAllocation gtkAllocation2 = new GtkAllocation();
                GTK.gtk_widget_get_allocation(this.vboxHandle, gtkAllocation2);
                gtkAllocation.width = n;
                gtkAllocation.height = n2 + gtkAllocation2.y;
                GTK4.gtk_widget_size_allocate(this.shellHandle, gtkAllocation, -1);
            }
        } else {
            if (this.redrawWindow != 0L) {
                GDK.gdk_window_resize(this.redrawWindow, n, n2);
            }
            if (this.enableWindow != 0L) {
                GDK.gdk_window_resize(this.enableWindow, n, n2);
            }
        }
        int n4 = n - 2 * n3;
        int n5 = n2 - 2 * n3;
        if ((this.style & 0x10) == 0) {
            GTK.gtk_widget_set_size_request(this.vboxHandle, n4, n5);
        }
        this.forceResize(n4, n5);
        if (bl) {
            this.resized = true;
            this.sendEvent(11);
            if (this.isDisposed()) {
                return;
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false);
                if (this.isCustomResize()) {
                    this.forceResize(n4, n5);
                }
            }
        }
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3;
        n3 = Math.min(n3, Short.MAX_VALUE);
        n4 = Math.min(n4, Short.MAX_VALUE);
        if (this.fullScreen) {
            this.setFullScreen(false);
        }
        if (this.getMaximized()) {
            boolean bl4;
            Rectangle rectangle = this.getBoundsInPixels();
            bl3 = !bl || rectangle.x == n && rectangle.y == n2;
            boolean bl5 = bl4 = !bl2 || rectangle.width == n3 && rectangle.height == n4;
            if (bl3 && bl4) {
                return 0;
            }
            this.setMaximized(false);
        }
        int n5 = 0;
        if (bl && !GTK.GTK4) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            GTK3.gtk_window_get_position(this.shellHandle, nArray, nArray2);
            GTK3.gtk_window_move(this.shellHandle, n, n2);
            for (int i = 0; i < 1000; ++i) {
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                GTK3.gtk_window_get_position(this.shellHandle, nArray3, nArray4);
                if (nArray3[0] == n && nArray4[0] == n2) break;
            }
            if (nArray[0] != n || nArray2[0] != n2) {
                this.moved = true;
                this.oldX = n;
                this.oldY = n2;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return 0;
                }
                n5 |= 0x80;
            }
        }
        if (bl2) {
            n3 = Math.max(1, Math.max(this.geometry.getMinWidth(), n3 - this.trimWidth()));
            if (this.geometry.getMaxWidth() > 0) {
                n3 = Math.min(n3, this.geometry.getMaxWidth());
            }
            n4 = Math.max(1, Math.max(this.geometry.getMinHeight(), n4 - this.trimHeight()));
            if (this.geometry.getMaxHeight() > 0) {
                n4 = Math.min(n4, this.geometry.getMaxHeight());
            }
            if ((this.style & 0x10) != 0 || this.geometry.getMinHeight() != 0 || this.geometry.getMinWidth() != 0 || this.geometry.getMaxHeight() != 0 || this.geometry.getMaxWidth() != 0) {
                if (GTK.GTK4) {
                    long l = GTK4.gtk_widget_get_next_sibling(GTK4.gtk_widget_get_first_child(this.shellHandle));
                    int[] nArray = new int[1];
                    GTK4.gtk_widget_measure(l, 1, 0, null, nArray, null, null);
                    GTK.gtk_window_set_default_size(this.shellHandle, n3, n4 + nArray[0]);
                } else {
                    GTK3.gtk_window_resize(this.shellHandle, n3, n4);
                }
            }
            boolean bl6 = bl3 = n3 != this.oldWidth || n4 != this.oldHeight;
            if (bl3) {
                this.oldWidth = n3;
                this.oldHeight = n4;
                n5 |= 0x100;
            }
            this.resizeBounds(n3, n4, bl3);
        }
        return n5;
    }

    @Override
    void setCursor(long l) {
        if (!GTK.GTK4 && this.enableWindow != 0L) {
            GDK.gdk_window_set_cursor(this.enableWindow, l);
        }
        super.setCursor(l);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((this.state & 0x10) == 0 == bl) {
            return;
        }
        Display display = this.display;
        Control control = null;
        boolean bl2 = false;
        if (!bl && display.focusEvent != 16) {
            control = display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        this.state = bl ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        this.enableWidget(bl);
        if (this.isDisposed()) {
            return;
        }
        if (!GTK.GTK4) {
            if (bl) {
                if (this.enableWindow != 0L) {
                    this.cleanupEnableWindow();
                }
            } else {
                long l = this.shellHandle;
                GTK.gtk_widget_realize(l);
                long l2 = this.gtk_widget_get_window(l);
                Rectangle rectangle = this.getBoundsInPixels();
                GdkWindowAttr gdkWindowAttr = new GdkWindowAttr();
                gdkWindowAttr.width = rectangle.width;
                gdkWindowAttr.height = rectangle.height;
                gdkWindowAttr.event_mask = -32769;
                gdkWindowAttr.wclass = 1;
                gdkWindowAttr.window_type = 2;
                this.enableWindow = GTK3.gdk_window_new(l2, gdkWindowAttr, 0);
                if (this.enableWindow != 0L) {
                    if (this.cursor != null) {
                        GDK.gdk_window_set_cursor(this.enableWindow, this.cursor.handle);
                    }
                    GDK.gdk_window_set_user_data(this.enableWindow, l);
                    GDK.gdk_window_show(this.enableWindow);
                }
            }
        }
        if (bl2) {
            this.fixFocus(control);
        }
        if (bl && display.activeShell == this && !this.restoreFocus()) {
            this.traverseGroup(false);
        }
    }

    public void setFullScreen(boolean bl) {
        this.checkWidget();
        if (bl) {
            GTK.gtk_window_fullscreen(this.shellHandle);
        } else {
            GTK.gtk_window_unfullscreen(this.shellHandle);
            if (this.maximized) {
                this.setMaximized(true);
            }
        }
        this.fullScreen = bl;
    }

    public void setImeInputMode(int n) {
        this.checkWidget();
    }

    @Override
    void setInitialBounds() {
        int n = 0;
        int n2 = 0;
        if ((this.state & 0x400000) != 0) {
            GtkAllocation gtkAllocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.shellHandle, gtkAllocation);
            n = gtkAllocation.width;
            n2 = gtkAllocation.height;
        } else {
            GdkRectangle gdkRectangle = new GdkRectangle();
            if (GTK.GTK4) {
                long l;
                long l2 = GDK.gdk_display_get_default();
                if (l2 != 0L) {
                    l = GDK.gdk_display_get_monitor_at_surface(l2, this.paintSurface());
                    GDK.gdk_monitor_get_geometry(l, gdkRectangle);
                    n = (int)((double)gdkRectangle.width * 0.625);
                    n2 = (int)((double)gdkRectangle.height * 0.625);
                }
                if ((this.style & 0x10) != 0) {
                    l = GTK4.gtk_widget_get_next_sibling(GTK4.gtk_widget_get_first_child(this.shellHandle));
                    int[] nArray = new int[1];
                    GTK4.gtk_widget_measure(l, 1, 0, null, nArray, null, null);
                    GTK.gtk_window_set_default_size(this.shellHandle, n, n2 + nArray[0]);
                }
            } else {
                long l = GDK.gdk_display_get_default();
                if (l != 0L) {
                    long l3 = GDK.gdk_display_get_monitor_at_window(l, this.paintWindow());
                    GDK.gdk_monitor_get_geometry(l3, gdkRectangle);
                    n = (int)((double)gdkRectangle.width * 0.625);
                    n2 = (int)((double)gdkRectangle.height * 0.625);
                }
                if (n == 0 && n2 == 0) {
                    n = (int)((double)GDK.gdk_screen_width() * 0.625);
                    n2 = (int)((double)GDK.gdk_screen_height() * 0.625);
                }
                if ((this.style & 0x10) != 0) {
                    GTK3.gtk_window_resize(this.shellHandle, n, n2);
                }
            }
        }
        this.resizeBounds(n, n2, false);
    }

    @Override
    public void setMaximized(boolean bl) {
        this.checkWidget();
        super.setMaximized(bl);
        if (bl) {
            GTK.gtk_window_maximize(this.shellHandle);
        } else {
            GTK.gtk_window_unmaximize(this.shellHandle);
        }
    }

    @Override
    public void setMenuBar(Menu menu) {
        long l;
        boolean bl;
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        boolean bl2 = bl = menu != null && this.menuBar != null;
        if (menu != null) {
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        if (this.menuBar != null) {
            l = this.menuBar.handle;
            GTK.gtk_widget_hide(l);
            if (!GTK.GTK4) {
                this.destroyAccelGroup();
            }
        }
        this.menuBar = menu;
        if (this.menuBar != null) {
            l = menu.handle;
            GTK.gtk_widget_show(l);
            if (!GTK.GTK4) {
                this.createAccelGroup();
                this.menuBar.addAccelerators(this.accelGroup);
            }
        }
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.vboxHandle, gtkAllocation);
        int n = gtkAllocation.width;
        int n2 = gtkAllocation.height;
        this.resizeBounds(n, n2, !bl);
    }

    @Override
    public void setMinimized(boolean bl) {
        this.checkWidget();
        if (this.minimized == bl) {
            return;
        }
        super.setMinimized(bl);
        if (!GTK.gtk_widget_get_visible(this.shellHandle)) {
            GTK.gtk_widget_show(this.shellHandle);
        }
        if (bl) {
            if (GTK.GTK4) {
                GTK4.gtk_window_minimize(this.shellHandle);
            } else {
                GTK3.gtk_window_iconify(this.shellHandle);
            }
        } else {
            if (GTK.GTK4) {
                GTK4.gtk_window_unminimize(this.shellHandle);
            } else {
                GTK3.gtk_window_deiconify(this.shellHandle);
            }
            this.bringToTop(false);
        }
    }

    public void setMinimumSize(int n, int n2) {
        this.checkWidget();
        this.setMinimumSize(new Point(n, n2));
    }

    void setMinimumSizeInPixels(int n, int n2) {
        this.checkWidget();
        this.geometry.setMinWidth(Math.max(n, this.trimWidth()) - this.trimWidth());
        this.geometry.setMinHeight(Math.max(n2, this.trimHeight()) - this.trimHeight());
        if (GTK.GTK4) {
            this.geometry.setMinSizeRequested(true);
            return;
        }
        int n3 = 2;
        if (this.geometry.getMaxHeight() > 0 || this.geometry.getMaxWidth() > 0) {
            n3 |= 4;
        }
        GTK3.gtk_window_set_geometry_hints(this.shellHandle, 0L, (GdkGeometry)this.geometry, n3);
    }

    public void setMinimumSize(Point point) {
        this.checkWidget();
        this.setMinimumSizeInPixels(DPIUtil.autoScaleUp(point));
    }

    void setMinimumSizeInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setMinimumSizeInPixels(point.x, point.y);
    }

    public void setMaximumSize(int n, int n2) {
        this.checkWidget();
        this.setMaximumSize(new Point(n, n2));
    }

    public void setMaximumSize(Point point) {
        this.checkWidget();
        this.setMaximumSizeInPixels(DPIUtil.autoScaleUp(point));
    }

    void setMaximumSizeInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setMaximumSizeInPixels(point.x, point.y);
    }

    void setMaximumSizeInPixels(int n, int n2) {
        this.checkWidget();
        this.geometry.setMaxWidth(Math.max(n, this.trimWidth()) - this.trimWidth());
        this.geometry.setMaxHeight(Math.max(n2, this.trimHeight()) - this.trimHeight());
        int n3 = 4;
        if (this.geometry.getMinWidth() > 0 || this.geometry.getMinHeight() > 0) {
            n3 |= 2;
        }
        GTK3.gtk_window_set_geometry_hints(this.shellHandle, 0L, (GdkGeometry)this.geometry, n3);
    }

    public void setModified(boolean bl) {
        this.checkWidget();
        this.modified = bl;
    }

    @Override
    public void setRegion(Region region) {
        Object object;
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (region != null) {
            object = region.getBounds();
            this.setSize(((Rectangle)object).x + ((Rectangle)object).width, ((Rectangle)object).y + ((Rectangle)object).height);
        }
        object = null;
        if ((this.style & 0x4000000) != 0) {
            if (this.originalRegion != null) {
                object = this.region;
            }
            this.originalRegion = region;
            region = Shell.mirrorRegion(region);
        } else {
            this.originalRegion = null;
        }
        super.setRegion(region);
        if (object != null) {
            ((Resource)object).dispose();
        }
    }

    static void gdk_region_get_rectangles(long l, long[] lArray, int[] nArray) {
        int n = Cairo.cairo_region_num_rectangles(l);
        if (nArray != null) {
            nArray[0] = n;
        }
        lArray[0] = OS.g_malloc(GdkRectangle.sizeof * n);
        for (int i = 0; i < n; ++i) {
            Cairo.cairo_region_get_rectangle(l, i, lArray[0] + (long)(i * GdkRectangle.sizeof));
        }
    }

    static Region mirrorRegion(Region region) {
        if (region == null) {
            return null;
        }
        Region region2 = new Region(region.getDevice());
        long l = region.handle;
        int[] nArray = new int[1];
        long[] lArray = new long[1];
        Shell.gdk_region_get_rectangles(l, lArray, nArray);
        Rectangle rectangle = DPIUtil.autoScaleUp(region.getBounds());
        cairo_rectangle_int_t cairo_rectangle_int_t2 = new cairo_rectangle_int_t();
        for (int i = 0; i < nArray[0]; ++i) {
            Cairo.memmove(cairo_rectangle_int_t2, lArray[0] + (long)(i * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
            cairo_rectangle_int_t2.x = rectangle.x + rectangle.width - cairo_rectangle_int_t2.x - cairo_rectangle_int_t2.width;
            Cairo.cairo_region_union_rectangle(region2.handle, cairo_rectangle_int_t2);
        }
        if (lArray[0] != 0L) {
            OS.g_free(lArray[0]);
        }
        return region2;
    }

    @Override
    void setRelations() {
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        int n = string.length();
        char[] cArray = new char[Math.max(6, n) + 1];
        string.getChars(0, n, cArray, 0);
        for (int i = n; i < cArray.length; ++i) {
            cArray[i] = 32;
        }
        byte[] byArray = Converter.wcsToMbcs(cArray, true);
        GTK.gtk_window_set_title(this.shellHandle, byArray);
    }

    @Override
    public void setVisible(boolean bl) {
        int n;
        this.checkWidget();
        if (this.moved) {
            this.setLocationInPixels(this.oldX, this.oldY);
        }
        if ((this.style & (n = 229376)) != 0) {
            if (bl) {
                this.display.setModalShell(this);
                GTK.gtk_window_set_modal(this.shellHandle, true);
            } else {
                this.display.clearModal(this);
                GTK.gtk_window_set_modal(this.shellHandle, false);
            }
            if (this.parent != null && this.parent.getShell().getFullScreen()) {
                GTK3.gtk_window_set_type_hint(this.shellHandle, 1);
            }
        } else {
            this.updateModal();
        }
        this.showWithParent = bl;
        if (GTK.gtk_widget_get_mapped(this.shellHandle) == bl) {
            return;
        }
        if (bl) {
            Object object;
            if (this.center && !this.moved) {
                this.center();
                if (this.isDisposed()) {
                    return;
                }
            }
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.mapped = false;
            if (!GTK.GTK4 && this.oldWidth == 0 && this.oldHeight == 0) {
                object = new int[1];
                int[] nArray = new int[1];
                GTK3.gtk_window_get_size(this.shellHandle, (int[])object, nArray);
                GTK3.gtk_window_resize(this.shellHandle, 1, 1);
                GTK.gtk_widget_show(this.shellHandle);
                GTK3.gtk_window_resize(this.shellHandle, object[0], nArray[0]);
                this.resizeBounds(object[0], nArray[0], false);
            } else {
                GTK.gtk_widget_show(this.shellHandle);
            }
            if (!GTK.GTK4 && this.enableWindow != 0L) {
                GDK.gdk_window_raise(this.enableWindow);
            }
            if (this.isDisposed()) {
                return;
            }
            if (GTK.GTK4 || !OS.isX11() || !GTK.GTK_IS_PLUG(this.shellHandle)) {
                Shell shell;
                this.display.dispatchEvents = new int[]{2, 12, 13, 14, 15, 30, 32};
                object = this.display;
                ((Display)object).putGdkEvents();
                boolean bl2 = false;
                Shell shell2 = shell = this.parent != null ? this.parent.getShell() : null;
                do {
                    if (GTK.GTK4) {
                        OS.g_main_context_iteration(0L, false);
                    } else {
                        GTK3.gtk_main_iteration_do(false);
                    }
                    if (this.isDisposed()) break;
                    boolean bl3 = bl2 = this.minimized || shell != null && shell.minimized;
                } while (!this.mapped && !bl2);
                ((Display)object).dispatchEvents = null;
                if (this.isDisposed()) {
                    return;
                }
                if (!bl2) {
                    this.update(true, true);
                    if (this.isDisposed()) {
                        return;
                    }
                    this.adjustTrim();
                }
            }
            this.mapped = true;
            if ((this.style & n) != 0 && !GTK.GTK4) {
                this.gdk_pointer_ungrab(GTK3.gtk_widget_get_window(this.shellHandle), 0);
            }
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                object = this.getLocationInPixels();
                this.oldX = ((Point)object).x;
                this.oldY = ((Point)object).y;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                object = this.getSizeInPixels();
                this.oldWidth = ((Point)object).x - this.trimWidth();
                this.oldHeight = ((Point)object).y - this.trimHeight();
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
        } else {
            this.fixActiveShell();
            this.checkAndUngrabFocus();
            GTK.gtk_widget_hide(this.shellHandle);
            this.sendEvent(23);
        }
    }

    @Override
    void setZOrder(Control control, boolean bl, boolean bl2) {
        if (this.mapped) {
            this.setZOrder(control, bl, false, false);
        }
    }

    @Override
    long shellMapProc(long l, long l2, long l3) {
        this.mapped = true;
        this.display.dispatchEvents = null;
        return 0L;
    }

    @Override
    void showWidget() {
        if ((this.state & 0x400000) != 0) {
            if (GTK.gtk_window_is_active(this.shellHandle)) {
                this.display.activeShell = this;
                this.display.activePending = true;
            }
            if (GTK.GTK4) {
                long l = GTK4.gtk_widget_get_first_child(this.shellHandle);
                while (l != 0L) {
                    GTK.gtk_widget_unparent(l);
                    l = GTK4.gtk_widget_get_next_sibling(l);
                }
            } else {
                long l;
                long l2 = l = GTK3.gtk_container_get_children(this.shellHandle);
                while (l2 != 0L) {
                    GTK3.gtk_container_remove(this.shellHandle, OS.g_list_data(l2));
                    l2 = OS.g_list_next(l2);
                }
                OS.g_list_free(l);
            }
        }
        if (GTK.GTK4) {
            GTK4.gtk_window_set_child(this.shellHandle, this.vboxHandle);
        } else {
            GTK3.gtk_container_add(this.shellHandle, this.vboxHandle);
        }
        if (this.scrolledHandle != 0L) {
            GTK.gtk_widget_show(this.scrolledHandle);
        }
        if (this.handle != 0L) {
            GTK.gtk_widget_show(this.handle);
        }
        if (this.vboxHandle != 0L) {
            GTK.gtk_widget_show(this.vboxHandle);
        }
    }

    @Override
    long sizeAllocateProc(long l, long l2, long l3) {
        Object object;
        int n = 16;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (GTK.GTK4) {
            object = new double[1];
            double[] dArray = new double[1];
            this.display.getPointerPosition((double[])object, dArray);
            nArray[0] = (int)object[0];
            nArray2[0] = (int)dArray[0];
        } else {
            this.display.getWindowPointerPosition(0L, nArray, nArray2, null);
        }
        nArray2[0] = nArray2[0] + n;
        object = new GdkRectangle();
        long l4 = GDK.gdk_display_get_default();
        long l5 = GDK.gdk_display_get_monitor_at_point(l4, nArray[0], nArray2[0]);
        GDK.gdk_monitor_get_geometry(l5, (GdkRectangle)object);
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        int n2 = gtkAllocation.width;
        int n3 = gtkAllocation.height;
        if (nArray[0] + n2 > object.x + object.width) {
            nArray[0] = object.x + object.width - n2;
        }
        if (nArray2[0] + n3 > object.y + object.height) {
            nArray2[0] = object.y + object.height - n3;
        }
        GTK3.gtk_window_move(l, nArray[0], nArray2[0]);
        return 0L;
    }

    @Override
    long sizeRequestProc(long l, long l2, long l3) {
        GTK.gtk_widget_hide(l);
        return 0L;
    }

    @Override
    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    int trimHeight() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        if (this.fullScreen) {
            return 0;
        }
        if (this.isCustomResize()) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl = (this.style & 0x4E0) != 0;
        bl2 = (this.style & 0x10) != 0;
        boolean bl4 = bl3 = (this.style & 0x800) != 0;
        if (bl) {
            if (bl2) {
                return this.display.trimHeights[4];
            }
            if (bl3) {
                return this.display.trimHeights[3];
            }
            return this.display.trimHeights[5];
        }
        if (bl2) {
            return this.display.trimHeights[2];
        }
        if (bl3) {
            return this.display.trimHeights[1];
        }
        return this.display.trimHeights[0];
    }

    int trimWidth() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        if (this.fullScreen) {
            return 0;
        }
        if (this.isCustomResize()) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl = (this.style & 0x4E0) != 0;
        bl2 = (this.style & 0x10) != 0;
        boolean bl4 = bl3 = (this.style & 0x800) != 0;
        if (bl) {
            if (bl2) {
                return this.display.trimWidths[4];
            }
            if (bl3) {
                return this.display.trimWidths[3];
            }
            return this.display.trimWidths[5];
        }
        if (bl2) {
            return this.display.trimWidths[2];
        }
        if (bl3) {
            return this.display.trimWidths[1];
        }
        return this.display.trimWidths[0];
    }

    void updateModal() {
        if (!GTK.GTK4 && OS.isX11() && GTK.GTK_IS_PLUG(this.shellHandle)) {
            return;
        }
        long l = 0L;
        boolean bl = false;
        if (this.display.getModalDialog() == null) {
            Shell shell = this.getModalShell();
            int n = 229376;
            Composite composite = null;
            if (shell == null) {
                if ((this.style & n) != 0) {
                    composite = this;
                    bl = GTK.gtk_window_get_modal(this.shellHandle);
                    if (bl) {
                        GTK.gtk_window_set_modal(this.shellHandle, false);
                    }
                }
            } else {
                composite = shell;
            }
            Shell shell2 = composite;
            while (composite != null) {
                if ((composite.style & n) == 0) {
                    l = composite.getShell().group;
                    break;
                }
                shell2 = composite;
                composite = composite.parent;
            }
            if (l == 0L && shell2 != null) {
                l = shell2.getShell().group;
            }
        }
        if (l == 0L) {
            l = GTK.gtk_window_get_group(0L);
        }
        if (l != 0L) {
            GTK.gtk_window_group_add_window(l, this.shellHandle);
            if (bl) {
                GTK.gtk_window_set_modal(this.shellHandle, true);
            }
        } else if (this.modalGroup != 0L) {
            GTK.gtk_window_group_remove_window(this.modalGroup, this.shellHandle);
        }
        this.modalGroup = l;
    }

    void updateMinimized(boolean bl) {
        Shell[] shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            Shell shell;
            boolean bl2 = false;
            for (shell = shellArray[i]; shell != null && shell != this && !shell.isUndecorated(); shell = (Shell)shell.getParent()) {
            }
            if (shell != null && shell != this) {
                bl2 = true;
            }
            if (!bl2) continue;
            if (bl) {
                if (!shellArray[i].isVisible()) continue;
                shellArray[i].showWithParent = true;
                GTK.gtk_widget_hide(shellArray[i].shellHandle);
                continue;
            }
            if (!shellArray[i].showWithParent) continue;
            shellArray[i].showWithParent = false;
            GTK.gtk_widget_show(shellArray[i].shellHandle);
        }
    }

    @Override
    void deregister() {
        super.deregister();
        Widget widget = this.display.removeWidget(this.shellHandle);
        if (this.shellHandle != 0L && !(widget instanceof Shell)) {
            SWT.error(51, null, ". Wrong widgetTable entry: " + widget + " removed for shell: " + this + this.display.dumpWidgetTableInfo());
        }
        if (Display.strictChecks) {
            Shell[] shellArray;
            for (Shell shell : shellArray = this.display.getShells()) {
                if (shell != this) continue;
                SWT.error(51, null, ". Disposed shell still in the widgetTable: " + this + this.display.dumpWidgetTableInfo());
            }
        }
    }

    boolean requiresUngrab() {
        return OS.isWayland() && (this.style & 0x4000) != 0 && (this.style & 0x80000) == 0;
    }

    void checkAndUngrabFocus() {
        if (this.requiresUngrab() && !this.isMappedToPopup() && this.grabbedFocus) {
            long l;
            if (GTK.GTK4) {
                long l2 = this.gtk_widget_get_surface(this.shellHandle);
                l = GDK.gdk_surface_get_display(l2);
            } else {
                long l3 = this.gtk_widget_get_window(this.shellHandle);
                l = GDK.gdk_window_get_display(l3);
                GTK3.gtk_grab_remove(this.shellHandle);
            }
            long l4 = GDK.gdk_display_get_default_seat(l);
            GDK.gdk_seat_ungrab(l4);
            this.grabbedFocus = false;
        }
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.fixActiveShell();
        this.checkAndUngrabFocus();
        if (this.popupChild != null && this.popupChild.shellHandle != 0L && !this.popupChild.isDisposed()) {
            this.popupChild.dispose();
        }
        GTK.gtk_widget_hide(this.shellHandle);
        super.dispose();
    }

    public void forceActive() {
        this.checkWidget();
        this.bringToTop(true);
    }

    @Override
    Rectangle getBoundsInPixels() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if ((this.state & 0x200000) == 0) {
            if (!GTK.GTK4) {
                GTK3.gtk_window_get_position(this.shellHandle, nArray, nArray2);
            }
        } else if (!GTK.GTK4) {
            GDK.gdk_window_get_root_origin(GTK3.gtk_widget_get_window(this.shellHandle), nArray, nArray2);
        }
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.vboxHandle, gtkAllocation);
        int n = gtkAllocation.width;
        int n2 = gtkAllocation.height;
        int n3 = 0;
        if ((this.style & 0xCF8) == 0 || this.isCustomResize()) {
            n3 = this.gtk_container_get_border_width_or_margin(this.shellHandle);
        }
        return new Rectangle(nArray[0], nArray2[0], n + this.trimWidth() + 2 * n3, n2 + this.trimHeight() + 2 * n3);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.shellHandle = 0L;
    }

    @Override
    void releaseChildren(boolean bl) {
        Widget widget;
        int n;
        Shell[] shellArray = this.getShells();
        for (n = 0; n < shellArray.length; ++n) {
            widget = shellArray[n];
            if (widget == null || widget.isDisposed()) continue;
            ((Control)widget).release(false);
        }
        if (this.toolTips != null) {
            for (n = 0; n < this.toolTips.length; ++n) {
                widget = this.toolTips[n];
                if (widget == null || widget.isDisposed()) continue;
                widget.dispose();
            }
            this.toolTips = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseWidget() {
        Region region = null;
        if (this.originalRegion != null) {
            region = this.region;
        }
        super.releaseWidget();
        this.destroyAccelGroup();
        this.display.clearModal(this);
        if (this.display.activeShell == this) {
            this.display.activeShell = null;
        }
        if (this.tooltipsHandle != 0L) {
            OS.g_object_unref(this.tooltipsHandle);
        }
        this.tooltipsHandle = 0L;
        if (this.group != 0L) {
            OS.g_object_unref(this.group);
        }
        this.modalGroup = 0L;
        this.group = 0L;
        this.lastActive = null;
        if (region != null) {
            region.dispose();
        }
    }

    @Override
    Point getWindowOrigin() {
        if (!this.mapped) {
            return this.getLocationInPixels();
        }
        return super.getWindowOrigin();
    }

    @Override
    Point getSurfaceOrigin() {
        if (!this.mapped) {
            return this.getLocationInPixels();
        }
        return super.getSurfaceOrigin();
    }
}

