/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.BorderData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BorderLayout
extends Layout {
    private static final String LAYOUT_KEY = BorderLayout.class.getName() + ".layoutData";
    private static final ToIntFunction<Point> WIDTH = point -> point.x;
    private static final ToIntFunction<Point> HEIGHT = point -> point.y;
    public int type = 256;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int spacing = 0;
    public int controlSpacing = 0;
    public double widthDistributionFactor = 0.5;
    public double heightDistributionFactor = 0.5;

    @Override
    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (n2 > -1 && n > -1) {
            return new Point(n, n2);
        }
        Stream<Map.Entry> stream = Arrays.stream(composite.getChildren()).map(control -> this.borderDataControl(control, bl));
        Map<Integer, List<Map.Entry<Control, BorderData>>> map = stream.collect(Collectors.groupingBy(BorderLayout::region));
        if (n <= -1) {
            IntStream.Builder builder = IntStream.builder();
            int n10 = this.getTotal(WIDTH, 128, map);
            n9 = this.getTotal(WIDTH, 1024, map);
            n8 = this.type == 256 ? this.getTotal(WIDTH, 0x1000000, map) : BorderLayout.getMax(WIDTH, 0x1000000, map);
            n7 = BorderLayout.getMax(WIDTH, 16384, map);
            n6 = BorderLayout.getMax(WIDTH, 131072, map);
            n5 = n7 + n8 + n6;
            if (n8 > 0) {
                if (n7 > 0) {
                    n5 += this.spacing;
                }
                if (n6 > 0) {
                    n5 += this.spacing;
                }
            } else if (n7 > 0 && n6 > 0) {
                n5 += this.spacing;
            }
            builder.add(n5);
            builder.add(n10);
            builder.add(n9);
            n4 = builder.build().max().orElse(0) + 2 * this.marginWidth;
        } else {
            n4 = n;
        }
        if (n2 <= -1) {
            IntStream.Builder builder = IntStream.builder();
            n9 = BorderLayout.getMax(HEIGHT, 128, map);
            n8 = BorderLayout.getMax(HEIGHT, 1024, map);
            n7 = this.getTotal(HEIGHT, 16384, map);
            n6 = this.getTotal(HEIGHT, 131072, map);
            n5 = this.type == 256 ? BorderLayout.getMax(HEIGHT, 0x1000000, map) : this.getTotal(HEIGHT, 0x1000000, map);
            if (n5 > 0) {
                if (n9 > 0) {
                    n5 += this.spacing;
                }
                if (n8 > 0) {
                    n5 += this.spacing;
                }
            }
            if (n7 > 0) {
                if (n9 > 0) {
                    n7 += this.spacing;
                }
                if (n8 > 0) {
                    n7 += this.spacing;
                }
            }
            if (n6 > 0) {
                if (n9 > 0) {
                    n6 += this.spacing;
                }
                if (n8 > 0) {
                    n6 += this.spacing;
                }
            }
            int n11 = n9 + n8;
            builder.add(n7 + n11);
            builder.add(n5 + n11);
            builder.add(n6 + n11);
            n3 = builder.build().max().orElse(0) + 2 * this.marginHeight;
        } else {
            n3 = n2;
        }
        return new Point(n4, n3);
    }

    private int getTotal(ToIntFunction<Point> toIntFunction, int n, Map<Integer, List<Map.Entry<Control, BorderData>>> map) {
        List list = map.getOrDefault(n, Collections.emptyList());
        if (list.isEmpty()) {
            return 0;
        }
        return list.stream().mapToInt(entry -> toIntFunction.applyAsInt(((BorderData)entry.getValue()).getSize((Control)entry.getKey()))).sum() + (list.size() - 1) * this.controlSpacing;
    }

    private static int getMax(ToIntFunction<Point> toIntFunction, int n, Map<Integer, List<Map.Entry<Control, BorderData>>> map) {
        List<Map.Entry<Control, BorderData>> list = map.getOrDefault(n, Collections.emptyList());
        return BorderLayout.getMax(toIntFunction, list, -1, -1, false);
    }

    private static int getMax(ToIntFunction<Point> toIntFunction, List<Map.Entry<Control, BorderData>> list, int n, int n2, boolean bl) {
        if (list.isEmpty()) {
            return 0;
        }
        if (n != -1 || n2 != -1) {
            return list.stream().mapToInt(entry -> toIntFunction.applyAsInt(((BorderData)entry.getValue()).computeSize((Control)entry.getKey(), n, n2, bl))).max().orElse(0);
        }
        return list.stream().mapToInt(entry -> toIntFunction.applyAsInt(((BorderData)entry.getValue()).getSize((Control)entry.getKey()))).max().orElse(0);
    }

    @Override
    protected void layout(Composite composite, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        Rectangle rectangle = composite.getClientArea();
        int n5 = rectangle.x + this.marginWidth;
        int n6 = rectangle.y + this.marginHeight;
        int n7 = rectangle.width - 2 * this.marginWidth;
        int n8 = rectangle.height - 2 * this.marginHeight;
        Stream<Map.Entry> stream = Arrays.stream(composite.getChildren()).map(control -> this.borderDataControl(control, bl));
        Map<Integer, List<Map.Entry>> map = stream.collect(Collectors.groupingBy(BorderLayout::region));
        map.getOrDefault(0, Collections.emptyList()).forEach(entry -> ((Control)entry.getKey()).setBounds(n5, n6, 0, 0));
        List<Map.Entry<Control, BorderData>> list = map.getOrDefault(128, Collections.emptyList());
        List<Map.Entry<Control, BorderData>> list2 = map.getOrDefault(1024, Collections.emptyList());
        List<Map.Entry<Control, BorderData>> list3 = map.getOrDefault(16384, Collections.emptyList());
        List<Map.Entry<Control, BorderData>> list4 = map.getOrDefault(131072, Collections.emptyList());
        List list5 = map.getOrDefault(0x1000000, Collections.emptyList());
        int n9 = list.size();
        int n10 = n9 > 0 ? (n7 - (n9 - 1) * this.controlSpacing) / n9 : 0;
        int n11 = BorderLayout.getMax(HEIGHT, list, n10, -1, bl);
        int n12 = list2.size();
        int n13 = n12 > 0 ? (n7 - (n12 - 1) * this.controlSpacing) / n12 : 0;
        int n14 = BorderLayout.getMax(HEIGHT, list2, n13, -1, bl);
        if (n11 + n14 > n8) {
            n4 = (int)((double)n8 * this.heightDistributionFactor);
            if (n11 > n4) {
                n11 = n4;
            }
            n14 = n8 - n11;
        }
        n4 = n8 - n11 - n14;
        int n15 = list3.size();
        int n16 = BorderLayout.getMax(WIDTH, list3, -1, -1, bl);
        int n17 = list4.size();
        int n18 = BorderLayout.getMax(WIDTH, list4, -1, -1, bl);
        if (n16 + n18 > n7) {
            n3 = (int)((double)n7 * this.widthDistributionFactor);
            if (n16 > n3) {
                n16 = n3;
            }
            n18 = n7 - n16;
        }
        n3 = n7 - n16 - n18;
        int n19 = list5.size();
        if (n9 > 0) {
            n2 = n5;
            n = n6;
            for (Map.Entry<Control, BorderData> entry2 : list) {
                entry2.getKey().setBounds(n2, n, n10, n11);
                n2 += n10 + this.controlSpacing;
            }
        }
        if (n12 > 0) {
            n2 = n5;
            n = n6 + n4 + n11;
            for (Map.Entry<Control, BorderData> entry2 : list2) {
                entry2.getKey().setBounds(n2, n, n13, n14);
                n2 += n13 + this.controlSpacing;
            }
        }
        if (n15 > 0) {
            n2 = n5;
            n = n6 + n11;
            int n20 = n8 - n11 - n14;
            if (n9 > 0) {
                n += this.spacing;
                n20 -= this.spacing;
            }
            if (n12 > 0) {
                n20 -= this.spacing;
            }
            int n21 = (n20 - (n15 - 1) * this.controlSpacing) / n15;
            for (Map.Entry<Control, BorderData> entry3 : list3) {
                entry3.getKey().setBounds(n2, n, n16, n21);
                n += n21 + this.controlSpacing;
            }
        }
        if (n17 > 0) {
            n2 = n5 + n3 + n16;
            n = n6 + n11;
            int n22 = n8 - n11 - n14;
            if (n9 > 0) {
                n += this.spacing;
                n22 -= this.spacing;
            }
            if (n12 > 0) {
                n22 -= this.spacing;
            }
            int n23 = (n22 - (n17 - 1) * this.controlSpacing) / n17;
            for (Map.Entry<Control, BorderData> entry3 : list4) {
                entry3.getKey().setBounds(n2, n, n18, n23);
                n += n23 + this.controlSpacing;
            }
        }
        if (n19 > 0) {
            int n24;
            int n25;
            n2 = n5 + n16;
            n = n6 + n11;
            int n26 = n4;
            int n27 = n3;
            if (n15 > 0) {
                n2 += this.spacing;
                n27 -= this.spacing;
            }
            if (n17 > 0) {
                n27 -= this.spacing;
            }
            if (n9 > 0) {
                n += this.spacing;
                n26 -= this.spacing;
            }
            if (n12 > 0) {
                n26 -= this.spacing;
            }
            if (this.type == 256) {
                n25 = n26;
                n24 = (n27 - (n19 - 1) * this.controlSpacing) / n19;
            } else {
                n24 = n27;
                n25 = (n26 - (n19 - 1) * this.controlSpacing) / n19;
            }
            for (Map.Entry entry4 : list5) {
                ((Control)entry4.getKey()).setBounds(n2, n, n24, n25);
                if (this.type == 256) {
                    n2 += n24 + this.controlSpacing;
                    continue;
                }
                n += n25 + this.controlSpacing;
            }
        }
    }

    private <C extends Control> Map.Entry<C, BorderData> borderDataControl(C c, boolean bl) {
        BorderData borderData;
        Object object = c.getLayoutData();
        if (object instanceof BorderData) {
            BorderData borderData2 = (BorderData)object;
            if (bl) {
                borderData2.flushCache(c);
            }
            return new AbstractMap.SimpleEntry<C, BorderData>(c, borderData2);
        }
        BorderData borderData3 = borderData = bl ? null : (BorderData)c.getData(LAYOUT_KEY);
        if (borderData == null) {
            borderData = new BorderData();
            c.setData(LAYOUT_KEY, borderData);
        }
        return new AbstractMap.SimpleEntry<C, BorderData>(c, borderData);
    }

    private static int region(Map.Entry<Control, BorderData> entry) {
        BorderData borderData = entry.getValue();
        if (borderData == null) {
            return 0x1000000;
        }
        return borderData.getRegion();
    }

    public String toString() {
        return "BorderLayout [type=" + (this.type == 256 ? "SWT.HORIZONTAL" : "SWT.VERTICAL") + ", marginWidth=" + this.marginWidth + ", marginHeight=" + this.marginHeight + ", spacing=" + this.spacing + ", controlSpacing=" + this.controlSpacing + ", widthDistributionFactor=" + this.widthDistributionFactor + ", heightDistributionFactor=" + this.heightDistributionFactor + "]";
    }
}

