/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import java.security.AccessController;
import java.util.Locale;

final class Platform {
    public static final String MAC = "Mac";
    public static final String WINDOWS = "Win";
    public static final String GTK = "Gtk";
    public static final String IOS = "Ios";
    public static final String UNKNOWN = "unknown";
    private static String type = null;

    Platform() {
    }

    public static synchronized String determinePlatform() {
        if (type == null) {
            String string2 = AccessController.doPrivileged(() -> System.getProperty("glass.platform"));
            if (string2 != null) {
                type = string2.equals("macosx") ? MAC : (string2.equals("windows") ? WINDOWS : (string2.equals("linux") ? GTK : (string2.equals("gtk") ? GTK : (string2.equals("ios") ? IOS : string2))));
                return type;
            }
            String string3 = System.getProperty("os.name");
            String string4 = string3.toLowerCase(Locale.ROOT);
            if (string4.startsWith("mac") || string4.startsWith("darwin")) {
                type = MAC;
            } else if (string4.startsWith("wind")) {
                type = WINDOWS;
            } else if (string4.startsWith("linux")) {
                type = GTK;
            }
        }
        return type;
    }
}

