/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.GDE;
import gde.config.Settings;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public class WebBrowser {
    private static Logger log = Logger.getLogger(WebBrowser.class.getName());

    public static void openURL(String deviceName, String fileName) {
        String basePath = FileUtils.getJarBasePath() + "/";
        String jarName = "DataExplorer.jar";
        if (deviceName.length() >= 1) {
            basePath = basePath + "devices/";
            jarName = deviceName + ".jar";
        }
        log.log(Level.FINE, "basePath = " + basePath + " jarName = " + jarName);
        try {
            String targetDir = GDE.JAVA_IO_TMPDIR + "GDE" + GDE.FILE_SEPARATOR;
            String helpDir = "help" + GDE.FILE_SEPARATOR + Settings.getInstance().getLocale().getLanguage() + GDE.FILE_SEPARATOR;
            FileUtils.extractDir(new JarFile(basePath + jarName), helpDir, targetDir, "555");
            String stringUrl = targetDir + helpDir + fileName;
            log.log(Level.FINE, "stringUrl = " + stringUrl);
            WebBrowser.openBrowser(stringUrl);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGE0018", new Object[]{e.getLocalizedMessage()}));
        }
    }

    public static void openBrowser(String stringUrl) {
        block5: {
            try {
                if (GDE.IS_WINDOWS) {
                    Runtime.getRuntime().exec("rundll32.exe url.dll,FileProtocolHandler " + stringUrl);
                    break block5;
                }
                if (GDE.IS_LINUX) {
                    Runtime.getRuntime().exec("xdg-open " + stringUrl);
                    break block5;
                }
                if (GDE.IS_MAC) {
                    Runtime.getRuntime().exec("open " + stringUrl);
                    break block5;
                }
                throw new Exception(Messages.getString("GDE_MSGE0020", new Object[]{System.getProperty("os.name")}));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                DataExplorer.getInstance().openMessageDialogAsync(Messages.getString("GDE_MSGE0021", new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
            }
        }
    }
}

