/*
 * Decompiled with CFR 0.152.
 */
package gde.io;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channels;
import gde.data.ObjectData;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.MeasurementPropertyTypes;
import gde.device.PropertyType;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.GPSHelper;
import gde.utils.StringHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class KMZWriter {
    static Logger log = Logger.getLogger(KMZWriter.class.getName());
    static final String ALTITUDE_ABSOLUTE = "absolute";
    static final String ALTITUDE_RELATIVE2GROUND = "relativeToGround";
    static final String ALTITUDE_CLAMP2GROUNDE = "clampToGround";
    static final String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + GDE.LINE_SEPARATOR + "<kml xmlns=\"http://www.opengis.net/kml/2.2\" xmlns:gx=\"http://www.google.com/kml/ext/2.2\">" + GDE.LINE_SEPARATOR + GDE.LINE_SEPARATOR;
    static final String position = "<Document>" + GDE.LINE_SEPARATOR + "\t<name>%s</name>" + GDE.LINE_SEPARATOR + "\t<open>1</open>" + GDE.LINE_SEPARATOR + "\t<description>%s</description>" + GDE.LINE_SEPARATOR + "\t<LookAt>" + GDE.LINE_SEPARATOR + "\t\t<gx:TimeSpan>" + GDE.LINE_SEPARATOR + "\t\t\t<begin>%sT%sZ</begin>" + GDE.LINE_SEPARATOR + "\t\t\t<end>%sT%sZ</end>" + GDE.LINE_SEPARATOR + "\t\t</gx:TimeSpan>" + GDE.LINE_SEPARATOR + "\t\t<longitude>%.7f</longitude>" + GDE.LINE_SEPARATOR + "\t\t<latitude>%.7f</latitude>" + GDE.LINE_SEPARATOR + "\t<altitude>0</altitude>" + GDE.LINE_SEPARATOR + "\t\t<heading>%d</heading>" + GDE.LINE_SEPARATOR + "\t\t<tilt>%d</tilt>" + GDE.LINE_SEPARATOR + "\t\t<range>%d</range>" + GDE.LINE_SEPARATOR + "\t\t<altitudeMode>relativeToGround</altitudeMode>" + GDE.LINE_SEPARATOR + "\t</LookAt>" + GDE.LINE_SEPARATOR;
    static final String[] icons = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"};
    static final String iconsdef = "\t<Style id=\"track-%s_n\">" + GDE.LINE_SEPARATOR + "\t\t<IconStyle>" + GDE.LINE_SEPARATOR + "\t\t\t<scale>0.4</scale>" + GDE.LINE_SEPARATOR + "\t\t\t<heading>%.1f</heading>" + GDE.LINE_SEPARATOR + "\t\t\t<Icon>" + GDE.LINE_SEPARATOR + "\t\t\t\t<href>track.png</href>" + GDE.LINE_SEPARATOR + "\t\t\t</Icon>" + GDE.LINE_SEPARATOR + "\t\t\t<gx:headingMode>northUp</gx:headingMode>" + GDE.LINE_SEPARATOR + "\t\t</IconStyle>" + GDE.LINE_SEPARATOR + "\t\t<LabelStyle>" + GDE.LINE_SEPARATOR + "\t\t\t<scale>0</scale>" + GDE.LINE_SEPARATOR + "\t\t</LabelStyle>" + GDE.LINE_SEPARATOR + "\t</Style>" + GDE.LINE_SEPARATOR + "\t<Style id=\"track-%s_h\">" + GDE.LINE_SEPARATOR + "\t\t<IconStyle>" + GDE.LINE_SEPARATOR + "\t\t\t<scale>1.0</scale>" + GDE.LINE_SEPARATOR + "\t\t\t<heading>%.1f</heading>" + GDE.LINE_SEPARATOR + "\t\t\t<Icon>" + GDE.LINE_SEPARATOR + "\t\t\t\t<href>track.png</href>" + GDE.LINE_SEPARATOR + "\t\t\t</Icon>" + GDE.LINE_SEPARATOR + "\t\t\t<gx:headingMode>northUp</gx:headingMode>" + GDE.LINE_SEPARATOR + "\t\t</IconStyle>" + GDE.LINE_SEPARATOR + "\t</Style>" + GDE.LINE_SEPARATOR + "\t<StyleMap id=\"track-%s\">" + GDE.LINE_SEPARATOR + "\t\t<Pair>" + GDE.LINE_SEPARATOR + "\t\t\t<key>normal</key>" + GDE.LINE_SEPARATOR + "\t\t\t<styleUrl>#track-%s_n</styleUrl>" + GDE.LINE_SEPARATOR + "\t\t</Pair>" + GDE.LINE_SEPARATOR + "\t<Pair>" + GDE.LINE_SEPARATOR + "\t\t<key>highlight</key>" + GDE.LINE_SEPARATOR + "\t\t\t<styleUrl>#track-%s_h</styleUrl>" + GDE.LINE_SEPARATOR + "\t\t</Pair>" + GDE.LINE_SEPARATOR + "\t</StyleMap>" + GDE.LINE_SEPARATOR;
    static final String statistics = "\t<Folder>" + GDE.LINE_SEPARATOR + "\t\t<name>%s</name>" + GDE.LINE_SEPARATOR + "\t\t<Snippet maxLines=\"0\"></Snippet>" + GDE.LINE_SEPARATOR + "\t\t<description><![CDATA[<table>" + GDE.LINE_SEPARATOR + "\t\t\t<tr><td><b>Distance</b> %.1f km </td></tr>" + GDE.LINE_SEPARATOR + "\t\t\t<tr><td><b>Min Alt</b> %.0f meters </td></tr>" + GDE.LINE_SEPARATOR + "\t\t\t<tr><td><b>Max Alt</b> %.0f%s meters </td></tr>" + GDE.LINE_SEPARATOR + "\t\t\t<tr><td><b>Min %s</b> %.1f %s </td></tr>" + GDE.LINE_SEPARATOR + "\t\t\t<tr><td><b>Avg %s</b> %.1f %s </td></tr>" + GDE.LINE_SEPARATOR + "\t\t\t<tr><td><b>Max %s</b> %.1f %s </td></tr>" + GDE.LINE_SEPARATOR + "\t\t\t<tr><td><b>Start Time</b> %sT %sZ  </td></tr>" + GDE.LINE_SEPARATOR + "\t\t\t<tr><td><b>End Time</b> %sT %sZ  </td></tr>" + GDE.LINE_SEPARATOR + "\t\t</table>]]></description>" + GDE.LINE_SEPARATOR + "\t\t<TimeSpan>" + GDE.LINE_SEPARATOR + "\t\t\t<begin>%sT%sZ</begin>" + GDE.LINE_SEPARATOR + "\t\t\t<end>%sT%sZ</end>" + GDE.LINE_SEPARATOR + "\t\t</TimeSpan>" + GDE.LINE_SEPARATOR + "\t</Folder>" + GDE.LINE_SEPARATOR;
    static final String pointsLeader = "\t<Folder>" + GDE.LINE_SEPARATOR + "\t\t\t\t<name>Data-Track</name>" + GDE.LINE_SEPARATOR + "\t\t\t\t<visibility>0</visibility>" + GDE.LINE_SEPARATOR + "\t\t\t\t<open>0</open>" + GDE.LINE_SEPARATOR;
    static final String dataPoint = "\t\t<Placemark>" + GDE.LINE_SEPARATOR + "\t\t\t<visibility>0</visibility>" + GDE.LINE_SEPARATOR + "\t\t\t<name>t:%ds   x=%.1f%s   h=%.0fm</name>" + GDE.LINE_SEPARATOR + "\t\t\t<Snippet maxLines=\"0\"></Snippet>" + GDE.LINE_SEPARATOR + "\t\t\t<description><![CDATA[<table>" + GDE.LINE_SEPARATOR + "\t\t\t\t<tr><td>Longitude: %.7f </td></tr>" + GDE.LINE_SEPARATOR + "\t\t\t\t<tr><td>Latitude: %.7f </td></tr>" + GDE.LINE_SEPARATOR + "\t\t\t\t<tr><td>Altitude: %.0f meters </td></tr>" + GDE.LINE_SEPARATOR + "\t\t\t\t<tr><td>%s: %.1f %s </td></tr>" + GDE.LINE_SEPARATOR + "\t\t\t\t<tr><td>Heading: %.1f </td></tr>" + GDE.LINE_SEPARATOR + "\t\t\t\t<tr><td>Time: %sT %sZ </td></tr>" + GDE.LINE_SEPARATOR + "\t\t\t</table>]]></description>" + GDE.LINE_SEPARATOR + "\t\t\t<LookAt>" + GDE.LINE_SEPARATOR + "\t\t\t\t<longitude>%.7f</longitude>" + GDE.LINE_SEPARATOR + "\t\t\t\t<latitude>%.7f</latitude>" + GDE.LINE_SEPARATOR + "\t\t\t\t<altitude>%.0f</altitude>" + GDE.LINE_SEPARATOR + "\t\t\t\t<heading>%.1f</heading>" + GDE.LINE_SEPARATOR + "\t\t\t\t<tilt>0</tilt>" + GDE.LINE_SEPARATOR + "\t\t\t\t<range>0</range>" + GDE.LINE_SEPARATOR + "\t\t\t</LookAt>" + GDE.LINE_SEPARATOR + "\t\t\t<TimeStamp><when>%sT%sZ</when></TimeStamp>" + GDE.LINE_SEPARATOR + "\t\t\t<styleUrl>#%s</styleUrl>" + GDE.LINE_SEPARATOR + "\t\t\t<Point>" + GDE.LINE_SEPARATOR + "\t\t\t\t<altitudeMode>%s</altitudeMode>" + GDE.LINE_SEPARATOR + "\t\t\t\t<coordinates>%.7f,%.7f,%.0f</coordinates>" + GDE.LINE_SEPARATOR + "\t\t\t</Point>" + GDE.LINE_SEPARATOR + "\t\t</Placemark>" + GDE.LINE_SEPARATOR;
    static final String emptyStyleMap = "\t\t<StyleMap id=\"none\">" + GDE.LINE_SEPARATOR + "\t\t\t<Pair>" + GDE.LINE_SEPARATOR + "\t\t\t\t<key>normal</key>" + GDE.LINE_SEPARATOR + "\t\t\t\t<styleUrl>#none_n</styleUrl>" + GDE.LINE_SEPARATOR + "\t\t\t</Pair>" + GDE.LINE_SEPARATOR + "\t\t\t<Pair>" + GDE.LINE_SEPARATOR + "\t\t\t\t<key>highlight</key>" + GDE.LINE_SEPARATOR + "\t\t\t\t<styleUrl>#none_n</styleUrl>" + GDE.LINE_SEPARATOR + "\t\t\t</Pair>" + GDE.LINE_SEPARATOR + "\t\t</StyleMap>" + GDE.LINE_SEPARATOR + "\t\t<Style id=\"none_n\">" + GDE.LINE_SEPARATOR + "\t\t\t<IconStyle>" + GDE.LINE_SEPARATOR + "\t\t\t\t<scale>1</scale>" + GDE.LINE_SEPARATOR + "\t\t\t\t<heading>0</heading>" + GDE.LINE_SEPARATOR + "\t\t\t\t<color>000000000</color>" + GDE.LINE_SEPARATOR + "\t\t\t\t<Icon>" + GDE.LINE_SEPARATOR + "\t\t\t\t\t<href>track.png</href>" + GDE.LINE_SEPARATOR + "\t\t\t\t</Icon>" + GDE.LINE_SEPARATOR + "\t\t\t\t<gx:headingMode>northUp</gx:headingMode>" + GDE.LINE_SEPARATOR + "\t\t\t</IconStyle>" + GDE.LINE_SEPARATOR + "\t\t\t<LabelStyle>" + GDE.LINE_SEPARATOR + "\t\t\t\t<scale>0</scale>" + GDE.LINE_SEPARATOR + "\t\t\t</LabelStyle>" + GDE.LINE_SEPARATOR + "\t\t</Style>" + GDE.LINE_SEPARATOR;
    static final String pointsTrailer = "\t</Folder>" + GDE.LINE_SEPARATOR;
    static final String speedHeader = "\t<Folder>" + GDE.LINE_SEPARATOR + "\t\t<name>%s-Track</name>" + GDE.LINE_SEPARATOR + "\t\t<open>0</open>" + GDE.LINE_SEPARATOR;
    static final String speedLeader = "\t\t\t<Placemark>" + GDE.LINE_SEPARATOR + "\t\t\t<name>gx:%s</name>" + GDE.LINE_SEPARATOR + "\t\t\t<Style>" + GDE.LINE_SEPARATOR + "\t\t\t\t<LineStyle>" + GDE.LINE_SEPARATOR + "\t\t\t\t\t<color>%s</color>" + GDE.LINE_SEPARATOR + "\t\t\t\t\t<width>%d</width>" + GDE.LINE_SEPARATOR + "\t\t\t\t</LineStyle>" + GDE.LINE_SEPARATOR + "\t\t\t\t<PolyStyle>" + GDE.LINE_SEPARATOR + "\t\t\t\t\t<color>5f%s</color>" + GDE.LINE_SEPARATOR + "\t\t\t\t\t<colorMode>%s</colorMode>" + GDE.LINE_SEPARATOR + "\t\t\t\t\t<outline>0</outline>" + GDE.LINE_SEPARATOR + "\t\t\t\t</PolyStyle>" + GDE.LINE_SEPARATOR + "\t\t\t</Style>" + GDE.LINE_SEPARATOR + "\t\t\t<LineString>" + GDE.LINE_SEPARATOR + "\t\t\t\t<extrude>%d</extrude>" + GDE.LINE_SEPARATOR + "\t\t\t\t<gx:altitudeMode>%s</gx:altitudeMode>" + GDE.LINE_SEPARATOR + "\t\t\t\t<coordinates>" + GDE.LINE_SEPARATOR;
    static final String speedTrailer = "\t\t\t\t</coordinates>" + GDE.LINE_SEPARATOR + "\t\t\t</LineString>" + GDE.LINE_SEPARATOR + "\t\t</Placemark>" + GDE.LINE_SEPARATOR;
    static final String speedFooter = "\t</Folder>" + GDE.LINE_SEPARATOR;
    static final String triangleHeader = "\t<Folder>" + GDE.LINE_SEPARATOR + "\t\t<name>%s-Track</name>" + GDE.LINE_SEPARATOR + "\t\t<open>0</open>" + GDE.LINE_SEPARATOR;
    static final String triangleLeader = "\t\t\t<Placemark>" + GDE.LINE_SEPARATOR + "\t\t\t<name>gx:%s</name>" + GDE.LINE_SEPARATOR + "\t\t\t<Style>" + GDE.LINE_SEPARATOR + "\t\t\t\t<LineStyle>" + GDE.LINE_SEPARATOR + "\t\t\t\t\t<color>%s</color>" + GDE.LINE_SEPARATOR + "\t\t\t\t\t<width>%d</width>" + GDE.LINE_SEPARATOR + "\t\t\t\t</LineStyle>" + GDE.LINE_SEPARATOR + "\t\t\t\t<PolyStyle>" + GDE.LINE_SEPARATOR + "\t\t\t\t\t<color>5f%s</color>" + GDE.LINE_SEPARATOR + "\t\t\t\t\t<colorMode>%s</colorMode>" + GDE.LINE_SEPARATOR + "\t\t\t\t\t<outline>0</outline>" + GDE.LINE_SEPARATOR + "\t\t\t\t</PolyStyle>" + GDE.LINE_SEPARATOR + "\t\t\t</Style>" + GDE.LINE_SEPARATOR + "\t\t\t<LineString>" + GDE.LINE_SEPARATOR + "\t\t\t\t<extrude>%d</extrude>" + GDE.LINE_SEPARATOR + "\t\t\t\t<gx:altitudeMode>%s</gx:altitudeMode>" + GDE.LINE_SEPARATOR + "\t\t\t\t<coordinates>" + GDE.LINE_SEPARATOR;
    static final String triangleTrailer = "\t\t\t\t</coordinates>" + GDE.LINE_SEPARATOR + "\t\t\t</LineString>" + GDE.LINE_SEPARATOR + "\t\t</Placemark>" + GDE.LINE_SEPARATOR;
    static final String triangleFooter = "\t</Folder>" + GDE.LINE_SEPARATOR;
    static final String footer = "</Document>" + GDE.LINE_SEPARATOR + "</kml>" + GDE.LINE_SEPARATOR;
    static final DataExplorer application = DataExplorer.getInstance();
    static final Channels channels = Channels.getInstance();

    public static void write(String kmzFilePath, String kmlFileName, RecordSet recordSet, int ordinalLongitude, int ordinalLatitude, int ordinalAltitude, int ordinalMeasurement, int ordinalSlope, int ordinalTripLength, int ordinalTrackDirection, boolean isAltRelative, boolean isClampToGround) throws Exception {
        StringBuilder sb = new StringBuilder();
        double height0 = 0.0;
        double altitudeDelta = 0.0;
        long startTime = new Date().getTime();
        int timeStep_ms = Settings.getInstance().getKmzExportTimeStep_ms();
        ZipOutputStream zipWriter = null;
        IDevice device = DataExplorer.getInstance().getActiveDevice();
        try {
            int i;
            Vector recordAzimuth;
            Record recordMeasurement;
            Record recordAltitude;
            GDE.getUiNotification().setStatusMessage(Messages.getString("GDE_MSGT0138", new String[]{"kmz", kmzFilePath}));
            File targetFile = new File(kmzFilePath);
            if (targetFile.exists()) {
                if (!targetFile.delete()) {
                    log.log(Level.WARNING, kmzFilePath + " could not deleted!");
                }
                if (!targetFile.createNewFile()) {
                    log.log(Level.WARNING, kmzFilePath + " could not created!");
                }
            }
            zipWriter = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(targetFile)));
            zipWriter.putNextEntry(new ZipEntry(kmlFileName));
            zipWriter.write(header.getBytes());
            int realDataSize = recordSet.getRecordDataSize(true);
            int dataSize = recordSet.getRecordDataSize(false);
            int progressCycle = 0;
            GDE.getUiNotification().setProgress(progressCycle);
            Record recordLongitude = recordSet.get(ordinalLongitude);
            Record recordLatitude = recordSet.get(ordinalLatitude);
            Record record = ordinalAltitude < 0 ? null : (recordAltitude = recordSet.get(ordinalAltitude).hasReasonableData() ? recordSet.get(ordinalAltitude) : null);
            Record record2 = ordinalMeasurement < 0 ? null : (recordMeasurement = recordSet.get(ordinalMeasurement).hasReasonableData() ? recordSet.get(ordinalMeasurement) : null);
            Record recordSlope = ordinalSlope < 0 ? null : (recordSet.get(ordinalSlope).hasReasonableData() ? recordSet.get(ordinalSlope) : null);
            String measurementName = recordMeasurement != null ? recordMeasurement.getName() : "";
            String measurementUnit = recordMeasurement != null ? recordMeasurement.getUnit() : "";
            boolean isExtrude = false;
            String randomColor = "";
            if (application.isObjectoriented()) {
                Properties properties;
                ObjectData object = application.getObject();
                if (object != null && (properties = object.getProperties()) != null) {
                    if (properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_IS_EXTRUDE.value()) != null) {
                        isExtrude = Boolean.parseBoolean(properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_IS_EXTRUDE.value()).toString());
                    }
                    if (properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_IS_RANDOM_COLOR.value()) != null) {
                        randomColor = Boolean.parseBoolean(properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_IS_RANDOM_COLOR.value()).toString()) ? "random" : "";
                    }
                }
            } else {
                Integer activeChannelNumber = application.getActiveChannelNumber();
                Integer measurementOrdinal = device.getGPS2KMZMeasurementOrdinal();
                if (activeChannelNumber != null && measurementOrdinal != null && measurementOrdinal >= 0) {
                    PropertyType property = device.getMeasruementProperty(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_IS_EXTRUDE.value());
                    if (property != null) {
                        try {
                            isExtrude = Boolean.parseBoolean(property.getValue());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((property = device.getMeasruementProperty(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_IS_RANDOM_COLOR.value())) != null) {
                        try {
                            randomColor = Boolean.parseBoolean(property.getValue()) ? "random" : "";
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if (recordLongitude == null || recordLatitude == null) {
                throw new Exception(Messages.getString("GDE_MSGE0005", new Object[]{Messages.getString("GDE_MSGT0599"), recordSet.getChannelConfigName()}));
            }
            if (recordAltitude == null) {
                isClampToGround = true;
                altitudeDelta = 0.0;
            } else {
                altitudeDelta = Math.abs(device.translateValue(recordAltitude, (double)recordAltitude.getMaxValue() / 1000.0) - device.translateValue(recordAltitude, (double)recordAltitude.getMinValue() / 1000.0));
                boolean bl = isClampToGround = isClampToGround || altitudeDelta < 10.0;
            }
            String altitudeMode = isClampToGround ? ALTITUDE_CLAMP2GROUNDE : (isAltRelative ? ALTITUDE_RELATIVE2GROUND : ALTITUDE_ABSOLUTE);
            Record recordTripLength = ordinalTripLength < 0 ? null : recordSet.get(ordinalTripLength);
            try {
                recordAzimuth = ordinalTrackDirection >= 0 ? recordSet.get(ordinalTrackDirection) : GPSHelper.calculateAzimuth(device, recordSet, ordinalLatitude, ordinalLongitude, ordinalAltitude);
            }
            catch (Exception e) {
                recordAzimuth = GPSHelper.calculateAzimuth(device, recordSet, ordinalLatitude, ordinalLongitude, ordinalAltitude);
            }
            long date = new Date().getTime();
            try {
                String[] arrayDescription = recordSet.getRecordSetDescription().split(" ");
                int[] intDate = new int[3];
                for (String strDate : arrayDescription) {
                    String[] tmp = strDate.replace(',', '-').replace(';', '-').replace('\r', '-').replace('\n', '-').split("-");
                    if (tmp.length < 3 || !Character.isDigit(tmp[0].charAt(0)) || !Character.isDigit(tmp[1].charAt(0)) || !Character.isDigit(tmp[2].charAt(0))) continue;
                    intDate = new int[]{Integer.parseInt(tmp[0]), Integer.parseInt(tmp[1]), Integer.parseInt(tmp[2])};
                    break;
                }
                int[] intTime = new int[3];
                for (String strTime : arrayDescription) {
                    String[] tmp = strTime.replace(',', ':').replace(';', ':').replace('\r', ':').replace('\n', ':').split(":");
                    if (tmp.length < 3 || !Character.isDigit(tmp[0].charAt(0)) || !Character.isDigit(tmp[1].charAt(0)) || !Character.isDigit(tmp[2].charAt(0))) continue;
                    intTime = new int[]{Integer.parseInt(tmp[0]), Integer.parseInt(tmp[1]), Integer.parseInt(tmp[2])};
                    break;
                }
                GregorianCalendar calendar = new GregorianCalendar(intDate[0], intDate[1] - 1, intDate[2], intTime[0], intTime[1], intTime[2]);
                date = calendar.getTimeInMillis();
            }
            catch (Exception arrayDescription) {
                // empty catch block
            }
            String dateString = new SimpleDateFormat("yyyy-MM-dd").format(date);
            int gpsStartIndex = GPSHelper.getStartIndexGPS(recordSet, ordinalLatitude, ordinalLongitude);
            height0 = isAltRelative && !isClampToGround && recordAltitude != null ? device.translateValue(recordAltitude, (double)recordAltitude.realGet(gpsStartIndex).intValue() / 1000.0) : 0.0;
            boolean isPositionWritten = false;
            double positionLongitude = device.translateValue(recordLongitude, (double)recordLongitude.get(1).intValue() / 1000.0);
            double positionLatitude = device.translateValue(recordLongitude, (double)recordLatitude.get(1).intValue() / 1000.0);
            for (i = gpsStartIndex; i < realDataSize; ++i) {
                if (recordLongitude.get(i) == 0 || recordLatitude.get(i) == 0 || isPositionWritten) continue;
                positionLongitude = device.translateValue(recordLongitude, (double)recordLongitude.get(i).intValue() / 1000.0);
                positionLatitude = device.translateValue(recordLongitude, (double)recordLatitude.get(i).intValue() / 1000.0);
                String recordSetDescription = recordSet.getRecordSetDescription();
                recordSetDescription = recordSetDescription.contains("\n") ? recordSetDescription.split("\n")[0] : recordSetDescription;
                zipWriter.write(String.format(Locale.ENGLISH, position, recordSet.getName(), recordSetDescription, dateString, new SimpleDateFormat("HH:mm:ss").format(date), dateString, new SimpleDateFormat("HH:mm:ss").format((double)date + recordSet.getTime_ms(recordLongitude.size() - 1)), positionLongitude, positionLatitude, -50, 70, 1000).getBytes());
                isPositionWritten = true;
                break;
            }
            int startIndex = i;
            int velocityRange = 0;
            int velocityAvg = recordMeasurement != null ? (int)device.translateValue(recordMeasurement, (double)recordMeasurement.getAvgValue() / 1000.0) : 0;
            int measurementLowerLimit = 20;
            int velocityUpperLimit = 100;
            String withinLimitsColor = "ff0000ff";
            String lowerLimitColor = "ff00ff00";
            String upperLimitColor = "ff00ffff";
            if (application.isObjectoriented()) {
                ObjectData object = application.getObject();
                Properties properties = object.getProperties();
                if (properties != null) {
                    int b;
                    int g;
                    String color2;
                    double avgLimitFactor = 0.0;
                    int lowerLimitVelocity = 0;
                    int upperLimitVelocity = 0;
                    try {
                        avgLimitFactor = Double.parseDouble(((String)properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_AVG_LIMIT_FACTOR.value())).trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        lowerLimitVelocity = Integer.parseInt(((String)properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_LOWER_LIMIT.value())).trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        upperLimitVelocity = Integer.parseInt(((String)properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_UPPER_LIMIT.value())).trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    measurementLowerLimit = (int)(avgLimitFactor != 0.0 ? (double)velocityAvg / avgLimitFactor : (lowerLimitVelocity != 0 ? (double)lowerLimitVelocity : 0.0));
                    velocityUpperLimit = (int)(avgLimitFactor != 0.0 ? (double)velocityAvg * avgLimitFactor : (upperLimitVelocity != 0 ? (double)upperLimitVelocity : 500.0));
                    try {
                        color2 = (String)properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_WITHIN_LIMITS_COLOR.value());
                        int r = Integer.valueOf(color2.split(",")[0].trim());
                        g = Integer.valueOf(color2.split(",")[1].trim());
                        b = Integer.valueOf(color2.split(",")[2].trim());
                        withinLimitsColor = String.format("ff%02x%02x%02x", b, g, r);
                    }
                    catch (Exception color2) {
                        // empty catch block
                    }
                    try {
                        color2 = (String)properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_LOWER_LIMIT_COLOR.value());
                        int r = Integer.valueOf(color2.split(",")[0].trim());
                        g = Integer.valueOf(color2.split(",")[1].trim());
                        b = Integer.valueOf(color2.split(",")[2].trim());
                        lowerLimitColor = String.format("ff%02x%02x%02x", b, g, r);
                    }
                    catch (Exception color3) {
                        // empty catch block
                    }
                    try {
                        color2 = (String)properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_UPPER_LIMIT_COLOR.value());
                        int r = Integer.valueOf(color2.split(",")[0].trim());
                        g = Integer.valueOf(color2.split(",")[1].trim());
                        b = Integer.valueOf(color2.split(",")[2].trim());
                        upperLimitColor = String.format("ff%02x%02x%02x", b, g, r);
                    }
                    catch (Exception exception) {}
                }
            } else {
                PropertyType propertyUpperLimit;
                PropertyType propertyAvg = recordMeasurement == null ? null : recordMeasurement.getDevice().getMeasruementProperty(recordSet.getChannelConfigNumber(), ordinalMeasurement, MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_AVG_LIMIT_FACTOR.value());
                PropertyType propertyLowerLimit = recordMeasurement == null ? null : recordMeasurement.getDevice().getMeasruementProperty(recordSet.getChannelConfigNumber(), ordinalMeasurement, MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_LOWER_LIMIT.value());
                PropertyType propertyType = propertyUpperLimit = recordMeasurement == null ? null : recordMeasurement.getDevice().getMeasruementProperty(recordSet.getChannelConfigNumber(), ordinalMeasurement, MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_UPPER_LIMIT.value());
                measurementLowerLimit = (int)(propertyAvg != null ? (double)velocityAvg / Double.valueOf(propertyAvg.getValue()) : (propertyLowerLimit != null ? (double)Integer.valueOf(propertyLowerLimit.getValue()).intValue() : 0.0));
                velocityUpperLimit = (int)(propertyAvg != null ? (double)velocityAvg * Double.valueOf(propertyAvg.getValue()) : (propertyUpperLimit != null ? (double)Integer.valueOf(propertyUpperLimit.getValue()).intValue() : 500.0));
                PropertyType propertyWithinLimitsColor = recordMeasurement == null ? null : recordMeasurement.getDevice().getMeasruementProperty(recordSet.getChannelConfigNumber(), ordinalMeasurement, MeasurementPropertyTypes.GOOGLE_EARTH_WITHIN_LIMITS_COLOR.value());
                PropertyType propertyLowerLimitColor = recordMeasurement == null ? null : recordMeasurement.getDevice().getMeasruementProperty(recordSet.getChannelConfigNumber(), ordinalMeasurement, MeasurementPropertyTypes.GOOGLE_EARTH_LOWER_LIMIT_COLOR.value());
                PropertyType propertyUpperLimitColor = recordMeasurement == null ? null : recordMeasurement.getDevice().getMeasruementProperty(recordSet.getChannelConfigNumber(), ordinalMeasurement, MeasurementPropertyTypes.GOOGLE_EARTH_UPPER_LIMIT_COLOR.value());
                String[] colorRGB = propertyWithinLimitsColor != null ? propertyWithinLimitsColor.getValue().split(",") : new String[3];
                withinLimitsColor = propertyWithinLimitsColor != null ? String.format("ff%02x%02x%02x", Integer.parseInt(colorRGB[2]), Integer.parseInt(colorRGB[1]), Integer.parseInt(colorRGB[0])) : "ff0000ff";
                colorRGB = propertyLowerLimitColor != null ? propertyLowerLimitColor.getValue().split(",") : new String[3];
                lowerLimitColor = propertyLowerLimitColor != null ? String.format("ff%02x%02x%02x", Integer.parseInt(colorRGB[2]), Integer.parseInt(colorRGB[1]), Integer.parseInt(colorRGB[0])) : "ff00ff00";
                colorRGB = propertyUpperLimitColor != null ? propertyUpperLimitColor.getValue().split(",") : new String[3];
                upperLimitColor = propertyUpperLimitColor != null ? String.format("ff%02x%02x%02x", Integer.parseInt(colorRGB[2]), Integer.parseInt(colorRGB[1]), Integer.parseInt(colorRGB[0])) : "ff00ffff";
            }
            String[] velocityColors = new String[]{lowerLimitColor, withinLimitsColor, upperLimitColor};
            double relAltitude = !isClampToGround && recordAltitude != null ? device.translateValue(recordAltitude, (double)recordAltitude.get(i).intValue() / 1000.0) - height0 : 0.0;
            zipWriter.write(String.format(Locale.ENGLISH, statistics, "Statistics", recordTripLength == null ? 0.0 : device.translateValue(recordTripLength, (double)recordTripLength.getMaxValue() / 1000.0), relAltitude, recordAltitude == null ? 0.0 : device.translateValue(recordAltitude, (double)recordAltitude.getMaxValue() / 1000.0) - height0, isAltRelative ? "" : String.format("(%.0f)", recordAltitude == null ? 0.0 : device.translateValue(recordAltitude, (double)recordAltitude.getMaxValue() / 1000.0) - relAltitude), measurementName, recordMeasurement == null ? 0.0 : device.translateValue(recordMeasurement, (double)recordMeasurement.getMinValue() / 1000.0), measurementUnit, measurementName, recordMeasurement == null ? 0.0 : device.translateValue(recordMeasurement, (double)recordMeasurement.getAvgValue() / 1000.0), measurementUnit, measurementName, recordMeasurement == null ? 0.0 : device.translateValue(recordMeasurement, (double)recordMeasurement.getMaxValue() / 1000.0), measurementUnit, dateString, new SimpleDateFormat("HH:mm:ss").format(date), dateString, new SimpleDateFormat("HH:mm:ss").format((double)date + recordSet.getTime_ms(recordLongitude.size() - 1)), dateString, new SimpleDateFormat("HH:mm:ss").format(date), dateString, new SimpleDateFormat("HH:mm:ss").format((double)date + recordSet.getTime_ms(recordLongitude.size() - 1))).getBytes());
            zipWriter.write(String.format(speedHeader, measurementName).getBytes());
            String initialPlacemarkName = Messages.getString("GDE_MSGT0604", new Object[]{measurementName, measurementLowerLimit, measurementUnit});
            zipWriter.write(String.format(Locale.ENGLISH, speedLeader, initialPlacemarkName, lowerLimitColor, 2, lowerLimitColor.substring(2), randomColor, isExtrude ? 1 : 0, altitudeMode).getBytes());
            long lastTimeStamp = -1L;
            long recordSetStartTimeStamp = recordSet.getTime(recordSet.isZoomMode() ? 0 : startIndex) / 10L;
            int n = i = recordSet.isZoomMode() ? 0 : startIndex;
            while (isPositionWritten && i < dataSize) {
                long timeStamp = recordSet.getTime(i) / 10L + recordSetStartTimeStamp;
                if (timeStamp - lastTimeStamp >= (long)timeStep_ms || lastTimeStamp == -1L) {
                    int velocity;
                    int n2 = velocity = recordMeasurement == null ? 0 : (int)device.translateValue(recordMeasurement, (double)recordMeasurement.get(i).intValue() / 1000.0);
                    if (!(recordMeasurement == null || velocity < measurementLowerLimit && velocityRange == 0 || velocity >= measurementLowerLimit && velocity <= velocityUpperLimit && velocityRange == 1 || velocity > velocityUpperLimit && velocityRange == 2)) {
                        velocityRange = KMZWriter.switchColor(zipWriter, recordMeasurement, velocity, measurementLowerLimit, velocityUpperLimit, velocityColors, velocityRange, altitudeMode, isExtrude, randomColor);
                        zipWriter.write(sb.toString().getBytes());
                    }
                    sb = new StringBuilder();
                    relAltitude = recordAltitude == null ? 0.0 : device.translateValue(recordAltitude, (double)recordAltitude.get(i).intValue() / 1000.0) - height0;
                    sb.append(String.format(Locale.ENGLISH, "\t\t\t\t\t\t%.7f,", device.translateValue(recordLongitude, (double)recordLongitude.get(i).intValue() / 1000.0))).append(String.format(Locale.ENGLISH, "%.7f,", device.translateValue(recordLatitude, (double)recordLatitude.get(i).intValue() / 1000.0))).append(String.format(Locale.ENGLISH, "%.0f", relAltitude < 0.0 ? 0.0 : relAltitude)).append(GDE.LINE_SEPARATOR);
                    zipWriter.write(sb.toString().getBytes());
                    if (i % 50 == 0) {
                        GDE.getUiNotification().setProgress(++progressCycle * 5000 / dataSize);
                    }
                    log.log(java.util.logging.Level.FINER, "data line = " + sb.toString());
                    lastTimeStamp = timeStamp;
                }
                ++i;
            }
            zipWriter.write(speedTrailer.getBytes());
            zipWriter.write(speedFooter.getBytes());
            if (recordSet.getDevice().getName().equals("IGCAdapter")) {
                int relativeAltitude = (int)(recordAltitude == null ? 0.0 : device.translateValue(recordAltitude, (double)recordAltitude.getMaxValue() / 1000.0) - height0);
                String[] triangleTaskDefinition = recordSet.getRecordSetDescription().split(GDE.LINE_SEPARATOR);
                if (triangleTaskDefinition.length == 2 && triangleTaskDefinition[1].length() > 25 && triangleTaskDefinition[1].split(" - ").length == 4) {
                    ArrayList<String> wayPoints = new ArrayList<String>();
                    for (String strCoords : triangleTaskDefinition[1].split(" - ")) {
                        if (!strCoords.startsWith("WP", 17)) continue;
                        wayPoints.add(strCoords.substring(0, 8) + ";" + strCoords.substring(8, 17));
                    }
                    zipWriter.write(String.format(triangleHeader, "triangle").getBytes());
                    zipWriter.write(String.format(Locale.ENGLISH, triangleLeader, "triangle", "ffff0000", 2, "ffff0000".substring(2), randomColor, 1, altitudeMode).getBytes());
                    for (i = 0; i < 3 && wayPoints.size() == 3; ++i) {
                        sb = new StringBuilder();
                        double latitude = Double.parseDouble(((String)wayPoints.get(i)).split(";")[0].substring(0, 7)) / 100.0;
                        latitude = ((String)wayPoints.get(i)).split(";")[0].endsWith("N") ? latitude : -1.0 * latitude;
                        double longitude = Double.parseDouble(((String)wayPoints.get(i)).split(";")[1].substring(0, 7)) / 10.0;
                        longitude = ((String)wayPoints.get(i)).split(";")[1].endsWith("E") ? longitude : -1.0 * longitude;
                        sb.append(String.format(Locale.ENGLISH, "\t\t\t\t\t\t%.7f,", device.translateValue(recordLongitude, longitude))).append(String.format(Locale.ENGLISH, "%.7f,", device.translateValue(recordLatitude, latitude))).append(String.format(Locale.ENGLISH, "%d", relativeAltitude)).append(GDE.LINE_SEPARATOR);
                        zipWriter.write(sb.toString().getBytes());
                        log.log(java.util.logging.Level.INFO, "data line = " + sb.toString());
                    }
                    sb = new StringBuilder();
                    double latitude = Double.parseDouble(((String)wayPoints.get(0)).split(";")[0].substring(0, 7)) / 100.0;
                    latitude = ((String)wayPoints.get(0)).split(";")[0].endsWith("N") ? latitude : -1.0 * latitude;
                    double longitude = Double.parseDouble(((String)wayPoints.get(0)).split(";")[1].substring(0, 7)) / 10.0;
                    longitude = ((String)wayPoints.get(0)).split(";")[1].endsWith("E") ? longitude : -1.0 * longitude;
                    sb.append(String.format(Locale.ENGLISH, "\t\t\t\t\t\t%.7f,", device.translateValue(recordLongitude, longitude))).append(String.format(Locale.ENGLISH, "%.7f,", device.translateValue(recordLatitude, latitude))).append(String.format(Locale.ENGLISH, "%d", relativeAltitude)).append(GDE.LINE_SEPARATOR);
                    zipWriter.write(sb.toString().getBytes());
                    log.log(java.util.logging.Level.INFO, "data line = " + sb.toString());
                    zipWriter.write(triangleTrailer.getBytes());
                    zipWriter.write(triangleFooter.getBytes());
                }
            }
            zipWriter.write(pointsLeader.getBytes());
            lastTimeStamp = -1L;
            int n3 = i = recordSet.isZoomMode() ? 0 : startIndex;
            while (isPositionWritten && i < dataSize) {
                long timeStamp = recordSet.getTime(i) / 10L + recordSetStartTimeStamp;
                if (timeStamp - lastTimeStamp >= (long)timeStep_ms || lastTimeStamp == -1L) {
                    double slope;
                    double speed = recordMeasurement == null ? 0.0 : device.translateValue(recordMeasurement, (double)recordMeasurement.get(i).intValue() / 1000.0);
                    double d = slope = recordSlope == null ? 0.0 : device.translateValue(recordSlope, (double)recordSlope.get(i).intValue() / 1000.0);
                    double slopeLast = i == 0 ? slope : (recordSlope == null ? 0.0 : device.translateValue(recordSlope, (double)recordSlope.get(i - 1).intValue() / 1000.0));
                    boolean isSlope0 = speed > 2.0 && (slope <= 0.0 && slopeLast > 0.0 || slope > 0.0 && slopeLast <= 0.0 || slope == 0.0);
                    relAltitude = recordAltitude == null ? 0.0 : device.translateValue(recordAltitude, (double)recordAltitude.get(i).intValue() / 1000.0) - height0;
                    zipWriter.write(String.format(Locale.ENGLISH, dataPoint, recordSet.getTime(i) / 1000L / 10L, speed, measurementUnit, relAltitude, device.translateValue(recordLongitude, (double)recordLongitude.get(i).intValue() / 1000.0), device.translateValue(recordLatitude, (double)recordLatitude.get(i).intValue() / 1000.0), relAltitude, measurementName, speed, measurementUnit, (double)((Integer)recordAzimuth.get(i)).intValue() / 1000.0, dateString, new SimpleDateFormat("HH:mm:ss").format((double)date + recordSet.getTime_ms(i)), device.translateValue(recordLongitude, (double)recordLongitude.get(i).intValue() / 1000.0), device.translateValue(recordLatitude, (double)recordLatitude.get(i).intValue() / 1000.0), relAltitude, (double)((Integer)recordAzimuth.get(i)).intValue() / 1000.0, dateString, new SimpleDateFormat("HH:mm:ss").format((double)date + recordSet.getTime_ms(i)), isSlope0 ? KMZWriter.getTrackIcon((double)((Integer)recordAzimuth.get(i)).intValue() / 1000.0) : "none", altitudeMode, device.translateValue(recordLongitude, (double)recordLongitude.get(i).intValue() / 1000.0), device.translateValue(recordLatitude, (double)recordLatitude.get(i).intValue() / 1000.0), relAltitude < 0.0 ? 0.0 : relAltitude).getBytes());
                    lastTimeStamp = timeStamp;
                }
                ++i;
            }
            zipWriter.write(pointsTrailer.getBytes());
            for (int j = 0; j < icons.length; ++j) {
                zipWriter.write(String.format(Locale.ENGLISH, iconsdef, icons[j], 22.5 * (double)j, icons[j], 22.5 * (double)j, icons[j], icons[j], icons[j]).getBytes());
            }
            zipWriter.write(emptyStyleMap.getBytes());
            zipWriter.write(footer.getBytes());
            zipWriter.closeEntry();
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{SWTResourceManager.getImage("gde/resource/track.png").getImageData()};
            zipWriter.putNextEntry(new ZipEntry("track.png"));
            imageLoader.save((OutputStream)zipWriter, 5);
            zipWriter.closeEntry();
            zipWriter.flush();
            zipWriter.close();
            zipWriter = null;
        }
        catch (IOException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            throw new Exception(Messages.getString("GDE_MSGE0006", new Object[]{"kmz", kmzFilePath, e.getMessage()}));
        }
        catch (Exception e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            throw new Exception(Messages.getString("GDE_MSGE0007") + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        finally {
            GDE.getUiNotification().setStatusMessage("");
            if (zipWriter != null) {
                try {
                    zipWriter.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                }
                zipWriter = null;
            }
        }
        GDE.getUiNotification().setProgress(100);
        GDE.getUiNotification().setStatusMessage("");
        if (log.isLoggable(Level.TIME)) {
            log.log(Level.TIME, "KML file = " + kmzFilePath + " written successfulywrite time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
        }
    }

    private static String getTrackIcon(double tmpAzimuth) {
        String trackIcon = "track-" + icons[0];
        if (tmpAzimuth >= 348.75 && tmpAzimuth <= 360.0 || tmpAzimuth >= 0.0 && tmpAzimuth < 11.25) {
            trackIcon = "track-" + icons[0];
        } else if (tmpAzimuth >= 11.25 && tmpAzimuth < 33.75) {
            trackIcon = "track-" + icons[1];
        } else if (tmpAzimuth >= 33.75 && tmpAzimuth < 56.25) {
            trackIcon = "track-" + icons[2];
        } else if (tmpAzimuth >= 56.25 && tmpAzimuth < 78.75) {
            trackIcon = "track-" + icons[3];
        } else if (tmpAzimuth >= 78.75 && tmpAzimuth < 101.25) {
            trackIcon = "track-" + icons[4];
        } else if (tmpAzimuth >= 101.25 && tmpAzimuth < 123.75) {
            trackIcon = "track-" + icons[5];
        } else if (tmpAzimuth >= 123.75 && tmpAzimuth < 146.25) {
            trackIcon = "track-" + icons[6];
        } else if (tmpAzimuth >= 146.25 && tmpAzimuth < 168.75) {
            trackIcon = "track-" + icons[7];
        } else if (tmpAzimuth >= 168.75 && tmpAzimuth < 191.25) {
            trackIcon = "track-" + icons[8];
        } else if (tmpAzimuth >= 191.25 && tmpAzimuth < 213.75) {
            trackIcon = "track-" + icons[9];
        } else if (tmpAzimuth >= 213.75 && tmpAzimuth < 236.25) {
            trackIcon = "track-" + icons[10];
        } else if (tmpAzimuth >= 236.25 && tmpAzimuth < 258.75) {
            trackIcon = "track-" + icons[11];
        } else if (tmpAzimuth >= 258.75 && tmpAzimuth < 281.25) {
            trackIcon = "track-" + icons[12];
        } else if (tmpAzimuth >= 281.25 && tmpAzimuth < 303.75) {
            trackIcon = "track-" + icons[13];
        } else if (tmpAzimuth >= 303.75 && tmpAzimuth < 326.25) {
            trackIcon = "track-" + icons[14];
        } else if (tmpAzimuth >= 326.25 && tmpAzimuth < 348.75) {
            trackIcon = "track-" + icons[15];
        }
        return trackIcon;
    }

    public static int switchColor(ZipOutputStream writer, Record measurementRecord, int actualValue, int measurementLowerLimit, int measurementUpperLimit, String[] measurementColors, int velocityRange, String altitudeMode, boolean isExtrude, String randomColor) throws IOException {
        if (actualValue < measurementLowerLimit) {
            String placemarkName0 = Messages.getString("GDE_MSGT0604", new Object[]{measurementRecord.getName(), measurementLowerLimit, measurementRecord.getUnit()});
            writer.write(speedTrailer.getBytes());
            writer.write(String.format(Locale.ENGLISH, speedLeader, placemarkName0, measurementColors[0], 2, measurementColors[0].substring(2), randomColor, isExtrude ? 1 : 0, altitudeMode).getBytes());
            velocityRange = 0;
        } else if (actualValue >= measurementLowerLimit && actualValue <= measurementUpperLimit) {
            String placemarkName1 = Messages.getString("GDE_MSGT0605", new Object[]{measurementRecord.getName(), measurementLowerLimit, measurementUpperLimit, measurementRecord.getUnit()});
            writer.write(speedTrailer.getBytes());
            writer.write(String.format(Locale.ENGLISH, speedLeader, placemarkName1, measurementColors[1], 2, measurementColors[1].substring(2), randomColor, isExtrude ? 1 : 0, altitudeMode).getBytes());
            velocityRange = 1;
        } else if (actualValue > measurementUpperLimit) {
            String placemarkName2 = Messages.getString("GDE_MSGT0606", new Object[]{measurementRecord.getName(), measurementUpperLimit, measurementRecord.getUnit()});
            writer.write(speedTrailer.getBytes());
            writer.write(String.format(Locale.ENGLISH, speedLeader, placemarkName2, measurementColors[2], 2, measurementColors[2].substring(2), randomColor, isExtrude ? 1 : 0, altitudeMode).getBytes());
            velocityRange = 2;
        }
        return velocityRange;
    }
}

