/*
 * Decompiled with CFR 0.152.
 */
package gde.io;

import gde.device.CheckSumTypes;
import gde.device.FormatTypes;
import gde.exception.DevicePropertiesInconsistenceException;
import gde.io.IDataParser;
import gde.io.NMEAParser;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.Checksum;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataParser
extends NMEAParser
implements IDataParser {
    static Logger log = Logger.getLogger(DataParser.class.getName());
    protected int start_time_ms = Integer.MIN_VALUE;
    protected int valueSize;
    protected final int timeFactor;
    protected final FormatTypes checkSumFormatType;
    protected final FormatTypes dataFormatType;
    protected final boolean isMultiply1000;
    protected final boolean isRedirectChannel1;

    public DataParser(int useTimeFactor, String useLeaderChar, String useSeparator, CheckSumTypes useCheckSumType, int useDataSize) {
        super(useLeaderChar, useSeparator, useCheckSumType, useDataSize, DataExplorer.getInstance().getActiveDevice(), DataExplorer.getInstance().getActiveChannelNumber(), (short)0);
        this.timeFactor = useTimeFactor;
        this.checkSumFormatType = FormatTypes.BINARY;
        this.dataFormatType = FormatTypes.VALUE;
        this.isMultiply1000 = true;
        this.isRedirectChannel1 = false;
    }

    public DataParser(int useTimeFactor, String useLeaderChar, String useSeparator, CheckSumTypes useCheckSumType, FormatTypes useCheckSumFormatType, int useDataSize, FormatTypes useDataFormatType, boolean doMultiply1000) {
        super(useLeaderChar, useSeparator, useCheckSumType, useDataSize, DataExplorer.getInstance().getActiveDevice(), DataExplorer.getInstance().getActiveChannelNumber(), (short)0);
        this.timeFactor = useTimeFactor;
        this.checkSumFormatType = useCheckSumFormatType;
        this.dataFormatType = useDataFormatType;
        this.isMultiply1000 = doMultiply1000;
        this.isRedirectChannel1 = false;
    }

    @Override
    public boolean isRedirectChannel1() {
        return this.isRedirectChannel1;
    }

    public DataParser(int useTimeFactor, String useLeaderChar, String useSeparator, CheckSumTypes useCheckSumType, int useDataSize, boolean redirect2Channel1) {
        super(useLeaderChar, useSeparator, useCheckSumType, useDataSize, DataExplorer.getInstance().getActiveDevice(), DataExplorer.getInstance().getActiveChannelNumber(), (short)0);
        this.timeFactor = useTimeFactor;
        this.checkSumFormatType = FormatTypes.BINARY;
        this.dataFormatType = FormatTypes.VALUE;
        this.isMultiply1000 = true;
        this.isRedirectChannel1 = redirect2Channel1;
    }

    @Override
    public void parse(String inputLine, int lineNum) throws DevicePropertiesInconsistenceException, Exception {
        try {
            String[] strValues = inputLine.split(this.separator);
            try {
                int n = this.channelConfigNumber = this.isRedirectChannel1 ? 1 : Integer.parseInt(strValues[0].substring(1).trim());
                int n2 = this.dataFormatType != null && this.dataFormatType == FormatTypes.BINARY ? strValues.length - 4 : (this.dataFormatType != null && this.dataFormatType == FormatTypes.VALUE && this.dataBlockSize != 0 ? (Math.abs(this.dataBlockSize) > this.device.getNumberOfMeasurements(this.channelConfigNumber) ? this.device.getNumberOfMeasurements(this.channelConfigNumber) : Math.abs(this.dataBlockSize)) : (this.valueSize = strValues.length - 4));
                if (!this.device.getName().startsWith("iCharger")) {
                    this.values = new int[this.valueSize];
                }
                log.log(Level.FINER, "parser inputLine = " + inputLine);
                this.parse(inputLine, strValues);
            }
            catch (RuntimeException e) {
                super.parse(inputLine, lineNum);
            }
        }
        catch (NumberFormatException e) {
            log.log(Level.WARNING, e.getMessage(), e);
            throw e;
        }
    }

    @Override
    public void parse(String inputLine, String[] strValues) throws DevicePropertiesInconsistenceException {
        String strValue = strValues[0].trim().substring(1);
        this.channelConfigNumber = this.isRedirectChannel1 ? 1 : Integer.parseInt(strValue);
        strValue = strValues[1].trim();
        this.state = Integer.parseInt(strValue);
        strValue = strValues[2].trim().replace(',', '.');
        String string = strValue = strValue.length() > 0 ? strValue : "0";
        if (this.start_time_ms == Integer.MIN_VALUE) {
            this.start_time_ms = (int)(Double.parseDouble(strValue) * (double)this.timeFactor);
        } else {
            this.time_ms = this.deviceName.startsWith("JLog") && this.time_ms >= 3276700 ? (this.time_ms += 100) : (int)(Double.parseDouble(strValue) * (double)this.timeFactor) - this.start_time_ms;
        }
        for (int i = 0; i < this.valueSize && i < strValues.length - 4; ++i) {
            strValue = strValues[i + 3].trim().replace(',', '.');
            try {
                double tmpValue;
                double d = tmpValue = strValue.length() > 0 ? Double.parseDouble(strValue) : 0.0;
                if (this.isMultiply1000 && tmpValue < 2147483.0 && tmpValue > -2147483.0) {
                    this.values[i] = (int)(tmpValue * 1000.0);
                    continue;
                }
                if (tmpValue < 2.147483647E9 || tmpValue > -2.147483648E9) {
                    this.values[i] = (int)tmpValue;
                    continue;
                }
                this.values[i] = (int)(tmpValue / 1000.0);
                continue;
            }
            catch (NumberFormatException e) {
                this.values[i] = 0;
            }
        }
        if (this.device.getTimeStep_ms() < 0.0 && this.time_ms <= 0 && this.isTimeResetEnabled) {
            this.recordSetNumberOffset += ++this.timeResetCounter;
            this.isTimeResetEnabled = false;
        }
        if (this.checkSumType != null && !this.isChecksumOK(inputLine, Integer.parseInt(strValues[strValues.length - 1].trim(), 16))) {
            DevicePropertiesInconsistenceException e = new DevicePropertiesInconsistenceException(Messages.getString("GDE_MSGE0049", new Object[]{strValues[strValues.length - 1].trim(), String.format("%X", this.calcChecksum(inputLine))}));
            log.log(Level.WARNING, e.getMessage(), e);
            throw e;
        }
    }

    public boolean isChecksumOK(String inputLine, int tmpCheckSum) {
        return tmpCheckSum == this.calcChecksum(inputLine);
    }

    public int calcChecksum(String inputLine) {
        int checksum = 0;
        block0 : switch (this.checkSumType) {
            case ADD: {
                switch (this.checkSumFormatType) {
                    case VALUE: {
                        checksum = Checksum.ADD(this.values, 0, this.valueSize);
                        break block0;
                    }
                }
                checksum = Checksum.ADD(inputLine.substring(0, inputLine.lastIndexOf(this.separator) + 1).getBytes());
                break;
            }
            case XOR: {
                switch (this.checkSumFormatType) {
                    case VALUE: {
                        checksum = Checksum.XOR(this.values, 0, this.valueSize);
                        break block0;
                    }
                }
                checksum = Checksum.XOR(inputLine.substring(0, inputLine.lastIndexOf(this.separator) + 1).getBytes());
                break;
            }
            case OR: {
                switch (this.checkSumFormatType) {
                    case VALUE: {
                        checksum = Checksum.OR(this.values, 0, this.valueSize);
                        break block0;
                    }
                }
                checksum = Checksum.OR(inputLine.substring(0, inputLine.lastIndexOf(this.separator) + 1).getBytes());
                break;
            }
            case AND: {
                switch (this.checkSumFormatType) {
                    case VALUE: {
                        checksum = Checksum.AND(this.values, 0, this.valueSize);
                        break block0;
                    }
                }
                checksum = Checksum.AND(inputLine.substring(0, inputLine.lastIndexOf(this.separator) + 1).getBytes());
            }
        }
        return checksum;
    }

    public static final double[] byte2Double(byte[] inData, boolean byteSwap) {
        int j = 0;
        int length = inData.length / 8;
        double[] outData = new double[length];
        if (!byteSwap) {
            for (int i = 0; i < length; ++i) {
                j = i * 8;
                int upper = ((inData[j] & 0xFF) << 24) + ((inData[j + 1] & 0xFF) << 16) + ((inData[j + 2] & 0xFF) << 8) + ((inData[j + 3] & 0xFF) << 0);
                int lower = ((inData[j + 4] & 0xFF) << 24) + ((inData[j + 5] & 0xFF) << 16) + ((inData[j + 6] & 0xFF) << 8) + ((inData[j + 7] & 0xFF) << 0);
                outData[i] = Double.longBitsToDouble(((long)upper << 32) + ((long)lower & 0xFFFFFFFFL));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                j = i * 8;
                int upper = ((inData[j + 7] & 0xFF) << 24) + ((inData[j + 6] & 0xFF) << 16) + ((inData[j + 5] & 0xFF) << 8) + ((inData[j + 4] & 0xFF) << 0);
                int lower = ((inData[j + 3] & 0xFF) << 24) + ((inData[j + 2] & 0xFF) << 16) + ((inData[j + 1] & 0xFF) << 8) + ((inData[j] & 0xFF) << 0);
                outData[i] = Double.longBitsToDouble(((long)upper << 32) + ((long)lower & 0xFFFFFFFFL));
            }
        }
        return outData;
    }

    public static long getLong(byte[] array, int offset) {
        return (long)(array[offset] & 0xFF) << 56 | (long)(array[offset + 1] & 0xFF) << 48 | (long)(array[offset + 2] & 0xFF) << 40 | (long)(array[offset + 3] & 0xFF) << 32 | (long)(array[offset + 4] & 0xFF) << 24 | (long)(array[offset + 5] & 0xFF) << 16 | (long)(array[offset + 6] & 0xFF) << 8 | (long)(array[offset + 7] & 0xFF);
    }

    public static long parse2Long(byte[] buffer, int startIndex) {
        return (long)(buffer[startIndex + 7] & 0xFF) << 56 | (long)(buffer[startIndex + 6] & 0xFF) << 48 | (long)(buffer[startIndex + 5] & 0xFF) << 40 | (long)(buffer[startIndex + 4] & 0xFF) << 32 | (long)(buffer[startIndex + 3] & 0xFF) << 24 | (long)(buffer[startIndex + 2] & 0xFF) << 16 | (long)(buffer[startIndex + 1] & 0xFF) << 8 | (long)(buffer[startIndex] & 0xFF);
    }

    public static long getUInt32(byte[] buffer, int startIndex) {
        long value = buffer[0 + startIndex] & 0xFF;
        value |= (long)(buffer[1 + startIndex] << 8 & 0xFFFF);
        value |= (long)(buffer[2 + startIndex] << 16 & 0xFFFFFF);
        return value |= (long)(buffer[3 + startIndex] << 24 & 0xFFFFFFFF);
    }

    public static int getInt(byte[] array, int offset) {
        return (array[offset] & 0xFF) << 24 | (array[offset + 1] & 0xFF) << 16 | (array[offset + 2] & 0xFF) << 8 | array[offset + 3] & 0xFF;
    }

    public static int parse2Int(byte[] buffer, int startIndex) {
        return (buffer[startIndex + 3] & 0xFF) << 24 | (buffer[startIndex + 2] & 0xFF) << 16 | (buffer[startIndex + 1] & 0xFF) << 8 | buffer[startIndex] & 0xFF;
    }

    public static short parse2Short(byte[] buffer, int startIndex) {
        return (short)((buffer[startIndex + 1] & 0xFF) << 8 | buffer[startIndex] & 0xFF);
    }

    public static int parse2UnsignedShort(byte[] buffer, int startIndex) {
        return (buffer[startIndex + 1] & 0xFF) << 8 | buffer[startIndex] & 0xFF;
    }

    public static int intFromBytes(byte b1, byte b2, byte b3, byte b4) {
        return b1 << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    public static short shortFromBytes(byte b1, byte b2) {
        return (short)(b1 << 8 | b2 & 0xFF);
    }

    public static short parse2Short(byte low, byte high) {
        return (short)((high & 0xFF) << 8 | low & 0xFF);
    }

    public static int parse2UnsignedShort(byte low, byte high) {
        return (high & 0xFF) << 8 | low & 0xFF;
    }
}

