/*
 * Decompiled with CFR 0.152.
 */
package gde.data;

import gde.data.AbstractRecord;
import gde.data.AbstractRecordSet;
import gde.data.Record;
import gde.data.TimeSteps;
import gde.device.IDevice;
import gde.device.StatisticsType;
import gde.log.Level;
import gde.log.Logger;
import java.util.Vector;

public abstract class CommonRecord
extends AbstractRecord {
    private static final String $CLASS_NAME = CommonRecord.class.getName();
    private static final long serialVersionUID = 26031957L;
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    TimeSteps timeStep_ms = null;
    protected IDevice device;
    protected int ordinal;
    protected AbstractRecordSet parent;
    protected String name;
    String unit;
    String symbol;
    String description = " ";
    protected Boolean isActive;
    Record.DataType dataType = Record.DataType.DEFAULT;
    StatisticsType statistics = null;
    protected int maxValue = 0;
    protected int minValue = 0;
    int avgValue = Integer.MIN_VALUE;
    int sigmaValue = Integer.MIN_VALUE;

    public CommonRecord(IDevice newDevice, int newOrdinal, String newName, String newSymbol, String newUnit, boolean isActiveValue, StatisticsType newStatistic, int initialCapacity) {
        super(initialCapacity);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, newName + " Record(IDevice, int, String, String, String, boolean, StatisticsType, List<PropertyType>, int)");
        }
        this.device = newDevice;
        this.ordinal = newOrdinal;
        this.name = newName;
        this.symbol = newSymbol;
        this.unit = newUnit;
        this.isActive = isActiveValue;
        this.statistics = newStatistic;
    }

    protected CommonRecord(CommonRecord record) {
        super(record);
    }

    public synchronized boolean add(Integer point, double useTimeStep_ms) {
        if (this.timeStep_ms != null) {
            this.timeStep_ms.add(useTimeStep_ms);
        }
        return this.add(point);
    }

    @Override
    public abstract boolean add(Integer var1);

    @Override
    public synchronized Integer set(int index, Integer point) {
        String $METHOD_NAME = "set";
        if (super.size() == 0) {
            this.minValue = this.maxValue = point.intValue();
        } else if (point > this.maxValue) {
            this.maxValue = point;
        } else if (point < this.minValue) {
            this.minValue = point;
        }
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, $CLASS_NAME, "set", this.name + " setting point = " + point);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.logp(Level.FINEST, $CLASS_NAME, "set", this.name + " minValue = " + this.minValue + " maxValue = " + this.maxValue);
        }
        return super.set(index, point);
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int newOrdinal) {
        this.ordinal = newOrdinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getSyncMasterName() {
        StringBuilder sb = new StringBuilder().append(this.name.split(" ")[0]);
        AbstractRecordSet.SyncedRecords<? extends AbstractRecord> syncedRecords = this.getAbstractParent().scaleSyncedRecords;
        if (syncedRecords.get(this.ordinal) != null && ((AbstractRecord)((Vector)syncedRecords.get(this.ordinal)).firstElement()).getName().split(" ").length > 1) {
            sb.append(" ");
            String[] splitName = ((AbstractRecord)((Vector)syncedRecords.get(this.ordinal)).firstElement()).getName().split(" ");
            sb.append(splitName.length > 1 ? splitName[1] : "*");
            sb.append(".");
            sb.append(".");
            String trailer = "*";
            for (AbstractRecord tmpRecord : (Vector)syncedRecords.get(this.ordinal)) {
                if (!tmpRecord.isDisplayable() || tmpRecord.size() <= 1) continue;
                trailer = tmpRecord.getName();
            }
            sb.append(trailer.split(" ").length > 1 ? trailer.split(" ")[1] : "*");
        } else {
            sb.append(" - ").append(((AbstractRecord)((Vector)syncedRecords.get(this.ordinal)).lastElement()).getName());
        }
        return sb.toString();
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String newUnit) {
        this.unit = newUnit;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String newSymbol) {
        this.symbol = newSymbol;
    }

    public abstract int getMaxValue();

    public abstract int getMinValue();

    public int getRealMaxValue() {
        return this.maxValue;
    }

    public int getRealMinValue() {
        return this.minValue;
    }

    @Override
    public abstract int size();

    public int realSize() {
        return super.size();
    }

    @Override
    public Integer getFirst() {
        return super.size() > 0 ? (Integer)super.get(0) : 0;
    }

    @Override
    public Integer getLast() {
        return super.size() > 0 ? (Integer)super.get(super.size() - 1) : 0;
    }

    public Integer realGet(int index) {
        try {
            return super.size() != 0 ? (Integer)super.get(index) : 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.log(Level.WARNING, String.format("%s - %20s: size = %d - indesx = %d", this.parent.name, this.name, super.size(), index));
            return super.size() != 0 ? (Integer)super.get(index - 1) : 0;
        }
    }

    @Override
    public AbstractRecordSet getAbstractParent() {
        return this.parent;
    }

    public boolean isActive() {
        return this.isActive == null || super.size() == 0 ? false : this.isActive;
    }

    public void setActive(Boolean newValue) {
        this.isActive = newValue;
    }

    public boolean isCalculation() {
        return this.isActive == null;
    }

    public long getStartTimeStamp() {
        return this.timeStep_ms == null ? this.parent.timeStep_ms.getStartTimeStamp() : this.timeStep_ms.getStartTimeStamp();
    }

    public abstract double getTime_ms(int var1);

    public double getLastTime_ms() {
        return this.timeStep_ms == null ? (double)((Long)this.parent.timeStep_ms.lastElement()).longValue() / 10.0 : (double)((Long)this.timeStep_ms.lastElement()).longValue() / 10.0;
    }

    void setTimeStep_ms(double newTimeStep_ms) {
        this.timeStep_ms = new TimeSteps(newTimeStep_ms);
    }

    public double getMaxTime_ms() {
        return this.timeStep_ms == null ? this.parent.getMaxTime_ms() : (this.timeStep_ms.isConstant ? this.timeStep_ms.getMaxTime_ms() * (double)(this.elementCount - 1) : this.timeStep_ms.getMaxTime_ms());
    }

    protected int[] findBoundingIndexes(double time_ms) {
        int[] indexs;
        int[] nArray = indexs = this.timeStep_ms == null ? this.parent.timeStep_ms.findBoundingIndexes(time_ms) : this.timeStep_ms.findBoundingIndexes(time_ms);
        if (this.elementCount > 0) {
            indexs[0] = indexs[0] > this.elementCount - 1 ? this.elementCount - 1 : indexs[0];
            indexs[1] = indexs[1] > this.elementCount - 1 ? this.elementCount - 1 : indexs[1];
        }
        return indexs;
    }

    @Override
    public abstract String getFormattedScaleValue(double var1);

    public void resetMinMax() {
        this.maxValue = 0;
        this.minValue = 0;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, this.name);
        }
    }

    public void setMinMax(int newMin, int newMax) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "setMinMax :  " + newMin + "," + newMax);
        }
        this.maxValue = newMax;
        this.minValue = newMin;
    }

    public int getAvgValue() {
        this.setAvgValue();
        return this.avgValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvgValue() {
        CommonRecord commonRecord = this;
        synchronized (commonRecord) {
            if (super.size() > 0) {
                long sum = 0L;
                int zeroCount = 0;
                for (Integer xi : this) {
                    if (xi != null && xi != 0) {
                        sum += (long)xi.intValue();
                        continue;
                    }
                    ++zeroCount;
                }
                this.avgValue = super.size() - zeroCount != 0 ? Long.valueOf(sum / (long)(super.size() - zeroCount)).intValue() : 0;
            }
        }
    }

    public int getSigmaValue() {
        this.setSigmaValue();
        return this.sigmaValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSigmaValue() {
        CommonRecord commonRecord = this;
        synchronized (commonRecord) {
            if (super.size() > 0) {
                double average = (double)this.getAvgValue() / 1000.0;
                double sumPoweredValues = 0.0;
                int zeroCount = 0;
                for (Integer xi : this) {
                    if (xi != null && xi != 0) {
                        sumPoweredValues += Math.pow((double)xi.intValue() / 1000.0 - average, 2.0);
                        continue;
                    }
                    ++zeroCount;
                }
                this.sigmaValue = super.size() - zeroCount - 1 != 0 ? Double.valueOf(Math.sqrt(sumPoweredValues / (double)(super.size() - zeroCount - 1)) * 1000.0).intValue() : 0;
            }
        }
    }

    public boolean isScaleSynced() {
        return this.getAbstractParent().isOneOfSyncableRecord(this.name);
    }

    public boolean isScaleSyncMaster() {
        return this.getAbstractParent().scaleSyncedRecords.containsKey(this.ordinal);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public abstract boolean hasReasonableData();

    @Override
    public String toString() {
        return "CommonRecord [ordinal=" + this.ordinal + ", name=" + this.name + ", realSize=" + this.realSize() + ", isActive=" + this.isActive + ", dataType=" + (Object)((Object)this.dataType) + ", maxValue=" + this.maxValue + ", minValue=" + this.minValue + ", avgValue=" + this.avgValue + ", sigmaValue=" + this.sigmaValue + "]";
    }
}

