/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.graupner.HoTTAdapterDialog;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.MeasurementControl;
import gde.ui.SWTResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class HoTTAdapterDialogTabItem
extends CTabItem {
    static final Logger log = Logger.getLogger(HoTTAdapterDialogTabItem.class.getName());
    Composite measurementComposite;
    Button measurement;
    Label measurementUnitLabel;
    Label measurementSymbolLabel;
    Label tabItemLabel;
    ScrolledComposite scolledComposite;
    Composite mainTabComposite;
    final CTabFolder parent;
    final IDevice device;
    final DataExplorer application;
    final Channels channels;
    final HoTTAdapterDialog dialog;
    final int channelConfigNumber;
    final List<MeasurementControl> measurementTypes = new ArrayList<MeasurementControl>();

    public HoTTAdapterDialogTabItem(CTabFolder parentTabFolder, HoTTAdapterDialog parentDialog, int useChannelConfigNumber, IDevice useDevice) {
        super(parentTabFolder, 0);
        this.parent = parentTabFolder;
        this.dialog = parentDialog;
        this.device = useDevice;
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.channelConfigNumber = useChannelConfigNumber;
        this.setText(this.device.getChannelNameReplacement(this.channelConfigNumber));
        this.create();
    }

    void create() {
        this.scolledComposite = new ScrolledComposite((Composite)this.parent, 512);
        this.scolledComposite.setLayout((Layout)new FillLayout());
        this.setControl((Control)this.scolledComposite);
        this.mainTabComposite = new Composite((Composite)this.scolledComposite, 0);
        GridLayout mainTabCompositeLayout = new GridLayout();
        mainTabCompositeLayout.makeColumnsEqualWidth = true;
        mainTabCompositeLayout.numColumns = 2;
        this.mainTabComposite.setLayout((Layout)mainTabCompositeLayout);
        this.mainTabComposite.setSize(610, 350);
        this.scolledComposite.setContent((Control)this.mainTabComposite);
        this.tabItemLabel = new Label(this.mainTabComposite, 0x1000000);
        GridData tabItemLabelLData = new GridData();
        tabItemLabelLData.horizontalAlignment = 1;
        tabItemLabelLData.verticalAlignment = 1;
        tabItemLabelLData.heightHint = 20;
        tabItemLabelLData.widthHint = 300;
        this.tabItemLabel.setLayoutData((Object)tabItemLabelLData);
        this.tabItemLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + 2), (int)1));
        this.tabItemLabel.setText(Messages.getString((String)"GDE_MSGT2401"));
        Composite filler = new Composite(this.mainTabComposite, 0);
        GridData fillerLData = new GridData();
        fillerLData.horizontalAlignment = 1;
        fillerLData.verticalAlignment = 1;
        fillerLData.heightHint = 20;
        fillerLData.widthHint = 300;
        filler.setLayoutData((Object)fillerLData);
        if (this.channelConfigNumber == this.application.getActiveChannelNumber()) {
            this.createMeasurementsControls(this.channelConfigNumber);
        }
        this.scolledComposite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent evt) {
                log.log(Level.FINEST, "scolledComposite.controlResized, event=" + evt);
                int height = 35 + HoTTAdapterDialogTabItem.this.device.getChannelMeasuremtsReplacedNames(HoTTAdapterDialogTabItem.this.parent.getSelectionIndex() + 1).size() * 28 / 2;
                HoTTAdapterDialogTabItem.this.mainTabComposite.setSize(HoTTAdapterDialogTabItem.this.scolledComposite.getClientArea().width, height);
            }

            public void controlMoved(ControlEvent evt) {
                log.log(Level.FINEST, "scolledComposite.controlMoved, event=" + evt);
                int height = 35 + HoTTAdapterDialogTabItem.this.device.getChannelMeasuremtsReplacedNames(HoTTAdapterDialogTabItem.this.parent.getSelectionIndex() + 1).size() * 28 / 2;
                HoTTAdapterDialogTabItem.this.mainTabComposite.setSize(HoTTAdapterDialogTabItem.this.scolledComposite.getClientArea().width, height);
            }
        });
    }

    public void createMeasurementsControls(int channelConfigNumber) {
        RecordSet actualRecordSet = this.channels.getActiveChannel().getActiveRecordSet();
        List channelMeasurements = this.device.getChannelMeasuremtsReplacedNames(channelConfigNumber);
        if (actualRecordSet != null && actualRecordSet.realSize() == channelMeasurements.size()) {
            for (int i = 0; i < channelMeasurements.size(); ++i) {
                MeasurementType measurement = (MeasurementType)channelMeasurements.get(i);
                if (!measurement.getName().equals(actualRecordSet.get(i).getName())) {
                    measurement.setName(actualRecordSet.get(i).getName());
                }
                if (!measurement.getUnit().equals(actualRecordSet.get(i).getUnit())) {
                    measurement.setUnit(actualRecordSet.get(i).getUnit());
                }
                if (!measurement.getSymbol().equals(actualRecordSet.get(i).getSymbol())) {
                    measurement.setSymbol(actualRecordSet.get(i).getSymbol());
                }
                this.measurementTypes.add(new MeasurementControl(this.mainTabComposite, (DeviceDialog)this.dialog, channelConfigNumber, i, measurement, this.device, 1));
            }
        } else {
            for (int i = 0; i < channelMeasurements.size(); ++i) {
                this.measurementTypes.add(new MeasurementControl(this.mainTabComposite, (DeviceDialog)this.dialog, channelConfigNumber, i, (MeasurementType)channelMeasurements.get(i), this.device, 1));
            }
        }
        this.mainTabComposite.layout(true);
    }

    public boolean isMeasurementTypesCreated() {
        return this.measurementTypes.size() > 0;
    }
}

