/*
 * Decompiled with CFR 0.152.
 */
package gde.device.peaktech;

import gde.data.Channel;
import gde.data.Channels;
import gde.device.DeviceConfiguration;
import gde.device.peaktech.GathererThreadRS232;
import gde.device.peaktech.PeakTech;
import gde.exception.ApplicationConfigurationException;
import gde.exception.SerialPortException;
import gde.log.Level;
import gde.messages.Messages;
import gde.utils.StringHelper;
import java.io.FileNotFoundException;
import java.util.HashMap;
import javax.xml.bind.JAXBException;

public class PeakTechRS232
extends PeakTech {
    public PeakTechRS232(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
    }

    public PeakTechRS232(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
    }

    @Override
    public HashMap<String, String> getMeasurementInfo(byte[] buffer, HashMap<String, String> measurementInfo) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "buffer : " + StringHelper.byte2Hex2CharString((byte[])buffer, (int)buffer.length));
        }
        String unit = "";
        switch (buffer[9] & 0xFF) {
            case 128: {
                unit = "\u00b5";
                break;
            }
            case 64: {
                unit = "m";
                break;
            }
            case 32: {
                unit = "k";
                break;
            }
            case 16: {
                unit = "M";
                break;
            }
            case 2: {
                unit = "%";
                break;
            }
        }
        switch (buffer[10] & 0xFF) {
            case 128: {
                unit = unit + "V";
                break;
            }
            case 64: {
                unit = unit + "A";
                break;
            }
            case 32: {
                unit = unit + "\u03a9";
                break;
            }
            case 16: {
                unit = unit + "hFE";
                break;
            }
            case 8: {
                unit = unit + "Hz";
                break;
            }
            case 4: {
                unit = unit + "F";
                break;
            }
            case 2: {
                unit = unit + "\u00b0C";
                break;
            }
            case 1: {
                unit = unit + "\u00b0F";
                break;
            }
        }
        measurementInfo.put("input_unit", unit);
        String typeSymbol = Messages.getString((String)"GDE_MSGT1500");
        if (unit.contains("V")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1501");
        } else if (unit.endsWith("A")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1503");
        } else if (unit.endsWith("\u03a9")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1504");
        } else if (unit.endsWith("F")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1505");
        } else if (unit.endsWith("Hz")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1506");
        } else if (unit.endsWith("\u00b0C")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1507");
        } else if (unit.endsWith("%")) {
            typeSymbol = Messages.getString((String)"GDE_MSGT1537");
        }
        try {
            measurementInfo.put("input_type", typeSymbol.split(" ")[0]);
            measurementInfo.put("input_symbol", typeSymbol.split(" ")[1]);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage());
        }
        return measurementInfo;
    }

    @Override
    public String getMode(byte[] buffer) {
        String mode = "";
        mode = (buffer[7] & 0x20) > 0 ? Messages.getString((String)"GDE_MSGT1511") : Messages.getString((String)"GDE_MSGT1510");
        switch (buffer[7] & 0xFF) {
            case 16: {
                mode = "AC";
                break;
            }
            case 8: {
                mode = "DC";
                break;
            }
        }
        return mode;
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        log.log(Level.OFF, StringHelper.byte2Hex2CharString((byte[])dataBuffer, (int)dataBuffer.length));
        log.log(Level.OFF, String.format("Input: %c%c%c%c%c", dataBuffer[0], dataBuffer[1], dataBuffer[2], dataBuffer[3], dataBuffer[4]));
        points[0] = Integer.valueOf(String.format("%c%c%c%c%c", dataBuffer[0], dataBuffer[1], dataBuffer[2], dataBuffer[3], dataBuffer[4]));
        switch (dataBuffer[6]) {
            default: {
                points[0] = points[0] * 1000;
                break;
            }
            case 1: {
                points[0] = points[0] * 100;
                break;
            }
            case 2: {
                points[0] = points[0] * 10;
                break;
            }
            case 3: 
            case 4: {
                points[0] = points[0] * 1;
            }
        }
        return points;
    }

    @Override
    public void open_closeCommPort() {
        block12: {
            if (this.serialPort != null) {
                if (!this.serialPort.isConnected()) {
                    try {
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block12;
                        this.getDialog().dataGatherThread = new GathererThreadRS232(this.application, this, this.serialPort, activChannel.getNumber(), this.getDialog());
                        try {
                            if (this.serialPort.isConnected()) {
                                this.getDialog().dataGatherThread.start();
                            }
                        }
                        catch (RuntimeException e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                        if (this.getDialog().boundsComposite != null && !this.getDialog().isDisposed()) {
                            this.getDialog().boundsComposite.redraw();
                        }
                    }
                    catch (SerialPortException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                } else {
                    if (this.getDialog().dataGatherThread != null) {
                        this.getDialog().dataGatherThread.stopDataGatheringThread(false);
                    }
                    if (this.getDialog().boundsComposite != null && !this.getDialog().isDisposed()) {
                        this.getDialog().boundsComposite.redraw();
                    }
                    this.serialPort.close();
                }
            }
        }
    }
}

