/*
 * Decompiled with CFR 0.152.
 */
package gde.device.multiplex;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.device.PropertyType;
import gde.device.multiplex.FlightRecorderDialog;
import gde.exception.DataInconsitsentException;
import gde.io.CSVSerialDataReaderWriter;
import gde.io.DataParser;
import gde.io.FileHandler;
import gde.io.IDataParser;
import gde.io.LogViewReader;
import gde.io.NMEAParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class FlightRecorder
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(FlightRecorder.class.getName());
    final DataExplorer application;
    final Channels channels;
    final FlightRecorderDialog dialog;

    public FlightRecorder(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.multiplex.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.dialog = new FlightRecorderDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT2704"), Messages.getString((String)"GDE_MSGT2704"));
            this.updateFileMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
    }

    public FlightRecorder(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.multiplex.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.dialog = new FlightRecorderDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT2704"), Messages.getString((String)"GDE_MSGT2704"));
            this.updateFileMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 0;
    }

    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        block6: {
            NMEAParser data = new NMEAParser(this.getDataBlockLeader(), this.getDataBlockSeparator().value(), this.getDataBlockCheckSumType(), Math.abs(this.getDataBlockSize(InputTypes.FILE_IO)), (IDevice)this, this.channels.getActiveChannelNumber(), this.getUTCdelta());
            String sThreadId = String.format("%06d", Thread.currentThread().getId());
            int progressCycle = 0;
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            try {
                int lastLength = 0;
                for (int i = 0; i < recordDataSize; ++i) {
                    byte[] subLengthBytes = new byte[4];
                    System.arraycopy(dataBuffer, lastLength, subLengthBytes, 0, 4);
                    int subLenght = LogViewReader.parse2Int((byte[])subLengthBytes) - 8;
                    byte[] lineBuffer = new byte[subLenght];
                    System.arraycopy(dataBuffer, 4 + lastLength, lineBuffer, 0, subLenght);
                    String textInput = new String(lineBuffer, "ISO-8859-1");
                    StringTokenizer st = new StringTokenizer(textInput);
                    Vector<String> vec = new Vector<String>();
                    while (st.hasMoreTokens()) {
                        vec.add(st.nextToken("\r\n"));
                    }
                    data.parse(vec, vec.size());
                    lastLength += subLenght + 12;
                    recordSet.addNoneCalculationRecordsPoints(data.getValues(), (double)data.getTime_ms());
                    if (!doUpdateProgressBar || i % 50 != 0) continue;
                    this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
                }
                this.updateVisibilityStatus(recordSet, true);
                if (doUpdateProgressBar) {
                    this.application.setProgress(100, sThreadId);
                }
            }
            catch (Exception e) {
                String msg = e.getMessage() + Messages.getString((String)"GDE_MSGW0543");
                log.log(java.util.logging.Level.WARNING, msg, e);
                this.application.openMessageDialog(msg);
                if (!doUpdateProgressBar) break block6;
                this.application.setProgress(0, sThreadId);
            }
        }
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int i;
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 4 * recordDataSize;
        byte[] timeStampBuffer = new byte[timeStampBufferSize];
        if (!recordSet.isTimeStepConstant()) {
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
            }
        }
        log.log(java.util.logging.Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        for (i = 0; i < recordDataSize; ++i) {
            log.log(java.util.logging.Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((convertBuffer[0 + j * 4] & 0xFF) << 24) + ((convertBuffer[1 + j * 4] & 0xFF) << 16) + ((convertBuffer[2 + j * 4] & 0xFF) << 8) + ((convertBuffer[3 + j * 4] & 0xFF) << 0);
            }
            if (recordSet.isTimeStepConstant()) {
                recordSet.addPoints(points);
            } else {
                recordSet.addPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public boolean isGPSCoordinates(Record record) {
        return record.getOrdinal() == 0 || record.getOrdinal() == 1;
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double offset = record.getOffset();
                double reduction = record.getReduction();
                double factor = record.getFactor();
                if (record.getOrdinal() > 1) {
                    dataTableRow[index + 1] = record.getDecimalFormat().format(offset + ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor);
                } else {
                    double value = (double)record.realGet(rowIndex).intValue() / 1000000.0;
                    int grad = (int)value;
                    double minuten = (value - (double)grad) * 100.0;
                    dataTableRow[index + 1] = String.format("%.6f", (double)grad + minuten / 60.0);
                }
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
        boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
        property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
        boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
        try {
            if (subtractFirst) {
                reduction = (double)record.getFirst().intValue() / 1000.0;
            }
            if (subtractLast) {
                reduction = (double)record.getLast().intValue() / 1000.0;
            }
        }
        finally {
            double newValue = 0.0;
        }
        {
        }
    }

    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
        boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
        property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
        boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
        try {
            if (subtractFirst) {
                reduction = (double)record.getFirst().intValue() / 1000.0;
            }
            if (subtractLast) {
                reduction = (double)record.getLast().intValue() / 1000.0;
            }
        }
        finally {
            double newValue = 0.0;
        }
        {
        }
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int displayableCounter = 0;
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            log.log(java.util.logging.Level.FINE, record.getName() + " = " + this.getMeasurementNameReplacement(recordSet.getChannelConfigNumber(), i));
            if (includeReasonableDataCheck) {
                record.setDisplayable(record.hasReasonableData());
                log.log(java.util.logging.Level.FINE, record.getName() + " hasReasonableData = " + record.hasReasonableData());
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            log.log(java.util.logging.Level.FINE, "add to displayable counter: " + record.getName());
            ++displayableCounter;
        }
        log.log(Level.FINER, "displayableCounter = " + displayableCounter);
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        this.application.updateStatisticsData();
    }

    public FlightRecorderDialog getDialog() {
        return this.dialog;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    public void open_closeCommPort() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT2700"));
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    FlightRecorder.this.application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        if (!selectedImportFile.toLowerCase().endsWith(".csv")) {
                            if (selectedImportFile.contains(".")) {
                                selectedImportFile = selectedImportFile.substring(0, selectedImportFile.indexOf(46));
                            }
                            selectedImportFile = selectedImportFile + ".csv";
                        }
                        log.log(Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        try {
                            Integer channelConfigNumber = FlightRecorder.this.dialog != null && !FlightRecorder.this.dialog.isDisposed() ? FlightRecorder.this.dialog.getTabFolderSelectionIndex() + 1 : 1;
                            String recordNameExtend = selectedImportFile.substring(selectedImportFile.lastIndexOf(46) - 4, selectedImportFile.lastIndexOf(46));
                            RecordSet recordSet = CSVSerialDataReaderWriter.read((String)selectedImportFile, (IDevice)FlightRecorder.this, (String)recordNameExtend, (Integer)channelConfigNumber, (IDataParser)new DataParser(FlightRecorder.this.getDataBlockTimeUnitFactor(), FlightRecorder.this.getDataBlockLeader(), FlightRecorder.this.getDataBlockSeparator().value(), FlightRecorder.this.getDataBlockCheckSumType(), FlightRecorder.this.getDataBlockSize(InputTypes.FILE_IO)));
                            for (int i = 4; i < recordSet.getRecordNames().length; ++i) {
                                MeasurementType measurement = FlightRecorder.this.getMeasurement(recordSet.getChannelConfigNumber(), i);
                                recordSet.get(i).setName(measurement.getName());
                                recordSet.get(i).setUnit(measurement.getUnit());
                            }
                        }
                        catch (Throwable e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    FlightRecorder.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public void updateFileMenu(Menu exportMenue) {
        if (exportMenue.getItem(exportMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0732"))) {
            new MenuItem(exportMenue, 2);
            MenuItem convertKMZ3DRelativeItem = new MenuItem(exportMenue, 8);
            convertKMZ3DRelativeItem.setText(Messages.getString((String)"GDE_MSGT2705"));
            convertKMZ3DRelativeItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKLM3DRelativeItem action performed! " + e);
                    FlightRecorder.this.export2KMZ3D(0);
                }
            });
            MenuItem convertKMZ3DAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZ3DAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT2706"));
            convertKMZ3DAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKLM3DAbsoluteItem action performed! " + e);
                    FlightRecorder.this.export2KMZ3D(1);
                }
            });
            convertKMZ3DAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZ3DAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT2707"));
            convertKMZ3DAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKLM3DAbsoluteItem action performed! " + e);
                    FlightRecorder.this.export2KMZ3D(2);
                }
            });
        }
    }

    public void export2KMZ3D(int type) {
        new FileHandler().exportFileKMZ(Messages.getString((String)"GDE_MSGT2703"), 1, 0, 2, 7, 9, 11, -1, type == 0, type == 2);
    }

    public boolean isActualRecordSetWithGpsData() {
        RecordSet activeRecordSet;
        boolean containsGPSdata = false;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
            containsGPSdata = activeRecordSet.get(0).hasReasonableData() && activeRecordSet.get(1).hasReasonableData() && activeRecordSet.get(2).hasReasonableData();
        }
        return containsGPSdata;
    }

    public String exportFile(String fileEndingType, boolean isExportTmpDir) {
        RecordSet activeRecordSet;
        String exportFileName = "";
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && fileEndingType.contains("kmz")) {
            int additionalMeasurementOrdinal = this.getGPS2KMZMeasurementOrdinal();
            exportFileName = new FileHandler().exportFileKMZ(1, 0, 2, additionalMeasurementOrdinal, this.findRecordByUnit(activeRecordSet, "m/s"), this.findRecordByUnit(activeRecordSet, "km"), -1, true, isExportTmpDir);
        }
        return exportFileName;
    }

    private int findRecordByUnit(RecordSet recordSet, String unit) {
        if (recordSet != null) {
            for (int i = 0; i < recordSet.size(); ++i) {
                Record record = recordSet.get(i);
                if (!record.getUnit().equalsIgnoreCase(unit)) continue;
                return record.getOrdinal();
            }
        }
        return -1;
    }

    public Integer getGPS2KMZMeasurementOrdinal() {
        if (this.kmzMeasurementOrdinal == null && this.application.getActiveRecordSet() != null) {
            return this.findRecordByUnit(this.application.getActiveRecordSet(), "km/h");
        }
        return this.kmzMeasurementOrdinal;
    }

    public String translateGPS2IGC(RecordSet recordSet, int index, char fixValidity, int startAltitude, int offsetAltitude) {
        Record recordLatitude = recordSet.get(0);
        Record recordLongitude = recordSet.get(1);
        Record baroAlitude = recordSet.get(2);
        Record gpsAlitude = recordSet.get(2);
        return String.format("%02d%05d%s%03d%05d%s%c%05d%05d", recordLatitude.get(index) / 1000000, Double.valueOf((double)(recordLatitude.get(index) % 1000000) / 10.0 + 0.5).intValue(), recordLatitude.get(index) > 0 ? "N" : "S", recordLongitude.get(index) / 1000000, Double.valueOf((double)(recordLongitude.get(index) % 1000000) / 10.0 + 0.5).intValue(), recordLongitude.get(index) > 0 ? "E" : "W", Character.valueOf(fixValidity), Double.valueOf((double)baroAlitude.get(index).intValue() / 10000.0 + (double)startAltitude + (double)offsetAltitude).intValue(), Double.valueOf((double)gpsAlitude.get(index).intValue() / 1000.0 + (double)offsetAltitude).intValue());
    }

    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGT2708", (Object[])GDE.MOD1));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGT2708"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "importDeviceLogItem action performed! " + e);
                    FlightRecorder.this.open_closeCommPort();
                }
            });
        }
    }
}

