/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageRep;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Display;

public class ImageTransfer
extends ByteArrayTransfer {
    static ImageTransfer _instance = new ImageTransfer();
    static final String TIFF = OS.NSTIFFPboardType.getString();
    static final int TIFFID = ImageTransfer.registerType(TIFF);

    ImageTransfer() {
    }

    public static ImageTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        ImageData imgData = (ImageData)object;
        Image image = new Image((Device)Display.getCurrent(), imgData);
        NSImage handle = image.handle;
        transferData.data = handle.TIFFRepresentation();
        image.dispose();
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        NSData data2 = (NSData)transferData.data;
        if (data2.length() == 0L) {
            return null;
        }
        NSImage nsImage = (NSImage)new NSImage().alloc();
        nsImage.initWithData(data2);
        NSSize size = nsImage.size();
        NSImageRep rep = nsImage.bestRepresentationForDevice(null);
        if (size.width != (double)rep.pixelsWide() || size.height != (double)rep.pixelsHigh()) {
            size.width /= (double)rep.pixelsWide() / size.width;
            size.height /= (double)rep.pixelsHigh() / size.height;
            NSImage newImage = ((NSImage)new NSImage().alloc()).initWithSize(size);
            newImage.lockFocus();
            NSRect rect = new NSRect();
            rect.width = size.width;
            rect.height = size.height;
            nsImage.drawInRect(rect, new NSRect(), 1L, 1.0);
            newImage.unlockFocus();
            nsImage.release();
            nsImage = newImage;
        }
        Image image = Image.cocoa_new(Display.getCurrent(), 0, nsImage);
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{TIFFID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{TIFF};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

