/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontFactory;
import com.sun.javafx.font.Metrics;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontUtils;
import com.sun.javafx.scene.text.FontHelper;
import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.FontMetrics;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public class PrismFontLoader
extends FontLoader {
    private static PrismFontLoader theInstance = new PrismFontLoader();
    private boolean embeddedFontsLoaded = false;
    FontFactory installedFontFactory = null;

    public static PrismFontLoader getInstance() {
        return theInstance;
    }

    Properties loadEmbeddedFontDefinitions() {
        Properties properties2 = new Properties();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            return properties2;
        }
        URL uRL = classLoader.getResource("META-INF/fonts.mf");
        if (uRL == null) {
            return properties2;
        }
        try (InputStream inputStream2 = uRL.openStream();){
            properties2.load(inputStream2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return properties2;
    }

    private void loadEmbeddedFonts() {
        if (!this.embeddedFontsLoaded) {
            FontFactory fontFactory = this.getFontFactoryFromPipeline();
            if (!fontFactory.hasPermission()) {
                this.embeddedFontsLoaded = true;
                return;
            }
            Properties properties2 = this.loadEmbeddedFontDefinitions();
            Enumeration<Object> enumeration = properties2.keys();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = properties2.getProperty(string2);
                if (!string3.startsWith("/")) continue;
                string3 = string3.substring(1);
                try {
                    InputStream inputStream2 = classLoader.getResourceAsStream(string3);
                    try {
                        fontFactory.loadEmbeddedFont(string2, inputStream2, 0.0f, true, false);
                    }
                    finally {
                        if (inputStream2 == null) continue;
                        inputStream2.close();
                    }
                }
                catch (Exception exception) {}
            }
            this.embeddedFontsLoaded = true;
        }
    }

    private Font[] createFonts(PGFont[] pGFontArray) {
        if (pGFontArray == null || pGFontArray.length == 0) {
            return null;
        }
        Font[] fontArray = new Font[pGFontArray.length];
        for (int j = 0; j < pGFontArray.length; ++j) {
            fontArray[j] = this.createFont(pGFontArray[j]);
        }
        return fontArray;
    }

    @Override
    public Font[] loadFont(InputStream inputStream2, double d, boolean bl) {
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        PGFont[] pGFontArray = fontFactory.loadEmbeddedFont(null, inputStream2, (float)d, true, bl);
        return this.createFonts(pGFontArray);
    }

    @Override
    public Font[] loadFont(String string2, double d, boolean bl) {
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        PGFont[] pGFontArray = fontFactory.loadEmbeddedFont(null, string2, (float)d, true, bl);
        return this.createFonts(pGFontArray);
    }

    private Font createFont(PGFont pGFont) {
        return FontHelper.nativeFont(pGFont, pGFont.getName(), pGFont.getFamilyName(), pGFont.getStyleName(), pGFont.getSize());
    }

    @Override
    public List<String> getFamilies() {
        this.loadEmbeddedFonts();
        return Arrays.asList(this.getFontFactoryFromPipeline().getFontFamilyNames());
    }

    @Override
    public List<String> getFontNames() {
        this.loadEmbeddedFonts();
        return Arrays.asList(this.getFontFactoryFromPipeline().getFontFullNames());
    }

    @Override
    public List<String> getFontNames(String string2) {
        this.loadEmbeddedFonts();
        return Arrays.asList(this.getFontFactoryFromPipeline().getFontFullNames(string2));
    }

    @Override
    public Font font(String string2, FontWeight fontWeight, FontPosture fontPosture, float f) {
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        if (!this.embeddedFontsLoaded && !fontFactory.isPlatformFont(string2)) {
            this.loadEmbeddedFonts();
        }
        boolean bl = fontWeight != null && fontWeight.ordinal() >= FontWeight.BOLD.ordinal();
        boolean bl2 = fontPosture == FontPosture.ITALIC;
        PGFont pGFont = fontFactory.createFont(string2, bl, bl2, f);
        Font font = FontHelper.nativeFont(pGFont, pGFont.getName(), pGFont.getFamilyName(), pGFont.getStyleName(), f);
        return font;
    }

    @Override
    public void loadFont(Font font) {
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        String string2 = font.getName();
        if (!this.embeddedFontsLoaded && !fontFactory.isPlatformFont(string2)) {
            this.loadEmbeddedFonts();
        }
        PGFont pGFont = fontFactory.createFont(string2, (float)font.getSize());
        String string3 = pGFont.getName();
        String string4 = pGFont.getFamilyName();
        String string5 = pGFont.getStyleName();
        FontHelper.setNativeFont(font, pGFont, string3, string4, string5);
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        if (font != null) {
            PGFont pGFont = (PGFont)FontHelper.getNativeFont(font);
            Metrics metrics = PrismFontUtils.getFontMetrics(pGFont);
            float f = -metrics.getAscent();
            float f2 = -metrics.getAscent();
            float f3 = metrics.getXHeight();
            float f4 = metrics.getDescent();
            float f5 = metrics.getDescent();
            float f6 = metrics.getLineGap();
            return FontMetrics.createFontMetrics(f, f2, f3, f4, f5, f6, font);
        }
        return null;
    }

    @Override
    public float getCharWidth(char c, Font font) {
        PGFont pGFont = (PGFont)FontHelper.getNativeFont(font);
        return (float)PrismFontUtils.getCharWidth(pGFont, c);
    }

    @Override
    public float getSystemFontSize() {
        return PrismFontFactory.getSystemFontSize();
    }

    private FontFactory getFontFactoryFromPipeline() {
        if (this.installedFontFactory != null) {
            return this.installedFontFactory;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.prism.GraphicsPipeline");
            Method method = clazz.getMethod("getPipeline", null);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("getFontFactory", null);
            Object object2 = method2.invoke(object, new Object[0]);
            this.installedFontFactory = (FontFactory)object2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.installedFontFactory;
    }
}

