/*
 * Decompiled with CFR 0.152.
 */
package gde.device.ardupilot;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DataTypes;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementType;
import gde.device.PropertyType;
import gde.device.StatisticsType;
import gde.device.ardupilot.ArduPilot;
import gde.device.ardupilot.LogFMT;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.MissMatchDeviceException;
import gde.exception.NotSupportedFileFormatException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;

public class ArduPilotLogReader {
    static Logger log = Logger.getLogger(ArduPilotLogReader.class.getName());
    static final DataExplorer application = DataExplorer.getInstance();
    static final Channels channels = Channels.getInstance();
    static final String pattern = "[^0-9].";
    static int realUsedMeasurementCount;
    static IDevice device;

    public static HashMap<String, String> getHeader(char separator, String filePath) throws NotSupportedFileFormatException, IOException {
        String line = "*";
        BufferedReader reader = null;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("logfile", filePath.substring(filePath.lastIndexOf(GDE.FILE_SEPARATOR) + 1));
        File logFile = new File(filePath);
        header.put("sizekb", "" + (logFile.isFile() ? logFile.length() / 1000L : 0L));
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "ISO-8859-1"));
            int lineCount = 0;
            while ((line = reader.readLine()) != null) {
                ++lineCount;
                if (line.startsWith("Ardu")) {
                    header.put("vehicletype", line.split(" ")[0]);
                    header.put("firmwareversion", line.split(" ")[1]);
                    continue;
                }
                if (!line.startsWith("Free")) continue;
                header.put("freemem", line.split(" ")[2]);
            }
            header.put("sizelines", "" + lineCount);
            header.put("DeviceName : ", application.getActiveDevice().getName());
            log.log(Level.FINE, "DeviceName : " + (String)header.get("DeviceName : "));
            log.log(Level.FINE, "Channel/Configuration Name: " + (header.get("Channel/Configuration Name: ") != null ? (String)header.get("Channel/Configuration Name: ") : ""));
        }
        catch (FileNotFoundException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new FileNotFoundException(Messages.getString((String)"GDE_MSGW0011", (Object[])new Object[]{filePath}));
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw new IOException(Messages.getString((String)"GDE_MSGW0012", (Object[])new Object[]{filePath}));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return header;
    }

    public static LinkedHashMap<String, LogFMT> getSensorsMeasurements(String separator, String filePath) throws NotSupportedFileFormatException, IOException {
        String line = "*";
        LinkedHashMap<String, LogFMT> logFmts = new LinkedHashMap<String, LogFMT>();
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "ISO-8859-1"));
            block9: while ((line = reader.readLine()) != null) {
                if (!line.startsWith("FMT")) continue;
                String[] tmpFMT = line.split(", ");
                switch (ArduPilot.LogEntry.getLogEntry(tmpFMT[3])) {
                    case ACC: 
                    case ARSP: 
                    case BARO: 
                    case CURR: 
                    case CURR_CELL: 
                    case ESC: 
                    case GPA: 
                    case GYR: 
                    case IMT: 
                    case IMU: 
                    case ISBD: 
                    case ISBH: 
                    case MAG: 
                    case PID: 
                    case QUAT: 
                    case GPS: {
                        log.log(Level.INFO, String.format("%4s\t%12s\t%s", tmpFMT[3], tmpFMT[4], tmpFMT[5]));
                        logFmts.put(tmpFMT[3], new LogFMT(line, separator));
                        continue block9;
                    }
                }
            }
        }
        return logFmts;
    }

    public static RecordSet read(char separator, String filePath, String recordSetNameExtend) throws NotSupportedFileFormatException, MissMatchDeviceException, IOException, DataInconsitsentException, DataTypeException {
        RecordSet recordSet;
        block40: {
            String line = "*";
            recordSet = null;
            long inputFileSize = new File(filePath).length();
            int progressLineLength = Math.abs(application.getActiveDevice().getDataBlockSize(InputTypes.FILE_IO));
            BufferedReader reader = null;
            Channel activeChannel = null;
            realUsedMeasurementCount = 0;
            try {
                HashMap<String, String> fileHeader = ArduPilotLogReader.getHeader(separator, filePath);
                LinkedHashMap<String, LogFMT> logEntries = ArduPilotLogReader.getSensorsMeasurements("" + separator, filePath);
                activeChannel = (Channel)channels.get((Object)channels.getChannelNumber(fileHeader.get("Channel/Configuration Name: ")));
                Channel channel = activeChannel = activeChannel == null ? channels.getActiveChannel() : activeChannel;
                if (activeChannel == null) break block40;
                GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT0134") + filePath);
                GDE.getUiNotification().setProgress(0);
                if (!application.getActiveDevice().getName().equals(fileHeader.get("DeviceName : "))) {
                    MissMatchDeviceException e = new MissMatchDeviceException(Messages.getString((String)"GDE_MSGW0013", (Object[])new Object[]{fileHeader.get("DeviceName : ")}));
                    log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                    throw e;
                }
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "ISO-8859-1"));
                while ((line = reader.readLine()) != null && line.matches(pattern)) {
                }
                if (GDE.isWithUi()) {
                    channels.switchChannel(activeChannel.getNumber(), "");
                    application.getMenuToolBar().updateChannelSelector();
                    activeChannel = channels.getActiveChannel();
                }
                int existingNumberMeasurements = device.getDeviceConfiguration().getMeasurementNames(activeChannel.getNumber()).length;
                String recordSetName = activeChannel.size() + 1 + recordSetNameExtend;
                ArrayList<String> tmpRecordNames = new ArrayList<String>();
                ArrayList<String> tmpRecordSymbols = new ArrayList<String>();
                ArrayList<String> tmpRecordUnits = new ArrayList<String>();
                ArrayList<Double> tmpRecordFactors = new ArrayList<Double>();
                int measurementOrdinal = 0;
                block18: for (LogFMT logEntryFormat : logEntries.values()) {
                    switch (ArduPilot.LogEntry.getLogEntry(logEntryFormat.name)) {
                        case ACC: 
                        case ARSP: 
                        case BARO: 
                        case CURR: 
                        case CURR_CELL: 
                        case ESC: 
                        case GPA: 
                        case GYR: 
                        case IMT: 
                        case IMU: 
                        case ISBD: 
                        case ISBH: 
                        case MAG: 
                        case PID: 
                        case QUAT: 
                        case GPS: {
                            log.log(Level.FINE, logEntryFormat.name);
                            tmpRecordNames.addAll(logEntryFormat.getMeasurementNames());
                            List<String> symbols = logEntryFormat.getSymbols();
                            tmpRecordSymbols.addAll(symbols);
                            List<String> units = logEntryFormat.getUnits();
                            tmpRecordUnits.addAll(units);
                            List<Double> factors = logEntryFormat.getMults();
                            tmpRecordFactors.addAll(factors);
                            int index = 0;
                            for (String measurementName : logEntryFormat.getMeasurementNames()) {
                                ArduPilotLogReader.setupMeasurement(activeChannel.getNumber(), measurementOrdinal++, measurementName, symbols.get(index), units.get(index), true, factors.get(index), true);
                                ++index;
                            }
                            continue block18;
                        }
                    }
                }
                if (tmpRecordNames.size() != existingNumberMeasurements) {
                    for (int i = tmpRecordNames.size(); i < existingNumberMeasurements; ++i) {
                        device.removeMeasurementFromChannel(activeChannel.getNumber(), device.getMeasurement(activeChannel.getNumber(), tmpRecordNames.size()));
                    }
                }
                recordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)activeChannel.getNumber(), (String[])tmpRecordNames.toArray(new String[1]), (String[])tmpRecordSymbols.toArray(new String[1]), (String[])tmpRecordUnits.toArray(new String[1]), (double)device.getTimeStep_ms(), (boolean)true, (boolean)true, (boolean)true);
                recordSetName = recordSet.getName();
                for (int i = 0; i < recordSet.size(); ++i) {
                    Record record = recordSet.get(i);
                    log.log(Level.FINE, String.format("%s - %s", record.getName(), record.getUnit()));
                    if (record.getUnit().equals("m/s") && record.getName().toLowerCase().contains("gps_spd")) {
                        record.setDataType(Record.DataType.GPS_SPEED);
                        continue;
                    }
                    if (record.getUnit().equals("m/s") && record.getName().toLowerCase().contains("airspeed")) {
                        record.setDataType(Record.DataType.AIR_SPEED);
                        continue;
                    }
                    if (record.getUnit().equals("m") && record.getName().toLowerCase().contains("gps_alt")) {
                        record.setDataType(Record.DataType.GPS_ALTITUDE);
                        continue;
                    }
                    if (record.getUnit().contains("\u00b0") && record.getName().toLowerCase().contains("gps_lng")) {
                        record.setDataType(Record.DataType.GPS_LONGITUDE);
                        continue;
                    }
                    if (!record.getUnit().contains("\u00b0") || !record.getName().toLowerCase().contains("gps_lat")) continue;
                    record.setDataType(Record.DataType.GPS_LATITUDE);
                }
                boolean isFileBasedTimeStamp = true;
                long startTimeStamp = (long)((double)new File(filePath).lastModified() - recordSet.getMaxTime_ms());
                recordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp));
                recordSet.setStartTimeStamp(startTimeStamp);
                activeChannel.setFileDescription(new SimpleDateFormat("yyyy-MM-dd").format(startTimeStamp).substring(0, 10) + activeChannel.getFileDescription().substring(10));
                long lastTimeStamp = 0L;
                Object[] updateRecordNames = recordSet.getRecordNames();
                int[] points = new int[updateRecordNames.length];
                if (points.length != recordSet.realSize()) {
                    throw new DataInconsitsentException(String.format("mismatch recordSet size to detected point size\n%s \n%s", StringHelper.arrayToString((Object[])recordSet.getRecordNames()), StringHelper.arrayToString((Object[])updateRecordNames)));
                }
                boolean isNewTimeStamp = false;
                int lineNumber = 0;
                block22: while ((line = reader.readLine()) != null) {
                    int progress;
                    ++lineNumber;
                    switch (ArduPilot.LogEntry.getLogEntry(line.split(", ")[0])) {
                        case ACC: 
                        case ARSP: 
                        case BARO: 
                        case CURR: 
                        case CURR_CELL: 
                        case ESC: 
                        case GPA: 
                        case GYR: 
                        case IMT: 
                        case IMU: 
                        case ISBD: 
                        case ISBH: 
                        case MAG: 
                        case PID: 
                        case QUAT: 
                        case GPS: {
                            log.log(Level.FINE, line);
                            String sensor = line.split(", ")[0];
                            LogFMT logEntry = logEntries.get(sensor);
                            int index = 0;
                            for (String name : logEntry.getMeasurementNames()) {
                                int entryOrdinal = recordSet.get((Object)name).getOrdinal();
                                if (name.toLowerCase().contains("time")) {
                                    long tmpTimeStamp = Long.parseLong(line.split(", ")[1 + index]) * 1000L;
                                    if (isFileBasedTimeStamp && lastTimeStamp == 0L) {
                                        startTimeStamp = lastTimeStamp = tmpTimeStamp;
                                        recordSet.setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp));
                                        recordSet.setStartTimeStamp(startTimeStamp);
                                        activeChannel.setFileDescription(new SimpleDateFormat("yyyy-MM-dd").format(startTimeStamp).substring(0, 10) + activeChannel.getFileDescription().substring(10));
                                        isNewTimeStamp = true;
                                    } else if (lastTimeStamp < tmpTimeStamp) {
                                        lastTimeStamp = tmpTimeStamp;
                                        isNewTimeStamp = true;
                                    }
                                    log.log(Level.FINE, new SimpleDateFormat("mm:ss.SSS").format((lastTimeStamp - startTimeStamp) / 1000L));
                                    points[entryOrdinal] = 0;
                                } else {
                                    try {
                                        points[entryOrdinal] = Integer.parseInt("" + ArduPilot.parseValue(logEntry.getFmt(index), line.split(", ")[1 + index]));
                                    }
                                    catch (NumberFormatException e) {
                                        log.log(Level.WARNING, String.format("%s line %d -> NumberFormatException for %s", filePath, lineNumber, e.getMessage()));
                                    }
                                }
                                ++index;
                            }
                            if (!isNewTimeStamp) break;
                            recordSet.addPoints(points, (double)(lastTimeStamp - startTimeStamp) / 1000.0);
                            isNewTimeStamp = false;
                            break;
                        }
                        default: {
                            continue block22;
                        }
                    }
                    if ((progress = (int)((long)(lineNumber * 100) / (inputFileSize / (long)(progressLineLength = progressLineLength > line.length() ? progressLineLength : line.length())))) > 90 || progress <= GDE.getUiNotification().getProgressPercentage() || progress % 10 != 0) continue;
                    GDE.getUiNotification().setProgress(progress);
                    try {
                        Thread.sleep(2L);
                    }
                    catch (Exception exception) {}
                }
                recordSet.setSaved(true);
                activeChannel.put((Object)recordSetName, (Object)recordSet);
                activeChannel.setActiveRecordSet(recordSetName);
                activeChannel.applyTemplate(recordSetName, true);
                recordSet.updateVisibleAndDisplayableRecordsForTable();
                device.updateVisibilityStatus(recordSet, true);
                if (GDE.isWithUi()) {
                    activeChannel.switchRecordSet(recordSetName);
                }
                reader.close();
                reader = null;
            }
            catch (UnsupportedEncodingException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw new UnsupportedEncodingException(Messages.getString((String)"GDE_MSGW0010"));
            }
            catch (FileNotFoundException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw new FileNotFoundException(Messages.getString((String)"GDE_MSGW0011", (Object[])new Object[]{filePath}));
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw new IOException(Messages.getString((String)"GDE_MSGW0012", (Object[])new Object[]{filePath}));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                GDE.getUiNotification().setProgress(100);
                GDE.getUiNotification().setStatusMessage("");
                if (GDE.isWithUi()) {
                    application.getMenuToolBar().updateChannelSelector();
                    application.getMenuToolBar().updateRecordSetSelectCombo();
                }
            }
        }
        return recordSet;
    }

    public static void setupMeasurement(Record.DataType dataType, int channelConfig, int measurementOrdinal, String name, String symbol, String unit, boolean isActive, double factor, boolean isClearStatistics) {
        ++realUsedMeasurementCount;
        MeasurementType gdeMeasurement = device.getMeasurement(channelConfig, measurementOrdinal);
        if (!name.equals(gdeMeasurement.getName())) {
            gdeMeasurement.setName(name);
            gdeMeasurement.setStatistics(null);
        }
        gdeMeasurement.removeProperties();
        gdeMeasurement.setSymbol(symbol);
        gdeMeasurement.setUnit(unit);
        gdeMeasurement.setActive(Boolean.valueOf(isActive));
        gdeMeasurement.setFactor(factor);
        switch (dataType) {
            case GPS_LATITUDE: {
                PropertyType tmpPropertyType = new PropertyType();
                tmpPropertyType.setName(Record.DataType.GPS_LATITUDE.value());
                tmpPropertyType.setType(DataTypes.STRING);
                tmpPropertyType.setValue((Object)Record.DataType.GPS_LATITUDE.value());
                gdeMeasurement.getProperty().add(tmpPropertyType);
                break;
            }
            case GPS_LONGITUDE: {
                PropertyType tmpPropertyType = new PropertyType();
                tmpPropertyType.setName(Record.DataType.GPS_LONGITUDE.value());
                tmpPropertyType.setType(DataTypes.STRING);
                tmpPropertyType.setValue((Object)Record.DataType.GPS_LONGITUDE.value());
                gdeMeasurement.getProperty().add(tmpPropertyType);
                break;
            }
            case GPS_ALTITUDE: {
                PropertyType tmpPropertyType = new PropertyType();
                tmpPropertyType.setName(Record.DataType.GPS_ALTITUDE.value());
                tmpPropertyType.setType(DataTypes.STRING);
                tmpPropertyType.setValue((Object)Record.DataType.GPS_ALTITUDE.value());
                gdeMeasurement.getProperty().add(tmpPropertyType);
                break;
            }
            case GPS_AZIMUTH: {
                PropertyType tmpPropertyType = new PropertyType();
                tmpPropertyType.setName(Record.DataType.GPS_AZIMUTH.value());
                tmpPropertyType.setType(DataTypes.STRING);
                tmpPropertyType.setValue((Object)Record.DataType.GPS_AZIMUTH.value());
                gdeMeasurement.getProperty().add(tmpPropertyType);
                break;
            }
            case GPS_SPEED: {
                PropertyType tmpPropertyType = new PropertyType();
                tmpPropertyType.setName(Record.DataType.GPS_SPEED.value());
                tmpPropertyType.setType(DataTypes.STRING);
                tmpPropertyType.setValue((Object)Record.DataType.GPS_SPEED.value());
                gdeMeasurement.getProperty().add(tmpPropertyType);
                break;
            }
        }
        if (isClearStatistics) {
            gdeMeasurement.setStatistics(null);
        } else {
            StatisticsType newStatisticsType = gdeMeasurement.getStatistics();
            if (newStatisticsType == null) {
                newStatisticsType = new StatisticsType();
            }
            newStatisticsType.setMin(true);
            newStatisticsType.setMax(true);
            newStatisticsType.setAvg(true);
            newStatisticsType.setSigma(true);
            gdeMeasurement.setStatistics(newStatisticsType);
        }
    }

    private static void setupMeasurement(int channelConfig, int measurementOrdinal, String name, String symbol, String unit, boolean isActive, double factor, boolean isClearStatistics) {
        ++realUsedMeasurementCount;
        MeasurementType gdeMeasurement = device.getMeasurement(channelConfig, measurementOrdinal);
        if (!name.equals(gdeMeasurement.getName())) {
            gdeMeasurement.setName(name.length() == 0 ? "???_" + measurementOrdinal : name);
            gdeMeasurement.setStatistics(null);
        }
        gdeMeasurement.removeProperties();
        gdeMeasurement.setSymbol(symbol);
        gdeMeasurement.setUnit(unit);
        gdeMeasurement.setActive(Boolean.valueOf(true));
        if (factor != 0.0 && factor != 1.0) {
            gdeMeasurement.setFactor(factor);
        }
        if (isClearStatistics) {
            gdeMeasurement.setStatistics(null);
        } else {
            StatisticsType newStatisticsType = gdeMeasurement.getStatistics();
            if (newStatisticsType == null) {
                newStatisticsType = new StatisticsType();
            }
            newStatisticsType.setMin(true);
            newStatisticsType.setMax(true);
            newStatisticsType.setAvg(true);
            newStatisticsType.setSigma(true);
            gdeMeasurement.setStatistics(newStatisticsType);
        }
    }

    static {
        device = application.getActiveDevice();
    }
}

