/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.graupner.Polaron;
import gde.device.graupner.PolaronEx1400;
import gde.device.graupner.PolaronSerialPort;
import gde.device.graupner.PolaronSports;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.util.logging.Logger;

public class PolaronGathererThread
extends Thread {
    static final String $CLASS_NAME = PolaronGathererThread.class.getName();
    static final Logger log = Logger.getLogger(PolaronGathererThread.class.getName());
    static final int TIME_STEP_DEFAULT = 1000;
    static final int WAIT_TIME_RETRYS = 3600;
    final DataExplorer application;
    final PolaronSerialPort serialPort;
    final Polaron device;
    final Channels channels;
    String recordSetKey1 = Messages.getString((String)"GDE_MSGT0272");
    String recordSetKey2 = Messages.getString((String)"GDE_MSGT0272");
    String recordSetKey3 = Messages.getString((String)"GDE_MSGT0272");
    int retryCounter = 3600;
    boolean isCollectDataStopped = false;
    boolean isProgrammExecuting1 = false;
    boolean isProgrammExecuting2 = false;
    boolean isProgrammExecuting3 = false;
    boolean[] isAlerted4Finish = new boolean[]{false, false, false, false};
    boolean isLinkedMode = false;
    boolean isContinuousRecordSet = Settings.getInstance().isContinuousRecordSet();
    int lastNumberDisplayableRecords = 0;

    public PolaronGathererThread() throws ApplicationConfigurationException, SerialPortException {
        super("dataGatherer");
        this.application = DataExplorer.getInstance();
        this.device = (Polaron)this.application.getActiveDevice();
        this.serialPort = this.device.getCommunicationPort();
        this.channels = Channels.getInstance();
        this.setPriority(10);
    }

    @Override
    public void run() {
        String $METHOD_NAME = "run";
        RecordSet recordSet1 = null;
        RecordSet recordSet2 = null;
        RecordSet recordSet3 = null;
        int[] points1 = new int[this.device.getNumberOfMeasurements(1)];
        int[] points2 = new int[this.device.getNumberOfMeasurements(2)];
        int[] points3 = new int[this.device.getNumberOfMeasurements(3)];
        byte[] dataBuffer = null;
        this.isProgrammExecuting1 = false;
        this.isProgrammExecuting2 = false;
        this.isProgrammExecuting3 = false;
        this.isCollectDataStopped = false;
        log.logp(Level.FINE, $CLASS_NAME, "run", "====> entry initial time step ms = " + this.device.getTimeStep_ms());
        long atualTime_ms = 0L;
        while (!this.isCollectDataStopped) {
            atualTime_ms = System.currentTimeMillis();
            try {
                switch (this.device.getDeviceTypeIdentifier()) {
                    case PolaronSports: {
                        dataBuffer = this.serialPort.getData(true);
                        break;
                    }
                    default: {
                        dataBuffer = this.serialPort.getData();
                    }
                }
                switch (this.device.getDeviceTypeIdentifier()) {
                    default: {
                        this.isProgrammExecuting3 = this.device.isLinkedMode(dataBuffer);
                        if (this.isProgrammExecuting3 || this.isLinkedMode) break;
                        this.isProgrammExecuting1 = this.device.isProcessing(1, dataBuffer);
                        this.isProgrammExecuting2 = this.device.isProcessing(2, dataBuffer);
                        break;
                    }
                    case PolaronEx1400: {
                        this.isProgrammExecuting3 = this.device.isLinkedMode(dataBuffer);
                        if (this.isProgrammExecuting3 || this.isLinkedMode) break;
                        this.isProgrammExecuting1 = ((PolaronEx1400)this.device).isProcessing(1, dataBuffer);
                        this.isProgrammExecuting2 = ((PolaronEx1400)this.device).isProcessing(2, dataBuffer);
                        break;
                    }
                    case PolaronSports: {
                        this.isProgrammExecuting1 = ((PolaronSports)this.device).isProcessing(1, dataBuffer);
                        this.isProgrammExecuting2 = ((PolaronSports)this.device).isProcessing(2, dataBuffer);
                        this.isProgrammExecuting3 = false;
                    }
                }
                if (this.isProgrammExecuting1 || this.isProgrammExecuting2 || this.isProgrammExecuting3) {
                    switch (this.device.getDeviceTypeIdentifier()) {
                        case PolaronSports: 
                        case PolaronEx1400: 
                        case PolaronEx: 
                        case PolaronACDC: 
                        case PolaronPro: {
                            if (this.isProgrammExecuting3) {
                                this.isLinkedMode = true;
                                Object[] ch3 = this.processDataChannel(3, recordSet3, this.recordSetKey3, dataBuffer, points3);
                                recordSet3 = (RecordSet)ch3[0];
                                this.recordSetKey3 = (String)ch3[1];
                                break;
                            }
                            if (this.isProgrammExecuting1) {
                                Object[] ch1 = this.processDataChannel(1, recordSet1, this.recordSetKey1, dataBuffer, points1);
                                recordSet1 = (RecordSet)ch1[0];
                                this.recordSetKey1 = (String)ch1[1];
                            }
                            if (!this.isProgrammExecuting2) break;
                            byte[] buffer = new byte[Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO)) / 2 + 11];
                            switch (this.device.getDeviceTypeIdentifier()) {
                                case PolaronSports: {
                                    System.arraycopy(dataBuffer, 0, buffer, 0, 9);
                                    System.arraycopy(dataBuffer, 77, buffer, 9, dataBuffer.length - 77);
                                    if (!log.isLoggable(Level.FINE)) break;
                                    log.logp(Level.FINE, $CLASS_NAME, "run", StringHelper.byte2Hex2CharString((byte[])buffer, (int)buffer.length));
                                    break;
                                }
                                case PolaronEx: {
                                    System.arraycopy(dataBuffer, 0, buffer, 0, 11);
                                    System.arraycopy(dataBuffer, 125, buffer, 11, buffer.length - 11);
                                    if (!log.isLoggable(Level.FINE)) break;
                                    log.logp(Level.FINE, $CLASS_NAME, "run", StringHelper.byte2Hex2CharString((byte[])buffer, (int)buffer.length));
                                    break;
                                }
                                case PolaronEx1400: 
                                case PolaronACDC: {
                                    System.arraycopy(dataBuffer, 0, buffer, 0, 11);
                                    System.arraycopy(dataBuffer, 129, buffer, 11, 130);
                                    if (!log.isLoggable(Level.FINE)) break;
                                    log.logp(Level.FINE, $CLASS_NAME, "run", StringHelper.byte2Hex2CharString((byte[])buffer, (int)buffer.length));
                                    break;
                                }
                                default: {
                                    System.arraycopy(dataBuffer, buffer.length - 9 - 30, buffer, 0, buffer.length);
                                    System.arraycopy(dataBuffer, 0, buffer, 0, 11);
                                }
                            }
                            Object[] ch2 = this.processDataChannel(2, recordSet2, this.recordSetKey2, buffer, points2);
                            recordSet2 = (RecordSet)ch2[0];
                            this.recordSetKey2 = (String)ch2[1];
                            break;
                        }
                    }
                    if (!this.isProgrammExecuting1 && recordSet1 != null && recordSet1.getRecordDataSize(true) > 5) {
                        this.finalizeRecordSet(recordSet1.getName());
                        this.isProgrammExecuting1 = false;
                        recordSet1 = null;
                    }
                    if (!this.isProgrammExecuting2 && recordSet2 != null && recordSet2.getRecordDataSize(true) > 5) {
                        this.finalizeRecordSet(recordSet2.getName());
                        this.isProgrammExecuting2 = false;
                        recordSet2 = null;
                    }
                    if (!this.isProgrammExecuting3 && recordSet3 != null && recordSet3.getRecordDataSize(true) > 5) {
                        this.finalizeRecordSet(recordSet3.getName());
                        this.isProgrammExecuting3 = false;
                        recordSet3 = null;
                    }
                } else {
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI3100"));
                    log.logp(Level.FINER, $CLASS_NAME, "run", "wait for device activation");
                    if (0 == this.setRetryCounter(this.getRetryCounter() - 1)) {
                        log.log(Level.FINE, "device activation timeout");
                        this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGI3103"));
                        this.stopDataGatheringThread(false, null);
                    }
                    int processNumber = this.device.getProcessingMode(dataBuffer);
                    if (recordSet1 != null && recordSet1.getRecordDataSize(true) > 5) {
                        this.finalizeRecordSet(recordSet1.getName());
                        this.isProgrammExecuting1 = false;
                        recordSet1 = null;
                        if (processNumber == 4) {
                            this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGI3104", (Object[])new Object[]{1}));
                        }
                    }
                    if (recordSet2 != null && recordSet2.getRecordDataSize(true) > 5) {
                        this.finalizeRecordSet(recordSet2.getName());
                        this.isProgrammExecuting2 = false;
                        recordSet2 = null;
                        if (processNumber == 4) {
                            this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGI3104", (Object[])new Object[]{2}));
                        }
                    }
                    if (recordSet3 != null && recordSet3.getRecordDataSize(true) > 5) {
                        this.finalizeRecordSet(recordSet3.getName());
                        this.isProgrammExecuting3 = false;
                        recordSet3 = null;
                        if (processNumber == 4) {
                            this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGI3104", (Object[])new Object[]{3}));
                        }
                    }
                }
            }
            catch (DataInconsitsentException e) {
                String message = Messages.getString((String)"GDE_MSGE0036", (Object[])new Object[]{this.getClass().getSimpleName(), "run"});
                if (recordSet1 != null) {
                    this.cleanup(recordSet1.getName(), message);
                }
                if (recordSet2 != null) {
                    this.cleanup(recordSet2.getName(), message);
                }
                if (recordSet3 != null) {
                    this.cleanup(recordSet3.getName(), message);
                }
                this.stopDataGatheringThread(false, e);
            }
            catch (Throwable e) {
                if (e instanceof TimeOutException) {
                    if (recordSet1 != null) {
                        this.finalizeRecordSet(recordSet1.getName());
                        WaitTimer.delay((long)1000L);
                    }
                    if (recordSet2 != null) {
                        this.finalizeRecordSet(recordSet2.getName());
                        WaitTimer.delay((long)1000L);
                    }
                    if (recordSet3 != null) {
                        this.finalizeRecordSet(recordSet3.getName());
                        WaitTimer.delay((long)1000L);
                    }
                }
                if (e instanceof TimeOutException && !this.isProgrammExecuting1 && !this.isProgrammExecuting2) {
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI3100"));
                    log.logp(Level.FINE, $CLASS_NAME, "run", "wait for device activation ...");
                    if (0 == this.setRetryCounter(this.getRetryCounter() - 1)) {
                        log.log(Level.FINE, "device activation timeout");
                        this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGI3100"));
                        this.stopDataGatheringThread(false, null);
                    }
                    WaitTimer.delay((long)(atualTime_ms + 1000L - System.currentTimeMillis()));
                }
                log.log(Level.FINE, "program end detected");
                this.stopDataGatheringThread(true, e);
            }
            WaitTimer.delay((long)(atualTime_ms + 1000L - System.currentTimeMillis()));
        }
        this.application.setStatusMessage("");
        log.logp(Level.FINE, $CLASS_NAME, "run", "======> exit");
    }

    private Object[] processDataChannel(int number, RecordSet recordSet, String recordSetKey, byte[] dataBuffer, int[] points) throws DataInconsitsentException {
        Channel channel;
        String processName;
        String $METHOD_NAME = "processOutlet";
        Object[] result = new Object[2];
        if (PolaronSerialPort.log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, PolaronSerialPort.$CLASS_NAME, "processOutlet", number + " - " + StringHelper.byte2Hex2CharString((byte[])dataBuffer, (int)dataBuffer.length));
        }
        int processNumber = this.device.getProcessingMode(dataBuffer);
        String string = processName = this.isContinuousRecordSet ? Messages.getString((String)"GDE_MSGT3126") : this.device.PROCESSING_MODE[processNumber];
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "processName = " + processName + " " + processNumber);
        }
        if ((channel = (Channel)this.channels.get((Object)number)) != null) {
            if (recordSet == null || !recordSetKey.contains(processName)) {
                this.application.setStatusMessage("");
                this.setRetryCounter(3600);
                StringBuilder extend = new StringBuilder();
                if (processNumber < 5) {
                    String processingType = this.device.getProcessingType(dataBuffer);
                    int cycleNumber = this.device.getCycleNumber(number, dataBuffer);
                    if (processingType.length() > 3 || cycleNumber > 0) {
                        extend.append(" [");
                    }
                    if (processingType.length() > 3) {
                        extend.append(processingType);
                    }
                    if (cycleNumber > 0) {
                        if (processingType.equals(Messages.getString((String)"GDE_MSGT3125"))) {
                            extend.append(":").append(cycleNumber);
                        } else {
                            if (processingType.length() > 0) {
                                extend.append(" - ");
                            }
                            extend.append(Messages.getString((String)"GDE_MSGT3125")).append(":").append(cycleNumber);
                        }
                    }
                    if (processingType.length() > 3 || cycleNumber > 0) {
                        extend.append("]");
                    }
                }
                recordSetKey = channel.getNextRecordSetNumber() + ") " + (this.isContinuousRecordSet ? processName : processName + extend.toString());
                recordSetKey = recordSetKey.length() <= 40 ? recordSetKey : recordSetKey.substring(0, 40);
                channel.put((Object)recordSetKey, (Object)RecordSet.createRecordSet((String)recordSetKey, (IDevice)this.application.getActiveDevice(), (int)channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                channel.applyTemplateBasics(recordSetKey);
                log.logp(Level.FINE, $CLASS_NAME, "processOutlet", recordSetKey + " created for channel " + channel.getName());
                recordSet = (RecordSet)channel.get((Object)recordSetKey);
                this.device.setTemperatureUnit(number, recordSet, dataBuffer);
                recordSet.setAllDisplayable();
                this.channels.switchChannel(channel.getNumber(), recordSetKey);
                channel.switchRecordSet(recordSetKey);
                String description = recordSet.getRecordSetDescription() + GDE.LINE_SEPARATOR + "Firmware  : " + this.device.getFirmwareVersion(dataBuffer) + (this.device.getBatteryMemoryNumber(number, dataBuffer) >= 1 ? "; Memory #" + this.device.getBatteryMemoryNumber(number, dataBuffer) : "");
                recordSet.setRecordSetDescription(description);
                if (processNumber == 4 && !this.isAlerted4Finish[number]) {
                    this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGI3104", (Object[])new Object[]{number}));
                    this.isAlerted4Finish[number] = true;
                } else {
                    this.isAlerted4Finish[number] = false;
                }
            }
            if (this.isContinuousRecordSet && processNumber == 3) {
                result[0] = recordSet;
                result[1] = recordSetKey;
                return result;
            }
            recordSet.addPoints(this.device.convertDataBytes(points, dataBuffer));
            RecordSet activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet();
            if (activeRecordSet != null && recordSet.size() > 0 && recordSet.isChildOfActiveChannel() && recordSet.equals((Object)activeRecordSet)) {
                this.application.updateAllTabs(false, this.lastNumberDisplayableRecords != activeRecordSet.getConfiguredDisplayable());
                this.lastNumberDisplayableRecords = activeRecordSet.getConfiguredDisplayable();
            }
            if (recordSet.get(0).realSize() < 3 || recordSet.get(0).realSize() % 10 == 0) {
                this.device.updateVisibilityStatus(recordSet, true);
            }
        }
        result[0] = recordSet;
        result[1] = recordSetKey;
        return result;
    }

    void stopDataGatheringThread(boolean enableEndMessage, Throwable throwable) {
        String $METHOD_NAME = "stopDataGatheringThread";
        if (throwable != null) {
            log.logp(Level.WARNING, $CLASS_NAME, "stopDataGatheringThread", throwable.getMessage(), throwable);
        }
        this.isCollectDataStopped = true;
        if (this.serialPort != null) {
            if (this.serialPort.getXferErrors() > 0) {
                log.log(Level.WARNING, "During complete data transfer " + this.serialPort.getXferErrors() + " number of errors occured!");
            }
            this.serialPort.close();
        }
    }

    void finalizeRecordSet(String recordSetKey) {
        RecordSet tmpRecordSet = this.channels.getActiveChannel().getActiveRecordSet();
        if (tmpRecordSet != null) {
            this.device.updateVisibilityStatus(tmpRecordSet, true);
            this.device.makeInActiveDisplayable(tmpRecordSet);
            this.application.updateStatisticsData();
            this.application.updateDataTable(recordSetKey, false);
            log.log(Level.TIME, "set average time step msec = " + this.device.getAverageTimeStep_ms());
        }
    }

    void cleanup(String recordSetKey, final String message) {
        RecordSet activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet();
        if (activeRecordSet != null) {
            activeRecordSet.clear();
            this.channels.getActiveChannel().remove(recordSetKey);
            if (Thread.currentThread().getId() == this.application.getThreadId()) {
                this.application.getMenuToolBar().updateRecordSetSelectCombo();
                this.application.updateStatisticsData();
                this.application.updateDataTable(recordSetKey, true);
                this.application.openMessageDialog(message);
            } else {
                final String useRecordSetKey = recordSetKey;
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PolaronGathererThread.this.application.getMenuToolBar().updateRecordSetSelectCombo();
                        PolaronGathererThread.this.application.updateStatisticsData();
                        PolaronGathererThread.this.application.updateDataTable(useRecordSetKey, true);
                        PolaronGathererThread.this.application.openMessageDialog(message);
                    }
                });
            }
        } else {
            this.application.openMessageDialog(message);
        }
    }

    void setCollectDataStopped(boolean enabled) {
        this.isCollectDataStopped = enabled;
    }

    boolean isCollectDataStopped() {
        return this.isCollectDataStopped;
    }

    int getRetryCounter() {
        return this.retryCounter;
    }

    int setRetryCounter(int newRetryCounter) {
        this.retryCounter = newRetryCounter;
        return this.retryCounter;
    }
}

