/*
 * Decompiled with CFR 0.152.
 */
package gde.ui;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DataTypes;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MeasurementControlConfigurable
extends Composite {
    static final Logger log = Logger.getLogger(MeasurementControlConfigurable.class.getName());
    Composite measurementComposite;
    Button measurement;
    Text measurementName;
    Text measurementUnit;
    Text measurementSymbol;
    Button measurementSynch;
    Button inputFileButton;
    Composite buttonComposite;
    final IDevice device;
    final DataExplorer application;
    final Channels channels;
    final DeviceDialog dialog;
    final MeasurementType measurementType;
    final int ordinal;
    final int channelConfigNumber;
    final String address;
    final String filterExtend;

    public MeasurementControlConfigurable(Composite parentComposite, DeviceDialog parentDialog, int useChannelConfigNumber, int useOrdinal, MeasurementType useMeasurementType, IDevice useDevice, int horizontalSpan, String useAddress, String useFilterExtend) {
        super(parentComposite, 0);
        this.dialog = parentDialog;
        this.channelConfigNumber = useChannelConfigNumber;
        this.ordinal = useOrdinal;
        this.measurementType = useMeasurementType;
        this.device = useDevice;
        this.address = useAddress;
        this.filterExtend = useFilterExtend;
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        RowLayout thisLayout = new RowLayout(256);
        GridData thisLData = new GridData();
        thisLData.horizontalSpan = horizontalSpan;
        thisLData.horizontalAlignment = 1;
        thisLData.verticalAlignment = 1;
        thisLData.heightHint = 23;
        this.setLayoutData(thisLData);
        this.setLayout((Layout)thisLayout);
        this.measurement = new Button((Composite)this, 131104);
        RowData measurementLData = new RowData();
        measurementLData.width = 50;
        measurementLData.height = 20;
        this.measurement.setLayoutData((Object)measurementLData);
        this.measurement.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.measurement.setText(String.format(" %2s", this.address));
        this.measurement.setToolTipText(Messages.getString("GDE_MSGT0299"));
        this.measurement.setSelection(this.measurementType.isActive());
        this.measurement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RecordSet activeRecordSet;
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "measurement.widgetSelected, event=" + evt);
                }
                boolean isVisible = MeasurementControlConfigurable.this.measurement.getSelection();
                MeasurementControlConfigurable.this.device.setMeasurementActive(MeasurementControlConfigurable.this.channelConfigNumber, MeasurementControlConfigurable.this.ordinal, isVisible);
                Channel activeChannel = MeasurementControlConfigurable.this.channels.getActiveChannel();
                if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
                    activeRecordSet.get(MeasurementControlConfigurable.this.ordinal).setVisible(isVisible);
                    activeRecordSet.get(MeasurementControlConfigurable.this.ordinal).setDisplayable(isVisible);
                    MeasurementControlConfigurable.this.device.updateVisibilityStatus(activeRecordSet, false);
                    MeasurementControlConfigurable.this.application.updateGraphicsWindow();
                }
                MeasurementControlConfigurable.this.dialog.enableSaveButton(true);
            }
        });
        this.measurementName = new Text((Composite)this, 0x1000800);
        RowData measurementNameLData = new RowData();
        measurementNameLData.width = 120;
        measurementNameLData.height = GDE.IS_MAC ? 15 : 12;
        this.measurementName.setLayoutData((Object)measurementNameLData);
        this.measurementName.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.measurementName.setText(this.measurementType.getName().endsWith(this.filterExtend) ? this.measurementType.getName().substring(0, this.measurementType.getName().length() - this.filterExtend.length()) : this.measurementType.getName());
        this.measurementName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                MeasurementControlConfigurable.this.updateName(MeasurementControlConfigurable.this.measurementName.getText());
                MeasurementControlConfigurable.this.dialog.enableSaveButton(true);
            }
        });
        this.measurementSymbol = new Text((Composite)this, 0x1000800);
        RowData measurementSymbolLabelLData = new RowData();
        measurementSymbolLabelLData.width = 35;
        measurementSymbolLabelLData.height = GDE.IS_MAC ? 16 : 12;
        this.measurementSymbol.setLayoutData((Object)measurementSymbolLabelLData);
        this.measurementSymbol.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE - 1, 0));
        this.measurementSymbol.setText(this.measurementType.getSymbol());
        this.measurementSymbol.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                MeasurementControlConfigurable.this.updateSymbol(MeasurementControlConfigurable.this.measurementSymbol.getText());
                MeasurementControlConfigurable.this.dialog.enableSaveButton(true);
            }
        });
        this.measurementUnit = new Text((Composite)this, 0x1000800);
        RowData measurementUnitLabelLData = new RowData();
        measurementUnitLabelLData.width = 35;
        measurementUnitLabelLData.height = GDE.IS_MAC ? 16 : 12;
        this.measurementUnit.setLayoutData((Object)measurementUnitLabelLData);
        this.measurementUnit.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE - 1, 0));
        this.measurementUnit.setText(this.measurementType.getUnit());
        this.measurementUnit.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                MeasurementControlConfigurable.this.updateUnit(MeasurementControlConfigurable.this.measurementUnit.getText());
                MeasurementControlConfigurable.this.dialog.enableSaveButton(true);
            }
        });
        Composite spacer = new Composite((Composite)this, 0);
        RowData measurementLData2 = new RowData();
        measurementLData2.width = 3;
        measurementLData2.height = 20;
        spacer.setLayoutData((Object)measurementLData2);
        this.measurementSynch = new Button((Composite)this, 32);
        measurementLData = new RowData();
        measurementLData.width = 50;
        measurementLData.height = 20;
        this.measurementSynch.setLayoutData((Object)measurementLData);
        this.measurementSynch.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.measurementSynch.setText(String.format(" %2s", this.measurementType.getProperty(MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value()) != null ? this.measurementType.getProperty(MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value()).getValue() : ""));
        this.measurementSynch.setToolTipText(Messages.getString("GDE_MSGT0298"));
        this.measurementSynch.setSelection(this.measurementType.getProperty(MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value()) != null);
        this.measurementSynch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "measurementSynch.widgetSelected, event=" + evt);
                }
                MeasurementControlConfigurable.this.measurementSynch.setSelection(MeasurementControlConfigurable.this.synchronizeRecord(MeasurementControlConfigurable.this.measurementSynch.getSelection()));
                MeasurementControlConfigurable.this.dialog.enableSaveButton(MeasurementControlConfigurable.this.measurementSynch.getSelection());
            }
        });
    }

    void updateName(String newName) {
        for (int i = this.filterExtend.length(); i > 0; --i) {
            if (!newName.endsWith(this.filterExtend.substring(0, i))) continue;
            newName = newName.substring(0, newName.length() - this.filterExtend.length());
            break;
        }
        this.measurementType.setName(newName + this.filterExtend);
        RecordSet activeRecordSet = this.application.getActiveRecordSet();
        if (activeRecordSet != null) {
            activeRecordSet.get(this.ordinal).setName(newName + this.filterExtend);
        }
        this.device.setMeasurementName(this.channelConfigNumber, this.ordinal, newName + this.filterExtend);
    }

    void updateSymbol(String newSymbol) {
        for (int i = this.filterExtend.length(); i > 0; --i) {
            if (!newSymbol.endsWith(this.filterExtend.substring(0, i))) continue;
            newSymbol = newSymbol.substring(0, newSymbol.length() - this.filterExtend.length());
            break;
        }
        this.measurementType.setSymbol(newSymbol);
        RecordSet activeRecordSet = this.application.getActiveRecordSet();
        if (activeRecordSet != null) {
            activeRecordSet.get(this.ordinal).setSymbol(newSymbol);
        }
        this.device.setMeasurementSymbol(this.channelConfigNumber, this.ordinal, newSymbol);
    }

    void updateUnit(String newUnit) {
        if (newUnit.contains("[") || newUnit.contains("]")) {
            newUnit = newUnit.replace("[", "").replace("]", "").trim();
        }
        for (int i = this.filterExtend.length(); i > 0; --i) {
            if (!newUnit.endsWith(this.filterExtend.substring(0, i))) continue;
            newUnit = newUnit.substring(0, newUnit.length() - this.filterExtend.length());
            break;
        }
        this.measurementType.setUnit(newUnit);
        RecordSet activeRecordSet = this.application.getActiveRecordSet();
        if (activeRecordSet != null) {
            activeRecordSet.get(this.ordinal).setUnit(newUnit);
        }
        this.device.setMeasurementUnit(this.channelConfigNumber, this.ordinal, newUnit);
    }

    boolean synchronizeRecord(boolean enable) {
        boolean isEnabled;
        boolean bl = isEnabled = !enable;
        if (enable) {
            RecordSet activeRecordSet = this.application.getActiveRecordSet();
            if (activeRecordSet != null) {
                String syncMeasurementName_0;
                String syncMeasurementName_1 = this.measurementType.getName().endsWith(this.filterExtend) ? this.measurementType.getName().substring(0, this.measurementType.getName().length() - this.filterExtend.length()) : this.measurementType.getName();
                String string = syncMeasurementName_0 = activeRecordSet.get(syncMeasurementName_1.split(" ")[0]) != null && syncMeasurementName_1.contains(syncMeasurementName_1.split(" ")[0]) ? syncMeasurementName_1.split(" ")[0] : syncMeasurementName_1.split(" ")[0] + " " + 1;
                if (activeRecordSet.get(syncMeasurementName_0) != null && activeRecordSet.get(syncMeasurementName_0).getOrdinal() != this.ordinal) {
                    this.device.setMeasurementPropertyValue(this.channelConfigNumber, this.ordinal, MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value(), DataTypes.INTEGER, (Object)activeRecordSet.get(syncMeasurementName_0).getOrdinal());
                    isEnabled = true;
                } else if (activeRecordSet.get(syncMeasurementName_1) != null && activeRecordSet.get(syncMeasurementName_1).getOrdinal() != this.ordinal) {
                    this.device.setMeasurementPropertyValue(this.channelConfigNumber, this.ordinal, MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value(), DataTypes.INTEGER, (Object)activeRecordSet.get(syncMeasurementName_1).getOrdinal());
                    isEnabled = true;
                }
                if (!isEnabled) {
                    syncMeasurementName_1 = this.measurementType.getName().length() > 4 ? this.measurementType.getName().substring(0, 4) : this.measurementType.getName();
                    String syncMeasurementUnit_1 = this.measurementType.getUnit();
                    Record toBeSyncRecord = activeRecordSet.get(this.measurementType.getName());
                    for (String recordKey : activeRecordSet.getRecordNames()) {
                        String tmpSyncMasterRecordName;
                        Record tmpSyncMasterRecord = activeRecordSet.get(recordKey);
                        String string2 = tmpSyncMasterRecordName = tmpSyncMasterRecord.getName().length() > 4 ? tmpSyncMasterRecord.getName().substring(0, 4) : tmpSyncMasterRecord.getName();
                        if (toBeSyncRecord != null && log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, String.format("tmpSyncMasterRecord name %s, ordinal %d : toBeSyncRecord name %s, ordinal %d", tmpSyncMasterRecord.getName(), tmpSyncMasterRecord.getOrdinal(), toBeSyncRecord.getName(), toBeSyncRecord.getOrdinal()));
                        }
                        if (toBeSyncRecord == null || !tmpSyncMasterRecord.getUnit().equals(syncMeasurementUnit_1) || !tmpSyncMasterRecordName.equals(syncMeasurementName_1) || tmpSyncMasterRecord.getOrdinal() == activeRecordSet.get(this.measurementType.getName()).getOrdinal() || tmpSyncMasterRecord.getOrdinal() >= activeRecordSet.get(this.measurementType.getName()).getOrdinal()) continue;
                        this.device.setMeasurementPropertyValue(this.channelConfigNumber, this.ordinal, MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value(), DataTypes.INTEGER, (Object)tmpSyncMasterRecord.getOrdinal());
                        isEnabled = true;
                        break;
                    }
                }
            }
        } else {
            this.device.setMeasurementPropertyValue(this.channelConfigNumber, this.ordinal, MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value(), DataTypes.INTEGER, null);
            isEnabled = false;
        }
        this.measurementSynch.setText(String.format(" %2s", this.measurementType.getProperty(MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value()) != null ? this.measurementType.getProperty(MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value()).getValue() : ""));
        return isEnabled;
    }
}

