/*
 * Decompiled with CFR 0.152.
 */
package gde.ui;

import com.sun.istack.Nullable;
import gde.Analyzer;
import gde.Explorer;
import gde.GDE;
import gde.comm.DeviceCommPort;
import gde.comm.IDeviceCommPort;
import gde.config.Settings;
import gde.data.AbstractRecordSet;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.ObjectData;
import gde.data.RecordSet;
import gde.device.ChannelTypes;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.resource.DeviceXmlResource;
import gde.histo.ui.HistoExplorer;
import gde.histo.ui.HistoSummaryWindow;
import gde.io.OsdReaderWriter;
import gde.log.LogFormatter;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import gde.ui.StatusBar;
import gde.ui.dialog.AboutDialog;
import gde.ui.dialog.DeviceSelectionDialog;
import gde.ui.dialog.FontSizeDialog;
import gde.ui.dialog.HelpInfoDialog;
import gde.ui.dialog.SettingsDialog;
import gde.ui.dialog.UpdateMessageBox;
import gde.ui.menu.MenuBar;
import gde.ui.menu.MenuToolBar;
import gde.ui.tab.AnalogWindow;
import gde.ui.tab.CellVoltageWindow;
import gde.ui.tab.DataTableWindow;
import gde.ui.tab.DigitalWindow;
import gde.ui.tab.FileCommentWindow;
import gde.ui.tab.GraphicsComposite;
import gde.ui.tab.GraphicsWindow;
import gde.ui.tab.ObjectDescriptionWindow;
import gde.ui.tab.StatisticsWindow;
import gde.utils.FileUtils;
import gde.utils.ObjectKeyCompliance;
import gde.utils.OperatingSystemHelper;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import gde.utils.WebBrowser;
import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.Widget;

public class DataExplorer
extends Composite {
    static final String $CLASS_NAME = DataExplorer.class.getName();
    static final Logger log = Logger.getLogger(DataExplorer.class.getName());
    final HashMap<String, String> extensionFilterMap = new HashMap();
    public static final String RECORD_NAME = "recordName";
    public static final String NAME_REPLACEMENT = "nameReplacement";
    public static final String CURVE_SELECTION_ITEM = "curveSelectedItem";
    public static final String OLD_STATE = "oldState";
    public final Color COLOR_WHITE;
    public final Color COLOR_LIGHT_GREY;
    public final Color COLOR_GREY;
    public final Color COLOR_CANVAS_YELLOW;
    public final Color COLOR_BLUE;
    public final Color COLOR_LIGHT_BLUE;
    public final Color COLOR_DARK_GREEN;
    public final Color COLOR_BLACK;
    public final Color COLOR_RED;
    public Color COLOR_BACKGROUND;
    public Color COLOR_FOREGROUND;
    public static final int TAB_INDEX_GRAPHIC = 0;
    public static final int TAB_INDEX_DATA_TABLE = 1;
    public static final int TAB_INDEX_DIGITAL = 2;
    public static final int TAB_INDEX_ANALOG = 3;
    public static final int TAB_INDEX_CELL_VOLTAGE = 4;
    public static final int TAB_INDEX_COMPARE = 5;
    public static final int TAB_INDEX_COMMENT = 6;
    public static final int TAB_INDEX_HISTO_SUMMARY = 7;
    public static final int TAB_INDEX_HISTO_TABLE = 8;
    public static final String COMPARE_RECORD_SET = "compare_set";
    public static final String UTILITY_RECORD_SET = "utility_set";
    private static volatile DataExplorer application = null;
    gde.io.FileHandler fileHandler;
    CTabFolder displayTab;
    Settings settings;
    Menu menu;
    MenuBar menuBar;
    CoolBar menuCoolBar;
    int[] order;
    int[] wrapIndices;
    Point[] sizes;
    MenuToolBar menuToolBar;
    GraphicsWindow graphicsTabItem;
    GraphicsWindow compareTabItem;
    DataTableWindow dataTableTabItem;
    StatisticsWindow statisticsTabItem;
    DigitalWindow digitalTabItem;
    AnalogWindow analogTabItem;
    CellVoltageWindow cellVoltageTabItem;
    FileCommentWindow fileCommentTabItem;
    ObjectDescriptionWindow objectDescriptionTabItem;
    final Vector<CTabItem> customTabItems = new Vector();
    GraphicsWindow utilGraphicsTabItem;
    Composite tabComposite;
    Composite statusComposite;
    StatusBar statusBar;
    int progessPercentage = 0;
    boolean isDeviceDialogModal;
    int tabSelectedIndex;
    SettingsDialog settingsDialog;
    HelpInfoDialog helpDialog;
    DeviceSelectionDialog deviceSelectionDialog;
    RecordSet compareSet;
    RecordSet utilitySet;
    Optional<HistoExplorer> histoExplorer = Optional.empty();
    final long threadId;
    String progressBarUser = null;
    TaskItem taskBarItem;
    Thread writeTmpFileThread;
    boolean isTmpWriteStop = false;
    boolean isCurveSelectorEnabled = true;
    boolean isRecordCommentVisible = false;
    boolean isGraphicsHeaderVisible = false;
    boolean isObjectWindowVisible = false;
    int openYesNoMessageDialogAsyncValue = -1;
    Boolean openUpdateMessageDialogSyncValue = null;
    DropTarget target;
    final FileTransfer fileTransfer = FileTransfer.getInstance();
    Transfer[] types = new Transfer[]{this.fileTransfer};
    private Analyzer analyzer;
    private boolean isUpdateAllTabs = true;
    final boolean[] isTxOn = new boolean[]{true};
    Runnable txOn = new Runnable(){

        @Override
        public void run() {
            DataExplorer.this.statusBar.setSerialTxOn();
            DataExplorer.this.isTxOn[0] = true;
        }
    };
    final boolean[] isTxOff = new boolean[]{true};
    Runnable txOff = new Runnable(){

        @Override
        public void run() {
            DataExplorer.this.statusBar.setSerialTxOff();
            DataExplorer.this.isTxOff[0] = true;
        }
    };
    final boolean[] isRxOn = new boolean[]{true};
    Runnable rxOn = new Runnable(){

        @Override
        public void run() {
            DataExplorer.this.statusBar.setSerialRxOn();
            DataExplorer.this.isRxOn[0] = true;
        }
    };
    final boolean[] isRxOff = new boolean[]{true};
    Runnable rxOff = new Runnable(){

        @Override
        public void run() {
            DataExplorer.this.statusBar.setSerialRxOff();
            DataExplorer.this.isRxOff[0] = true;
        }
    };

    private DataExplorer() {
        super((Composite)GDE.shell, 0);
        this.threadId = Thread.currentThread().getId();
        SWTResourceManager.registerResourceUser((Widget)this);
        this.COLOR_WHITE = SWTResourceManager.getColor(1);
        this.COLOR_LIGHT_GREY = SWTResourceManager.getColor(22);
        this.COLOR_GREY = SWTResourceManager.getColor(15);
        this.COLOR_CANVAS_YELLOW = SWTResourceManager.getColor(250, 249, 211);
        this.COLOR_BLUE = SWTResourceManager.getColor(9);
        this.COLOR_LIGHT_BLUE = SWTResourceManager.getColor(239, 239, 255);
        this.COLOR_DARK_GREEN = SWTResourceManager.getColor(6);
        this.COLOR_BLACK = SWTResourceManager.getColor(2);
        this.COLOR_RED = SWTResourceManager.getColor(3);
        this.COLOR_BACKGROUND = SWTResourceManager.getColor(22);
        this.COLOR_FOREGROUND = SWTResourceManager.getColor(21);
    }

    private void initialize() {
        this.analyzer = Analyzer.getInstance();
        this.extensionFilterMap.put("osd", Messages.getString("GDE_MSGT0139"));
        this.extensionFilterMap.put("lov", Messages.getString("GDE_MSGT0140"));
        this.extensionFilterMap.put("csv", Messages.getString("GDE_MSGT0141"));
        this.extensionFilterMap.put("xml", Messages.getString("GDE_MSGT0142"));
        this.extensionFilterMap.put("png", Messages.getString("GDE_MSGT0213"));
        this.extensionFilterMap.put("gif", Messages.getString("GDE_MSGT0214"));
        this.extensionFilterMap.put("jpg", Messages.getString("GDE_MSGT0215"));
        this.extensionFilterMap.put("kmz", Messages.getString("GDE_MSGT0222"));
        this.extensionFilterMap.put("gpx", Messages.getString("GDE_MSGT0677"));
        this.extensionFilterMap.put("*", Messages.getString(GDE.IS_WINDOWS ? "GDE_MSGT0216" : "GDE_MSGT0676"));
        this.extensionFilterMap.put("ini", Messages.getString("GDE_MSGT0368"));
        this.extensionFilterMap.put("log", Messages.getString("GDE_MSGT0672"));
        this.extensionFilterMap.put("jml", Messages.getString("GDE_MSGT0673"));
        this.extensionFilterMap.put("bin", Messages.getString("GDE_MSGT0950"));
        this.extensionFilterMap.put("txt", Messages.getString("GDE_MSGT0951"));
        this.extensionFilterMap.put("bin;*.log", Messages.getString("GDE_MSGT0952"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataExplorer getInstance() {
        if (application == null) {
            DataExplorer dataExplorer = application = new DataExplorer();
            synchronized (dataExplorer) {
                application.initialize();
            }
        }
        return application;
    }

    public static boolean isInitialized() {
        return application != null;
    }

    private void initGUI() {
        try {
            this.setColorSchemaColors(this.settings.getSkinColorSchema());
            this.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0, false, false));
            this.setBackground(this.COLOR_BACKGROUND);
            GridLayout thisLayout = new GridLayout(1, true);
            thisLayout.marginWidth = 0;
            thisLayout.marginHeight = 0;
            thisLayout.numColumns = 1;
            thisLayout.makeColumnsEqualWidth = true;
            thisLayout.horizontalSpacing = 0;
            thisLayout.verticalSpacing = 0;
            this.setLayout((Layout)thisLayout);
            this.menu = new Menu((Decorations)GDE.shell, 2);
            this.menuBar = new MenuBar(this, this.menu);
            this.menuBar.create();
            GDE.shell.setMenuBar(this.menu);
            this.menuCoolBar = new CoolBar((Composite)this, 0x800000);
            this.menuCoolBar.setBackground(this.COLOR_BACKGROUND);
            GridData menuCoolBarLData = new GridData();
            menuCoolBarLData.horizontalAlignment = 4;
            menuCoolBarLData.verticalAlignment = 1;
            menuCoolBarLData.grabExcessHorizontalSpace = true;
            this.menuCoolBar.setLayoutData((Object)menuCoolBarLData);
            this.menuToolBar = new MenuToolBar(this, this.menuCoolBar);
            this.menuToolBar.create();
            this.menuCoolBar.setItemLayout(this.settings.getCoolBarOrder(DataExplorer.getInstance().getMenuToolBar().getCoolBarSizes()), this.settings.getCoolBarWraps(), this.settings.getCoolBarSizes(DataExplorer.getInstance().getMenuToolBar().getCoolBarSizes()));
            this.displayTab = new CTabFolder((Composite)this, 0x800000);
            this.displayTab.setBackground(new Color[]{this.COLOR_BACKGROUND, this.settings.getGraphicsSurroundingBackground()}, new int[]{100}, true);
            this.displayTab.setForeground(this.COLOR_FOREGROUND);
            GridData tabCompositeLData = new GridData();
            tabCompositeLData.verticalAlignment = 4;
            tabCompositeLData.horizontalAlignment = 4;
            tabCompositeLData.grabExcessHorizontalSpace = true;
            tabCompositeLData.grabExcessVerticalSpace = true;
            this.displayTab.setLayoutData((Object)tabCompositeLData);
            this.displayTab.setSimple(false);
            this.graphicsTabItem = new GraphicsWindow(this.displayTab, 0, GraphicsWindow.GraphicsType.NORMAL, Messages.getString("GDE_MSGT0143"), 0);
            this.graphicsTabItem.create();
            this.displayTab.setSelection(0);
            this.statusComposite = new Composite((Composite)this, 0);
            GridData statusCompositeLData = new GridData();
            statusCompositeLData.grabExcessHorizontalSpace = true;
            statusCompositeLData.horizontalAlignment = 4;
            statusCompositeLData.verticalAlignment = 3;
            this.statusComposite.setLayoutData((Object)statusCompositeLData);
            this.statusBar = new StatusBar(this.statusComposite);
            this.statusBar.create();
            log.info(() -> "Statusbar created");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void execute(final String inputFilePath) {
        String $METHOD_NAME = "execute";
        try {
            TaskBar taskBar;
            FileUtils.cleanupPre();
            this.settings = Settings.getInstance();
            log.logp(gde.log.Level.INFO, $CLASS_NAME, "execute", this.settings.toString());
            new Thread("updateAvailablePorts"){

                @Override
                public void run() {
                    try {
                        if (DataExplorer.this.getActiveDevice() != null && DataExplorer.this.getActiveDevice().getDeviceConfiguration() != null && DataExplorer.this.getActiveDevice().getDeviceConfiguration().getSerialPortType() != null) {
                            DeviceCommPort.listConfiguredSerialPorts(DataExplorer.this.settings.doPortAvailabilityCheck(), DataExplorer.this.settings.isSerialPortBlackListEnabled() ? DataExplorer.this.settings.getSerialPortBlackList() : "", DataExplorer.this.settings.isSerialPortWhiteListEnabled() ? DataExplorer.this.settings.getSerialPortWhiteList() : new Vector());
                        }
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, t.getMessage(), t);
                    }
                    log.log(gde.log.Level.TIME, "updateAvailablePortsThread time =", StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - GDE.StartTime));
                }
            }.start();
            this.isDeviceDialogModal = this.settings.isDeviceDialogsModal();
            if (this.settings.getWindow().width < 600) {
                this.settings.setWindow(new Point(this.settings.getWindow().x, this.settings.getWindow().y), new Point(600, this.settings.getWindow().height));
            }
            if (this.settings.getWindow().height < 400) {
                this.settings.setWindow(new Point(this.settings.getWindow().x, this.settings.getWindow().y), new Point(this.settings.getWindow().width, 400));
            }
            if (this.settings.isWindowMaximized()) {
                GDE.shell.setLocation(this.settings.getWindow().x, this.settings.getWindow().y);
                GDE.shell.setSize(this.settings.getWindow().width, this.settings.getWindow().height);
                GDE.shell.setMaximized(true);
            } else {
                Rectangle displayBounds = GDE.display.getBounds();
                if (this.settings.getWindow().x < displayBounds.x || this.settings.getWindow().x > displayBounds.width + displayBounds.x || this.settings.getWindow().y < displayBounds.y || this.settings.getWindow().y > displayBounds.height + displayBounds.y) {
                    GDE.shell.setLocation(50, 50);
                    GDE.shell.setSize(this.settings.getWindow().width, this.settings.getWindow().height);
                } else {
                    GDE.shell.setBounds(this.settings.getWindow());
                }
            }
            this.fileHandler = new gde.io.FileHandler();
            this.initGUI();
            ((Explorer)this.analyzer).setChannels();
            GDE.shell.setLayout((Layout)new FillLayout());
            GDE.shell.setImage(SWTResourceManager.getImage(GDE.IS_MAC ? "gde/resource/DataExplorer_MAC.png" : "gde/resource/DataExplorer.png"));
            GDE.shell.setText("DataExplorer");
            if (GDE.splash != null) {
                GDE.splash.dispose();
            }
            this.taskBarItem = (taskBar = GDE.display.getSystemTaskBar()) == null ? null : (taskBar.getItem(GDE.shell) != null ? taskBar.getItem(GDE.shell) : taskBar.getItem(null));
            StringBuilder sb = new StringBuilder();
            if (this.settings.isDevicePropertiesUpdated()) {
                sb.append(Messages.getString("GDE_MSGI0016")).append("\n");
            }
            if (this.settings.isGraphicsTemplateUpdated()) {
                sb.append(Messages.getString("GDE_MSGI0017")).append("\n");
            }
            if (!this.settings.isHistoCacheTemplateUpdated() || sb.length() == 0) {
                // empty if block
            }
            if (sb.length() > 0) {
                application.openMessageDialog(GDE.shell, sb.toString());
            }
            GDE.shell.addControlListener(new ControlListener(){

                public void controlResized(ControlEvent controlevent) {
                    if (log.isLoggable(gde.log.Level.FINEST)) {
                        log.logp(gde.log.Level.FINEST, $CLASS_NAME, "shell.controlResized", GDE.shell.getLocation().toString() + "event = " + controlevent);
                    }
                    application.settings.setWindowMaximized(GDE.shell.getMaximized());
                    if (!application.settings.isWindowMaximized()) {
                        application.settings.setWindow(GDE.shell.getLocation(), GDE.shell.getSize());
                    }
                }

                public void controlMoved(ControlEvent controlevent) {
                    if (log.isLoggable(gde.log.Level.FINEST)) {
                        log.logp(gde.log.Level.FINEST, $CLASS_NAME, "shell.controlResized", GDE.shell.getLocation().toString() + "event = " + controlevent);
                    }
                    if (!GDE.shell.getMaximized()) {
                        application.settings.setWindow(GDE.shell.getLocation(), GDE.shell.getSize());
                    }
                }
            });
            GDE.shell.open();
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataExplorer.this.postInitGUI(inputFilePath);
                    for (String errorMessage : GDE.getInitErrors()) {
                        MessageBox messageDialog = new MessageBox(GDE.shell, 40);
                        if (errorMessage.contains(";")) {
                            String[] messages = errorMessage.split(";");
                            messageDialog.setText(messages[0]);
                            messageDialog.setMessage(messages[1]);
                        } else {
                            messageDialog.setText("DataExplorer");
                            messageDialog.setMessage(errorMessage);
                        }
                        messageDialog.open();
                    }
                }
            });
            if (!this.settings.isUpdateChecked()) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            log.log(gde.log.Level.WARNING, e.getMessage(), e);
                        }
                        long startTime = new Date().getTime();
                        DataExplorer.this.check4update();
                        if (log.isLoggable(gde.log.Level.TIME)) {
                            log.log(gde.log.Level.TIME, "check4update time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
                        }
                    }
                }, "check4update").start();
            }
            this.enableWritingTmpFiles(this.settings.getUsageWritingTmpFiles());
            log.logp(gde.log.Level.TIME, $CLASS_NAME, "execute", "total init time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - GDE.StartTime));
            while (!GDE.shell.isDisposed() && !this.isDisposed()) {
                if (GDE.display.readAndDispatch()) continue;
                GDE.display.sleep();
            }
        }
        catch (Throwable t) {
            log.log(gde.log.Level.SEVERE, t.getMessage(), t);
            t.printStackTrace(System.err);
        }
        this.isTmpWriteStop = true;
        FileUtils.cleanupPost();
        this.histoExplorer.ifPresent(HistoExplorer::cleanup);
    }

    private void updateLogger() {
        LogFormatter lf = new LogFormatter();
        Logger rootLogger = Logger.getLogger("");
        rootLogger.removeHandler(GDE.logHandler);
        if (System.getProperty("ECLIPSE") == null) {
            try {
                FileHandler logHandler = new FileHandler(Settings.getLogFilePath(), 5000000, 3);
                rootLogger.addHandler(logHandler);
                logHandler.setFormatter(lf);
                logHandler.setLevel(gde.log.Level.ALL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ConsoleHandler logHandler = new ConsoleHandler();
            rootLogger.addHandler(logHandler);
            logHandler.setFormatter(lf);
            logHandler.setLevel(gde.log.Level.ALL);
        }
        this.settings.updateLogLevel();
    }

    private void postInitGUI(String inputFilePath) {
        String $METHOD_NAME = "postInitGUI";
        try {
            if (log.isLoggable(gde.log.Level.FINE)) {
                log.logp(gde.log.Level.FINE, $CLASS_NAME, "postInitGUI", "init tabs");
            }
            this.statisticsTabItem = new StatisticsWindow(this.displayTab, 0);
            this.statisticsTabItem.create();
            this.fileCommentTabItem = new FileCommentWindow(this.displayTab, 0);
            this.fileCommentTabItem.create();
            this.setObjectDescriptionTabVisible(this.menuToolBar.isObjectoriented());
            if (log.isLoggable(gde.log.Level.FINE)) {
                log.logp(gde.log.Level.FINE, $CLASS_NAME, "postInitGUI", "init listener");
            }
            GDE.shell.addListener(21, new Listener(){

                public void handleEvent(Event evt) {
                    if (log.isLoggable(gde.log.Level.FINE)) {
                        log.logp(gde.log.Level.FINE, $CLASS_NAME, "postInitGUI", GDE.shell.getLocation().toString() + "event = " + evt);
                    }
                    evt.doit = DataExplorer.this.getDeviceSelectionDialog().checkDataSaved();
                    for (Thread thread : Thread.getAllStackTraces().keySet()) {
                        if (thread == null || thread.isDaemon() || !thread.isAlive() || !thread.getClass().getName().startsWith("gde.device")) continue;
                        DataExplorer.this.openMessageDialog(Messages.getString("GDE_MSGW0048"));
                        evt.doit = false;
                    }
                }
            });
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent evt) {
                    if (log.isLoggable(gde.log.Level.FINE)) {
                        log.logp(gde.log.Level.FINE, $CLASS_NAME, "widgetDisposed", GDE.shell.getLocation().toString() + "event = " + evt);
                    }
                    if (log.isLoggable(gde.log.Level.FINE)) {
                        log.logp(gde.log.Level.FINE, $CLASS_NAME, "widgetDisposed", GDE.shell.getSize().toString());
                    }
                    for (Thread thread : Thread.getAllStackTraces().keySet()) {
                        if (thread == null || thread.isDaemon() || !thread.isAlive() || !thread.getClass().getName().startsWith("gde.device")) continue;
                        try {
                            thread.stop();
                        }
                        catch (Throwable e) {
                            log.log(gde.log.Level.SEVERE, "thread.getClass().getName() killed brute force while shutdown");
                        }
                    }
                    if (DataExplorer.this.helpDialog != null && !DataExplorer.this.helpDialog.isDisposed()) {
                        DataExplorer.this.helpDialog.dispose();
                    }
                    if (application.getActiveDevice() != null) {
                        application.getActiveDevice().storeDeviceProperties();
                        IDeviceCommPort port = application.getActiveDevice().getCommunicationPort();
                        if (port != null) {
                            try {
                                if (port.getClass().getName().toLowerCase().contains("usb")) {
                                    port.closeUsbPort(null);
                                } else {
                                    port.close();
                                }
                            }
                            catch (Exception e) {
                                log.log(gde.log.Level.WARNING, e.getMessage(), e);
                            }
                            application.getActiveDevice().storeDeviceProperties();
                        }
                    }
                    if (application.getDeviceDialog() != null && !application.getDeviceDialog().isDisposed()) {
                        application.getDeviceDialog().forceDispose();
                    }
                    DataExplorer.this.order = DataExplorer.this.menuCoolBar.getItemOrder();
                    DataExplorer.this.wrapIndices = DataExplorer.this.menuCoolBar.getWrapIndices();
                    if (DataExplorer.this.wrapIndices.length > 0 && DataExplorer.this.wrapIndices[0] != 0) {
                        int[] newWraps = new int[DataExplorer.this.wrapIndices.length + 1];
                        for (int i = 0; i < DataExplorer.this.wrapIndices.length; ++i) {
                            newWraps[i + 1] = DataExplorer.this.wrapIndices[i];
                        }
                        DataExplorer.this.wrapIndices = newWraps;
                    }
                    DataExplorer.this.sizes = DataExplorer.this.menuCoolBar.getItemSizes();
                    application.settings.setCoolBarStates(DataExplorer.this.order, DataExplorer.this.wrapIndices, DataExplorer.this.sizes);
                    if (DataExplorer.this.objectDescriptionTabItem != null && !DataExplorer.this.objectDescriptionTabItem.isDisposed()) {
                        DataExplorer.this.objectDescriptionTabItem.checkSaveObjectData();
                    }
                    application.settings.store();
                }
            });
            this.menuCoolBar.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent evt) {
                    if (log.isLoggable(gde.log.Level.FINEST)) {
                        log.logp(gde.log.Level.FINEST, $CLASS_NAME, "postInitGUI", "menuCoolBar.controlResized, event=" + evt);
                    }
                    if (DataExplorer.this.displayTab != null && DataExplorer.this.getSize().y != 0) {
                        Point menuCoolBarSize = DataExplorer.this.menuCoolBar.getSize();
                        if (log.isLoggable(gde.log.Level.FINE)) {
                            log.logp(gde.log.Level.FINE, $CLASS_NAME, "menuCoolBar.controlResized", "menuCoolBarSize = " + menuCoolBarSize);
                        }
                        Point shellSize = new Point(DataExplorer.this.getClientArea().width, DataExplorer.this.getClientArea().height);
                        if (log.isLoggable(gde.log.Level.FINE)) {
                            log.logp(gde.log.Level.FINE, $CLASS_NAME, "menuCoolBar.controlResized", "shellClientSize = " + shellSize);
                        }
                        Point statusBarSize = DataExplorer.this.statusComposite.getSize();
                        if (log.isLoggable(gde.log.Level.FINE)) {
                            log.logp(gde.log.Level.FINE, $CLASS_NAME, "menuCoolBar.controlResized", "statusBarSize = " + statusBarSize);
                        }
                        DataExplorer.this.displayTab.setBounds(0, menuCoolBarSize.y, shellSize.x, shellSize.y - menuCoolBarSize.y - statusBarSize.y);
                        if (log.isLoggable(gde.log.Level.FINE)) {
                            log.logp(gde.log.Level.FINE, $CLASS_NAME, "postInitGUI", "displayTab.bounds = " + DataExplorer.this.displayTab.getBounds());
                        }
                    }
                }
            });
            this.displayTab.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent evt) {
                    if (log.isLoggable(gde.log.Level.FINEST)) {
                        log.logp(gde.log.Level.FINEST, $CLASS_NAME, "postInitGUI", "displayTab.controlResized, event=" + evt);
                    }
                    if (DataExplorer.this.displayTab != null && DataExplorer.this.getSize().y != 0) {
                        DataExplorer.this.menuCoolBar.pack();
                        Point menuCoolBarSize = DataExplorer.this.menuCoolBar.getSize();
                        Point shellSize = new Point(GDE.shell.getClientArea().width, GDE.shell.getClientArea().height);
                        Point statusBarSize = DataExplorer.this.statusComposite.getSize();
                        if (log.isLoggable(gde.log.Level.FINE)) {
                            log.logp(gde.log.Level.FINE, $CLASS_NAME, "displayTab.controlRezised", "displayTab.bounds = " + DataExplorer.this.displayTab.getBounds());
                        }
                        DataExplorer.this.displayTab.setBounds(0, menuCoolBarSize.y, shellSize.x, shellSize.y - menuCoolBarSize.y - statusBarSize.y);
                    }
                }
            });
            this.displayTab.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent evt) {
                    if (log.isLoggable(gde.log.Level.FINER) && DataExplorer.this.displayTab.getSelectionIndex() >= 0) {
                        log.logp(gde.log.Level.FINER, $CLASS_NAME, "postInitGUI", "displayTab.paintControl " + DataExplorer.this.displayTab.getItems()[DataExplorer.this.displayTab.getSelectionIndex()].getText() + " - " + DataExplorer.this.displayTab.getSelectionIndex() + " - " + evt);
                    }
                    if (DataExplorer.this.isRecordSetVisible(GraphicsWindow.GraphicsType.NORMAL)) {
                        if (DataExplorer.this.graphicsTabItem.isCurveSelectorEnabled()) {
                            DataExplorer.this.graphicsTabItem.setSashFormWeights(DataExplorer.this.graphicsTabItem.getCurveSelectorComposite().getSelectorColumnWidth());
                        } else {
                            DataExplorer.this.graphicsTabItem.setSashFormWeights(0);
                        }
                    } else if (DataExplorer.this.isRecordSetVisible(GraphicsWindow.GraphicsType.COMPARE) && DataExplorer.this.compareTabItem != null) {
                        DataExplorer.this.compareTabItem.setSashFormWeights(DataExplorer.this.compareTabItem.getCurveSelectorComposite().getSelectorColumnWidth());
                    } else if (DataExplorer.this.isRecordSetVisible(GraphicsWindow.GraphicsType.UTIL) && DataExplorer.this.utilGraphicsTabItem != null) {
                        DataExplorer.this.utilGraphicsTabItem.setSashFormWeights(DataExplorer.this.utilGraphicsTabItem.getCurveSelectorComposite().getSelectorColumnWidth());
                    }
                    if (DataExplorer.this.objectDescriptionTabItem != null) {
                        if (DataExplorer.this.objectDescriptionTabItem.isVisible()) {
                            if (log.isLoggable(gde.log.Level.FINER)) {
                                log.logp(gde.log.Level.FINER, $CLASS_NAME, "postInitGUI", "displayTab.focusGained " + evt);
                            }
                            DataExplorer.this.isObjectWindowVisible = true;
                        } else if (DataExplorer.this.isObjectWindowVisible) {
                            if (log.isLoggable(gde.log.Level.FINER)) {
                                log.logp(gde.log.Level.FINER, $CLASS_NAME, "postInitGUI", "displayTab.focusLost " + evt);
                            }
                            DataExplorer.this.checkSaveObjectData();
                            DataExplorer.this.isObjectWindowVisible = false;
                        }
                    }
                    if (log.isLoggable(gde.log.Level.FINE) && DataExplorer.this.displayTab != null && DataExplorer.this.menuCoolBar != null && DataExplorer.this.statusComposite != null && DataExplorer.this.getSize().y != 0) {
                        log.logp(gde.log.Level.FINE, $CLASS_NAME, "postInitGUI", "menuCoolBar.size = " + DataExplorer.this.menuCoolBar.getSize());
                        log.logp(gde.log.Level.FINE, $CLASS_NAME, "postInitGUI", "shellClient.size = " + new Point(DataExplorer.this.getClientArea().width, DataExplorer.this.getClientArea().height));
                        log.logp(gde.log.Level.FINE, $CLASS_NAME, "postInitGUI", "statusBar.size = " + DataExplorer.this.statusComposite.getSize());
                        log.logp(gde.log.Level.FINE, $CLASS_NAME, "postInitGUI", "displayTab.bounds = " + DataExplorer.this.displayTab.getBounds());
                    }
                }
            });
            this.displayTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    CTabFolder tabFolder = (CTabFolder)evt.widget;
                    int tabPreviousIndex = DataExplorer.this.tabSelectedIndex;
                    int tabSelectionIndex = tabFolder.getSelectionIndex();
                    DataExplorer.this.tabSelectedIndex = tabFolder.getSelectionIndex();
                    if (DataExplorer.this.histoExplorer.isPresent()) {
                        try {
                            if (log.isLoggable(gde.log.Level.FINER)) {
                                log.logp(gde.log.Level.FINER, $CLASS_NAME, "postInitGUI", "old=" + tabPreviousIndex + " new=" + tabSelectionIndex + " addSelectionListener, event=" + evt);
                            }
                            if (tabFolder.getItem(tabPreviousIndex) instanceof HistoSummaryWindow) {
                                DataExplorer.this.setStatusMessage("");
                            }
                        }
                        catch (Exception e) {
                            log.log(gde.log.Level.WARNING, e.getMessage(), e);
                        }
                    }
                    if (tabSelectionIndex == 0) {
                        DataExplorer.this.menuToolBar.enableScopePointsCombo(true);
                        DataExplorer.this.enableZoomMenuButtons(true);
                        DataExplorer.this.updateGraphicsWindow();
                    } else if (tabSelectionIndex > 0) {
                        if (DataExplorer.this.displayTab.getItem(tabSelectionIndex) instanceof GraphicsWindow && DataExplorer.this.isRecordSetVisible(GraphicsWindow.GraphicsType.COMPARE)) {
                            DataExplorer.this.menuToolBar.enableScopePointsCombo(false);
                            DataExplorer.this.enableZoomMenuButtons(true);
                            DataExplorer.this.updateGraphicsWindow();
                        } else if (DataExplorer.this.displayTab.getItem(tabSelectionIndex) instanceof GraphicsWindow && DataExplorer.this.isRecordSetVisible(GraphicsWindow.GraphicsType.UTIL)) {
                            DataExplorer.this.menuToolBar.enableScopePointsCombo(false);
                            DataExplorer.this.enableZoomMenuButtons(false);
                            DataExplorer.this.updateGraphicsWindow();
                        } else if (DataExplorer.this.displayTab.getItem(tabSelectionIndex) instanceof DataTableWindow) {
                            RecordSet activeRecordSet;
                            Channel activeChannel = Analyzer.getInstance().getActiveChannel();
                            RecordSet recordSet = activeRecordSet = activeChannel != null ? activeChannel.getActiveRecordSet() : null;
                            if (activeRecordSet != null) {
                                DataExplorer.this.dataTableTabItem.cleanTable();
                                DataExplorer.this.dataTableTabItem.setRowCount(activeRecordSet.getRecordDataSize(false));
                            }
                        } else {
                            DataExplorer.this.histoExplorer.ifPresent(h -> h.updateVisibleTab(evt));
                        }
                    }
                }
            });
            this.target = new DropTarget((Control)this, 17);
            this.target.setTransfer(this.types);
            this.target.addDropListener((DropTargetListener)new DropTargetAdapter(){

                public void dragEnter(DropTargetEvent event) {
                    if (event.detail == 16) {
                        event.detail = (event.operations & 1) != 0 ? 1 : 0;
                    }
                    for (TransferData element : event.dataTypes) {
                        if (!DataExplorer.this.fileTransfer.isSupportedType(element)) continue;
                        event.currentDataType = element;
                        if (event.detail == 1) break;
                        event.detail = 0;
                        break;
                    }
                }

                public void dragOperationChanged(DropTargetEvent event) {
                    if (event.detail == 16) {
                        event.detail = (event.operations & 1) != 0 ? 1 : 0;
                    }
                    if (DataExplorer.this.fileTransfer.isSupportedType(event.currentDataType) && event.detail != 1) {
                        event.detail = 0;
                    }
                }

                public void drop(DropTargetEvent event) {
                    if (DataExplorer.this.fileTransfer.isSupportedType(event.currentDataType)) {
                        String[] files;
                        for (String filePath : files = (String[])event.data) {
                            String directoryName;
                            if (log.isLoggable(gde.log.Level.FINE)) {
                                log.logp(gde.log.Level.FINE, $CLASS_NAME, "postInitGUI", "dropped file = " + filePath);
                            }
                            if (filePath.toLowerCase().endsWith("osd")) {
                                directoryName = ObjectKeyCompliance.getUpcomingObjectKey(Paths.get(filePath, new String[0]));
                                if (!directoryName.isEmpty()) {
                                    ObjectKeyCompliance.createObjectKey(directoryName);
                                }
                                DataExplorer.this.fileHandler.openOsdFile(filePath);
                                continue;
                            }
                            if (filePath.toLowerCase().endsWith("lov")) {
                                directoryName = ObjectKeyCompliance.getUpcomingObjectKey(Paths.get(filePath, new String[0]));
                                if (!directoryName.isEmpty()) {
                                    ObjectKeyCompliance.createObjectKey(directoryName);
                                }
                                DataExplorer.this.fileHandler.openLovFile(filePath);
                                continue;
                            }
                            application.openMessageDialog(Messages.getString("GDE_MSGI0022"));
                        }
                    }
                }
            });
            if (log.isLoggable(gde.log.Level.FINE)) {
                log.logp(gde.log.Level.FINE, $CLASS_NAME, "postInitGUI", "init help listener");
            }
            this.menuCoolBar.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent evt) {
                    if (log.isLoggable(gde.log.Level.FINE)) {
                        log.logp(gde.log.Level.FINE, $CLASS_NAME, "postInitGUI", "this.helpRequested, event=" + evt);
                    }
                    application.openHelpDialog("", "HelpInfo_3.html");
                }
            });
            this.menu.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent evt) {
                    if (log.isLoggable(gde.log.Level.FINE)) {
                        log.logp(gde.log.Level.FINE, $CLASS_NAME, "postInitGUI", "this.helpRequested, event=" + evt);
                    }
                    application.openHelpDialog("", "HelpInfo_3.html");
                }
            });
            this.isRecordCommentVisible = this.settings.isRecordCommentVisible();
            if (this.isRecordCommentVisible) {
                this.menuBar.setRecordCommentMenuItemSelection(this.isRecordCommentVisible);
                this.enableRecordSetComment(this.isRecordCommentVisible);
            }
            this.isGraphicsHeaderVisible = this.settings.isGraphicsHeaderVisible();
            if (this.isGraphicsHeaderVisible) {
                this.menuBar.setGraphicsHeaderMenuItemSelection(this.isGraphicsHeaderVisible);
                this.enableGraphicsHeader(this.isGraphicsHeaderVisible);
            }
            if (!this.settings.isDesktopShortcutCreated()) {
                this.settings.setProperty("is_desktop_shotcut_created", "" + OperatingSystemHelper.createDesktopLink());
            }
            if (!this.settings.isApplicationRegistered()) {
                this.settings.setProperty("is_GDE_registered", "" + OperatingSystemHelper.registerApplication());
            }
            if ((GDE.IS_MAC || GDE.IS_LINUX) && !this.settings.isLockUucpHinted()) {
                if (GDE.IS_MAC && !OperatingSystemHelper.isUucpMember()) {
                    this.openMessageDialog(Messages.getString("GDE_MSGI0046"));
                } else if (GDE.IS_LINUX && !OperatingSystemHelper.isUucpMember()) {
                    this.openMessageDialog(Messages.getString("GDE_MSGI0045"));
                }
                this.settings.setProperty("is_lock_uucp_hinted", "true");
            }
            if (this.settings.isDevicePropertiesUpdated()) {
                this.analyzer.joinDeviceConfigurationsThread();
                this.settings.startMigationThread();
                this.settings.joinMigationThread();
                this.analyzer.startDeviceConfigurationsThread();
                this.analyzer.joinDeviceConfigurationsThread();
            }
            if (!this.settings.isOK()) {
                this.openSettingsDialog();
            }
            this.deviceSelectionDialog = new DeviceSelectionDialog(GDE.shell, 32768, this);
            if (this.settings.getActiveDevice().equals("---")) {
                this.deviceSelectionDialog.open();
            } else {
                this.deviceSelectionDialog.setupDevice();
            }
            if (inputFilePath.length() > 5) {
                if (inputFilePath.endsWith("osd")) {
                    this.fileHandler.openOsdFile(inputFilePath);
                } else if (inputFilePath.endsWith("lov")) {
                    this.fileHandler.openLovFile(inputFilePath);
                }
            }
        }
        catch (Exception e) {
            log.log(gde.log.Level.SEVERE, e.getMessage(), e);
            this.openMessageDialog(Messages.getString("GDE_MSGE0007") + e.getMessage());
        }
        if (log.isLoggable(gde.log.Level.TIME)) {
            log.logp(gde.log.Level.TIME, $CLASS_NAME, "postInitGUI", String.format("layout time = %s", StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - GDE.StartTime)));
        }
        this.setHisto(Settings.getInstance().isHistoActive());
        if (log.isLoggable(gde.log.Level.TIME)) {
            log.logp(gde.log.Level.TIME, $CLASS_NAME, "postInitGUI", String.format("done time = %s", StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - GDE.StartTime)));
        }
        GDE.shell.layout();
        this.updateLogger();
        if (application.getActiveDevice() != null && Settings.getInstance().isStartDeviceCommunicationAfterStartup()) {
            application.getActiveDevice().open_closeCommPort();
        }
    }

    public synchronized void setHisto(boolean isActive) {
        if (isActive) {
            HistoExplorer tmpHistoExplorer = new HistoExplorer(this.displayTab);
            this.histoExplorer = Optional.of(tmpHistoExplorer);
            if (this.displayTab != null) {
                tmpHistoExplorer.initHisto();
                tmpHistoExplorer.enableCurveSelector(this.isCurveSelectorEnabled);
                tmpHistoExplorer.enableGraphicsHeader(this.isGraphicsHeaderVisible);
                tmpHistoExplorer.enableRecordSetComment(this.isRecordCommentVisible);
            }
        } else {
            this.histoExplorer.ifPresent(h -> h.disposeHisto());
            this.histoExplorer = Optional.empty();
        }
    }

    public void updateStatisticsData() {
        if (this.statisticsTabItem != null && !this.statisticsTabItem.isDisposed()) {
            if (Thread.currentThread().getId() == application.getThreadId()) {
                this.statisticsTabItem.updateStatisticsData(true);
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorer.this.statisticsTabItem.updateStatisticsData(true);
                    }
                });
            }
        }
    }

    public void setupDataTableHeader() {
        if (this.dataTableTabItem != null && !this.dataTableTabItem.isDisposed()) {
            this.dataTableTabItem.setHeader();
        }
    }

    public synchronized void updateDataTable(String requestingRecordSetName, final boolean forceClean) {
        RecordSet activeRecordSet;
        Channel activeChannel = this.analyzer.getActiveChannel();
        RecordSet recordSet = activeRecordSet = activeChannel != null ? activeChannel.getActiveRecordSet() : null;
        if (activeRecordSet != null && activeRecordSet.getRecordDataSize(true) > 0 && this.dataTableTabItem != null && !this.dataTableTabItem.isDisposed() && activeRecordSet.getName().equals(requestingRecordSetName) && activeRecordSet.getDevice().isTableTabRequested()) {
            if (Thread.currentThread().getId() == application.getThreadId()) {
                if (forceClean) {
                    this.dataTableTabItem.setHeader();
                }
                this.dataTableTabItem.setRowCount(activeRecordSet.getRecordDataSize(false));
                this.dataTableTabItem.updateTopIndex();
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (forceClean) {
                            DataExplorer.this.dataTableTabItem.setHeader();
                        }
                        DataExplorer.this.dataTableTabItem.setRowCount(activeRecordSet.getRecordDataSize(false));
                        DataExplorer.this.dataTableTabItem.updateTopIndex();
                    }
                });
            }
        } else if (activeRecordSet == null || requestingRecordSetName.equals("")) {
            if (Thread.currentThread().getId() == application.getThreadId()) {
                if (this.dataTableTabItem != null) {
                    this.dataTableTabItem.cleanTable();
                }
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (DataExplorer.this.dataTableTabItem != null) {
                            DataExplorer.this.dataTableTabItem.cleanTable();
                        }
                    }
                });
            }
        }
    }

    public void updateDigitalWindow() {
        if (this.digitalTabItem != null && !this.digitalTabItem.isDisposed()) {
            if (Thread.currentThread().getId() == application.getThreadId()) {
                this.digitalTabItem.update(true);
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorer.this.digitalTabItem.update(true);
                    }
                });
            }
        }
    }

    public void updateDigitalWindowChilds() {
        if (this.digitalTabItem != null && !this.digitalTabItem.isDisposed()) {
            if (Thread.currentThread().getId() == application.getThreadId()) {
                this.digitalTabItem.updateChilds();
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorer.this.digitalTabItem.updateChilds();
                    }
                });
            }
        }
    }

    public void updateAnalogWindow() {
        if (this.analogTabItem != null && !this.analogTabItem.isDisposed()) {
            if (Thread.currentThread().getId() == application.getThreadId()) {
                this.analogTabItem.update(true);
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorer.this.analogTabItem.update(true);
                    }
                });
            }
        }
    }

    public void updateAnalogWindowChilds() {
        if (this.analogTabItem != null && !this.analogTabItem.isDisposed()) {
            if (Thread.currentThread().getId() == application.getThreadId()) {
                this.analogTabItem.updateChilds();
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorer.this.analogTabItem.updateChilds();
                    }
                });
            }
        }
    }

    public void setCellVoltageWindowOrdinal(int[] measurementOrdinals) {
        if (this.cellVoltageTabItem != null) {
            this.cellVoltageTabItem.setMeasurements(measurementOrdinals[0], measurementOrdinals[1]);
        }
    }

    public void updateCellVoltageWindow() {
        if (this.cellVoltageTabItem != null && !this.cellVoltageTabItem.isDisposed()) {
            if (Thread.currentThread().getId() == application.getThreadId()) {
                this.cellVoltageTabItem.getCellVoltageMainComposite().redraw();
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorer.this.cellVoltageTabItem.getCellVoltageMainComposite().redraw();
                    }
                });
            }
        }
    }

    public void updateCellVoltageChilds() {
        if (this.cellVoltageTabItem != null && !this.cellVoltageTabItem.isDisposed()) {
            if (Thread.currentThread().getId() == application.getThreadId()) {
                this.cellVoltageTabItem.updateChilds();
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorer.this.cellVoltageTabItem.updateChilds();
                    }
                });
            }
        }
    }

    public void updateCellVoltageLimitsSelector() {
        if (this.cellVoltageTabItem != null && !this.cellVoltageTabItem.isDisposed()) {
            if (Thread.currentThread().getId() == application.getThreadId()) {
                this.cellVoltageTabItem.updateVoltageLimitsSelection();
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorer.this.cellVoltageTabItem.updateVoltageLimitsSelection();
                    }
                });
            }
        }
    }

    public void updateFileCommentWindow() {
        if (this.fileCommentTabItem != null) {
            if (Thread.currentThread().getId() == application.getThreadId()) {
                this.fileCommentTabItem.update();
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorer.this.fileCommentTabItem.update();
                    }
                });
            }
        }
    }

    public void updateObjectDescriptionWindow() {
        if (this.objectDescriptionTabItem != null && !this.objectDescriptionTabItem.isDisposed()) {
            if (Thread.currentThread().getId() == application.getThreadId()) {
                this.objectDescriptionTabItem.update();
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorer.this.objectDescriptionTabItem.update();
                    }
                });
            }
        }
    }

    public void cleanHeaderAndCommentInGraphicsWindow() {
        if (Thread.currentThread().getId() == application.getThreadId()) {
            this.graphicsTabItem.clearHeaderAndComment();
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataExplorer.this.graphicsTabItem.clearHeaderAndComment();
                }
            });
        }
    }

    public DeviceSelectionDialog getDeviceSelectionDialog() {
        return this.deviceSelectionDialog;
    }

    public void setStatusMessage(final String message, final int swtColor) {
        if (this.statusBar != null) {
            if (Thread.currentThread().getId() == application.getThreadId()) {
                this.statusBar.setMessage(message, swtColor);
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorer.this.statusBar.setMessage(message, swtColor);
                    }
                });
            }
        }
    }

    public void setStatusMessage(final String message) {
        if (this.statusBar != null) {
            if (Thread.currentThread().getId() == application.getThreadId()) {
                this.statusBar.setMessage(message);
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorer.this.statusBar.setMessage(message);
                    }
                });
            }
        }
    }

    public void setProgress(final int percentage, final String user) {
        if (this.statusBar != null && (this.progressBarUser == null || user == null || this.progressBarUser.equals(user))) {
            this.progressBarUser = percentage > 99 | percentage == 0 ? null : user;
            if (Thread.currentThread().getId() == application.getThreadId()) {
                this.statusBar.setProgress(percentage);
                if (this.taskBarItem != null) {
                    if (user == null) {
                        this.taskBarItem.setProgressState(-1);
                    } else {
                        this.taskBarItem.setProgressState(GDE.IS_MAC ? 4 : 0);
                    }
                    this.taskBarItem.setProgress(percentage);
                }
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorer.this.statusBar.setProgress(percentage);
                        if (DataExplorer.this.taskBarItem != null) {
                            if (user == null) {
                                DataExplorer.this.taskBarItem.setProgressState(-1);
                            } else {
                                DataExplorer.this.taskBarItem.setProgressState(GDE.IS_MAC ? 4 : 0);
                            }
                            DataExplorer.this.taskBarItem.setProgress(percentage);
                        }
                    }
                });
            }
            this.progessPercentage = percentage;
            if (percentage >= 100) {
                this.resetProgressBar();
            }
        }
    }

    private void resetProgressBar() {
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                DataExplorer.this.statusBar.setProgress(0);
                if (DataExplorer.this.taskBarItem != null) {
                    DataExplorer.this.taskBarItem.setProgress(0);
                }
            }
        });
    }

    public int getProgressPercentage() {
        if (Thread.currentThread().getId() == application.getThreadId()) {
            this.progessPercentage = this.statusBar.getProgressPercentage();
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataExplorer.this.progessPercentage = DataExplorer.this.statusBar.getProgressPercentage();
                }
            });
        }
        return this.progessPercentage == 100 ? 0 : this.progessPercentage;
    }

    public void setSerialTxOn() {
        if (this.isTxOn[0]) {
            this.isTxOn[0] = false;
            GDE.display.asyncExec(this.txOn);
        }
    }

    public void setSerialTxOff() {
        if (this.isTxOff[0]) {
            this.isTxOff[0] = false;
            GDE.display.asyncExec(this.txOff);
        }
    }

    public void setSerialRxOn() {
        if (this.isRxOn[0]) {
            this.isRxOn[0] = false;
            GDE.display.asyncExec(this.rxOn);
        }
    }

    public void setSerialRxOff() {
        if (this.isRxOff[0]) {
            this.isRxOff[0] = false;
            GDE.display.asyncExec(this.rxOff);
        }
    }

    public IDevice getActiveDevice() {
        return this.analyzer.getActiveDevice();
    }

    public void openDeviceDialog() {
        if (this.getDeviceDialog() != null) {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataExplorer.this.getDeviceDialog().open();
                }
            });
        }
    }

    public void setActiveDevice(IDevice device) {
        if (device != null) {
            if (this.getActiveDevice() == null || !this.getActiveDevice().getName().equals(device.getName())) {
                this.analyzer.setActiveDevice(device);
            }
            this.settings.setActiveDevice(device.getName() + ";" + device.getManufacturer() + ";" + device.getPort());
            this.updateTitleBar(this.getObjectKey(), device.getName(), device.getPort());
            if (this.deviceSelectionDialog.getNumberOfActiveDevices() > 1) {
                this.enableDeviceSwitchButtons(true);
            } else {
                this.enableDeviceSwitchButtons(false);
            }
        } else {
            this.settings.setActiveDevice("---;---;---");
            this.updateTitleBar(this.getObjectKey(), Messages.getString("GDE_MSGI0023"), "");
            IDevice nullDevice = null;
            this.analyzer.setActiveDevice(nullDevice);
            this.analyzer.getChannels().cleanup();
            this.enableDeviceSwitchButtons(false);
            this.setHisto(false);
        }
        if (this.utilGraphicsTabItem != null) {
            this.utilGraphicsTabItem.dispose();
            this.utilGraphicsTabItem = null;
        }
        for (CTabItem tab : this.customTabItems) {
            tab.dispose();
        }
        this.customTabItems.clear();
    }

    public void updateTitleBar(String objectName, String deviceName, String devicePort) {
        String actualFileName;
        StringBuilder sb = new StringBuilder().append("DataExplorer");
        String separator = "  -  ";
        String string = actualFileName = this.analyzer.getActiveChannel() != null ? this.analyzer.getActiveChannel().getFileName() : null;
        if (actualFileName != null && actualFileName.length() > 4) {
            sb.append(separator).append(actualFileName);
        }
        if (!(objectName == null || objectName.length() <= 0 || actualFileName != null && actualFileName.length() > 4 && actualFileName.contains(objectName) || objectName.startsWith(Messages.getString("GDE_MSGT0200").split(";")[0]))) {
            sb.append(separator).append(objectName);
        }
        if (deviceName != null && deviceName.length() > 0) {
            sb.append(separator).append(deviceName);
        }
        if (devicePort != null && devicePort.length() > 0) {
            sb.append(separator).append(devicePort);
        }
        final String headerText = sb.toString();
        if (Thread.currentThread().getId() == application.getThreadId()) {
            GDE.shell.setText(headerText);
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    GDE.shell.setText(headerText);
                }
            });
        }
    }

    public void updateTitleBar() {
        final IDevice actualDevice = this.getActiveDevice();
        if (actualDevice != null) {
            if (Thread.currentThread().getId() == application.getThreadId()) {
                this.updateTitleBar(this.getObjectKey(), actualDevice.getName(), actualDevice.getPort());
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorer.this.updateTitleBar(DataExplorer.this.getObjectKey(), actualDevice.getName(), actualDevice.getPort());
                    }
                });
            }
        }
    }

    public void openMessageDialog(final String message) {
        if (Thread.currentThread().getId() == application.getThreadId()) {
            MessageBox messageDialog = new MessageBox(GDE.shell, 40);
            messageDialog.setText("DataExplorer");
            messageDialog.setMessage(message);
            messageDialog.open();
        } else {
            GDE.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageBox messageDialog = new MessageBox(GDE.shell, 40);
                    messageDialog.setText("DataExplorer");
                    messageDialog.setMessage(message);
                    messageDialog.open();
                }
            });
        }
    }

    public void openMessageDialog(final Shell parent, final String message) {
        if (Thread.currentThread().getId() == application.getThreadId()) {
            Shell useParent = parent != null && !parent.isDisposed() ? parent : GDE.shell;
            MessageBox messageDialog = new MessageBox(useParent, 40);
            messageDialog.setText("DataExplorer");
            messageDialog.setMessage(message);
            messageDialog.open();
        } else {
            GDE.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell useParent = parent != null && !parent.isDisposed() ? parent : GDE.shell;
                    MessageBox messageDialog = new MessageBox(useParent, 40);
                    messageDialog.setText("DataExplorer");
                    messageDialog.setMessage(message);
                    messageDialog.open();
                }
            });
        }
    }

    public void openMessageDialogAsync(final String message) {
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox messageDialog = new MessageBox(GDE.shell, 40);
                messageDialog.setText("DataExplorer");
                messageDialog.setMessage(message);
                messageDialog.open();
            }
        });
    }

    public void openMessageDialogAsync(Shell parent, final String message) {
        final Shell useParent = parent != null && !parent.isDisposed() ? parent : GDE.shell;
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox messageDialog = new MessageBox(useParent, 40);
                messageDialog.setText("DataExplorer");
                messageDialog.setMessage(message);
                messageDialog.open();
            }
        });
    }

    public int openOkCancelMessageDialog(Shell parent, String message) {
        Shell useParent = parent != null && !parent.isDisposed() ? parent : GDE.shell;
        MessageBox okCancelMessageDialog = new MessageBox(useParent, 33060);
        okCancelMessageDialog.setText("DataExplorer");
        okCancelMessageDialog.setMessage(message);
        return okCancelMessageDialog.open();
    }

    public int openOkCancelMessageDialog(String message) {
        MessageBox okCancelMessageDialog = new MessageBox(this.getShell(), 33060);
        okCancelMessageDialog.setText("DataExplorer");
        okCancelMessageDialog.setMessage(message);
        return okCancelMessageDialog.open();
    }

    public int openYesNoMessageDialog(Shell parent, String message) {
        Shell useParent = parent != null && !parent.isDisposed() ? parent : GDE.shell;
        MessageBox yesNoMessageDialog = new MessageBox(useParent, 32964);
        yesNoMessageDialog.setText("DataExplorer");
        yesNoMessageDialog.setMessage(message);
        return yesNoMessageDialog.open();
    }

    public int openYesNoMessageDialog(String message) {
        MessageBox yesNoMessageDialog = new MessageBox(GDE.shell, 32964);
        yesNoMessageDialog.setText("DataExplorer");
        yesNoMessageDialog.setMessage(message);
        return yesNoMessageDialog.open();
    }

    public int openYesNoMessageDialogSync(final String message) {
        this.openYesNoMessageDialogAsyncValue = -1;
        GDE.display.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox yesNoMessageDialog = new MessageBox(GDE.shell, 32964);
                yesNoMessageDialog.setText("DataExplorer");
                yesNoMessageDialog.setMessage(message);
                DataExplorer.this.openYesNoMessageDialogAsyncValue = yesNoMessageDialog.open();
            }
        });
        int counter = 5000;
        while (this.openYesNoMessageDialogAsyncValue == -1 && counter-- > 0) {
            WaitTimer.delay(100L);
        }
        return this.openYesNoMessageDialogAsyncValue;
    }

    public int openYesNoCancelMessageDialog(Shell parent, String message) {
        Shell useParent = parent != null && !parent.isDisposed() ? parent : GDE.shell;
        MessageBox yesNoCancelMessageDialog = new MessageBox(useParent, 33220);
        yesNoCancelMessageDialog.setText("DataExplorer");
        yesNoCancelMessageDialog.setMessage(message);
        return yesNoCancelMessageDialog.open();
    }

    public boolean openUpdateMessageDialogSync() {
        this.openUpdateMessageDialogSyncValue = false;
        GDE.display.syncExec(new Runnable(){

            @Override
            public void run() {
                UpdateMessageBox updateMessageBox = new UpdateMessageBox(GDE.shell, 34848);
                DataExplorer.this.openUpdateMessageDialogSyncValue = updateMessageBox.open();
            }
        });
        int counter = 10000;
        while (this.openUpdateMessageDialogSyncValue == null && counter-- > 0) {
            WaitTimer.delay(100L);
        }
        return this.openUpdateMessageDialogSyncValue;
    }

    public void openAboutDialog() {
        new AboutDialog(GDE.shell, 32768).open();
    }

    public DeviceDialog getDeviceDialog() {
        return this.getActiveDevice() != null ? this.getActiveDevice().getDialog() : null;
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public void updateSubHistoryMenuItem(String addFilePath) {
        this.menuBar.updateSubHistoryMenuItem(addFilePath);
    }

    public MenuToolBar getMenuToolBar() {
        return this.menuToolBar;
    }

    public boolean isObjectoriented() {
        return this.menuToolBar != null ? this.menuToolBar.isObjectoriented() : false;
    }

    public String getObjectKey() {
        return this.menuToolBar != null ? (this.menuToolBar.isObjectoriented() ? this.menuToolBar.getActiveObjectKey() : "") : "";
    }

    public String[] getObjectKeys() {
        return this.settings.getObjectList();
    }

    public void selectObjectKey(final String newObjectKey) {
        if (this.settings != null && !this.analyzer.getChannels().getActiveChannel().getObjectKey().equals(newObjectKey)) {
            String[] objectKeys = this.settings.getObjectList();
            for (int searchSelectionIndex = 0; searchSelectionIndex < objectKeys.length; ++searchSelectionIndex) {
                if (!newObjectKey.equals(objectKeys[searchSelectionIndex])) continue;
                log.fine(() -> String.format("channel number %d - actual object key %s", this.analyzer.getChannels().getActiveChannel().getNumber(), this.analyzer.getChannels().getActiveChannel().getObjectKey()));
                if (Thread.currentThread().getId() == application.getThreadId()) {
                    this.menuToolBar.selectObjectKey(searchSelectionIndex);
                    this.analyzer.getActiveChannel().setObjectKey(newObjectKey);
                    break;
                }
                final int selectionIndex = searchSelectionIndex;
                GDE.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorer.this.menuToolBar.selectObjectKey(selectionIndex);
                        DataExplorer.this.analyzer.getActiveChannel().setObjectKey(newObjectKey);
                    }
                });
                break;
            }
        }
    }

    public void checkSaveObjectData() {
        if (this.objectDescriptionTabItem != null) {
            this.objectDescriptionTabItem.checkSaveObjectData();
        }
    }

    public String getObjectFilePath() {
        String objectkey = this.menuToolBar.getActiveObjectKey();
        FileUtils.checkDirectoryAndCreate(Settings.getInstance().getDataFilePath() + "/" + objectkey);
        return this.settings.getDataFilePath() + "/" + objectkey + "/";
    }

    public void setObjectList(final String[] newObjectKeyList, final String newObjectKey) {
        if (Thread.currentThread().getId() == application.getThreadId()) {
            this.menuToolBar.setObjectList(newObjectKeyList, newObjectKey);
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataExplorer.this.menuToolBar.setObjectList(newObjectKeyList, newObjectKey);
                }
            });
        }
    }

    public void setObjectListElements() {
        if (Thread.currentThread().getId() == application.getThreadId()) {
            this.menuToolBar.setObjectListElements();
        } else {
            GDE.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    DataExplorer.this.menuToolBar.setObjectListElements();
                }
            });
        }
    }

    public boolean isObjectSelectorEditable() {
        boolean objectSelectorEditable = true;
        if (Thread.currentThread().getId() == application.getThreadId()) {
            objectSelectorEditable = DataExplorer.getInstance().getMenuToolBar().isObjectSelectorEditable();
        } else {
            final boolean[] isObjectSelectorEditable = new boolean[]{true};
            GDE.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    isObjectSelectorEditable[0] = DataExplorer.getInstance().getMenuToolBar().isObjectSelectorEditable();
                }
            });
            objectSelectorEditable = isObjectSelectorEditable[0];
        }
        return objectSelectorEditable;
    }

    public void enableZoomMenuButtons(boolean enabled) {
        this.menuToolBar.enableZoomToolBar(enabled);
        this.menuBar.enableZoomMenuButtons(enabled);
    }

    public void enableDeviceSwitchButtons(boolean enabled) {
        this.menuToolBar.enableDeviceSwitchButtons(enabled);
        this.menuBar.enableDeviceSwitchButtons(enabled);
    }

    public void enableMenuActions(final boolean enabled) {
        if (Thread.currentThread().getId() == application.getThreadId()) {
            this.menuToolBar.enableDeviceSwitchButtons(enabled);
            this.menuBar.enableDeviceSwitchButtons(enabled);
            this.menuToolBar.enableChannelActions(enabled);
            this.menuToolBar.enableRecordSetActions(enabled);
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataExplorer.this.menuToolBar.enableDeviceSwitchButtons(enabled);
                    DataExplorer.this.menuBar.enableDeviceSwitchButtons(enabled);
                    DataExplorer.this.menuToolBar.enableChannelActions(enabled);
                    DataExplorer.this.menuToolBar.enableRecordSetActions(enabled);
                }
            });
        }
    }

    public void updateChannelSelector(int activeChannel) {
        String[] channelNames = new String[this.analyzer.getChannels().size()];
        for (int i = 0; i < channelNames.length; ++i) {
            channelNames[i] = ((Channel)this.analyzer.getChannels().get(i + 1)).getName();
        }
        CCombo channelSelect = this.menuToolBar.getChannelSelectCombo();
        channelSelect.setItems(channelNames);
        channelSelect.select(activeChannel);
    }

    public void updateRecordSelector(int activeRecord) {
        String[] recordNames;
        Channel activeChannel = this.analyzer.getActiveChannel();
        if (activeChannel != null && (recordNames = activeChannel.getRecordSetNames()) != null && recordNames.length > 0 && recordNames[0] != null) {
            CCombo recordSelect = this.menuToolBar.getRecordSelectCombo();
            recordSelect.setItems(recordNames);
            recordSelect.select(activeRecord);
        }
    }

    public void updateMenusRegardingGPSData() {
        this.menuBar.updateAdditionalGPSMenuItems();
        this.menuToolBar.updateGoogleEarthToolItem();
    }

    public FileDialog prepareFileOpenDialog(String name, String[] extensions, String path, String fileName, int addStyle) {
        String $METHOD_NAME = "fileOpenDialogPath";
        FileDialog fileOpenDialog = new FileDialog(GDE.shell, 0x9000 | addStyle);
        if (path != null) {
            String string = path = !(path = path.replace("/", GDE.FILE_SEPARATOR)).endsWith(GDE.FILE_SEPARATOR) ? path + GDE.FILE_SEPARATOR : path;
        }
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.logp(gde.log.Level.FINER, $CLASS_NAME, "fileOpenDialogPath", "dialogName = " + name + " path = " + path);
        }
        fileOpenDialog.setText(name);
        fileOpenDialog.setFileName(fileName == null ? "" : fileName);
        if (extensions != null) {
            this.adaptFilter(fileOpenDialog, extensions);
        }
        if (path != null) {
            fileOpenDialog.setFilterPath(path);
        }
        return fileOpenDialog;
    }

    public FileDialog openFileOpenDialog(String name, String[] extensions, String path, String fileName, int addStyle) {
        String $METHOD_NAME = "openFileOpenDialog";
        FileDialog fileOpenDialog = new FileDialog(GDE.shell, 0x9000 | addStyle);
        if (path != null) {
            String string = path = !(path = path.replace("/", GDE.FILE_SEPARATOR)).endsWith(GDE.FILE_SEPARATOR) ? path + GDE.FILE_SEPARATOR : path;
        }
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.logp(gde.log.Level.FINER, $CLASS_NAME, "openFileOpenDialog", "dialogName = " + name + " path = " + path);
        }
        fileOpenDialog.setText(name);
        fileOpenDialog.setFileName(fileName == null ? "" : fileName);
        if (extensions != null) {
            this.adaptFilter(fileOpenDialog, extensions);
        }
        if (path != null) {
            fileOpenDialog.setFilterPath(path);
        }
        fileOpenDialog.open();
        return fileOpenDialog;
    }

    private void adaptFilter(FileDialog fileOpenDialog, String[] extensions) {
        if (!GDE.IS_WINDOWS) {
            Vector<String> tmpExt = new Vector<String>();
            for (String extension : extensions) {
                if (!extension.equals("*.*")) {
                    tmpExt.add(extension);
                    tmpExt.add(extension.toUpperCase());
                    continue;
                }
                tmpExt.add("*");
            }
            extensions = tmpExt.toArray(new String[1]);
        }
        fileOpenDialog.setFilterExtensions(extensions);
        fileOpenDialog.setFilterNames(this.getExtensionDescription(extensions));
    }

    public FileDialog openFileOpenDialog(Shell parent, String name, String[] extensions, String path, String fileName, int addStyle) {
        String $METHOD_NAME = "openFileOpenDialog";
        FileDialog fileOpenDialog = new FileDialog(parent, 0x9000 | addStyle);
        if (path != null) {
            String string = path = !(path = path.replace("/", GDE.FILE_SEPARATOR)).endsWith(GDE.FILE_SEPARATOR) ? path + GDE.FILE_SEPARATOR : path;
        }
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.logp(gde.log.Level.FINER, $CLASS_NAME, "openFileOpenDialog", "dialogName = " + name + " path = " + path);
        }
        fileOpenDialog.setText(name);
        fileOpenDialog.setFileName(fileName == null ? "" : fileName);
        if (extensions != null) {
            this.adaptFilter(fileOpenDialog, extensions);
        }
        if (path != null) {
            fileOpenDialog.setFilterPath(path);
        }
        fileOpenDialog.open();
        return fileOpenDialog;
    }

    public FileDialog prepareFileSaveDialog(String name, String[] extensions, String path, String fileName) {
        String $METHOD_NAME = "openFileSaveDialog";
        FileDialog fileSaveDialog = new FileDialog(GDE.shell, 40960);
        if (path != null) {
            String string = path = !(path = path.replace("/", GDE.FILE_SEPARATOR)).endsWith(GDE.FILE_SEPARATOR) ? path + GDE.FILE_SEPARATOR : path;
        }
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.logp(gde.log.Level.FINER, $CLASS_NAME, "openFileSaveDialog", "dialogName = " + name + " path = " + path);
        }
        fileSaveDialog.setText(name);
        if (extensions != null) {
            this.adaptFilter(fileSaveDialog, extensions);
        }
        if (path != null) {
            fileSaveDialog.setFilterPath(path);
        }
        fileSaveDialog.setFileName(fileName != null && fileName.length() > 5 ? fileName : "");
        return fileSaveDialog;
    }

    public FileDialog prepareFileSaveDialog(Shell parent, String name, String[] extensions, String path, String fileName) {
        String $METHOD_NAME = "openFileSaveDialog";
        FileDialog fileSaveDialog = new FileDialog(parent, 57344);
        if (path != null) {
            String string = path = !(path = path.replace("/", GDE.FILE_SEPARATOR)).endsWith(GDE.FILE_SEPARATOR) ? path + GDE.FILE_SEPARATOR : path;
        }
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.logp(gde.log.Level.FINER, $CLASS_NAME, "openFileSaveDialog", "dialogName = " + name + " path = " + path);
        }
        fileSaveDialog.setText(name);
        if (extensions != null) {
            this.adaptFilter(fileSaveDialog, extensions);
        }
        if (path != null) {
            fileSaveDialog.setFilterPath(path);
        }
        fileSaveDialog.setFileName(fileName != null && fileName.length() > 5 ? fileName : "");
        return fileSaveDialog;
    }

    public String[] getExtensionDescription(String[] extensions) {
        String[] filterNames = new String[extensions.length];
        for (int i = 0; i < filterNames.length; ++i) {
            int beginIndex = extensions[i].indexOf(46);
            String tmpExt = beginIndex != -1 ? extensions[i].substring(beginIndex + 1) : extensions[i];
            filterNames[i] = this.extensionFilterMap.get(tmpExt.toLowerCase());
            if (filterNames[i] == null) {
                filterNames[i] = extensions[i];
                continue;
            }
            beginIndex = filterNames[i].indexOf(46);
            if (beginIndex <= 0) continue;
            String tmpFilterExt = filterNames[i].substring(filterNames[i].indexOf(46) + 1, filterNames[i].length() - 1);
            filterNames[i] = tmpExt.equals(tmpFilterExt) ? filterNames[i] : filterNames[i].replace(tmpFilterExt, tmpExt);
        }
        return filterNames;
    }

    public String openDirFileDialog(String name, String path) {
        String $METHOD_NAME = "openDirFileDialog";
        DirectoryDialog fileDirDialog = new DirectoryDialog(GDE.shell, 32768);
        if (path != null) {
            String string = path = !(path = path.replace("/", GDE.FILE_SEPARATOR)).endsWith(GDE.FILE_SEPARATOR) ? path + GDE.FILE_SEPARATOR : path;
        }
        if (log.isLoggable(gde.log.Level.FINER)) {
            log.logp(gde.log.Level.FINER, $CLASS_NAME, "openDirFileDialog", "dialogName = " + name + " path = " + path);
        }
        fileDirDialog.setText(name);
        if (path != null) {
            fileDirDialog.setFilterPath(path);
        }
        return fileDirDialog.open();
    }

    public RGB openColorDialog() {
        ColorDialog colorDialog = new ColorDialog(GDE.shell);
        colorDialog.setText(((Object)((Object)this)).getClass().getSimpleName() + Messages.getString("GDE_MSGT0145"));
        return colorDialog.open();
    }

    public int openFontSizeDialog() {
        FontSizeDialog fontSizeDialog = new FontSizeDialog(GDE.shell, 0);
        fontSizeDialog.setText(((Object)((Object)this)).getClass().getSimpleName() + Messages.getString("GDE_MSGT0145"));
        return fontSizeDialog.open(new String[]{"20", "25", "30", "35", "40", "45", "50", "55", "60", "65", "70"}, 6);
    }

    public void updateAllTabs(boolean force) {
        this.updateAllTabs(force, true);
    }

    public void updateAllTabs(final boolean force, final boolean redrawCurveSelector) {
        if (this.isUpdateAllTabs) {
            this.isUpdateAllTabs = false;
            if (Thread.currentThread().getId() == application.getThreadId()) {
                this.doUpdateAllTabs(force, redrawCurveSelector);
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataExplorer.this.doUpdateAllTabs(force, redrawCurveSelector);
                    }
                });
            }
        }
    }

    private void doUpdateAllTabs(boolean force, boolean redrawCurveSelector) {
        this.updateGraphicsWindow(redrawCurveSelector);
        this.updateStatisticsData();
        if (force) {
            this.updateDigitalWindow();
            this.updateAnalogWindow();
        } else {
            this.updateDigitalWindowChilds();
            this.updateAnalogWindowChilds();
        }
        this.updateCellVoltageWindow();
        this.updateFileCommentWindow();
        if (this.getActiveRecordSet() != null) {
            this.updateDataTable(this.getActiveRecordSet().getName(), force);
        } else {
            this.updateDataTable("", force);
        }
        this.isUpdateAllTabs = true;
    }

    public void updateGraphicsWindow() {
        if (this.graphicsTabItem != null) {
            this.updateGraphicsWindow(true);
        }
    }

    public void updateGraphicsWindow(final boolean refreshCurveSelector) {
        if (Thread.currentThread().getId() == application.getThreadId()) {
            if (!this.graphicsTabItem.isActiveCurveSelectorContextMenu()) {
                int tabSelectionIndex = this.displayTab.getSelectionIndex();
                if (tabSelectionIndex == 0) {
                    this.graphicsTabItem.redrawGraphics(refreshCurveSelector);
                } else if (tabSelectionIndex > 0) {
                    if (this.displayTab.getItem(tabSelectionIndex) instanceof GraphicsWindow && this.isRecordSetVisible(GraphicsWindow.GraphicsType.COMPARE)) {
                        this.compareTabItem.redrawGraphics(refreshCurveSelector);
                    } else if (this.displayTab.getItem(tabSelectionIndex) instanceof GraphicsWindow && this.isRecordSetVisible(GraphicsWindow.GraphicsType.UTIL)) {
                        this.utilGraphicsTabItem.redrawGraphics(refreshCurveSelector);
                    } else {
                        this.histoExplorer.ifPresent(h -> h.updateGraphicsWindow(refreshCurveSelector));
                    }
                }
            }
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!DataExplorer.this.graphicsTabItem.isActiveCurveSelectorContextMenu()) {
                        int tabSelectionIndex = DataExplorer.this.displayTab.getSelectionIndex();
                        if (tabSelectionIndex == 0) {
                            DataExplorer.this.graphicsTabItem.redrawGraphics(refreshCurveSelector);
                        } else if (DataExplorer.this.displayTab.getItem(tabSelectionIndex) instanceof GraphicsWindow && DataExplorer.this.isRecordSetVisible(GraphicsWindow.GraphicsType.COMPARE)) {
                            DataExplorer.this.compareTabItem.redrawGraphics(refreshCurveSelector);
                        } else if (DataExplorer.this.displayTab.getItem(tabSelectionIndex) instanceof GraphicsWindow && DataExplorer.this.isRecordSetVisible(GraphicsWindow.GraphicsType.UTIL)) {
                            DataExplorer.this.utilGraphicsTabItem.redrawGraphics(refreshCurveSelector);
                        } else {
                            DataExplorer.this.histoExplorer.ifPresent(h -> h.updateGraphicsWindow(refreshCurveSelector));
                        }
                    }
                }
            });
        }
    }

    public void updateGraphicsCaptions() {
        if (this.graphicsTabItem != null) {
            this.graphicsTabItem.updateCaptions();
        }
    }

    public void updateCurveSelectorTable() {
        if (Thread.currentThread().getId() == application.getThreadId()) {
            this.graphicsTabItem.updateCurveSelectorTable();
            if (this.compareTabItem != null && !this.compareTabItem.isDisposed()) {
                this.compareTabItem.updateCurveSelectorTable();
            }
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataExplorer.this.graphicsTabItem.updateCurveSelectorTable();
                    if (DataExplorer.this.compareTabItem != null && !DataExplorer.this.compareTabItem.isDisposed()) {
                        DataExplorer.this.compareTabItem.updateCurveSelectorTable();
                    }
                }
            });
        }
    }

    @Deprecated
    public void setRecordCommentEnabled(boolean enabled) {
        this.settings.setRecordCommentVisible(enabled);
        this.isRecordCommentVisible = enabled;
    }

    public void enableCurveSelector(boolean value) {
        this.graphicsTabItem.setCurveSelectorEnabled(value);
        this.histoExplorer.ifPresent(h -> h.enableCurveSelector(value));
        this.isCurveSelectorEnabled = value;
    }

    public void setGraphicsSashFormWeights(int newSelectorCopositeWidth, GraphicsWindow.GraphicsType graphicsType) {
        switch (graphicsType) {
            case COMPARE: {
                this.compareTabItem.setSashFormWeights(newSelectorCopositeWidth);
                break;
            }
            case UTIL: {
                this.utilGraphicsTabItem.setSashFormWeights(newSelectorCopositeWidth);
                break;
            }
            default: {
                this.graphicsTabItem.setSashFormWeights(newSelectorCopositeWidth);
            }
        }
    }

    public void openSettingsDialog() {
        this.settingsDialog = new SettingsDialog(GDE.shell, 32768);
        this.settingsDialog.open();
    }

    public void updateDisplayTab() {
        this.displayTab.redraw();
    }

    public void updateCompareWindow() {
        this.compareTabItem.redrawGraphics(true);
    }

    public boolean isWithCompareSet() {
        return this.compareSet != null && !this.compareSet.isEmpty();
    }

    public boolean isWithUtilitySet() {
        return this.utilitySet != null && !this.utilitySet.isEmpty();
    }

    public RecordSet getCompareSet() {
        return this.compareSet == null ? (this.compareSet = new RecordSet(this.analyzer, "", COMPARE_RECORD_SET, 1.0, GraphicsWindow.GraphicsType.COMPARE)) : this.compareSet;
    }

    public RecordSet getUtilitySet() {
        return this.utilitySet == null ? (this.utilitySet = new RecordSet(this.analyzer, "", UTILITY_RECORD_SET, 1.0, GraphicsWindow.GraphicsType.UTIL)) : this.utilitySet;
    }

    public GraphicsWindow getUtilGraphicsWindow(String tabName) {
        return this.setUtilGraphicsWindowVisible(true, tabName);
    }

    public boolean isRecordSetVisible(GraphicsWindow.GraphicsType type) {
        boolean result = false;
        switch (type) {
            case COMPARE: {
                result = this.compareTabItem != null && !this.compareTabItem.isDisposed() && this.compareTabItem.isVisible();
                break;
            }
            case UTIL: {
                result = this.utilGraphicsTabItem != null && !this.utilGraphicsTabItem.isDisposed() && this.utilGraphicsTabItem.isVisible();
                break;
            }
            default: {
                result = this.graphicsTabItem.isVisible();
            }
        }
        return result;
    }

    @Nullable
    public AbstractRecordSet getRecordSetOfVisibleTab() {
        if (this.isRecordSetVisible(GraphicsWindow.GraphicsType.NORMAL)) {
            return this.getActiveRecordSet();
        }
        if (this.isRecordSetVisible(GraphicsWindow.GraphicsType.COMPARE)) {
            return this.compareSet;
        }
        if (this.isRecordSetVisible(GraphicsWindow.GraphicsType.UTIL)) {
            return this.utilitySet;
        }
        if (this.histoExplorer.map(h -> h.isHistoChartWindowVisible()).orElse(false).booleanValue()) {
            return this.getPresentHistoExplorer().getHistoSet().getTrailRecordSet();
        }
        return this.getActiveRecordSet();
    }

    public void resetGraphicsWindowZoomAndMeasurement() {
        if (Thread.currentThread().getId() == application.getThreadId()) {
            this.graphicsTabItem.setModeState(GraphicsComposite.GraphicsMode.RESET);
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataExplorer.this.graphicsTabItem.setModeState(GraphicsComposite.GraphicsMode.RESET);
                }
            });
        }
    }

    public void setGraphicsMode(GraphicsComposite.GraphicsMode graphicsMode, boolean enabled) {
        String $METHOD_NAME = "setGraphicsMode";
        if (this.isRecordSetVisible(GraphicsWindow.GraphicsType.NORMAL)) {
            if (log.isLoggable(gde.log.Level.FINE)) {
                log.logp(gde.log.Level.FINE, $CLASS_NAME, "setGraphicsMode", "graphicsWindow.getGraphicCanvas().isVisible() == true");
            }
            this.setGraphicsWindowMode(graphicsMode, enabled);
        } else if (this.isRecordSetVisible(GraphicsWindow.GraphicsType.COMPARE) && graphicsMode != GraphicsComposite.GraphicsMode.SCOPE) {
            if (log.isLoggable(gde.log.Level.FINE)) {
                log.logp(gde.log.Level.FINE, $CLASS_NAME, "setGraphicsMode", "compareWindow.getGraphicCanvas().isVisible() == true");
            }
            this.setCompareWindowMode(graphicsMode, enabled);
        } else if (this.isRecordSetVisible(GraphicsWindow.GraphicsType.UTIL) && log.isLoggable(gde.log.Level.FINE)) {
            log.logp(gde.log.Level.FINE, $CLASS_NAME, "setGraphicsMode", "utilityWindow.getGraphicCanvas().isVisible() == true, it does not have a supported graphics mode");
        }
    }

    public void setGraphicsWindowMode(GraphicsComposite.GraphicsMode graphicsMode, boolean enabled) {
        RecordSet recordSet = Channels.getInstance().getActiveChannel().getActiveRecordSet();
        if (recordSet != null) {
            switch (graphicsMode) {
                case ZOOM: {
                    recordSet.resetMeasurement();
                    recordSet.setZoomMode(enabled);
                    this.graphicsTabItem.setModeState(graphicsMode);
                    break;
                }
                case SCOPE: {
                    recordSet.resetZoomAndMeasurement();
                    recordSet.setScopeSizeRecordPoints(this.getMenuToolBar().getScopeModeLevelValue());
                    this.graphicsTabItem.setModeState(graphicsMode);
                    this.updateGraphicsWindow();
                    break;
                }
                case PAN: {
                    if (!recordSet.isPanMode()) {
                        this.openMessageDialog(Messages.getString("GDE_MSGE0007"));
                        break;
                    }
                    recordSet.resetMeasurement();
                    this.graphicsTabItem.setModeState(graphicsMode);
                    break;
                }
                default: {
                    recordSet.resetZoomAndMeasurement();
                    this.graphicsTabItem.setModeState(graphicsMode);
                    this.updateGraphicsWindow();
                }
            }
        }
    }

    public void setCompareWindowMode(GraphicsComposite.GraphicsMode graphicsMode, boolean enabled) {
        if (application.isWithCompareSet()) {
            RecordSet recordSet = application.getCompareSet();
            switch (graphicsMode) {
                case ZOOM: {
                    recordSet.resetMeasurement();
                    recordSet.setZoomMode(enabled);
                    if (this.compareTabItem == null || this.compareTabItem.isDisposed()) break;
                    this.compareTabItem.setModeState(graphicsMode);
                    break;
                }
                case PAN: {
                    if (!recordSet.isPanMode()) {
                        this.openMessageDialog(Messages.getString("GDE_MSGE0007"));
                        break;
                    }
                    recordSet.resetMeasurement();
                    if (this.compareTabItem == null || this.compareTabItem.isDisposed()) break;
                    this.compareTabItem.setModeState(graphicsMode);
                    break;
                }
                default: {
                    recordSet.resetZoomAndMeasurement();
                    if (this.compareTabItem != null && !this.compareTabItem.isDisposed()) {
                        this.compareTabItem.setModeState(graphicsMode);
                    }
                    this.updateGraphicsWindow();
                }
            }
        }
    }

    public void clearMeasurementModes() {
        RecordSet recordSet;
        boolean isGraphicsTypeNormal = this.isRecordSetVisible(GraphicsWindow.GraphicsType.NORMAL);
        RecordSet recordSet2 = recordSet = isGraphicsTypeNormal ? Channels.getInstance().getActiveChannel().getActiveRecordSet() : this.compareSet;
        if (recordSet != null) {
            if (isGraphicsTypeNormal) {
                recordSet.clearMeasurementModes();
                this.graphicsTabItem.getGraphicsComposite().cleanMeasurementPointer();
            } else if (this.compareTabItem != null && !this.compareTabItem.isDisposed() && this.isWithCompareSet()) {
                recordSet = application.getCompareSet();
                recordSet.clearMeasurementModes();
                this.compareTabItem.getGraphicsComposite().cleanMeasurementPointer();
            }
        }
    }

    public void setMeasurementActive(String recordKey, boolean enabled) {
        boolean isGraphicsTypeNormal;
        RecordSet recordSet;
        if (log.isLoggable(gde.log.Level.FINE)) {
            log.log(gde.log.Level.FINE, recordKey);
        }
        RecordSet recordSet2 = recordSet = (isGraphicsTypeNormal = this.isRecordSetVisible(GraphicsWindow.GraphicsType.NORMAL)) ? Channels.getInstance().getActiveChannel().getActiveRecordSet() : this.compareSet;
        if (recordSet != null && recordSet.containsKey(recordKey)) {
            if (isGraphicsTypeNormal) {
                recordSet.setMeasurementMode(recordKey, enabled);
                this.graphicsTabItem.getGraphicsComposite().cleanMeasurementPointer();
                if (enabled) {
                    this.graphicsTabItem.getGraphicsComposite().drawMeasurePointer(null, recordSet, GraphicsComposite.GraphicsMode.MEASURE, false);
                }
            } else if (this.compareTabItem != null && !this.compareTabItem.isDisposed() && (recordSet = application.getCompareSet()) != null && recordSet.containsKey(recordKey)) {
                recordSet.setMeasurementMode(recordKey, enabled);
                if (enabled) {
                    this.compareTabItem.getGraphicsComposite().drawMeasurePointer(null, recordSet, GraphicsComposite.GraphicsMode.MEASURE, false);
                } else {
                    this.compareTabItem.getGraphicsComposite().cleanMeasurementPointer();
                }
            }
        }
    }

    public void setDeltaMeasurementActive(String recordKey, boolean enabled) {
        boolean isGraphicsTypeNormal;
        RecordSet recordSet;
        if (log.isLoggable(gde.log.Level.FINE)) {
            log.log(gde.log.Level.FINE, recordKey);
        }
        RecordSet recordSet2 = recordSet = (isGraphicsTypeNormal = this.isRecordSetVisible(GraphicsWindow.GraphicsType.NORMAL)) ? Channels.getInstance().getActiveChannel().getActiveRecordSet() : this.compareSet;
        if (recordSet != null && recordSet.containsKey(recordKey)) {
            if (isGraphicsTypeNormal) {
                recordSet.setDeltaMeasurementMode(recordKey, enabled);
                this.graphicsTabItem.getGraphicsComposite().cleanMeasurementPointer();
                if (enabled) {
                    this.graphicsTabItem.getGraphicsComposite().drawMeasurePointer(null, recordSet, GraphicsComposite.GraphicsMode.MEASURE_DELTA, false);
                }
            } else if (this.compareTabItem != null && !this.compareTabItem.isDisposed() && (recordSet = application.getCompareSet()) != null && recordSet.containsKey(recordKey)) {
                recordSet.setDeltaMeasurementMode(recordKey, enabled);
                if (enabled) {
                    this.compareTabItem.getGraphicsComposite().drawMeasurePointer(null, recordSet, GraphicsComposite.GraphicsMode.MEASURE_DELTA, false);
                } else {
                    this.compareTabItem.getGraphicsComposite().cleanMeasurementPointer();
                }
            }
        }
    }

    public void setAvgMedianMeasurementActive(String recordKey, boolean enabled) {
        boolean isGraphicsTypeNormal;
        RecordSet recordSet;
        if (log.isLoggable(gde.log.Level.FINE)) {
            log.log(gde.log.Level.FINE, recordKey);
        }
        RecordSet recordSet2 = recordSet = (isGraphicsTypeNormal = this.isRecordSetVisible(GraphicsWindow.GraphicsType.NORMAL)) ? Channels.getInstance().getActiveChannel().getActiveRecordSet() : this.compareSet;
        if (recordSet != null && recordSet.containsKey(recordKey)) {
            if (isGraphicsTypeNormal) {
                recordSet.setAvgMedianMeasurementMode(recordKey, enabled);
                this.graphicsTabItem.getGraphicsComposite().cleanMeasurementPointer();
                if (enabled) {
                    this.graphicsTabItem.getGraphicsComposite().drawMeasurePointer(null, recordSet, GraphicsComposite.GraphicsMode.MEASURE_DELTA, false);
                }
            } else if (this.compareTabItem != null && !this.compareTabItem.isDisposed() && (recordSet = application.getCompareSet()) != null && recordSet.containsKey(recordKey)) {
                recordSet.setAvgMedianMeasurementMode(recordKey, enabled);
                if (enabled) {
                    this.compareTabItem.getGraphicsComposite().drawMeasurePointer(null, recordSet, GraphicsComposite.GraphicsMode.MEASURE_DELTA, false);
                } else {
                    this.compareTabItem.getGraphicsComposite().cleanMeasurementPointer();
                }
            }
        }
    }

    public void setCutModeActive(boolean leftEnabled, boolean rightEnabled) {
        if (leftEnabled || rightEnabled) {
            if (leftEnabled) {
                this.graphicsTabItem.getGraphicsComposite().drawCutPointer(null, GraphicsComposite.GraphicsMode.CUT_LEFT, leftEnabled, rightEnabled);
            } else if (rightEnabled) {
                this.graphicsTabItem.getGraphicsComposite().drawCutPointer(null, GraphicsComposite.GraphicsMode.CUT_RIGHT, leftEnabled, rightEnabled);
            } else {
                this.graphicsTabItem.getGraphicsComposite().drawCutPointer(null, GraphicsComposite.GraphicsMode.RESET, false, false);
            }
        } else {
            this.graphicsTabItem.getGraphicsComposite().drawCutPointer(null, GraphicsComposite.GraphicsMode.RESET, false, false);
        }
    }

    public void setCursor(final Cursor newCursor) {
        if (Thread.currentThread().getId() == application.getThreadId()) {
            application.getParent().setCursor(newCursor);
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    application.getParent().setCursor(newCursor);
                }
            });
        }
    }

    public long getThreadId() {
        return this.threadId;
    }

    public void setPortConnected(final boolean isOpenStatus) {
        if (Thread.currentThread().getId() == application.getThreadId()) {
            this.menuBar.setPortConnected(isOpenStatus);
            this.menuToolBar.setPortConnected(isOpenStatus);
            if (this.statusBar != null) {
                if (isOpenStatus) {
                    this.statusBar.setSerialPortConnected();
                } else {
                    this.statusBar.setSerialPortDisconnected();
                    this.statusBar.setSerialRxOff();
                    this.statusBar.setSerialTxOff();
                }
            }
        } else if (this.statusBar != null) {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    DataExplorer.this.menuBar.setPortConnected(isOpenStatus);
                    DataExplorer.this.menuToolBar.setPortConnected(isOpenStatus);
                    if (isOpenStatus) {
                        DataExplorer.this.statusBar.setSerialPortConnected();
                    } else {
                        DataExplorer.this.statusBar.setSerialPortDisconnected();
                        DataExplorer.this.statusBar.setSerialRxOff();
                        DataExplorer.this.statusBar.setSerialTxOff();
                    }
                }
            });
        }
    }

    public void openHelpDialog(String deviceName, String fileName) {
        String $METHOD_NAME = "openHelpDialog";
        try {
            if (this.helpDialog == null || this.helpDialog.isDisposed()) {
                this.helpDialog = new HelpInfoDialog(GDE.shell, 0);
            }
            this.helpDialog.open(deviceName, fileName, 0, false);
        }
        catch (Error e) {
            if (log.isLoggable(gde.log.Level.FINE)) {
                log.logp(gde.log.Level.FINE, $CLASS_NAME, "openHelpDialog", "using OS registered web browser");
            }
            WebBrowser.openURL(deviceName, fileName);
            application.openMessageDialogAsync(Messages.getString("GDE_MSGI0025"));
        }
        catch (Throwable t) {
            application.openMessageDialog(Messages.getString("GDE_MSGE0007") + t.getClass().getSimpleName() + " - " + t.getMessage());
        }
    }

    public void openHelpDialog(String deviceName, String fileName, boolean extractBase) {
        String $METHOD_NAME = "openHelpDialog";
        try {
            if (this.helpDialog == null || this.helpDialog.isDisposed()) {
                this.helpDialog = new HelpInfoDialog(GDE.shell, 0);
            }
            this.helpDialog.open(deviceName, fileName, 0, extractBase);
        }
        catch (Error e) {
            if (log.isLoggable(gde.log.Level.FINE)) {
                log.logp(gde.log.Level.FINE, $CLASS_NAME, "openHelpDialog", "using OS registered web browser");
            }
            WebBrowser.openURL(deviceName, fileName);
            application.openMessageDialogAsync(Messages.getString("GDE_MSGI0025"));
        }
        catch (Throwable t) {
            application.openMessageDialog(Messages.getString("GDE_MSGE0007") + t.getClass().getSimpleName() + " - " + t.getMessage());
        }
    }

    public void openWebBrowser(String stringURL) {
        WebBrowser.openBrowser(stringURL);
    }

    public boolean isDeviceDialogModal() {
        return this.isDeviceDialogModal;
    }

    public void enableGraphicsHeader(boolean enabled) {
        this.graphicsTabItem.enableGraphicsHeader(enabled);
        this.histoExplorer.ifPresent(h -> h.enableGraphicsHeader(enabled));
        this.settings.setGraphicsHeaderVisible(enabled);
        this.isGraphicsHeaderVisible = enabled;
    }

    public void enableRecordSetComment(boolean enabled) {
        this.graphicsTabItem.enableRecordSetComment(enabled);
        this.histoExplorer.ifPresent(h -> h.enableRecordSetComment(enabled));
        this.settings.setRecordCommentVisible(enabled);
        this.isRecordCommentVisible = enabled;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void updateObjectImage() {
        if (this.objectDescriptionTabItem != null) {
            this.objectDescriptionTabItem.redrawImageCanvas();
        }
    }

    public void checkUpdateFileComment() {
        if (Thread.currentThread().getId() == application.getThreadId()) {
            if (this.fileCommentTabItem != null && this.fileCommentTabItem.isFileCommentChanged()) {
                this.fileCommentTabItem.setFileComment();
            }
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (DataExplorer.this.fileCommentTabItem != null && DataExplorer.this.fileCommentTabItem.isFileCommentChanged()) {
                        DataExplorer.this.fileCommentTabItem.setFileComment();
                    }
                }
            });
        }
    }

    public boolean isFileCommentChanged() {
        return this.fileCommentTabItem.isFileCommentChanged();
    }

    public void checkUpdateRecordSetComment() {
        if (Thread.currentThread().getId() == application.getThreadId()) {
            if (this.graphicsTabItem != null && this.graphicsTabItem.getGraphicsComposite().isRecordCommentChanged()) {
                this.graphicsTabItem.getGraphicsComposite().updateRecordSetComment();
            }
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (DataExplorer.this.graphicsTabItem.getGraphicsComposite().isRecordCommentChanged()) {
                        DataExplorer.this.graphicsTabItem.getGraphicsComposite().updateRecordSetComment();
                    }
                }
            });
        }
    }

    public boolean isRecordCommentChanged() {
        return this.graphicsTabItem.getGraphicsComposite().isRecordCommentChanged();
    }

    public Image getGraphicsPrintImage() {
        Optional histoImage = this.histoExplorer.flatMap(h -> h.getGraphicsPrintImage());
        return this.isRecordSetVisible(GraphicsWindow.GraphicsType.COMPARE) ? this.compareTabItem.getGraphicsComposite().getGraphicsPrintImage() : (this.isRecordSetVisible(GraphicsWindow.GraphicsType.UTIL) ? this.utilGraphicsTabItem.getGraphicsComposite().getGraphicsPrintImage() : (histoImage.isPresent() ? (Image)histoImage.get() : this.graphicsTabItem.getGraphicsComposite().getGraphicsPrintImage()));
    }

    public Image getGraphicsTabContentAsImage() {
        return this.isRecordSetVisible(GraphicsWindow.GraphicsType.COMPARE) ? this.compareTabItem.getContentAsImage() : (this.isRecordSetVisible(GraphicsWindow.GraphicsType.COMPARE) ? this.utilGraphicsTabItem.getContentAsImage() : this.graphicsTabItem.getContentAsImage());
    }

    public Image getStatisticsTabContentAsImage() {
        return this.statisticsTabItem.getContentAsImage();
    }

    public String getStatisticsAsText() {
        return this.statisticsTabItem.getContentAsText();
    }

    public Image getTableTabContentAsImage() {
        return this.dataTableTabItem.getContentAsImage();
    }

    public Image getDigitalTabContentAsImage() {
        return this.digitalTabItem.getContentAsImage();
    }

    public Image getAnalogTabContentAsImage() {
        return this.analogTabItem.getContentAsImage();
    }

    public Image getCellVoltageTabContentAsImage() {
        return this.cellVoltageTabItem.getContentAsImage();
    }

    public Image getFileDescriptionTabContentAsImage() {
        return this.fileCommentTabItem.getContentAsImage();
    }

    public Image getObjectTabContentAsImage() {
        return this.objectDescriptionTabItem.getContentAsImage();
    }

    public void copyTabContentAsImage() {
        Optional histoImage;
        Image graphicsImage = null;
        int tabSelectionIndex = this.displayTab.getSelectionIndex();
        graphicsImage = tabSelectionIndex == 0 ? this.graphicsTabItem.getContentAsImage() : (this.displayTab.getItem(tabSelectionIndex) instanceof StatisticsWindow ? this.statisticsTabItem.getContentAsImage() : (this.displayTab.getItem(tabSelectionIndex) instanceof DataTableWindow ? this.dataTableTabItem.getContentAsImage() : (this.displayTab.getItem(tabSelectionIndex) instanceof DigitalWindow ? this.digitalTabItem.getContentAsImage() : (this.displayTab.getItem(tabSelectionIndex) instanceof AnalogWindow ? this.analogTabItem.getContentAsImage() : (this.displayTab.getItem(tabSelectionIndex) instanceof CellVoltageWindow ? this.cellVoltageTabItem.getContentAsImage() : (this.displayTab.getItem(tabSelectionIndex) instanceof FileCommentWindow ? this.fileCommentTabItem.getContentAsImage() : (this.displayTab.getItem(tabSelectionIndex) instanceof ObjectDescriptionWindow ? this.objectDescriptionTabItem.getContentAsImage() : (this.displayTab.getItem(tabSelectionIndex) instanceof GraphicsWindow && this.isRecordSetVisible(GraphicsWindow.GraphicsType.COMPARE) ? this.compareTabItem.getContentAsImage() : (this.displayTab.getItem(tabSelectionIndex) instanceof GraphicsWindow && this.isRecordSetVisible(GraphicsWindow.GraphicsType.UTIL) ? this.utilGraphicsTabItem.getContentAsImage() : ((histoImage = this.histoExplorer.flatMap(h -> h.getContentAsImage())).isPresent() ? (Image)histoImage.get() : this.graphicsTabItem.getContentAsImage()))))))))));
        Clipboard clipboard = new Clipboard(GDE.display);
        clipboard.setContents(new Object[]{graphicsImage.getImageData()}, new Transfer[]{ImageTransfer.getInstance()});
        clipboard.dispose();
        graphicsImage.dispose();
    }

    public void copyGraphicsPrintImage() {
        Image graphicsImage = this.getGraphicsPrintImage();
        Clipboard clipboard = new Clipboard(GDE.display);
        clipboard.setContents(new Object[]{graphicsImage.getImageData()}, new Transfer[]{ImageTransfer.getInstance()});
        clipboard.dispose();
        graphicsImage.dispose();
    }

    public void selectTab(Predicate<? super CTabItem> tabFilter) {
        this.displayTab.setSelection(Arrays.stream(this.getTabFolder().getItems()).filter(tabFilter).findFirst().orElseThrow(UnsupportedOperationException::new));
        this.displayTab.showSelection();
    }

    public void selectTab(int index) {
        this.displayTab.setSelection(index);
        this.displayTab.showSelection();
    }

    public int getTabSelectionIndex() {
        return this.displayTab.getSelectionIndex();
    }

    public void setInnerAreaBackground(int tabSelectionIndex, Color innerAreaBackground) {
        if (tabSelectionIndex == 0) {
            this.settings.setGraphicsCurveAreaBackground(innerAreaBackground);
            this.graphicsTabItem.setCurveAreaBackground(innerAreaBackground);
        } else if (tabSelectionIndex > 0) {
            if (this.displayTab.getItem(tabSelectionIndex) instanceof StatisticsWindow) {
                this.settings.setSatisticsInnerAreaBackground(innerAreaBackground);
                this.statisticsTabItem.setInnerAreaBackground(innerAreaBackground);
            } else if (this.displayTab.getItem(tabSelectionIndex) instanceof DigitalWindow) {
                this.settings.setDigitalInnerAreaBackground(innerAreaBackground);
                this.digitalTabItem.setInnerAreaBackground(innerAreaBackground);
            } else if (this.displayTab.getItem(tabSelectionIndex) instanceof AnalogWindow) {
                this.settings.setAnalogInnerAreaBackground(innerAreaBackground);
                this.analogTabItem.setInnerAreaBackground(innerAreaBackground);
            } else if (this.displayTab.getItem(tabSelectionIndex) instanceof CellVoltageWindow) {
                this.settings.setCellVoltageInnerAreaBackground(innerAreaBackground);
                this.cellVoltageTabItem.setInnerAreaBackground(innerAreaBackground);
            } else if (this.displayTab.getItem(tabSelectionIndex) instanceof FileCommentWindow) {
                this.settings.setFileCommentInnerAreaBackground(innerAreaBackground);
                this.fileCommentTabItem.setInnerAreaBackground(innerAreaBackground);
            } else if (this.displayTab.getItem(tabSelectionIndex) instanceof ObjectDescriptionWindow) {
                this.settings.setObjectDescriptionInnerAreaBackground(innerAreaBackground);
                this.objectDescriptionTabItem.setInnerAreaBackground(innerAreaBackground);
            } else if (this.displayTab.getItem(tabSelectionIndex) instanceof GraphicsWindow && this.isRecordSetVisible(GraphicsWindow.GraphicsType.COMPARE)) {
                this.settings.setCompareCurveAreaBackground(innerAreaBackground);
                this.compareTabItem.setCurveAreaBackground(innerAreaBackground);
            } else if (this.displayTab.getItem(tabSelectionIndex) instanceof GraphicsWindow && this.isRecordSetVisible(GraphicsWindow.GraphicsType.UTIL)) {
                this.settings.setUtilityCurveAreaBackground(innerAreaBackground);
                this.utilGraphicsTabItem.setCurveAreaBackground(innerAreaBackground);
            } else {
                this.histoExplorer.ifPresent(h -> h.setInnerAreaBackground(innerAreaBackground));
            }
        }
    }

    public void setBorderColor(int tabItemIndex, Color borderColor) {
        if (tabItemIndex == 0) {
            this.settings.setCurveGraphicsBorderColor(borderColor);
            this.graphicsTabItem.setCurveAreaBorderColor(borderColor);
        } else if (tabItemIndex > 0) {
            if (this.displayTab.getItem(tabItemIndex) instanceof GraphicsWindow && this.isRecordSetVisible(GraphicsWindow.GraphicsType.COMPARE)) {
                this.settings.setCurveCompareBorderColor(borderColor);
                this.compareTabItem.setCurveAreaBorderColor(borderColor);
            } else if (this.displayTab.getItem(tabItemIndex) instanceof GraphicsWindow && this.isRecordSetVisible(GraphicsWindow.GraphicsType.UTIL)) {
                this.settings.setUtilityCurvesBorderColor(borderColor);
                this.utilGraphicsTabItem.setCurveAreaBorderColor(borderColor);
            } else {
                this.histoExplorer.ifPresent(h -> h.setBorderColor(borderColor));
            }
        }
    }

    public void setTabFontSize(int tabSelectionIndex, int newFonSize) {
        if (tabSelectionIndex != 0 && tabSelectionIndex > 0 && this.displayTab.getItem(tabSelectionIndex) instanceof DigitalWindow) {
            this.digitalTabItem.setDigitalDisplayFontSize(newFonSize);
            this.updateDigitalWindowChilds();
        }
    }

    public void setSurroundingBackground(int tabSelectionIndex, Color surroundingBackground) {
        if (tabSelectionIndex == 0) {
            this.settings.setGraphicsSurroundingBackground(surroundingBackground);
            this.graphicsTabItem.setSurroundingBackground(surroundingBackground);
        } else if (tabSelectionIndex > 0) {
            if (this.displayTab.getItem(tabSelectionIndex) instanceof StatisticsWindow) {
                this.settings.setSatisticsSurroundingAreaBackground(surroundingBackground);
                this.statisticsTabItem.setSurroundingAreaBackground(surroundingBackground);
            } else if (this.displayTab.getItem(tabSelectionIndex) instanceof DigitalWindow) {
                this.settings.setDigitalSurroundingAreaBackground(surroundingBackground);
                this.digitalTabItem.setSurroundingAreaBackground(surroundingBackground);
            } else if (this.displayTab.getItem(tabSelectionIndex) instanceof AnalogWindow) {
                this.settings.setAnalogSurroundingAreaBackground(surroundingBackground);
                this.analogTabItem.setSurroundingAreaBackground(surroundingBackground);
            } else if (this.displayTab.getItem(tabSelectionIndex) instanceof CellVoltageWindow) {
                this.settings.setCellVoltageSurroundingAreaBackground(surroundingBackground);
                this.cellVoltageTabItem.setSurroundingAreaBackground(surroundingBackground);
            } else if (this.displayTab.getItem(tabSelectionIndex) instanceof FileCommentWindow) {
                this.settings.setFileCommentSurroundingAreaBackground(surroundingBackground);
                this.fileCommentTabItem.setSurroundingAreaBackground(surroundingBackground);
            } else if (this.displayTab.getItem(tabSelectionIndex) instanceof ObjectDescriptionWindow) {
                this.settings.setObjectDescriptionSurroundingAreaBackground(surroundingBackground);
                this.objectDescriptionTabItem.setSurroundingAreaBackground(surroundingBackground);
            } else if (this.displayTab.getItem(tabSelectionIndex) instanceof GraphicsWindow && this.isRecordSetVisible(GraphicsWindow.GraphicsType.COMPARE)) {
                this.settings.setCompareSurroundingBackground(surroundingBackground);
                this.compareTabItem.setSurroundingBackground(surroundingBackground);
            } else if (this.displayTab.getItem(tabSelectionIndex) instanceof GraphicsWindow && this.isRecordSetVisible(GraphicsWindow.GraphicsType.UTIL)) {
                this.settings.setUtilitySurroundingBackground(surroundingBackground);
                this.utilGraphicsTabItem.setSurroundingBackground(surroundingBackground);
            } else {
                this.histoExplorer.ifPresent(h -> h.setSurroundingBackground(surroundingBackground));
            }
        }
    }

    public void setAbsoluteDateTime(boolean enable) {
        RecordSet activeRecordSet;
        this.dataTableTabItem.setAbsoluteDateTime(enable);
        this.dataTableTabItem.setHeader();
        Channel activeChannel = this.analyzer.getActiveChannel();
        RecordSet recordSet = activeRecordSet = activeChannel != null ? activeChannel.getActiveRecordSet() : null;
        if (activeRecordSet != null) {
            this.dataTableTabItem.setRowCount(activeRecordSet.getRecordDataSize(false));
        }
    }

    public void setDataTableTabItemVisible(boolean visible) {
        if (visible) {
            if (this.dataTableTabItem == null || this.dataTableTabItem.isDisposed()) {
                this.dataTableTabItem = new DataTableWindow(this.displayTab, 0, 2);
                this.dataTableTabItem.create();
            }
        } else if (this.dataTableTabItem != null && !this.dataTableTabItem.isDisposed()) {
            this.dataTableTabItem.dispose();
            this.dataTableTabItem = null;
        }
    }

    public void setDigitalTabItemVisible(boolean visible) {
        if (visible) {
            if (this.digitalTabItem == null || this.digitalTabItem.isDisposed()) {
                int position = this.displayTab.getItem(2) instanceof DataTableWindow ? 3 : 2;
                this.digitalTabItem = new DigitalWindow(this.displayTab, 0, position);
                this.digitalTabItem.create();
            }
        } else if (this.digitalTabItem != null && !this.digitalTabItem.isDisposed()) {
            this.digitalTabItem.dispose();
            this.digitalTabItem = null;
        }
    }

    public void setAnalogTabItemVisible(boolean visible) {
        if (visible) {
            if (this.analogTabItem == null || this.analogTabItem.isDisposed()) {
                int position = this.displayTab.getItem(2) instanceof DataTableWindow && this.displayTab.getItem(3) instanceof DigitalWindow ? 4 : (this.displayTab.getItem(2) instanceof DataTableWindow || this.displayTab.getItem(2) instanceof DigitalWindow ? 3 : 2);
                this.analogTabItem = new AnalogWindow(this.displayTab, 0, position);
                this.analogTabItem.create();
            }
        } else if (this.analogTabItem != null && !this.analogTabItem.isDisposed()) {
            this.analogTabItem.dispose();
            this.analogTabItem = null;
        }
    }

    public void setCellVoltageTabItemVisible(boolean visible) {
        if (visible) {
            if (this.cellVoltageTabItem == null || this.cellVoltageTabItem.isDisposed()) {
                int position = 2;
                CTabItem[] tabItems = this.displayTab.getItems();
                for (int i = 1; i < tabItems.length; ++i) {
                    if (!(tabItems[i] instanceof GraphicsWindow) && !(tabItems[i] instanceof FileCommentWindow)) continue;
                    position = i;
                }
                this.cellVoltageTabItem = new CellVoltageWindow(this.displayTab, 0, position);
                this.cellVoltageTabItem.create();
            }
        } else if (this.cellVoltageTabItem != null && !this.cellVoltageTabItem.isDisposed()) {
            this.cellVoltageTabItem.dispose();
            this.cellVoltageTabItem = null;
        }
    }

    public void createCompareWindowTabItem() {
        if (this.compareTabItem == null || this.compareTabItem.isDisposed()) {
            for (int i = 0; i < this.displayTab.getItemCount(); ++i) {
                CTabItem tabItem = this.displayTab.getItems()[i];
                if (!(tabItem instanceof FileCommentWindow)) continue;
                this.compareTabItem = new GraphicsWindow(this.displayTab, 0, GraphicsWindow.GraphicsType.COMPARE, Messages.getString("GDE_MSGT0144"), i);
                this.compareTabItem.create();
                break;
            }
        }
    }

    public void setObjectDescriptionTabVisible(final boolean visible) {
        if (Thread.currentThread().getId() == application.getThreadId()) {
            if (visible) {
                if (this.objectDescriptionTabItem == null || this.objectDescriptionTabItem.isDisposed()) {
                    for (int i = 0; i < this.displayTab.getItemCount(); ++i) {
                        CTabItem tabItem = this.displayTab.getItems()[i];
                        if (!(tabItem instanceof FileCommentWindow)) continue;
                        this.objectDescriptionTabItem = new ObjectDescriptionWindow(this.displayTab, 0, i + 1);
                        this.objectDescriptionTabItem.create();
                        break;
                    }
                }
            } else if (this.objectDescriptionTabItem != null) {
                this.objectDescriptionTabItem.dispose();
                this.objectDescriptionTabItem = null;
            }
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (visible) {
                        if (DataExplorer.this.objectDescriptionTabItem == null || DataExplorer.this.objectDescriptionTabItem.isDisposed()) {
                            for (int i = 0; i < DataExplorer.this.displayTab.getItemCount(); ++i) {
                                CTabItem tabItem = DataExplorer.this.displayTab.getItems()[i];
                                if (!(tabItem instanceof FileCommentWindow)) continue;
                                DataExplorer.this.objectDescriptionTabItem = new ObjectDescriptionWindow(DataExplorer.this.displayTab, 0, i + 1);
                                DataExplorer.this.objectDescriptionTabItem.create();
                                break;
                            }
                        }
                    } else if (DataExplorer.this.objectDescriptionTabItem != null) {
                        DataExplorer.this.objectDescriptionTabItem.dispose();
                        DataExplorer.this.objectDescriptionTabItem = null;
                    }
                }
            });
        }
    }

    public void updateCurrentObjectData(String newObjectKey) {
        if (this.objectDescriptionTabItem != null) {
            this.objectDescriptionTabItem.setObject(this.objectDescriptionTabItem.getObject(), newObjectKey);
            this.updateObjectDescriptionWindow();
        }
    }

    public GraphicsWindow setUtilGraphicsWindowVisible(boolean visible, String tabName) {
        if (visible) {
            if (this.utilGraphicsTabItem == null || this.utilGraphicsTabItem.isDisposed()) {
                this.utilGraphicsTabItem = new GraphicsWindow(this.displayTab, 0, GraphicsWindow.GraphicsType.UTIL, tabName.length() < 3 ? Messages.getString("GDE_MSGT0282") : tabName, this.displayTab.getItemCount());
                this.utilGraphicsTabItem.create();
            }
        } else if (this.utilGraphicsTabItem != null) {
            this.utilGraphicsTabItem.dispose();
            this.utilGraphicsTabItem = null;
        }
        return this.utilGraphicsTabItem;
    }

    public void registerCustomTabItem(CTabItem customDeviceTabItem) {
        if (customDeviceTabItem == null) {
            for (CTabItem tab : this.customTabItems) {
                tab.dispose();
            }
            this.customTabItems.clear();
        } else {
            this.customTabItems.add(customDeviceTabItem);
        }
    }

    public CTabFolder getTabFolder() {
        return this.displayTab;
    }

    public void resetShellIcon() {
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                GDE.shell.setImage(SWTResourceManager.getImage(GDE.IS_MAC ? "gde/resource/DataExplorer_MAC.png" : "gde/resource/DataExplorer.png"));
            }
        });
    }

    public ObjectData getObject() {
        return this.objectDescriptionTabItem.getObject();
    }

    public ObjectData getActiveObject() {
        if (this.objectDescriptionTabItem != null && !this.objectDescriptionTabItem.isDisposed()) {
            return this.objectDescriptionTabItem.getObject();
        }
        return null;
    }

    public RecordSet getActiveRecordSet() {
        RecordSet activeRecordSet = null;
        Channel activeChannnel = this.analyzer.getActiveChannel();
        if (activeChannnel != null) {
            activeRecordSet = activeChannnel.getActiveRecordSet();
        }
        return activeRecordSet;
    }

    public int getActiveChannelNumber() {
        int activeChannelNumber = 1;
        if (this.analyzer != null && this.analyzer.getActiveChannel() != null) {
            activeChannelNumber = this.analyzer.getActiveChannel().getNumber();
        }
        return activeChannelNumber;
    }

    public Channel getActiveChannel() {
        return this.analyzer.getActiveChannel();
    }

    public void switchPreviousTabulator() {
        CTabItem[] tabItems = this.displayTab.getItems();
        for (int i = 0; i < tabItems.length; ++i) {
            CTabItem tabItem = tabItems[i];
            if (!tabItem.getControl().isVisible()) continue;
            if (i - 1 >= 0) {
                tabItem.getParent().setSelection(i - 1);
                break;
            }
            tabItem.getParent().setSelection(tabItems.length - 1);
            break;
        }
    }

    public void switchNextTabulator() {
        CTabItem[] tabItems = this.displayTab.getItems();
        for (int i = 0; i < tabItems.length; ++i) {
            CTabItem tabItem = tabItems[i];
            if (!tabItem.getControl().isVisible()) continue;
            if (i + 1 <= tabItems.length - 1) {
                tabItem.getParent().setSelection(i + 1);
                break;
            }
            tabItem.getParent().setSelection(0);
            break;
        }
    }

    public synchronized void updateExtensionFilterMap(String key, String value) {
        this.extensionFilterMap.put(key, value);
    }

    public void enableWritingTmpFiles(boolean enable) {
        if (enable && (this.writeTmpFileThread == null || !this.writeTmpFileThread.isAlive())) {
            this.isTmpWriteStop = false;
            this.writeTmpFileThread = new Thread("write_tmp"){

                @Override
                public void run() {
                    while (!DataExplorer.this.isTmpWriteStop) {
                        try {
                            int cycleCount = 0;
                            while (!DataExplorer.this.isTmpWriteStop && cycleCount++ < 300) {
                                Thread.sleep(1000L);
                            }
                            if (DataExplorer.this.isTmpWriteStop) break;
                            String tmpFilePath = Settings.getApplHomePath() + "/" + "~TempFile";
                            if (log.isLoggable(gde.log.Level.FINE)) {
                                log.log(gde.log.Level.FINE, "attempt to save a temporary file(s)");
                            }
                            if (DataExplorer.this.analyzer.getActiveChannel() != null && DataExplorer.this.analyzer.getActiveChannel().getType() == ChannelTypes.TYPE_CONFIG) {
                                if (DataExplorer.this.analyzer.getActiveChannel().getActiveRecordSet() == null) continue;
                                OsdReaderWriter.write(tmpFilePath + ".osd", DataExplorer.this.analyzer.getActiveChannel(), 4);
                                continue;
                            }
                            for (int i = 1; i <= DataExplorer.this.analyzer.getChannels().size() && DataExplorer.this.analyzer.getActiveChannel().getActiveRecordSet() != null; ++i) {
                                if (((Channel)DataExplorer.this.analyzer.getChannels().get(i)).size() <= 0) continue;
                                OsdReaderWriter.write(tmpFilePath + "_" + i + ".osd", (Channel)DataExplorer.this.analyzer.getChannels().get(i), 4);
                            }
                        }
                        catch (Exception e) {
                            log.log(gde.log.Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
            };
            this.writeTmpFileThread.start();
        } else {
            this.isTmpWriteStop = true;
        }
    }

    public void check4update() {
        final String[] versionCheck = FileUtils.isUpdateAvailable();
        if (Boolean.valueOf(versionCheck[0]).booleanValue() && this.openUpdateMessageDialogSync()) {
            new Thread("Download"){

                @Override
                public void run() {
                    try {
                        String downloadUrl = "https://download.savannah.gnu.org/releases/dataexplorer/";
                        String arch = System.getProperty("sun.arch.data.model");
                        String version = versionCheck[1];
                        String filename = "";
                        if (GDE.IS_WINDOWS) {
                            filename = "DataExplorer_Setup_" + version + "_win" + arch + ".exe";
                        } else if (GDE.IS_LINUX && GDE.IS_OS_ARCH_ARM) {
                            filename = "dataexplorer-" + version + "-bin_RaspbianLinux_ARM_" + arch + ".tar.gz";
                        } else if (GDE.IS_LINUX && !GDE.IS_OS_ARCH_ARM) {
                            filename = "dataexplorer-" + version + "-bin_GNULinux_x86_" + arch + ".tar.gz";
                        } else if (GDE.IS_MAC) {
                            filename = "DataExplorer-" + version + "_Mac_" + arch + ".dmg";
                        }
                        final String targetFilePath = GDE.JAVA_IO_TMPDIR + "/" + filename;
                        if (!new File(targetFilePath).exists()) {
                            FileUtils.downloadFile(new URL(downloadUrl + filename), targetFilePath);
                        }
                        GDE.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (GDE.IS_LINUX) {
                                    URL url = GDE.class.getProtectionDomain().getCodeSource().getLocation();
                                    if (url.getFile().endsWith(".jar")) {
                                        String installpath = url.getFile().substring(0, url.getPath().lastIndexOf(47));
                                        installpath = installpath.substring(0, installpath.lastIndexOf(47));
                                        String command = "cd " + installpath + "; sudo tar -xzf " + targetFilePath + "\"";
                                        log.log(gde.log.Level.FINE, "command = " + command);
                                        MessageBox message = new MessageBox(GDE.shell, 2);
                                        message.setText("DataExplorer");
                                        message.setMessage(Messages.getString("GDE_MSGI0055", new String[]{command}));
                                        message.open();
                                    }
                                } else {
                                    MessageBox message = new MessageBox(GDE.shell, 194);
                                    message.setText("DataExplorer");
                                    message.setMessage(Messages.getString("GDE_MSGI0053"));
                                    if (64 == message.open()) {
                                        OperatingSystemHelper.launchInstallApplication(targetFilePath);
                                        GDE.shell.dispose();
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    public void reloadLanguageRelatedResources() {
        Messages.reloadResources();
        DeviceXmlResource.reloadResources();
    }

    public Optional<HistoExplorer> getHistoExplorer() {
        return this.histoExplorer;
    }

    public HistoExplorer getPresentHistoExplorer() {
        return this.histoExplorer.orElseThrow(UnsupportedOperationException::new);
    }

    public void setColorSchemaColors(String schema) {
        switch (schema) {
            default: {
                this.COLOR_BACKGROUND = SWTResourceManager.getColor(22);
                this.COLOR_FOREGROUND = SWTResourceManager.getColor(21);
                break;
            }
            case "color_schema_light": {
                this.COLOR_BACKGROUND = SWTResourceManager.getColor(15);
                this.COLOR_FOREGROUND = SWTResourceManager.getColor(2);
                break;
            }
            case "color_schema_dark": {
                this.COLOR_BACKGROUND = SWTResourceManager.getColor(80, 80, 80);
                this.COLOR_FOREGROUND = SWTResourceManager.getColor(1);
            }
        }
        if (this.menuCoolBar != null) {
            this.setBackground(this.COLOR_BACKGROUND);
            this.menuCoolBar.setBackground(this.COLOR_BACKGROUND);
            this.menuToolBar.updateColorSchema();
            this.displayTab.setBackground(new Color[]{this.COLOR_BACKGROUND, this.settings.getGraphicsSurroundingBackground()}, new int[]{100}, true);
            this.displayTab.setForeground(this.COLOR_FOREGROUND);
            this.graphicsTabItem.updateColorSchema();
            this.statusBar.updateColorSchema();
        }
        this.histoExplorer.ifPresent(h -> h.updateColorSchema());
    }
}

