/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DataTypes;
import gde.device.DeviceDialog;
import gde.device.MeasurementPropertyTypes;
import gde.device.PropertyType;
import gde.device.smmodellbau.UniLog2;
import gde.device.smmodellbau.UniLog2LiveGatherer;
import gde.device.smmodellbau.UniLog2SerialPort;
import gde.device.smmodellbau.UniLog2SetupConfiguration1;
import gde.device.smmodellbau.UniLog2SetupConfiguration2;
import gde.device.smmodellbau.UniLog2SetupReaderWriter;
import gde.device.smmodellbau.UniLog2VisualizationControl;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class UniLog2Dialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(UniLog2Dialog.class.getName());
    static final String PROP_n100W = MeasurementPropertyTypes.PROP_N_100_W.value();
    CTabFolder tabFolder;
    CTabItem configurationTabItem;
    Composite configurationMainComposite;
    UniLog2SetupConfiguration1 configuration1Composite;
    UniLog2SetupConfiguration2 configuration2Composite;
    Button saveChangesButton;
    Button inputFileButton;
    Button helpButton;
    Button liveGathererButton;
    Button closeButton;
    CTabItem gpsLoggerTabItem;
    CTabItem telemetryTabItem;
    UniLog2LiveGatherer liveThread;
    final UniLog2 device;
    final Settings settings;
    final Channels channels;
    final UniLog2SerialPort serialPort;
    UniLog2SetupReaderWriter loggerSetup;
    RecordSet lastActiveRecordSet = null;
    boolean isVisibilityChanged = false;
    int measurementsCount = 0;

    public UniLog2Dialog(Shell parent, UniLog2 useDevice) {
        super(parent);
        this.device = useDevice;
        this.serialPort = useDevice.getCommunicationPort();
        this.settings = Settings.getInstance();
        this.channels = Channels.getInstance();
        for (int i = 1; i <= this.device.getChannelCount(); ++i) {
            this.measurementsCount = 15;
        }
    }

    public void open() {
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            log.log(Level.FINE, "dialogShell.isDisposed() " + (this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                this.loggerSetup = new UniLog2SetupReaderWriter(this.dialogShell, this.device);
                FormLayout dialogShellLayout = new FormLayout();
                this.dialogShell.setLayout((Layout)dialogShellLayout);
                this.dialogShell.layout();
                this.dialogShell.pack();
                this.dialogShell.setSize(650, 190 + this.measurementsCount * 32 + 50 + 70);
                this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                UniLog2Dialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        log.log(Level.FINEST, "dialogShell.widgetDisposed, event=" + evt);
                        if (UniLog2Dialog.this.device.isChangePropery()) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{UniLog2Dialog.this.device.getPropertiesFileName()});
                            if (UniLog2Dialog.this.application.openYesNoMessageDialog(UniLog2Dialog.this.getDialogShell(), msg) == 64) {
                                log.log(Level.FINE, "SWT.YES");
                                UniLog2Dialog.this.device.storeDeviceProperties();
                                UniLog2Dialog.this.setClosePossible(true);
                            }
                        }
                        UniLog2Dialog.this.dispose();
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        log.log(Level.FINER, "dialogShell.helpRequested, event=" + evt);
                        UniLog2Dialog.this.application.openHelpDialog(Messages.getString((String)"GDE_MSGT2510"), "HelpInfo.html");
                    }
                });
                this.dialogShell.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                    public void mouseEnter(MouseEvent evt) {
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "dialogShell.mouseEnter, event=" + evt);
                        }
                        UniLog2Dialog.this.fadeOutAplhaBlending(evt, UniLog2Dialog.this.getDialogShell().getClientArea(), 10, 10, 10, 15);
                    }

                    public void mouseHover(MouseEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "dialogShell.mouseHover, event=" + evt);
                        }
                    }

                    public void mouseExit(MouseEvent evt) {
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "dialogShell.mouseExit, event=" + evt);
                        }
                        UniLog2Dialog.this.fadeInAlpaBlending(evt, UniLog2Dialog.this.getDialogShell().getClientArea(), 10, 10, -10, 15);
                    }
                });
                this.dialogShell.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent paintevent) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "dialogShell.paintControl, event=" + paintevent);
                        }
                        RecordSet activeRecordSet = UniLog2Dialog.this.application.getActiveRecordSet();
                        int index = Channels.getInstance().getActiveChannelNumber();
                        if (UniLog2Dialog.this.lastActiveRecordSet == null && activeRecordSet != null || activeRecordSet != null && !UniLog2Dialog.this.lastActiveRecordSet.getName().equals(activeRecordSet.getName())) {
                            UniLog2Dialog.this.tabFolder.setSelection(index - 1);
                        }
                        UniLog2Dialog.this.lastActiveRecordSet = UniLog2Dialog.this.application.getActiveRecordSet();
                    }
                });
                this.tabFolder = new CTabFolder((Composite)this.dialogShell, 0);
                this.tabFolder.setSimple(false);
                for (int i = 0; i < this.device.getChannelCount(); ++i) {
                    this.createVisualizationTabItem(i + 1);
                }
                this.configurationTabItem = new CTabItem(this.tabFolder, 0);
                this.configurationTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.configurationTabItem.setText(Messages.getString((String)"GDE_MSGT2515"));
                this.configurationMainComposite = new Composite((Composite)this.tabFolder, 0);
                FormLayout configurationMainCompositeLayout = new FormLayout();
                this.configurationMainComposite.setLayout((Layout)configurationMainCompositeLayout);
                this.configurationTabItem.setControl((Control)this.configurationMainComposite);
                FormData layoutConfig1Data = new FormData();
                layoutConfig1Data.top = new FormAttachment(0, 1000, 0);
                layoutConfig1Data.left = new FormAttachment(0, 1000, 0);
                layoutConfig1Data.right = new FormAttachment(493, 1000, 0);
                layoutConfig1Data.bottom = new FormAttachment(1000, 1000, 0);
                this.configuration1Composite = new UniLog2SetupConfiguration1(this.configurationMainComposite, 0, this, this.loggerSetup);
                this.configuration1Composite.setLayoutData(layoutConfig1Data);
                FormData layoutConfig2Data = new FormData();
                layoutConfig2Data.top = new FormAttachment(0, 1000, 0);
                layoutConfig2Data.left = new FormAttachment(493, 1000, 0);
                layoutConfig2Data.right = new FormAttachment(1000, 1000, 0);
                layoutConfig2Data.bottom = new FormAttachment(1000, 1000, 0);
                this.configuration2Composite = new UniLog2SetupConfiguration2(this.configurationMainComposite, 0, this, this.loggerSetup);
                this.configuration2Composite.setLayoutData(layoutConfig2Data);
                FormData tabFolderLData = new FormData();
                tabFolderLData.top = new FormAttachment(0, 1000, 0);
                tabFolderLData.left = new FormAttachment(0, 1000, 0);
                tabFolderLData.right = new FormAttachment(1000, 1000, 0);
                tabFolderLData.bottom = new FormAttachment(1000, 1000, -50);
                this.tabFolder.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.tabFolder.setLayoutData((Object)tabFolderLData);
                this.tabFolder.setSelection(this.channels.getActiveChannel() != null ? this.channels.getActiveChannel().getNumber() - 1 : 0);
                this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "configTabFolder.widgetSelected, event=" + evt);
                        if (UniLog2Dialog.this.tabFolder.getSelectionIndex() == 2) {
                            UniLog2Dialog.this.configuration1Composite.changeVisibility();
                            UniLog2Dialog.this.saveChangesButton.setText(Messages.getString((String)"GDE_MSGT2518"));
                            UniLog2Dialog.this.saveChangesButton.setToolTipText(Messages.getString((String)"GDE_MSGT2524"));
                            UniLog2Dialog.this.loggerSetup.loadSetup();
                            UniLog2Dialog.this.configuration1Composite.updateValues();
                            UniLog2Dialog.this.configuration2Composite.updateValues();
                        } else {
                            UniLog2Dialog.this.saveChangesButton.setText(Messages.getString((String)"GDE_MSGT2516"));
                            UniLog2Dialog.this.saveChangesButton.setToolTipText(Messages.getString((String)"GDE_MSGT2523"));
                            int channelNumber = UniLog2Dialog.this.tabFolder.getSelectionIndex();
                            if (channelNumber >= 0 && channelNumber <= UniLog2Dialog.this.device.getChannelCount()) {
                                String configKey = ++channelNumber + " : " + ((CTabItem)evt.item).getText();
                                Channel activeChannel = UniLog2Dialog.this.channels.getActiveChannel();
                                if (activeChannel != null) {
                                    log.log(Level.FINE, "activeChannel = " + activeChannel.getName() + " configKey = " + configKey);
                                    RecordSet activeRecordSet = activeChannel.getActiveRecordSet();
                                    if (activeRecordSet != null && activeChannel.getNumber() != channelNumber) {
                                        int answer = UniLog2Dialog.this.application.openYesNoMessageDialog(UniLog2Dialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGI2501"));
                                        if (answer == 64) {
                                            String recordSetKey = activeRecordSet.getName();
                                            Channel tmpChannel = (Channel)UniLog2Dialog.this.channels.get((Object)channelNumber);
                                            if (tmpChannel != null) {
                                                log.log(Level.FINE, "move record set " + recordSetKey + " to channel/configuration " + channelNumber + " : " + configKey);
                                                tmpChannel.put((Object)recordSetKey, (Object)activeRecordSet.clone(channelNumber));
                                                activeChannel.remove(recordSetKey);
                                                UniLog2Dialog.this.channels.switchChannel(channelNumber, recordSetKey);
                                                RecordSet newActiveRecordSet = ((Channel)UniLog2Dialog.this.channels.get((Object)channelNumber)).getActiveRecordSet();
                                                if (newActiveRecordSet != null) {
                                                    UniLog2Dialog.this.device.updateVisibilityStatus(newActiveRecordSet, false);
                                                    UniLog2Dialog.this.device.makeInActiveDisplayable(newActiveRecordSet);
                                                }
                                            }
                                        }
                                        UniLog2Dialog.this.application.updateCurveSelectorTable();
                                    }
                                }
                            }
                        }
                    }
                });
                this.saveChangesButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData saveButtonLData = new FormData();
                saveButtonLData.width = 130;
                saveButtonLData.height = GDE.IS_MAC ? 33 : 30;
                saveButtonLData.left = new FormAttachment(0, 1000, 15);
                saveButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.saveChangesButton.setLayoutData((Object)saveButtonLData);
                this.saveChangesButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.saveChangesButton.setText(Messages.getString((String)"GDE_MSGT2516"));
                this.saveChangesButton.setToolTipText(Messages.getString((String)"GDE_MSGT2523"));
                this.saveChangesButton.setEnabled(false);
                this.saveChangesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "saveButton.widgetSelected, event=" + evt);
                        if (UniLog2Dialog.this.tabFolder.getSelectionIndex() == 2) {
                            UniLog2Dialog.this.loggerSetup.saveSetup();
                        } else {
                            UniLog2Dialog.this.device.storeDeviceProperties();
                        }
                        UniLog2Dialog.this.saveChangesButton.setEnabled(false);
                    }
                });
                this.inputFileButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData inputFileButtonLData = new FormData();
                inputFileButtonLData.width = 130;
                inputFileButtonLData.height = GDE.IS_MAC ? 33 : 30;
                inputFileButtonLData.left = new FormAttachment(0, 1000, 155);
                inputFileButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.inputFileButton.setLayoutData((Object)inputFileButtonLData);
                this.inputFileButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.inputFileButton.setText(Messages.getString((String)"GDE_MSGT2517"));
                this.inputFileButton.setToolTipText(Messages.getString((String)"GDE_MSGT2525"));
                this.inputFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "inputFileButton.widgetSelected, event=" + evt);
                        if (UniLog2Dialog.this.isVisibilityChanged) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{UniLog2Dialog.this.device.getPropertiesFileName()});
                            if (UniLog2Dialog.this.application.openYesNoMessageDialog(UniLog2Dialog.this.dialogShell, msg) == 64) {
                                log.log(Level.FINE, "SWT.YES");
                                UniLog2Dialog.this.device.storeDeviceProperties();
                            }
                        }
                        UniLog2Dialog.this.device.open_closeCommPort();
                    }
                });
                this.helpButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData helpButtonLData = new FormData();
                helpButtonLData.width = GDE.IS_MAC ? 50 : 40;
                helpButtonLData.height = GDE.IS_MAC ? 33 : 30;
                helpButtonLData.left = new FormAttachment(0, 1000, 302);
                helpButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.helpButton.setLayoutData((Object)helpButtonLData);
                this.helpButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.helpButton.setImage(SWTResourceManager.getImage((String)"gde/resource/QuestionHot.gif"));
                this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "helpButton.widgetSelected, event=" + evt);
                        UniLog2Dialog.this.application.openHelpDialog(Messages.getString((String)"GDE_MSGT2510"), "HelpInfo.html");
                    }
                });
                this.liveGathererButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData saveSetupButtonLData = new FormData();
                saveSetupButtonLData.width = 130;
                saveSetupButtonLData.height = GDE.IS_MAC ? 33 : 30;
                saveSetupButtonLData.right = new FormAttachment(1000, 1000, -155);
                saveSetupButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.liveGathererButton.setLayoutData((Object)saveSetupButtonLData);
                this.liveGathererButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.liveGathererButton.setToolTipText(Messages.getString((String)"GDE_MSGT2578"));
                this.liveGathererButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "liveGathererButton.widgetSelected, event=" + evt);
                        }
                        if (UniLog2Dialog.this.liveThread == null || !UniLog2Dialog.this.serialPort.isConnected()) {
                            try {
                                UniLog2Dialog.this.liveThread = new UniLog2LiveGatherer(UniLog2Dialog.this.application, UniLog2Dialog.this.device, UniLog2Dialog.this.serialPort, UniLog2Dialog.this);
                                try {
                                    UniLog2Dialog.this.device.configureSerialPortMenu(1, Messages.getString((String)"GDE_MSGT2504"), Messages.getString((String)"GDE_MSGT2504"));
                                    UniLog2Dialog.this.liveThread.start();
                                }
                                catch (RuntimeException e) {
                                    log.log(Level.WARNING, e.getMessage(), e);
                                }
                            }
                            catch (Exception e) {
                                if (UniLog2Dialog.this.liveThread != null && UniLog2Dialog.this.liveThread.isAlive()) {
                                    UniLog2Dialog.this.liveThread.stopDataGathering();
                                    UniLog2Dialog.this.liveThread.interrupt();
                                }
                                UniLog2Dialog.this.device.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT2504"), Messages.getString((String)"GDE_MSGT2504"));
                                UniLog2Dialog.this.application.updateGraphicsWindow();
                                UniLog2Dialog.this.application.openMessageDialog(UniLog2Dialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGW2500", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                                UniLog2Dialog.this.liveGathererButton.setText(Messages.getString((String)"GDE_MSGT2576"));
                                UniLog2Dialog.this.liveThread = null;
                            }
                            UniLog2Dialog.this.liveGathererButton.setText(Messages.getString((String)"GDE_MSGT2577"));
                        } else {
                            if (UniLog2Dialog.this.liveThread != null && UniLog2Dialog.this.liveThread.isAlive()) {
                                UniLog2Dialog.this.liveThread.stopDataGathering();
                                UniLog2Dialog.this.liveThread.interrupt();
                            }
                            UniLog2Dialog.this.device.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT2504"), Messages.getString((String)"GDE_MSGT2504"));
                            UniLog2Dialog.this.application.updateGraphicsWindow();
                            UniLog2Dialog.this.liveGathererButton.setText(Messages.getString((String)"GDE_MSGT2576"));
                        }
                    }
                });
                this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData closeButtonLData = new FormData();
                closeButtonLData.width = 130;
                closeButtonLData.height = GDE.IS_MAC ? 33 : 30;
                closeButtonLData.right = new FormAttachment(1000, 1000, -10);
                closeButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.closeButton.setLayoutData((Object)closeButtonLData);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT0485"));
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "closeButton.widgetSelected, event=" + evt);
                        UniLog2Dialog.this.dispose();
                    }
                });
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 375, 10));
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            if (this.serialPort != null && this.serialPort.isConnected()) {
                this.liveGathererButton.setText(Messages.getString((String)"GDE_MSGT2577"));
            } else {
                this.liveGathererButton.setText(Messages.getString((String)"GDE_MSGT2576"));
            }
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void createVisualizationTabItem(final int channelNumber) {
        CTabItem visualizationTabItem = new CTabItem(this.tabFolder, 0);
        visualizationTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        visualizationTabItem.setText(Messages.getString((String)"GDE_MSGT2509") + " - " + this.device.getChannelNameReplacement(channelNumber));
        Composite visualizationMainComposite = new Composite((Composite)this.tabFolder, 0);
        FormLayout visualizationMainCompositeLayout = new FormLayout();
        visualizationMainComposite.setLayout((Layout)visualizationMainCompositeLayout);
        visualizationTabItem.setControl((Control)visualizationMainComposite);
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment(0, 1000, 0);
        layoutData.left = new FormAttachment(0, 1000, 0);
        layoutData.right = new FormAttachment(458, 1000, 0);
        layoutData.bottom = new FormAttachment(1000, 1000, 0);
        new UniLog2VisualizationControl(visualizationMainComposite, layoutData, this, channelNumber, this.device, Messages.getString((String)"GDE_MSGT2510"), 0, 15);
        CTabFolder subTabFolder1 = new CTabFolder(visualizationMainComposite, 0);
        FormData subTabFolder1LData = new FormData();
        subTabFolder1LData.top = new FormAttachment(0, 1000, 0);
        subTabFolder1LData.left = new FormAttachment(460, 1000, 0);
        subTabFolder1LData.right = new FormAttachment(1000, 1000, 0);
        subTabFolder1LData.bottom = new FormAttachment(1000, 1000, 0);
        subTabFolder1.setLayoutData((Object)subTabFolder1LData);
        CTabItem uniLogTabItem = new CTabItem(subTabFolder1, 0);
        uniLogTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
        uniLogTabItem.setText("                                                                      ");
        Composite uniLogVisualization = new Composite((Composite)subTabFolder1, 0);
        FormLayout compositeLayout = new FormLayout();
        uniLogVisualization.setLayout((Layout)compositeLayout);
        uniLogTabItem.setControl((Control)uniLogVisualization);
        FormData layoutUniLogData = new FormData();
        layoutUniLogData.top = new FormAttachment(0, 1000, 0);
        layoutUniLogData.left = new FormAttachment(0, 1000, 0);
        layoutUniLogData.right = new FormAttachment(1000, 1000, 0);
        layoutUniLogData.bottom = new FormAttachment(1000, 1000, -100);
        new UniLog2VisualizationControl(uniLogVisualization, layoutUniLogData, this, channelNumber, this.device, Messages.getString((String)"GDE_MSGT2511"), 15, 9);
        Composite filler = new Composite(uniLogVisualization, 0);
        FormData composite2LData = new FormData();
        composite2LData.left = new FormAttachment(0, 1000, 0);
        composite2LData.bottom = new FormAttachment(1000, 1000, 0);
        composite2LData.right = new FormAttachment(1000, 1000, 0);
        composite2LData.height = 40;
        filler.setLayoutData((Object)composite2LData);
        filler.setLayout((Layout)new RowLayout());
        CLabel efficencyLabel = new CLabel(filler, 131072);
        RowData efficencyRowData = new RowData();
        efficencyRowData.height = 20;
        efficencyRowData.width = 150;
        efficencyLabel.setLayoutData((Object)efficencyRowData);
        efficencyLabel.setText(Messages.getString((String)"GDE_MSGT2505"));
        efficencyLabel.setToolTipText(Messages.getString((String)"GDE_MSGT2506"));
        efficencyLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        final Text propeller_n100W_Text = new Text(filler, 0x1000800);
        efficencyRowData = new RowData();
        efficencyRowData.height = GDE.IS_MAC ? 16 : (GDE.IS_LINUX ? 10 : 13);
        efficencyRowData.width = 80;
        propeller_n100W_Text.setLayoutData((Object)efficencyRowData);
        propeller_n100W_Text.setText("3600");
        propeller_n100W_Text.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        propeller_n100W_Text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                log.log(Level.FINEST, "efficencyN100WText.keyReleaded, evt=" + evt);
                try {
                    int propeller_n100W_Value = Integer.valueOf(propeller_n100W_Text.getText().trim());
                    if (UniLog2Dialog.this.channels.getActiveChannel() != null) {
                        RecordSet recordSet = UniLog2Dialog.this.channels.getActiveChannel().getActiveRecordSet();
                        if (recordSet != null) {
                            Record record = recordSet.get(14);
                            PropertyType property = record.getProperty(PROP_n100W);
                            if (property != null) {
                                property.setValue((Object)propeller_n100W_Value);
                            } else {
                                record.createProperty(PROP_n100W, DataTypes.INTEGER, (Object)propeller_n100W_Value);
                            }
                            recordSet.setRecalculationRequired();
                            UniLog2Dialog.this.device.makeInActiveDisplayable(recordSet);
                            UniLog2Dialog.this.application.updateGraphicsWindow();
                            UniLog2Dialog.this.application.updateStatisticsData();
                            UniLog2Dialog.this.application.updateDataTable(recordSet.getName(), true);
                            recordSet.setUnsaved(RecordSet.UNSAVED_REASON_CONFIGURATION);
                        }
                        UniLog2Dialog.this.device.setMeasurementPropertyValue(channelNumber, 14, MeasurementPropertyTypes.PROP_N_100_W.value(), DataTypes.INTEGER, propeller_n100W_Value);
                    }
                    UniLog2Dialog.this.saveChangesButton.setEnabled(true);
                }
                catch (Exception e) {
                    UniLog2Dialog.this.application.openMessageDialog(UniLog2Dialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE0030", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                }
            }
        });
        propeller_n100W_Text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                PropertyType property = UniLog2Dialog.this.device.getMeasruementProperty(channelNumber, 14, PROP_n100W);
                if (property != null) {
                    propeller_n100W_Text.setText(property.getValue());
                } else {
                    propeller_n100W_Text.setText("3600");
                }
            }
        });
        CLabel efficencyUnit = new CLabel(filler, 0);
        efficencyRowData = new RowData();
        efficencyRowData.height = 20;
        efficencyRowData.width = 50;
        efficencyUnit.setLayoutData((Object)efficencyRowData);
        efficencyUnit.setText(Messages.getString((String)"GDE_MSGT2507"));
        efficencyUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        CTabItem mLinkTabItem = new CTabItem(subTabFolder1, 0);
        mLinkTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
        mLinkTabItem.setText(Messages.getString((String)"GDE_MSGT2512"));
        Composite mLinkVisualization = new Composite((Composite)subTabFolder1, 0);
        compositeLayout = new FormLayout();
        mLinkVisualization.setLayout((Layout)compositeLayout);
        mLinkTabItem.setControl((Control)mLinkVisualization);
        FormData layoutMLinkData = new FormData();
        layoutMLinkData.top = new FormAttachment(0, 1000, 0);
        layoutMLinkData.left = new FormAttachment(0, 1000, 0);
        layoutMLinkData.right = new FormAttachment(1000, 1000, 0);
        layoutMLinkData.bottom = new FormAttachment(1000, 1000, 0);
        new UniLog2VisualizationControl(mLinkVisualization, layoutMLinkData, this, channelNumber, this.device, Messages.getString((String)"GDE_MSGT2512"), 24, 15);
        subTabFolder1.setSelection(0);
    }

    public void enableSaveButton(boolean enable) {
        this.saveChangesButton.setEnabled(enable);
        this.application.updateAllTabs(true);
    }

    public void enableSaveConfigurationButton(boolean enable) {
        this.saveChangesButton.setEnabled(enable);
    }

    public Integer getTabFolderSelectionIndex() {
        return this.tabFolder.getSelectionIndex();
    }

    public void resetButtons() {
        if (this.dialogShell != null && !this.dialogShell.isDisposed()) {
            this.liveGathererButton.setText(Messages.getString((String)"GDE_MSGT2576"));
            this.liveThread = null;
        }
    }

    public void updateAnalogAlarmUnits() {
        this.configuration2Composite.updateAnalogAlarmUnits();
    }
}

