/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Objects;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    long groupHandle;
    long labelHandle;
    long imageHandle;
    long boxHandle;
    int accelerator;
    int userId;
    String toolTipText;
    Image defaultDisableImage;
    boolean enabled = true;
    long modelHandle;
    long actionHandle;
    long shortcutHandle;
    Menu.Section section;
    String actionName;

    public MenuItem(Menu menu, int n) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        this.createWidget(menu.getItemCount());
    }

    public MenuItem(Menu menu, int n, int n2) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        int n3 = menu.getItemCount();
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        this.createWidget(n2);
    }

    void addAccelerator(long l) {
        this.updateAccelerator(l, true);
    }

    void addAccelerators(long l) {
        this.addAccelerator(l);
        if (this.menu != null) {
            this.menu.addAccelerators(l);
        }
    }

    public void addArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(armListener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return MenuItem.checkBits(n, 8, 32, 16, 2, 64, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        int n2 = 122;
        if (GTK.GTK4) {
            int n3;
            switch (this.style & n2) {
                case 2: {
                    this.modelHandle = OS.g_menu_new();
                    this.handle = OS.g_menu_item_new_section(null, this.modelHandle);
                    break;
                }
                case 16: {
                    long l = OS.g_variant_type_new(OS.G_VARIANT_TYPE_STRING);
                    this.actionHandle = OS.g_simple_action_new_stateful(Converter.javaStringToCString(String.valueOf(this.hashCode())), l, OS.g_variant_new_string(Converter.javaStringToCString("untoggled")));
                    OS.g_action_map_add_action(this.parent.actionGroup, this.actionHandle);
                    this.actionName = String.valueOf(this.parent.hashCode()) + "." + String.valueOf(this.hashCode()) + "::toggled";
                    this.handle = OS.g_menu_item_new(null, Converter.javaStringToCString(this.actionName));
                    OS.g_variant_type_free(l);
                    break;
                }
                case 32: {
                    long l = OS.g_variant_type_new(OS.G_VARIANT_TYPE_BOOLEAN);
                    this.actionHandle = OS.g_simple_action_new_stateful(Converter.javaStringToCString(String.valueOf(this.hashCode())), 0L, OS.g_variant_new_boolean(false));
                    OS.g_action_map_add_action(this.parent.actionGroup, this.actionHandle);
                    this.actionName = String.valueOf(this.parent.hashCode()) + "." + String.valueOf(this.hashCode());
                    this.handle = OS.g_menu_item_new(null, Converter.javaStringToCString(this.actionName));
                    OS.g_variant_type_free(l);
                    break;
                }
                case 64: {
                    this.modelHandle = OS.g_menu_new();
                    this.handle = OS.g_menu_item_new_submenu(Converter.javaStringToCString(""), this.modelHandle);
                    break;
                }
                default: {
                    this.actionHandle = OS.g_simple_action_new(Converter.javaStringToCString(String.valueOf(this.hashCode())), 0L);
                    OS.g_action_map_add_action(this.parent.actionGroup, this.actionHandle);
                    this.actionName = String.valueOf(this.parent.hashCode()) + "." + String.valueOf(this.hashCode());
                    this.handle = OS.g_menu_item_new(null, Converter.javaStringToCString(this.actionName));
                }
            }
            Menu.Section section = this.parent.sections.getLast();
            for (Menu.Section section2 : this.parent.sections) {
                n3 = section2.getSectionPosition();
                int n4 = section2.getSectionSize();
                if (n <= n3 || n > n3 + n4 + 1) continue;
                section = section2;
                break;
            }
            int n5 = n - (section.getSectionPosition() + 1);
            if ((this.style & 2) != 0) {
                Menu menu = this.parent;
                Objects.requireNonNull(menu);
                this.section = menu.new Menu.Section(this);
                int n6 = section.sectionItems.size() - n5;
                for (n3 = 0; n3 < n6; ++n3) {
                    MenuItem menuItem = section.sectionItems.remove(n5);
                    this.section.sectionItems.add(menuItem);
                    OS.g_menu_remove(section.getSectionHandle(), n5);
                    OS.g_menu_insert_item(this.modelHandle, this.section.sectionItems.indexOf(menuItem), menuItem.handle);
                    menuItem.section = this.section;
                }
                n3 = this.parent.sections.indexOf(section) + 1;
                this.parent.sections.add(n3, this.section);
                OS.g_menu_insert_item(this.parent.modelHandle, n3, this.handle);
            } else {
                this.section = section;
                section.sectionItems.add(n5, this);
                OS.g_menu_insert_item(section.getSectionHandle(), n5, this.handle);
            }
            this.parent.items.add(n, this);
        } else {
            boolean bl;
            long l;
            byte[] byArray = new byte[1];
            switch (this.style & n2) {
                case 2: {
                    this.handle = GTK3.gtk_separator_menu_item_new();
                    if (this.handle != 0L) break;
                    this.error(2);
                    break;
                }
                case 16: {
                    this.groupHandle = GTK3.gtk_radio_menu_item_new(0L);
                    if (this.groupHandle == 0L) {
                        this.error(2);
                    }
                    OS.g_object_ref_sink(this.groupHandle);
                    l = GTK3.gtk_radio_menu_item_get_group(this.groupHandle);
                    this.handle = GTK3.gtk_radio_menu_item_new(l);
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.labelHandle = GTK3.gtk_accel_label_new(byArray);
                    if (this.labelHandle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = this.gtk_box_new(0, false, 6);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    if (!OS.SWT_PADDED_MENU_ITEMS) break;
                    this.imageHandle = GTK.gtk_image_new();
                    if (this.imageHandle != 0L) break;
                    this.error(2);
                    break;
                }
                case 32: {
                    this.handle = GTK3.gtk_check_menu_item_new();
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.labelHandle = GTK3.gtk_accel_label_new(byArray);
                    if (this.labelHandle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = this.gtk_box_new(0, false, 6);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    if (!OS.SWT_PADDED_MENU_ITEMS) break;
                    this.imageHandle = GTK.gtk_image_new();
                    if (this.imageHandle != 0L) break;
                    this.error(2);
                    break;
                }
                case 64: {
                    this.handle = GTK3.gtk_menu_item_new();
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.labelHandle = GTK3.gtk_accel_label_new(byArray);
                    if (this.labelHandle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = this.gtk_box_new(0, false, 6);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    if ((this.parent.style & n2) == 2 || !OS.SWT_PADDED_MENU_ITEMS) break;
                    this.imageHandle = GTK.gtk_image_new();
                    if (this.imageHandle != 0L) break;
                    this.error(2);
                    break;
                }
                default: {
                    this.handle = GTK3.gtk_menu_item_new();
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.labelHandle = GTK3.gtk_accel_label_new(byArray);
                    if (this.labelHandle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = this.gtk_box_new(0, false, 6);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    if (!OS.SWT_PADDED_MENU_ITEMS) break;
                    this.imageHandle = GTK.gtk_image_new();
                    if (this.imageHandle != 0L) break;
                    this.error(2);
                }
            }
            if (this.imageHandle != 0L) {
                if (OS.SWT_PADDED_MENU_ITEMS) {
                    GTK.gtk_image_set_pixel_size(this.imageHandle, 16);
                }
                GTK3.gtk_container_add(this.boxHandle, this.imageHandle);
                GTK.gtk_widget_show(this.imageHandle);
            }
            if (this.labelHandle != 0L) {
                GTK.gtk_label_set_xalign(this.labelHandle, 0.0f);
                GTK.gtk_widget_set_halign(this.labelHandle, 0);
                this.gtk_box_pack_end(this.boxHandle, this.labelHandle, true, true, 0);
                GTK.gtk_widget_show(this.labelHandle);
            }
            if (this.boxHandle != 0L) {
                GTK3.gtk_container_add(this.handle, this.boxHandle);
                GTK.gtk_widget_show(this.boxHandle);
            }
            if ((this.style & 2) == 0) {
                if (this.boxHandle == 0L) {
                    this.labelHandle = GTK3.gtk_bin_get_child(this.handle);
                }
                GTK3.gtk_accel_label_set_accel_widget(this.labelHandle, 0L);
            }
            if (!(bl = GTK.gtk_widget_get_sensitive(l = this.parent.handle))) {
                GTK.gtk_widget_set_sensitive(l, true);
            }
            GTK3.gtk_menu_shell_insert(l, this.handle, n);
            if (!bl) {
                GTK.gtk_widget_set_sensitive(l, false);
            }
            GTK.gtk_widget_show(this.handle);
        }
    }

    void fixMenus(Decorations decorations) {
        if (this.menu != null && !this.menu.isDisposed() && !decorations.isDisposed()) {
            this.menu.fixMenus(decorations);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    long getAccelGroup() {
        Menu menu = this.parent;
        while (menu != null && menu.cascade != null) {
            menu = menu.cascade.parent;
        }
        if (menu == null) {
            return 0L;
        }
        Decorations decorations = menu.parent;
        if (decorations == null) {
            return 0L;
        }
        return decorations.menuBar == menu ? decorations.accelGroup : 0L;
    }

    public boolean getEnabled() {
        this.checkWidget();
        if (GTK.GTK4) {
            if ((this.style & 0x40) != 0) {
                return true;
            }
            return OS.g_action_get_enabled(this.actionHandle);
        }
        return GTK.gtk_widget_get_sensitive(this.handle);
    }

    public int getID() {
        this.checkWidget();
        return this.userId;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    @Override
    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        if (GTK.GTK4) {
            long l = OS.g_action_get_state(this.actionHandle);
            if ((this.style & 0x20) != 0) {
                return OS.g_variant_get_boolean(l);
            }
            String string = Converter.cCharPtrToJavaString(OS.g_variant_get_string(l, null), false);
            return string.equals("toggled");
        }
        return GTK3.gtk_check_menu_item_get_active(this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    @Override
    long gtk_activate(long l) {
        if ((this.style & 0x40) != 0 && this.menu != null) {
            return 0L;
        }
        if (!GTK.GTK4 && !this.isEnabled()) {
            return 0L;
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.sendSelectionEvent(13);
        return 0L;
    }

    @Override
    long gtk_select(long l) {
        this.parent.selectedItem = this;
        this.sendEvent(30);
        return 0L;
    }

    @Override
    long gtk3_show_help(long l, long l2) {
        boolean bl = this.hooks(28);
        if (bl) {
            this.postEvent(28);
        } else {
            bl = this.parent.sendHelpEvent(l2);
        }
        if (bl) {
            GTK3.gtk_menu_shell_deactivate(this.parent.handle);
            return 1L;
        }
        return 0L;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (GTK.GTK4) {
            if ((this.style & 8) != 0 || (this.style & 0x10) != 0) {
                OS.g_signal_connect(this.actionHandle, OS.activate, this.display.activateProc, this.handle);
            }
        } else {
            OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
            OS.g_signal_connect_closure(this.handle, OS.select, this.display.getClosure(44), false);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[46], 0, this.display.getClosure(46), false);
        }
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    @Override
    void releaseChildren(boolean bl) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            if (this.menu.selectedItem == this) {
                this.menu.selectedItem = null;
            }
            this.menu.dispose();
            this.menu = null;
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (GTK.GTK4) {
            if (this.parent.actionGroup != 0L && this.actionName != null) {
                OS.g_action_map_remove_action(this.parent.actionGroup, Converter.javaStringToCString(this.actionName));
            }
        } else {
            long l = this.getAccelGroup();
            if (l != 0L) {
                this.removeAccelerator(l);
            }
            if (this.groupHandle != 0L) {
                OS.g_object_unref(this.groupHandle);
            }
            this.groupHandle = 0L;
            this.parent = null;
        }
        this.accelerator = 0;
        this.disposeDefaultDisabledImage();
    }

    @Override
    void destroyWidget() {
        if (GTK.GTK4) {
            if ((this.style & 2) != 0) {
                Menu.Section section = this.parent.sections.get(this.parent.sections.indexOf(this.section) - 1);
                section.sectionItems.addAll(this.section.sectionItems);
                for (MenuItem menuItem : this.section.sectionItems) {
                    OS.g_menu_insert_item(section.getSectionHandle(), section.sectionItems.indexOf(menuItem), menuItem.handle);
                }
                OS.g_menu_remove(this.parent.modelHandle, this.parent.sections.indexOf(this.section));
                this.parent.sections.remove(this.section);
            } else {
                OS.g_menu_remove(this.section.getSectionHandle(), this.section.sectionItems.indexOf(this));
                this.section.sectionItems.remove(this);
            }
            this.parent.items.remove(this);
            this.parent = null;
            if (this.modelHandle != 0L) {
                OS.g_object_unref(this.modelHandle);
            }
            OS.g_object_unref(this.handle);
            this.releaseHandle();
        } else {
            super.destroyWidget();
        }
    }

    void removeAccelerator(long l) {
        this.updateAccelerator(l, false);
    }

    void removeAccelerators(long l) {
        this.removeAccelerator(l);
        if (this.menu != null) {
            this.menu.removeAccelerators(l);
        }
    }

    public void removeArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, armListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    @Override
    void reskinChildren(int n) {
        if (this.menu != null) {
            this.menu.reskin(n);
        }
        super.reskinChildren(n);
    }

    void selectRadio() {
        MenuItem[] menuItemArray = this.parent.getItems();
        for (int i = 0; i < menuItemArray.length && menuItemArray[i] != this; ++i) {
        }
        for (int i = i - 1; i >= 0 && menuItemArray[i].setRadioSelection(false); --i) {
        }
        for (int i = i + 1; i < menuItemArray.length && menuItemArray[i].setRadioSelection(false); ++i) {
        }
        this.setSelection(true);
    }

    public void setAccelerator(int n) {
        this.checkWidget();
        if (this.accelerator == n) {
            return;
        }
        if (GTK.GTK4) {
            if (this.shortcutHandle != 0L) {
                GTK4.gtk_shortcut_controller_remove_shortcut(this.parent.shortcutController, this.shortcutHandle);
                this.shortcutHandle = 0L;
            }
            this.accelerator = n;
            this.addShortcut(n);
        } else {
            long l = this.getAccelGroup();
            if (l != 0L) {
                this.removeAccelerator(l);
            }
            this.accelerator = n;
            if (l != 0L) {
                this.addAccelerator(l);
            }
        }
    }

    void addShortcut(int n) {
        int n2;
        int n3;
        if (n == 0 || !this.getEnabled()) {
            return;
        }
        if ((n & 0x400000) != 0) {
            return;
        }
        int n4 = 0;
        if ((n & 0x10000) != 0) {
            n4 |= 8;
        }
        if ((n & 0x20000) != 0) {
            n4 |= 1;
        }
        if ((n & 0x40000) != 0) {
            n4 |= 4;
        }
        if ((n3 = Display.untranslateKey(n2 = n & 0x100FFFF)) != 0) {
            n2 = n3;
        } else {
            switch (n2) {
                case 13: {
                    n2 = 65293;
                    break;
                }
                default: {
                    n2 = Converter.wcsToMbcs((char)n2);
                }
            }
        }
        if (n2 != 0) {
            this.shortcutHandle = GTK4.gtk_shortcut_new(GTK4.gtk_keyval_trigger_new(n2, n4), GTK4.gtk_named_action_new(Converter.javaStringToCString(this.actionName)));
            if (this.shortcutHandle == 0L) {
                this.error(2);
            }
            GTK4.gtk_shortcut_controller_add_shortcut(this.parent.shortcutController, this.shortcutHandle);
        }
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if (GTK.GTK4) {
            if (this.actionHandle != 0L) {
                OS.g_simple_action_set_enabled(this.actionHandle, bl);
            }
        } else {
            if (GTK.gtk_widget_get_sensitive(this.handle) == bl) {
                return;
            }
            long l = this.getAccelGroup();
            if (l != 0L) {
                this.removeAccelerator(l);
            }
            GTK.gtk_widget_set_sensitive(this.handle, bl);
            if (l != 0L) {
                this.addAccelerator(l);
            }
        }
        if (this.enabled == bl) {
            return;
        }
        this.enabled = bl;
        this._setEnabledOrDisabledImage();
    }

    private void _setEnabledOrDisabledImage() {
        if (!this.enabled) {
            if (this.defaultDisableImage == null && this.image != null) {
                this.defaultDisableImage = new Image((Device)this.getDisplay(), this.image, 1);
            }
            this._setImage(this.defaultDisableImage);
        }
        if (this.enabled && this.image != null) {
            this._setImage(this.image);
        }
    }

    public void setID(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        this.userId = n;
    }

    @Override
    public void setImage(Image image) {
        if (GTK.GTK4) {
            return;
        }
        this.checkWidget();
        if (this.image == image) {
            return;
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.disposeDefaultDisabledImage();
        super.setImage(image);
        this._setEnabledOrDisabledImage();
    }

    private void _setImage(Image image) {
        if (image != null) {
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            int n = imageList.indexOf(image);
            long l = 0L;
            if (n == -1) {
                n = imageList.add(image);
                l = imageList.getSurface(n);
            } else {
                imageList.put(n, image);
                l = imageList.getSurface(n);
            }
            if (!GTK3.GTK_IS_MENU_ITEM(this.handle)) {
                return;
            }
            if (OS.SWT_PADDED_MENU_ITEMS && this.imageHandle != 0L) {
                GTK3.gtk_image_set_from_surface(this.imageHandle, l);
            } else if (this.imageHandle == 0L) {
                this.imageHandle = GTK3.gtk_image_new_from_surface(l);
                if (this.imageHandle == 0L) {
                    this.error(2);
                }
                GTK3.gtk_container_add(this.boxHandle, this.imageHandle);
                GTK3.gtk_box_reorder_child(this.boxHandle, this.imageHandle, 0);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, l);
            }
            GTK.gtk_widget_show(this.imageHandle);
        } else if (this.imageHandle != 0L) {
            if (OS.SWT_PADDED_MENU_ITEMS) {
                GTK3.gtk_container_remove(this.boxHandle, this.imageHandle);
                this.imageHandle = GTK.gtk_image_new();
                if (this.imageHandle == 0L) {
                    this.error(2);
                }
                GTK.gtk_image_set_pixel_size(this.imageHandle, 16);
                GTK3.gtk_container_add(this.boxHandle, this.imageHandle);
                GTK.gtk_widget_show(this.imageHandle);
            } else {
                GTK3.gtk_container_remove(this.boxHandle, this.imageHandle);
                this.imageHandle = 0L;
            }
        }
    }

    public void setMenu(Menu menu) {
        Menu menu2;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((menu2 = this.menu) == menu) {
            return;
        }
        if (GTK.GTK4) {
            this.menu = menu;
            if (menu != null) {
                menu.cascade = this;
                OS.g_menu_item_set_submenu(this.handle, menu.modelHandle);
            } else {
                menu2.cascade = null;
                OS.g_menu_item_set_submenu(this.handle, 0L);
            }
            OS.g_menu_remove(this.section.getSectionHandle(), this.section.getItemPosition(this));
            OS.g_menu_insert_item(this.section.getSectionHandle(), this.section.getItemPosition(this), this.handle);
        } else {
            long l = this.getAccelGroup();
            if (l != 0L) {
                this.removeAccelerators(l);
            }
            if (menu2 != null) {
                menu2.cascade = null;
                OS.g_object_ref(menu2.handle);
                GTK3.gtk_menu_item_set_submenu(this.handle, 0L);
            }
            if ((this.menu = menu) != null) {
                menu.cascade = this;
                GTK3.gtk_menu_item_set_submenu(this.handle, menu.handle);
            }
            if (l != 0L) {
                this.addAccelerators(l);
            }
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.parent.style & 0x4000000) != 0 || !bl) {
            int n = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            GTK.gtk_widget_set_direction(this.handle, n);
            GTK3.gtk_container_forall(this.handle, this.display.setDirectionProc, n);
            if (this.menu != null) {
                this.menu._setOrientation(this.parent.style & 0x6000000);
            }
        }
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        if (GTK.GTK4) {
            if ((this.style & 0x20) != 0) {
                OS.g_simple_action_set_state(this.actionHandle, OS.g_variant_new_boolean(bl));
            } else {
                OS.g_simple_action_set_state(this.actionHandle, OS.g_variant_new_string(Converter.javaStringToCString(bl ? "toggled" : "untoggled")));
            }
        } else {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 1L);
            GTK3.gtk_check_menu_item_set_active(this.handle, bl);
            if ((this.style & 0x10) != 0) {
                GTK3.gtk_check_menu_item_set_active(this.groupHandle, !bl);
            }
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 1L);
        }
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        int n = string.indexOf(9);
        if (n != -1) {
            string = string.substring(0, n);
        }
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(cArray, true);
        if (GTK.GTK4) {
            OS.g_menu_item_set_label(this.handle, byArray);
            MaskKeysym maskKeysym = this.getMaskKeysym();
            if (maskKeysym != null) {
                OS.g_menu_item_set_attribute(this.handle, Converter.javaStringToCString("accel"), Converter.javaStringToCString("s"), GTK.gtk_accelerator_name(maskKeysym.keysym, maskKeysym.mask));
            }
            OS.g_menu_remove(this.section.getSectionHandle(), this.section.getItemPosition(this));
            OS.g_menu_insert_item(this.section.getSectionHandle(), this.section.getItemPosition(this), this.handle);
        } else if (this.labelHandle != 0L && GTK.GTK_IS_LABEL(this.labelHandle)) {
            GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
            if (GTK.GTK_IS_ACCEL_LABEL(this.labelHandle)) {
                MaskKeysym maskKeysym = this.getMaskKeysym();
                if (maskKeysym != null) {
                    GTK3.gtk_accel_label_set_accel_widget(this.labelHandle, this.handle);
                    GTK3.gtk_accel_label_set_accel(this.labelHandle, maskKeysym.keysym, maskKeysym.mask);
                }
                OS.g_signal_emit_by_name(this.handle, OS.accel_closures_changed);
            }
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (GTK.GTK4) {
            return;
        }
        if (string != null && (string.trim().length() == 0 || string.equals(this.toolTipText))) {
            return;
        }
        this.toolTipText = string;
        this.setToolTipText(this.handle, string);
    }

    void updateAccelerator(long l, boolean bl) {
        int n;
        int n2;
        if (this.accelerator == 0 || !this.getEnabled()) {
            return;
        }
        if ((this.accelerator & 0x400000) != 0) {
            return;
        }
        int n3 = 0;
        if ((this.accelerator & 0x10000) != 0) {
            n3 |= 8;
        }
        if ((this.accelerator & 0x20000) != 0) {
            n3 |= 1;
        }
        if ((this.accelerator & 0x40000) != 0) {
            n3 |= 4;
        }
        if ((n2 = Display.untranslateKey(n = this.accelerator & 0x100FFFF)) != 0) {
            n = n2;
        } else {
            switch (n) {
                case 13: {
                    n = 65293;
                    break;
                }
                default: {
                    n = Converter.wcsToMbcs((char)n);
                }
            }
        }
        if (n != 0) {
            if (bl) {
                GTK3.gtk_widget_add_accelerator(this.handle, OS.activate, l, n, n3, 1);
            } else {
                GTK3.gtk_widget_remove_accelerator(this.handle, l, n, n3);
            }
        }
    }

    private MaskKeysym getMaskKeysym() {
        if (this.text == null) {
            return null;
        }
        MaskKeysym maskKeysym = new MaskKeysym();
        int n = this.text.indexOf(9);
        if (n == -1) {
            return null;
        }
        int n2 = n + 1;
        int n3 = this.text.indexOf(43, n2);
        while (n3 != -1) {
            String string = this.text.substring(n2, n3);
            if (string.equals("Ctrl")) {
                maskKeysym.mask |= 4;
            }
            if (string.equals("Shift")) {
                maskKeysym.mask |= 1;
            }
            if (string.equals("Alt")) {
                maskKeysym.mask |= 8;
            }
            n2 = n3 + 1;
            n3 = this.text.indexOf(43, n2);
        }
        if ("Enter".equals(this.text.substring(n2))) {
            maskKeysym.keysym = 65076;
        }
        block0 : switch (this.text.length() - n2) {
            case 1: {
                maskKeysym.keysym = this.text.charAt(n2);
                maskKeysym.keysym = Converter.wcsToMbcs((char)maskKeysym.keysym);
                break;
            }
            case 2: {
                if (this.text.charAt(n2) != 'F') break;
                switch (this.text.charAt(n2 + 1)) {
                    case '1': {
                        maskKeysym.keysym = 65470;
                        break;
                    }
                    case '2': {
                        maskKeysym.keysym = 65471;
                        break;
                    }
                    case '3': {
                        maskKeysym.keysym = 65472;
                        break;
                    }
                    case '4': {
                        maskKeysym.keysym = 65473;
                        break;
                    }
                    case '5': {
                        maskKeysym.keysym = 65474;
                        break;
                    }
                    case '6': {
                        maskKeysym.keysym = 65475;
                        break;
                    }
                    case '7': {
                        maskKeysym.keysym = 65476;
                        break;
                    }
                    case '8': {
                        maskKeysym.keysym = 65477;
                        break;
                    }
                    case '9': {
                        maskKeysym.keysym = 65478;
                    }
                }
                break;
            }
            case 3: {
                if (this.text.charAt(n2) != 'F' || this.text.charAt(n2 + 1) != '1') break;
                switch (this.text.charAt(n2 + 2)) {
                    case '0': {
                        maskKeysym.keysym = 65479;
                        break block0;
                    }
                    case '1': {
                        maskKeysym.keysym = 65480;
                        break block0;
                    }
                    case '2': {
                        maskKeysym.keysym = 65481;
                        break block0;
                    }
                    case '3': {
                        maskKeysym.keysym = 65482;
                        break block0;
                    }
                    case '4': {
                        maskKeysym.keysym = 65483;
                        break block0;
                    }
                    case '5': {
                        maskKeysym.keysym = 65484;
                    }
                }
            }
        }
        return maskKeysym;
    }

    boolean updateAcceleratorText(boolean bl) {
        if (this.accelerator != 0) {
            return false;
        }
        MaskKeysym maskKeysym = null;
        if (bl) {
            maskKeysym = this.getMaskKeysym();
        }
        if (maskKeysym == null) {
            return true;
        }
        if (maskKeysym.keysym != 0) {
            long l = this.getAccelGroup();
            if (bl) {
                GTK3.gtk_widget_add_accelerator(this.handle, OS.activate, l, maskKeysym.keysym, maskKeysym.mask, 1);
            } else {
                GTK3.gtk_widget_remove_accelerator(this.handle, l, maskKeysym.keysym, maskKeysym.mask);
            }
        }
        return maskKeysym.keysym != 0;
    }

    @Override
    long dpiChanged(long l, long l2) {
        super.dpiChanged(l, l2);
        if (this.image != null) {
            this.image.internal_gtk_refreshImageForZoom();
            this.setImage(this.image);
        }
        return 0L;
    }

    private void disposeDefaultDisabledImage() {
        if (this.defaultDisableImage != null) {
            this.defaultDisableImage.dispose();
            this.defaultDisableImage = null;
        }
    }

    private static class MaskKeysym {
        int mask = 0;
        int keysym = 0;

        private MaskKeysym() {
        }
    }
}

